PROGRAM Tree;
{$M 60000, 0, 0}
USES
  BiosCrt, Dos, strings, DirOp, hexbin, masken, cdrom, disk, filecopy,
  volume;

TYPE
  Zeichen  = (Senk, Abzweig, Winkel);

VAR
  sr       : Searchrec;
  i        : Byte;
  Para     : String;
  MakeLine : Array[1..100] Of Boolean;
  LWChar   : Char;
  MID      : MIDRec;
  ReadBuf  : TSector;
  VTOC     : VTOCRec absolute ReadBuf;
  PStat    : Byte;
  IsVolID  : Byte;
  Fields   : Byte;

CONST
  DirFound : Boolean = FALSE;
  AllFiles : Boolean = FALSE;
  Ascii    : Boolean = FALSE;
  Page     : Boolean = FALSE;
  Down     : Boolean = FALSE;
  FUp      : Boolean = FALSE;
  Cut      : Byte    = 0;

  t        : Char    = #0;
  LW       : String  = '';
  FileName : PathStr = '';
  x        : Byte    = 0;
  Line     : Byte    = 1;

  Sign     : Array[Boolean, Zeichen] Of String[4] =
            (('   ', '', ''), ('|   ', '|---', '+---'));

  Space    : String[4]  = '    ';
  VolName  : String[12] = '';

LABEL
  Err;


 
PROCEDURE w (s : String);
BEGIN
  DosLnLF (s);
  If Page Then
  BEGIN
    inc (Line);
    If Line>23 Then
    BEGIN
      Line:= 1;
      DosStr (#13#10'Weiter mit ENTER oder Abbrechen mit Esc');
      t:= ReadBKey;
      DosLnLF (#13#10);
      If t=#27 Then Halt;
    END;
  END;
END;


PROCEDURE Hilfe;
CONST
s1='zeigt Verzeichnisbume an'#13#10#13#10+
   'TREE [Laufwerk/Verzeichnis] [gesuchte Datei(en)] [/a /f /p /l /g /s /v]'#13#10#13#10+
   '/a  verwendet einfachen ASCII-Zeichensatz'#13#10+
   '/f  zeigt auch alle Dateien';
s2='/p  seitenweise Anzeige'#13#10+
   '/l  verwendet Kleinschreibung'#13#10+
   '/g  verwendet Groschreibung fr Dateinamen'#13#10+
   '/s  schmale Darstellung'#13#10+
   '/v  sehr schmale Darstellung';
BEGIN
  Standardkopf ('TREE', Copyright);
  w (s1); w (s2);
  Blindstop; Halt;
END;


PROCEDURE WriteName (s : PathStr);
VAR
  x1 : Byte;
BEGIN
  For x1:= 1 To x Do
  If MakeLine[x1] Then DosStr (Sign[Ascii, Senk]) Else DosStr (Space);
  w (s);
END;


PROCEDURE ListDir (Pfad : PathStr);
VAR
  x1, cf: Byte;
  Found : Boolean;
BEGIN
  Found:= FALSE;
  inc (x);
  FindFirst (Vollpfad (Pfad, '*.*'), normalfile, sr);
  If DOSError>=150 Then BEGIN w (CopyResultStr (DOSError)); BlindStop; Halt; END;
  MakeLine[x]:= FALSE;
  While (DosError = 0) and (not MakeLine[x]) Do
  BEGIN
    If (sr.attr and directory <> 0) and (sr.name[1]<>'.') Then
    MakeLine[x]:= TRUE;
    FindNext (sr);
  END;

  For cf:= 1 To Fields Do
  BEGIN
    FindFirst (Vollpfad (Pfad, nthField(FileName, '+', cf)), normalfile, sr);
    While (DosError = 0) and (t<>#27) Do
    BEGIN
      If sr.attr and directory = 0 Then
      BEGIN
        Found:= TRUE;
        If FUp Then WriteName (sr.name) Else WriteName (LowStr (sr.name));
        If keyPressed Then t:= ReadBKey;
      END;
      FindNext (sr);
    END;
  END;
  If Found Then WriteName ('');
  dec (x);
END;


PROCEDURE Rek (S : PathStr);
VAR
  tx, tmp  : Searchrec;
  x1       : Byte;
BEGIN
  Findfirst (Vollpfad (S, '*.*'), normalfile, tx);
  If DOSError>=150 Then BEGIN w (CopyResultStr (DOSError)); BlindStop; Halt; END;
  While (DOSError=0) and (t<>#27) Do
  BEGIN
    If (tx.attr and directory<>0) and (tx.name[1]<>'.') Then
    BEGIN
      DirFound:= TRUE;
      If keyPressed Then t:= ReadBKey;
      tmp:= tx;
      inc (x); 
      MakeLine[x]:= FALSE;
      REPEAT
        FindNext (tmp);
        If (DosError=0) and (tmp.attr and directory<>0) Then MakeLine[x]:= TRUE;
      UNTIL (DosError<>0) or (MakeLine[x]);
      For x1:= 1 To x-1 Do
      If MakeLine[x1] Then DosStr (Sign[Ascii, Senk]) Else DosStr (Space);
      If not MakeLine[x] Then DosStr (Sign[Ascii, Winkel]) Else DosStr (Sign[Ascii, Abzweig]);

      If Down Then w (LowStr (tx.name)) Else w (tx.name);

      If AllFiles Then ListDir (Vollpfad (S, tx.name));

      Rek (Vollpfad (S, tx.name));
      dec (x); 
    END;
    Findnext (tx);
  END;
END;


FUNCTION GetVolumeFilename (LWChar : Char) : String;
VAR
  sr  : SearchRec;
  tmp : String[12];
  p   : Byte;
LABEL
  Ende;
BEGIN
  tmp:= '';
  FindFirst (LWChar+':\*.*', VolumeID, sr);
  While DosError=0 Do
  BEGIN
    If sr.attr and 15 = VolumeID Then { LFN von Win 9x berlesen }
    BEGIN tmp:= sr.name; Goto Ende; END;
    FindNext (sr);
  END;
  Ende:
  p:= pos ('.', tmp);
  If p<>0 Then delete (tmp, p, 1);
  GetVolumeFileName:= tmp;
END;


BEGIN
  StretchParam (Para);
  FillChar (MakeLine, SizeOf(MakeLine), TRUE);

  For i:= 1 To ParamCount Do
  BEGIN
    Para:= UpStr (ParamStr (i));
    If Para[1]='/' Then
    CASE Para[2] Of
      '?' : Hilfe;
      'F' : AllFiles:= TRUE;
      'A' : ASCII   := TRUE;
      'P' : Page    := TRUE;
      'L' : Down    := TRUE;
      'G' : FUp     := TRUE;
      'S' : Cut     := 1;
      'V' : Cut     := 2;
    END Else
    If LW      ='' Then LW      := Para Else
    If FileName='' Then FileName:= Para;
  END;
  If FileName='' Then FileName:= '*.*' Else Allfiles:= TRUE;
  Fields:= CountFields (FileName, '+');

  LW:= FileExpand (LW);
  If DOSError=0 Then PStat:= PathStatus (LW, CheckQuelle) Else PStat:= DOSError;
  If PStat<>0 Then BEGIN w (PathStatusStr (PStat)); BlindStop; Halt; END;

  DosStr ('Auflistung der Verzeichnispfade');

  LWChar:= LW[1];
  If Drive (LWChar) and CDDrive<>0 Then
  BEGIN
    IsVolID:= 1;
    ReadVTOC (ord(LWChar)-65, 0, ReadBuf);
    If IOResult=0 Then VolName:= Trim(VTOC.VolumeName);
  END Else
  BEGIN
    GetMediaID (LWChar, MID);
    IsVolID:= IOResult;
    If IsVolID=0 Then
    BEGIN
      Move (MID.VolumeLabel, VolName[1], 11);
      VolName[0]:= #11;
      VolName:= Trim (VolName);
      If VolName='NO NAME' Then VolName:= '';
    END Else
    VolName:= GetVolumeFilename (LWChar);
  END;

  If Length (VolName)<>0 Then
  BEGIN
    DosStr (' fr Datentrger ');
    DosStr (VolName);
  END;
  w ('');

  If IsVolID = 0 Then
  BEGIN
    DosStr ('Datentrgernummer: ');
    For i:= 4 DownTo 1 Do
    BEGIN If i=2 Then DosStr ('-'); DosStr (ByteHex (MID.VolumeID[i])); END;
    w ('');
  END;
  w (LW);

  For i:= 0 To 2 Do dec (Sign[Ascii, Zeichen(i)][0], Cut);
  dec (Space[0], Cut);

  If AllFiles Then ListDir (LW);
  Rek (LW);
  If not DirFound Then w ('Keine Unterverzeichnisse gefunden');
  BlindStop;
END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
