PROGRAM ViewVol;
USES
  BiosCrt, DOS, Strings, Keycode, Masken, rechnen, Filecopy;


CONST
  attribs  : array[1..4] Of Byte = (Archive, ReadOnly, Hidden, SysFile);
  attName  : array[1..4] Of String[15]
           = ('[ ] Archiv', '[ ] Nur lesen', '[ ] Versteckt', '[ ] Systemdatei');

  janein   : array[Boolean] Of String[4] = ('nein', 'ja  ');
  ProgName = 'VIEWOL';

TYPE
  str3     = String[3];
  str20    = String[20];

VAR
  PStat    : Byte;
  Found    : Boolean;
  sr       : SearchRec;
  f        : File;
  gel      : Word;
  dt       : DateTime;
  x, xx    : Byte;
  Quelle   : PathStr;

 
  InfoRec  : RECORD
               Header : array [1..2] of Char;
               UserStr: String[18];
               Nam    : String[12];
               siz    : LongInt;
               tim    : LongInt;
               att    : Byte;
               onDisk : LongInt;
               VolNr  : Word;
               LastVol: Boolean;
             END;

PROCEDURE w (s : String);
BEGIN
  GotoXY (1, WhereY);
  DosLnLF (s);
END;

PROCEDURE Strich;
VAR
  z : Byte;
BEGIN
  GotoXY (1, WhereY);
  For z:= 1 To 30 Do DosChar ('-'); DosStr (#13#10);
END;


PROCEDURE Hilfe;
CONST
s1='Durchsucht Disketten nach Dateiteilen, die mit dem Programm MULTIVOL.EXE'#13#10+
   'angelegt wurden, und zeigt deren Informationsfeld an.'#13#10#13#10+ 
   'VIEWVOL [Laufwerksbuchstabe]'#13#10;

BEGIN
  Standardkopf (ProgName, CopyRight);
  DosStr(s1);
  BlindStop;
  Halt;
END;



FUNCTION LZ (num : Word; Zeichen : Char) : Str3; assembler;
ASM
  xor dx, dx
  mov ax, Num
  or  ax, ax
  jz  @weiter
  mov bx, 10
  div bx
  @weiter:
  mov ah, dl
  or  ax, 3030h
  les di, @result
  mov Byte Ptr es:[di], 3
  inc di
  cld
  stosw
  mov al, Zeichen
  stosb
END;



PROCEDURE ViewVolume (s : PathStr; k : Byte);
VAR
  Fst    : String[18];
  Result : Word;
  x      : Byte;
BEGIN
  If k=1 Then Window (1, 3, 40, 21) Else Window (44, 3, 80, 21);
  ClrScr;

  Assign (f, s);
  Reset  (f, 1);
  Blockread (f, InfoRec, SizeOf(InfoRec), gel);
  XClose  (f);
  Result:= IOResult;
  If Result=0 Then
  BEGIN
    If (InfoRec.Header<>'AO') or (InfoRec.onDisk<>sr.Size - SizeOf(InfoRec))
    Then Exit Else Found:=True;
  END;

  UnPackTime (sr.time, dt);
  w ('Volumename     :  '+ sr.name);
  Strich;

  If (Result<>0) or (gel<>SizeOf(InfoRec)) Then
  BEGIN w ('Fehler beim Lesen der Datei-Infos'); Exit; END;

  w ('Kennwort       :  '+ InfoRec.UserStr);
  w ('Teilstck-Nr   :  '+ LongStr (InfoRec.VolNr));
  w ('letztes Teil ? :  '+ janein[InfoRec.LastVol]);
  w ('Teilstckgre :  '+ TausPkt(InfoRec.onDisk)+ ' Byte');
  w ('angelegt am    :  '+ LZ(dt.day, '.')+LZ(dt.month,'.')+LongStr(dt.year));
  w ('Uhrzeit        :  '+ LZ(dt.hour,':')+LZ(dt.min,  ':')+LZ(dt.sec,' ')+#13#10);

  UnPackTime (InfoRec.Tim, dt);
  w ('Dateiname      :  '+ InfoRec.nam);
  Strich;
  w ('Dateigre     :  '+ TausPkt(InfoRec.siz)+' Byte');
  w ('Dateidatum     :  '+ LZ(dt.day, '.')+LZ(dt.month,'.')+Longstr (dt.year));
  w ('Dateiuhrzeit   :  '+ LZ(dt.hour,':')+LZ(dt.min,  ':')+LZ(dt.sec,' ')+#13#10);

  For x:= 1 To 4 Do
  BEGIN
    If InfoRec.att and attribs[x] <> 0 Then attname[x, 2]:= 'x';
    If x=1 Then Fst:='Dateiattribute :  ' Else Fst:='                  ';
    w (Fst+attname[x]);
  END;
  w ('');
END;


PROCEDURE ShowMaske;
LABEL
  a1, a2;
BEGIN
  t2:= #0;
  a1:
  EditStr (1, Quelle, 'Laufwerk, das eine Diskette mit Dateiteilen enthlt:');

  If (ee=0) and (Quelle='') Then
  BEGIN
    Tastenabfrage ('Ungltiger Laufwerks-Bezeichner. Neue Eingabe? (j/n)', 'J', 'N');
    If t1='J' Then 
    BEGIN Fusszeile (EingabeHilfe); Goto a1 END Else UserAbort;
  END;
END;


BEGIN
  If ParamCount=0 Then
  BEGIN
    Quelle:= 'A:';
    StandardKopf (ProgName, 'Eingabemaske');
    Fusszeile (EingabeHilfe);
    ee:= 1; ShowMaske; ee:= 0; ShowMaske;
  END Else
  BEGIN
    Quelle:= ParamStr(1);
    If Quelle='/?' Then Hilfe;
  END;
  Quelle:= UpChar (Quelle[1])+':\';
  PStat:= PathStatus (Quelle, CheckQuelle);
  If PStat<>0 Then ErrorHalt (PathStatusStr (PStat));

  FileMode:=0; 
  Standardkopf (Progname, '');

  REPEAT
    t1:=#13; Found:= False; x:=1;
    FindFirst (VollPfad (Quelle, '*.*'), Normalfile, sr);
    WHILE (DOSerror=0) and (x<3) Do
    BEGIN
      If sr.attr and directory=0 Then
      BEGIN
        ViewVolume (VollPfad (Quelle, sr.name), x);
        If Found Then inc (x);
      END;
      FindNext (sr);
    END;
    Window (1, 3, 80, 25);

    If not Found Then
    BEGIN
      ClrScr;
      If DOSError>=150 Then ErrorMsg (CopyResultStr (DOSError)) Else
      ErrorMsg ('Keine Volume-Datei gefunden.');
    END;
    Tastenabfrage ('Nchste Diskette einlegen und ENTER drcken oder mit Esc beenden', #13, #27);
    Fusszeile ('Suche Dateiteile...');
  UNTIL t1=#27;
  ErrorHalt ('Fertig.');
END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
