PROGRAM Xcopy;
{$M 65000, 1024, 140000}

{ ??? Machen:
  - MakeTree und MkDir sollten Attribute des Quellverzeichnisses setzen

    Assign (Z, Ziel); SetFAttr (Z, at-16);
}


USES
  BiosCrt, DOS, Strings, Laufbalk, masken, keycode,
  LogFile, monitor, filecopy, Time, WildCard, DblFile, ErrorStr;

CONST
  ProgName = 'XCOPY';

VAR
  Objekt, Quelle, Ziel : PathStr;

  Stretch     : String;
  Files       : DoubleFileRec;
  PStat       : Byte;
  UserDate    : LongInt;
  DirAttrMask : Byte;
  t           : Char;

  BytesGesamt        : LongInt;
  DateiAnzahl        : LongInt;
  KopierteDateien    : LongInt;
  VerglicheneDateien : LongInt;
  ErledigteDateien   : LongInt;
  ErledigteBytes     : LongInt;

  OrigSynchronize    : Boolean;

CONST
  Suchpfad    : String  = '';
  Zielpfad    : PathStr = '';
  Result      : Word    = 0;
  Fehler      : LongInt = 0;

  ArcOnly     : Byte    = 0;
  Rekursiv    : Boolean = FALSE;
  NotDirs     : Boolean = False;
  NotReadO    : Boolean = True;
  Abfrage     : Boolean = False;
  AttrMask    : Byte    = NormalFile and not (Hidden or SysFile);
  TimeCheck   : Boolean = False;
  NoExCopy    : Boolean = False;
  OnlyExist   : Boolean = FALSE;
  Verify      : Boolean = False;
  LosTaste    : Boolean = False;
  Wait        : Boolean = FALSE;
  Schnell     : Boolean = FALSE;
  TimeCompare : Boolean = FALSE;
  Synchronize : Boolean = FALSE; { mu unbedingt FALSE sein! }

  CreateEmptyFolders : Boolean = FALSE;

LABEL
  Ende, Nochmal;


PROCEDURE Hilfetext;
CONST
s1='XCOPY [Quelle] [Zielpfad] [Parameter 1..x]'#13#10#13#10+
   '/a   kopiert nur Dateien mit gesetztem Archivattribut'#13#10+
   '/m   wie /a, Archivattribut der Quelldatei wird jedoch gelscht';
s2='/h   kopiert auch versteckte Dateien und Verzeichnisse'#13#10+
   '/s   kopiert auch alle (nicht leeren) Unterverzeichnisse'#13#10+
   '/e   kopiert auch alle leeren Unterverzeichnisse'#13#10+
   '/r   berschreibt auch schreibgeschtzte Dateien';
s3='/v   Quell- und Zieldateien werden nach dem Kopieren verglichen'#13#10+
   '/o   Kopierfehler werden in der Logdatei gespeichert'#13#10+
   '/n   bereits existierende Dateien werden nicht kopiert'#13#10+
   '/-y  fragt, ob eine bereits vorhandene Datei kopiert werden soll';
s4='/y   unterdrckt diese Abfrage'#13#10+
   '/w   fordert bei Beginn zu einem Tastendruck auf'#13#10+
   '/p   fragt bei jeder Datei nach, ob sie kopiert werden soll'#13#10+
   '/k   kopiert Dateien ohne ihre Verzeichnisstruktur';
s5='/d:t kopiert nur Dateien, die nicht lter als t Tage sind'#13#10+
   '/d:d kopiert nur Dateien, die ab Datum d (= TT.MM.JJ) gendert wurden'#13#10+
   '/d   berschreibt eine Datei nur, wenn sie lter ist als die Quelldatei';
s6='/dg  wie /d, kopiert wird jedoch in beide Richtungen (Daten-Abgleich)'#13#10+
   '/x   kopiert eine Datei nur, wenn sie im Ziel bereits existiert';
BEGIN
  Standardkopf ('XCOPY - Kopiert Dateien und Verzeichnisse', CopyRight);
  DosLnLF(s1); DosLnLF(s2); DosLnLF(s3); DosLnLF(s4); DosLnLF(s5); DosLnLF(s6);
  BlindStop; Halt;
END;



PROCEDURE Meldung (f, s : PathStr);
BEGIN
  Window (1, 8, 59, 21); GotoXY (1, 14); LineFeed;
  If Length (f)<>0 Then
  BEGIN
    OutStr (StretchRight(nthField(LowStr(f), '.', 1), 11));
    OutStr (StretchRight(nthField(LowStr(f), '.', 2),  8));
  END;
  OutStr (s);
  Window (1, 1, 80, 25);
END;


PROCEDURE XHalt;
BEGIN
  CursorOn; GotoXY (80, 24); BlindStop; Halt (Result);
END;


PROCEDURE CheckError (FName : PathStr);
BEGIN
  If Result=0 Then Exit;

  Meldung (FName, ExtIOResultStr(Result));
  inc (Fehler); GotoXY (74, 13); OutNum (Fehler);
  AppendErr (ExtIOResultStr(Result)+#13#10'Quelle : '+Quelle+#13#10'Ziel   : '+Ziel);

  If ((Result>= 150)  and (Result<= 153))
  or ((Result>= 155)  and (Result<= 157))
  or ( Result = 8)
  or ((Result>= 2000) and (Result<  3000)) Then
  XHalt;
END;


PROCEDURE xReadKey; 
BEGIN
  t:= #0;
  If Keypressed Then
  BEGIN
    t:= UpReadBKey;
    If t=#27 Then BEGIN Result:= 2000; CheckError (''); END;
  END;
END;


PROCEDURE Tastenfrage;
BEGIN
  REPEAT xReadKey; UNTIL pos (t, 'JNA'#13)<>0;
END;


PROCEDURE Fortschrittsbalken (VAR Files : DoubleFileRec); far;
BEGIN
  Balken (24, ErledigteBytes + FilePos(Files.f1), BytesGesamt);
END;


VAR
  ZielExist    : Byte;
  DateiKopiert : Boolean;


PROCEDURE CopyFile_BaseProc (VAR sr : SearchRec);
VAR
  CopyParams : Word;

BEGIN
  AssignFiles (Files, Quelle, Ziel);

  If Verify          Then SetDFVerifyFlag (Files);
  If not Schnell     Then SetDFUserProc   (Files, Fortschrittsbalken);

  CopyParams:= 0;
  If ArcOnly=2       Then CopyParams:= CopyParams or DelArchiveAttr;

  If ZielExist = Dat Then CopyParams:= CopyParams or DestFileExist Else
                          CopyParams:= CopyParams or DestFileNotExist;

  SetDFParameter (Files,  CopyParams);

  CopyFile (Files);
  Result:= abs(IOResult);

  If Result=0 Then
  BEGIN
    DateiKopiert:= TRUE;
    inc (KopierteDateien); GotoXY (74, 10); OutNum (KopierteDateien);
    If Verify Then
    BEGIN inc (VerglicheneDateien); GotoXY (74, 12); OutNum (VerglicheneDateien); END;
    Meldung (sr.name, '');
  END
  Else
  If Result=101 Then
  BEGIN
    Meldung ('', 'Neue Diskette einlegen und ENTER drcken');
    Tastenfrage;
  END
  Else CheckError (sr.name);
END;


PROCEDURE Copy_Proc (VAR sr : SearchRec);
BEGIN
  REPEAT
    If Lostaste Then
    BEGIN
      Meldung (sr.name, 'Datei kopieren? (j/n/a)');
      Tastenfrage;
      If t='N' Then Exit;
      If t='A' Then LosTaste:= FALSE;
    END;

    If (Abfrage) and (ZielExist=Dat) Then
    BEGIN
      Meldung (sr.name, 'vorhandene Datei berschreiben? (j/n/a)');
      Tastenfrage;
      If t='N' Then Exit;
      If t='A' Then Abfrage:=False;
    END;

    CopyFile_BaseProc (sr);

  UNTIL Result<>101; { volle gegen leere Diskette gewechselt }
END;


FUNCTION QFileOkay (VAR sr : SearchRec) : Boolean;
BEGIN
  QFileOkay:=
  ((not TimeCheck) or (sr.Time >= UserDate)) and
  ((ArcOnly=0)     or (sr.Attr and Archive <> 0));
END;


VAR
  zsr : SearchRec;  { wird nur von CheckIfZielExist und CopyFolderContent verwendet }


PROCEDURE CheckIfZielExist;
BEGIN
  FindFirst (Ziel, Normalfile, zsr);
  If DOSError<>0 Then ZielExist:= 0 Else
  If zsr.attr and directory<>0 Then ZielExist:= Ver Else ZielExist:= Dat;
END;


PROCEDURE CopyFolderContent (Suchpfad, VZiel : PathStr);
VAR
  sr : SearchRec; { mu hier drin bleiben }
BEGIN
  GotoXY (1, 3);
  OutStr (         'von  : '); OutStr (SuchPfad); ClrEol;
  OutStr (   #13#10'nach : '); OutStr (VZiel);    ClrEol;

  Findfirst (BuildPath (Suchpfad, '*.*'), AttrMask and not directory, sr);
  If DOSError>=150 Then ErrorHaltLog (IOResultStr (DOSError));

  While DOSError = 0 Do
  BEGIN
    If (QFileOkay (sr)) and (FileMatch (sr.name, Objekt)) Then
    BEGIN
      DateiKopiert:= FALSE;

      Quelle:= BuildPath (Suchpfad, sr.name);
      Ziel  := BuildPath (VZiel,    sr.name);

      CheckIfZielExist;

      If    ((ZielExist= 0)
        and  (not OnlyExist))
      or    ((ZielExist<>0)
        and  ( not NoExCopy)
        and  ((not NotReadO)    or (zsr.Attr and (ReadOnly or SysFile)=0))
        and  ((not TimeCompare) or (sr.Time > zsr.Time))
        and  ( not SameFile (Quelle, Ziel, sr, zsr))) Then
      BEGIN
        GotoXY (1, 6);
        OutStr ('Datei: '); OutStr (sr.name);  ClrEol;

        If ZielExist=Ver Then
        BEGIN Result:= 1001; CheckError (sr.name); END Else

        Copy_Proc (sr);
      END;

      inc (ErledigteDateien); GotoXY (74, 9); OutNum (ErledigteDateien);
      inc (ErledigteBytes, sr.size);

      If (not Schnell) and (not DateiKopiert) Then
      Balken (24, ErledigteBytes, BytesGesamt);

      xReadKey;
    END;

    Findnext (sr);
  END;

  If not Rekursiv Then Exit;

  Findfirst (BuildPath (Suchpfad, '*.*'), AttrMask, sr);
  While DOSError = 0 Do
  BEGIN
    If (sr.Attr and directory<>0) and (sr.name[1]<>'.') Then
    BEGIN
      Quelle:= BuildPath (Suchpfad, sr.name);

      If NotDirs Then
      Ziel:= VZiel Else
      Ziel:= BuildPath (VZiel, sr.name);

      CheckIfZielExist;
      If ZielExist<>Dat Then
      BEGIN
        If (CreateEmptyFolders) and (ZielExist=0) Then
        BEGIN MkDir (Ziel); Result:= IOResult; CheckError (sr.Name); END;
        CopyFolderContent (Quelle, Ziel);
      END Else
      BEGIN Result:= 1002; CheckError (sr.name); END;
    END;

    FindNext (sr);
  END;
END;


PROCEDURE CountFiles (Path : PathStr);
VAR
  sr : SearchRec;
BEGIN
  FindFirst (BuildPath (Path, '*.*'), DirAttrMask, sr);
  If DOSError>=150 Then ErrorHaltLog (IOResultStr (DOSError));
  While DOSError = 0 Do
  BEGIN
    If sr.attr and directory = 0 Then
    BEGIN
      If QFileOkay (sr) and FileMatch (sr.name, Objekt) Then
      BEGIN inc (BytesGesamt, sr.size); inc (DateiAnzahl); END;
    END
    Else
    If sr.name[1]<>'.' Then CountFiles (BuildPath(Path, sr.name));
    FindNext (sr);
  END;
END;


PROCEDURE ShowMaske;
LABEL
  a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13;

CONST
  Arc       : Boolean = FALSE;
  NotHidden : Boolean = TRUE;

BEGIN
  t2:= #0;
  a1:
  EditStr (1, Suchpfad, 'Verzeichnis oder Dateien, die kopiert werden sollen:');
  If t2=Up Then Goto a1;
  SuchPfad:= UpStr (SuchPfad);

  a2:
  EditStr (5, ZielPfad, 'Verzeichnis, in das die Dateien kopiert werden sollen:');
  If t2=Up Then Goto a1;
  ZielPfad:= UpStr (ZielPfad);

  a3:
  ParamField (9, NotReadO, 'keine schreibgeschtzten Dateien im Ziel berschreiben');
  If t2=Up Then Goto a2;

  a4:
  ParamField (10, NotHidden, 'keine versteckten Dateien und Verzeichnisse kopieren');
  If t2=Up Then Goto a3;
  If not NotHidden Then AttrMask:= AttrMask or Hidden;

  a5:
  ParamField (11, NoExCopy, 'keine im Ziel bereits existierenden Dateien kopieren');
  If t2=Up Then Goto a4;
  If (ee=0) and (NoExCopy) and (OnlyExist) Then BEGIN OnlyExist:= FALSE; Goto a9; END;

  a6:
  ParamField (12, Verify, 'Quell- und Zieldatei nach dem Kopieren vergleichen');
  If t2=Up Then Goto a5;

  a7:
  ParamField (13, Abfrage, 'fragt, ob eine bereits existierende Datei kopiert werden soll');
  If t2=Up Then Goto a6;

  a8:
  ParamField (14, LosTaste, 'fragt bei jeder Datei, ob sie kopiert werden soll');
  If t2=Up Then Goto a7;

  a9:
  ParamField (15, OnlyExist, 'kopiert nur Dateien, die im Ziel bereits existieren');
  If t2=Up Then Goto a8;
  If (ee=0) and (OnlyExist) and (NoExCopy) Then BEGIN NoExCopy:= FALSE; Goto a5; END;

  a10:
  ParamField (16, TimeCompare, 'berschreibt eine Datei nur, wenn sie lter als die Quelldatei ist');
  If t2=Up Then Goto a9;

  a11:
  ParamField (17, Rekursiv, 'kopiert auch Dateien in Unterverzeichnissen');
  If t2=Up Then Goto a10;

  a12:
  ParamField (18, Arc,      'kopiert nur Dateien mit Archivattribut und lscht das Attribut danach');
  If t2=Up Then Goto a11;
  If Arc Then ArcOnly:= 2 Else ArcOnly:= 0;

  a13:
  ParamField (19, Synchronize, 'Quell- und Zielverzeichnis tauschen die jeweils aktuelleren Dateien aus');
  If t2=Up Then Goto a12;
  If Synchronize Then TimeCompare:= TRUE;

  If (ee=0) and (Suchpfad='') Then
  BEGIN
    Tastenabfrage ('Ungltige Verzeichnisangabe. Neue Eingabe? (j/n)', 'J', 'N');
    If t1='J' Then 
    BEGIN Fusszeile (EingabeHilfe); Goto a1 END Else UserAbort;
  END;
  If (ee=0) and (Zielpfad='') Then
  BEGIN
    Tastenabfrage ('Ungltige Verzeichnisangabe. Neue Eingabe? (j/n)', 'J', 'N');
    If t1='J' Then 
    BEGIN Fusszeile (EingabeHilfe); Goto a2 END Else UserAbort;
  END;
END;


PROCEDURE Maske;
BEGIN
  Suchpfad:= FileExpand (''); ZielPfad:= SuchPfad;
  StandardKopf (ProgName, 'Eingabemaske');
  Fusszeile (EingabeHilfe);
  ee:= 1; ShowMaske; ee:= 0; ShowMaske;
END;


PROCEDURE Beschriftung;
VAR
  x : Byte;
CONST
  ar : array[9..12] Of String[14] =
  ('Erledigt  :  0','Kopiert   :  0','Verglichen:  0','Fehler    :  0');
BEGIN
  GotoXY (61, 8); OutStr ('Dateizahl :  ') ;
  If Schnell Then OutStr ('?') Else OutNum (DateiAnzahl);
  For x := 9 To 12 Do
  BEGIN
    If x>10 Then GotoXY (61, x+1) Else GotoXY (61, x);
    OutStr (ar[x]);
    ClrEol; { wegen Synchronize und Wiederholung nach Wait }
  END;
END;


PROCEDURE CheckParams;
VAR
  sr : SearchRec;
BEGIN
  Suchpfad:= FileExpand (Suchpfad);
  If DOSError=0 Then PStat:= PathStatus (Suchpfad, CheckQuelle) Else PStat:= DOSError;
  If PStat<>0 Then SimpleHaltLog (PathStatusStr (PStat));

  Zielpfad:= FileExpand (ZielPfad);
  If DOSError=0 Then PStat:= PathStatus (Zielpfad, CheckZiel) Else PStat:= DOSError;
  If PStat<>0 Then SimplehaltLog (PathStatusStr (PStat));

  If not isWildCard (SuchPfad) Then
  BEGIN      
    If (Length(Suchpfad)<=3) and (Suchpfad[2]=':') Then
    Suchpfad:= BuildPath (SuchPfad, '*.*') Else
    BEGIN
      FindFirst (SuchPfad, normalfile, sr);
      If DOSError>=150 Then SimpleHaltLog (IOResultStr (DOSError));
      If (DOSerror=0) and (sr.attr and directory<>0) Then
      Suchpfad:= BuildPath (SuchPfad, '*.*') Else Rekursiv:= FALSE;
    END;
  END;

  Objekt  := GetFileName (SuchPfad);
  Quelle  := Suchpfad;
  Suchpfad:= GetPathName (Suchpfad);
  Ziel    := ZielPfad;

  If NotDirs Then CreateEmptyFolders:= FALSE;
END;


PROCEDURE SwapPfade;
VAR
  tmp : String;
BEGIN
  tmp:= ZielPfad; ZielPfad:= SuchPfad; SuchPfad:= BuildPath (tmp, Objekt);
  CheckParams;
  Synchronize:= not Synchronize;
END;


PROCEDURE Parameter;
VAR
  x      : Byte;
  ParStr : String;

BEGIN
  ParStr:= UpStr (GetEnv ('COPYCMD'));
  If ParStr<>'' Then
  CASE ParStr[2] Of
    '-' : BEGIN If ParStr[3]='Y' Then Abfrage:= True; END;
    'Y' : BEGIN Abfrage := False;                     END;
  END;

  If ParamCount=0 Then Maske Else

  For x:= 1 To ParamCount Do
  BEGIN
    ParStr:= UpStr (ParamStr (x));
    If ParStr[1] = '/' Then
    CASE ParStr[2] Of
      '?' : Hilfetext;
      'O' : LogStatus:= 0;
      'S' : Rekursiv:= TRUE;
      'E' : BEGIN Rekursiv:= TRUE; CreateEmptyFolders:= TRUE; END;
      '-' : If pos ('Y', ParStr)=3 Then AbFrage:= True;
      'Y' : Abfrage := False;
      'V' : Verify  := True;
      'W' : Wait    := TRUE;
      'P' : Lostaste:= TRUE;
      'A' : ArcOnly := 1;
      'M' : ArcOnly := 2;
      'H' : AttrMask:= AttrMask or Hidden;
      'N' : NoExCopy:= True;
      'K' : NotDirs := TRUE;
      'R' : NotReadO:= FALSE;
      'X' : OnlyExist:=TRUE;
      'Q' : Schnell := TRUE;
      'D' : If (Length(ParStr)=2) Then TimeCompare:=TRUE Else
            If (Length(ParStr)=3) and (ParStr[3]='G') Then
            BEGIN TimeCompare:=TRUE; Synchronize:=TRUE; END Else
            BEGIN
              ParStr:= ReplaceAll(nthField (ParStr, ':', 2), '-', '.');
              { '-' aus Kompatibilittsgrnden }
              If pos ('.', ParStr)<>0 Then
              UserDate:= ParseDate  (ParStr) Else
              UserDate:= GetRelDate (0-IntVal (ParStr));
              If UserDate < 0 Then SimpleHaltLog ('Parameter /D: Fehlerhaftes Datum');
              TimeCheck:= True;
            END;
      END Else
      BEGIN
        If SuchPfad='' Then Suchpfad:= ParStr Else
        If ZielPfad='' Then ZielPfad:= ParStr;
      END;
  END;

  If (NoExCopy) and (OnlyExist) Then
  SimpleHaltLog ('Parameter /n und /x widersprechen sich');
  OrigSynchronize:= Synchronize;
END;

{----------------------------- HauptProgramm ------------------------------}

BEGIN
  StretchParam (Stretch);
  Parameter;
  CheckParams;
  CursorOff;
  Standardkopf (ProgName, '');
  GotoXY (1, 5); Linie; GotoXY (1, 20); Linie;

  If Wait Then
  BEGIN
    Meldung ('', 'Kopiervorgang starten? (j/n)');
    Tastenfrage; If t='N' Then Goto Ende;
  END;

Nochmal:
  KopierteDateien:= 0; VerglicheneDateien:= 0;
  BytesGesamt    := 0; ErledigteBytes    := 0;
  DateiAnzahl    := 0; ErledigteDateien  := 0;

  If SamePath (Suchpfad, Zielpfad, Rekursiv) Then
  BEGIN Result:= 2001; CheckError (''); END;

  If not Schnell Then
  BEGIN
    Meldung ('', 'Ermittle Datenmenge...');
    DirAttrMask:= AttrMask;
    If not Rekursiv Then DirAttrMask:= DirAttrMask and not directory;
    CountFiles (Suchpfad);
  END;

  If (DateiAnzahl>0) or (Schnell) Then
  BEGIN 
    Meldung ('', 'Kopiere...');
    Beschriftung;
    UnterBalken (24, '');
    CopyFolderContent (Suchpfad, ZielPfad);
  END Else Meldung ('', 'Keine zu kopierenden Dateien gefunden');

  If Synchronize Then BEGIN SwapPfade; Goto Nochmal; END;

  If Wait Then
  BEGIN
    Meldung ('', 'Kopiervorgang wiederholen? (j/n)');
    Tastenfrage; If t='N' Then Goto Ende;
    If OrigSynchronize Then SwapPfade;
    Goto Nochmal;
  END;

Ende:
 (* WaitKey;*)
  { Result:= 0; } XHalt;

END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
