PROGRAM Xera;
{$M 65000, 0, 0}

USES
  BiosCrt, Dos, strings, masken, keycode, filecopy, logfile, disk, Time,
  WildCard;

VAR
  sr         : Searchrec;
  i          : Byte;
  Para       : String;
  Objekt     : PathStr;
  tmp        : String;
  cf, Fields : Byte;
  PStat      : Byte;

CONST
  Ask        = 'Diese Datei lschen?                           J-a     N-ein     A-lle     E-nde';
  ProgName   = 'XERA';
  Pfad       : String  = '';
  Files      : LongInt = 0;
  Folders    : LongInt = 0;
  x          : Byte    = 0;
  IsDir      : Boolean = FALSE;
  Gesamt     : Longint = 0;

  Abfrage    : Boolean = FALSE;
  SubDirs    : Boolean = FALSE;
  DirsOnly   : Boolean = FALSE;
  DelEmptys  : Boolean = FALSE;
  Wait       : Boolean = FALSE;
  AskUser    : Boolean = TRUE;
  DelAll     : Boolean = FALSE;
  HidFiles   : Boolean = FALSE;
  ROFiles    : Boolean = FALSE;
  SysFiles   : Boolean = FALSE;
  TestOnly   : Boolean = FALSE;
  DelDate    : LongInt = -1;


PROCEDURE Hilfe;
CONST
s1='lscht Verzeichnisse und Dateien auch in Unterverzeichnissen'#13#10#13#10+
   'XERA Verzeichnis[\Dateiname(n)] [/p /w | /y /o] [/h /r /b /s /l /d:x] [/e]'#13#10#13#10+
   '/p    fordert vor dem Lschen jeder Datei zur Besttigung auf'#13#10+
   '/h    lscht auch versteckte Dateien';
s2='/r    lscht auch schreibgeschtzte Dateien'#13#10+
   '/b    lscht auch Systemdateien (Vorsicht!)'#13#10+
   '/s    lscht Dateien und Verzeichnisse auch in Unterverzeichnissen'#13#10+
   '/l    lscht auch leergewordene Verzeichnisse und Unterverzeichnisse';
s3='/d:t  lscht nur Dateien, die lter als oder gleich t Tage sind (z.B. /D:30)'#13#10+
   '/d:d  lscht nur Dateien, die am oder vor dem angegebenen Datum erstellt'#13#10+
   '      bzw. zuletzt gendert wurden. (z.B. /D:31.12.1997)';
s4='/e    lscht nur leere Verzeichnisse und Unterverzeichnisse'#13#10+
   '/t    lscht keine Daten, sondern zeigt an, welche Dateien gelscht wrden'#13#10+
   '/w    wartet vor Beginn des Lschens auf einen Tastendruck';
s5='/y    der Lschvorgang erfolgt ohne jede Benutzerrckfrage (Vorsicht!)'#13#10+
   '/o    nur mit /y: Fehler werden in der LOG-Datei protokolliert'#13#10#13#10+
   'ACHTUNG: Mit XERA gelschte Dateien sind nur sehr schwer oder gar nicht'#13#10+
   'wiederherstellbar.';

BEGIN
  StandardKopf (ProgName, CopyRight);
  DosLnLF (s1); DosLnLF (s2); DosLnLF (s3); DosLnLF (s4); DosLnLF (s5);
  Blindstop; Halt;
END;


PROCEDURE TastenFrage;
BEGIN
  REPEAT
    UpScanBKeys;
  UNTIL (t1='J') or (t1='N') or (t1= 'A') or (t1=#13) or (t1=#27);
END;


PROCEDURE DelFiles (Pfad : PathStr);
VAR
  Result : Word;
BEGIN
  For cf:= 1 To Fields Do
  BEGIN
    FindFirst (Vollpfad (Pfad, nthField (Objekt, '+', cf)), Normalfile, sr);
    If DOSError>=150 Then ErrorHaltLog (CopyResultStr (DOSError));
    While (DosError = 0) and (t1<>#27) Do
    BEGIN
      If   (sr.attr and directory=0)
      and ((sr.attr and ReadOnly =0) or (ROFiles))
      and ((sr.attr and Hidden   =0) or (HidFiles))
      and ((sr.attr and SysFile  =0) or (SysFiles))
      and ((DelDate=-1)              or (sr.time and $FFFF0000 <= DelDate))
      Then
      BEGIN
        If Files>0 Then DosLineFeed;
        DosStr (LowStr(sr.name) + FillString(14-Length(sr.name)) + '|  '+LowStr(Pfad));
        t1:= #0;
        If Abfrage Then
        BEGIN
          TastenFrage;
          If t1='A' Then Abfrage:= FALSE;
        END;
        If (t1=#27) or ((Keypressed) and (ReadBKey = #27)) Then
        UserAbortLog;

        If (not Abfrage) or (t1= 'J') or (t1=#13) Then
        BEGIN
          If not TestOnly Then
          BEGIN
            EraseFile (VollPfad (Pfad, sr.name));
            Result:= IOResult;
            If Result<>0 Then
            BEGIN
              If Result>=150 Then ErrorHaltLog (CopyResultStr (Result));
              DosLnLF (CopyResultStr (Result));
            END Else BEGIN inc (Files); inc (gesamt, sr.size); END;
          END Else BEGIN inc (Files); inc (gesamt, sr.size); END;
        END;
      END;
      FindNext (sr);
    END;
  END;
END;


PROCEDURE RDir (Path : PathStr);
BEGIN
  If DelEmptys Then
  BEGIN
    If not TestOnly Then
    BEGIN
      RmDir (Path);
      If IOResult<>0 Then Exit;
    END;
    If DirsOnly Then
    BEGIN
      If Folders>0 Then DosLineFeed;
      DosStr (LowStr(Path));
    END;
    inc (Folders);
  END;
END;


PROCEDURE Rek (S : PathStr);
VAR
  tx : Searchrec;
BEGIN
  Findfirst (Vollpfad (S, '*.*'), Normalfile, tx);
  While (DOSError=0) and (t1<>#27) Do
  BEGIN
    If (tx.attr and directory<>0) and (tx.name[1]<>'.') Then
    BEGIN
      If Keypressed Then t1:= ReadBKey;
      If not DirsOnly Then
      DelFiles (Vollpfad (S, tx.name));
      Rek      (Vollpfad (S, tx.name));
      RDir     (Vollpfad (S, tx.name));
    END;
    Findnext (tx);
  END;
END;


PROCEDURE ShowMaske;
LABEL
  a1, a2, a3, a4, a5, a6, a7, a8, a9;
BEGIN
  t2:= #0;

  a1:
  EditStr (1, Pfad, 'zu lschende Datei(en) oder zu lschendes Verzeichnis:');
  Pfad:= UpStr (Pfad);
  If t2=Up Then Goto a1;

  a2:
  ParamField (6, Abfrage, 'vor dem Lschen jeder Datei zur Besttigung auffordern');
  If t2=Up Then Goto a1;

  a3:
  ParamField (7, HidFiles, 'auch versteckte Dateien lschen');
  If t2=Up Then Goto a2;

  a4:
  ParamField (8, ROFiles,  'auch schreibgeschtzte Dateien lschen');
  If t2=Up Then Goto a3;

  a5:
  ParamField (9, SysFiles, 'auch Systemdateien lschen (Vorsicht!)');
  If t2=Up Then Goto a4;

  a6:
  ParamField (10, SubDirs, 'Dateien und Verzeichnisse auch in Unterverzeichnissen lschen');
  If t2=Up Then Goto a5;

  a7:
  ParamField (11, DelEmptys, 'auch leergewordene Verzeichnisse und Unterverzeichnisse lschen');
  If t2=Up Then Goto a6;

  a8:
  ParamField (13, DirsOnly, 'nur leere Verzeichnisse und Unterverzeichnisse lschen');
  If t2=Up Then Goto a7;

  a9:
  ParamField (15, TestOnly, 'Lschvorgang nur testen');
  If t2=Up Then Goto a8;

  If (ee=0) and (Pfad='') Then
  BEGIN
    Tastenabfrage ('Ungltige Verzeichnisangabe. Neue Eingabe? (j/n)', 'J', 'N');
    If t1='J' Then 
    BEGIN Fusszeile (EingabeHilfe); Goto a1; END Else UserAbort;
  END;
END;


PROCEDURE Maske;
BEGIN
  GetDir (0, Pfad);
  StandardKopf (ProgName, 'Eingabemaske');
  Fusszeile (EingabeHilfe);
  ee:= 1; ShowMaske; ee:= 0; ShowMaske;
END;


LABEL
  PfadTeilen;
BEGIN
  StretchParam (Para); t1:= #0;
  If ParamCount = 0 Then BEGIN Pfad:= FileExPand (''); Maske; END Else
  For i:= 1 To ParamCount Do
  BEGIN
    Para:= UpStr (ParamStr (i));
    If Para[1]='/' Then
    CASE Para[2] Of
      '?' : Hilfe;
      'H' : HidFiles := TRUE;
      'B' : SysFiles := TRUE;
      'R' : ROFiles  := TRUE;
      'E' : DirsOnly := TRUE;
      'D' : BEGIN
              Para:= nthField (Para, ':', 2);
              If Length (Para)=0 Then SimpleHaltLog ('Parameter /D: Fehlerhaftes Datum');
              If pos ('.', Para)<>0 Then
              DelDate:= ParseDate (Para) Else
              DelDate:= GetRelDate (0-IntVal (Para));
              If DelDate < 0 Then SimpleHaltLog ('Parameter /D: Fehlerhaftes Datum');
            END;
      'L' : DelEmptys:= TRUE;
      'S' : SubDirs  := TRUE;
      'T' : TestOnly := TRUE;
      'Y' : AskUser  := FALSE;
      'O' : LogStatus:= 0;
      'P' : Abfrage  := TRUE;
      'W' : Wait     := TRUE;
    END Else If Pfad='' Then Pfad:= Para;
  END;

  If not AskUser Then BEGIN Abfrage:= FALSE; Wait:= FALSE; END Else LogStatus:= 2;
  If DirsOnly    Then BEGIN SubDirs:= TRUE;  DelEmptys:= TRUE; END;

  If Pfad= '' Then SimpleHaltLog ('Verzeichnis- bzw. Dateiname fehlt');

  StandardKopf (ProgName, 'Verzeichnisse und Dateien lschen');

  If Wait Then
  BEGIN
    Tastenabfrage ('Starten von XERA mit Enter (Abruch mit Esc)', #13, #27);
    If t1=#27 Then UserAbort;
  END;

  Pfad:= FileExpand (Pfad);
  If DOSError=0 Then PStat:= PathStatus (Pfad, CheckQuelle) Else PStat:= DOSError;
  If PStat<>0 Then SimpleHaltLog (PathStatusStr (PStat));
  If Drive (Pfad[1]) and CDDrive<>0 Then SimpleHaltLog ('Lschen auf CD-ROM nicht mglich');

  If (Pfad[2]=':') and (Length(Pfad)<=3) Then
  BEGIN Objekt:= '*.*'; IsDir:= TRUE; END Else
  BEGIN
    If (IsPlus (Pfad)) or (IsWildCard (Pfad)) or (ObjektExist (Pfad)=Dat) Then
    BEGIN
      Objekt:= GetFileNames (Pfad);
      Pfad  := DelLastSlash (GetPathName(Pfad));
    END Else
    If ObjektExist (Pfad)=Ver Then
    BEGIN
      IsDir:= TRUE;
      Objekt:= '*.*';
      GetDir (DosDriveNum(Pfad[1]), tmp);
      If (tmp=Pfad) or (pos (Pfad+'\', tmp+'\') = 1) Then
      SimpleHaltLog ('Lschen des aktuellen Verzeichnisses nicht erlaubt');
    END;

    If Length(Pfad)>3 Then  (* z.B. C:\ *)
    BEGIN
      FindFirst (Pfad, Normalfile, sr);
      If DOSError<>0 Then
      BEGIN
        If DOSError>=150 Then SimpleHaltLog (CopyResultStr (DOSError));
        SimpleHaltLog ('Verzeichnis oder Datei nicht gefunden: '+Pfad);
      END;
    END;
  END;

  Fields:= CountFields (Objekt, '+');

  For cf:= 1 To Fields Do
  If (nthField (Objekt, '+', cf) = '*')
  or (nthField (Objekt, '+', cf) = '*.*') Then DelAll:= TRUE;

  If (AskUser and (not DirsOnly)) Then
  BEGIN
    DosLnLF ('Pfad : '+Pfad);
    DosLnLF ('Datei: '+Objekt);

    If ((IsDir or DelAll) and SubDirs) Then
    BEGIN
      If DelEmptys Then
      DosLnLF (#13#10'Achtung: Es wird das gesamte Verzeichnis samt Unterverzeichnissen gelscht.') Else
      DosLnLF (#13#10'Achtung: Es werden alle Dateien auch in Unterverzeichnissen gelscht.');
    END Else
    If SubDirs Then
    DosLnLF (#13#10'Achtung: Der Lschvorgang wird auch in Unterverzeichnissen durchgefhrt.') Else
    If DelAll Then
    DosLnLF (#13#10'Achtung: Alle Dateien in diesem Verzeichnis werden gelscht.');

    DosLnLF (#13#10'Wollen Sie diese Dateien wirklich lschen?   J-a  N-ein');
    REPEAT UpScanBKeys; UNTIL pos (t1, 'JN'#27)<>0;
    If t1<>'J' Then UserAbort;
    LineFeed;
  END;

  If Abfrage Then Fusszeile (Ask) Else
  Fusszeile ('Abbrechen mit Escape');
  GotoOldPos;

  If not DirsOnly Then DelFiles (Pfad);
  If SubDirs      Then Rek  (Pfad);
  If IsDir        Then RDir (Pfad);

  If TestOnly Then tmp:= ' - Lschen nur getestet !' Else tmp:= '';
  If DirsOnly Then
  ErrorHalt (StrVal(Folders)+' leere Verzeichnisse gelscht'+tmp) Else
  BEGIN
    If (DelEmptys) and (not TestOnly) Then
    ErrorHalt (StrVal(Files)+' Dateien ('+TausPkt (Gesamt shr 10)+' kB) und '+StrVal(Folders)+' leere Verzeichnisse gelscht')
    Else
    ErrorHalt (StrVal(Files)+' Dateien ('+TausPkt (Gesamt shr 10)+' kB) gelscht'+tmp);
  END;
END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
