PROGRAM Viewer;
USES
  BiosCrt, Monitor, Strings, keycode, FileIO, Mouse, hexbin, konvert,
  masken, Time, Lineedit, Dos, Filecopy, Laufbalk, Clipbord;

TYPE
  ViewerMode = (Bin, Hex, Tex, Spc); 

CONST
  ProgName   = 'XTYPE';
  ObjRe      = 79;
  ObjLi      = 2;
  WinRe      = 79;
  WinLi      = 2;
  WinOb      = 2;
  WinUn      = 24;
  BCol       = 7;
  TCol       = 0;
  AllSigns   : Boolean = FALSE;
  WinKonvert : Boolean = FALSE;
  MacKonvert : Boolean = FALSE;
  TxForm     : Boolean = FALSE;
  BlindOut   : Boolean = FALSE;
  IsClip     : Boolean = FALSE;
  Break      = 60;
  Suchwort   : String  = '';
  IsSeek     : Byte    = 0;
  Found      : Boolean = FALSE;
  FileName   : String  = '';

VAR
  ee, cf     : Byte;
  Fields     : Byte;
  wx, wy     : Word;
  c          : Char;
  Start      : LongInt;
  Counter    : LongInt;
  FPos       : LongInt;
  x, x1      : Byte;
  ViewMode   : ViewerMode;
  z, z1      : Char;
  Tmp        : String;
  i          : Byte;
  SuchW      : String;
  Param      : String;
  sr         : SearchRec;
  QuellPfad  : String;
  FName      : String;
  PStat      : Byte;
  FileNum    : Word;
  FNumTmp    : Word;

LABEL
  Nochmal;


PROCEDURE Hilfe;
BEGIN
  StandardKopf (Progname, Copyright);
  DosLnLF (
  'Datei-Betrachter'#13#10#13#10+
  'XTYPE [Dateiname(n)] [/h /b /w /m /v /a /c]'#13#10#13#10+
  '/h  zeigt die Datei als Hexadezimal-Code'#13#10+
  '/b  zeigt die Datei binr'#13#10+
  '/w  zeigt Windows-Zeichensatz als DOS-Zeichensatz');
  DosLnLF (
  '/m  zeigt Macintosh-Zeichensatz als DOS-Zeichensatz'#13#10+
  '/v  Vorlesemodus fr Blinde (BIOS-Ausgabe, nur im Textmodus)'#13#10+
  '/a  zeigt Leerzeichen als '#250);
  DosLnLF (
  '/c  zeigt das New-DOS-Clipboard (XTYPE /c).'#13#10#13#10+
  'Ohne Kommandoschalter zeigt XTYPE die Datei als Text. Space-Dateien werden'#13#10+
  'automatisch entkomprimiert angezeigt.');

  BlindStop; Halt;
END;


PROCEDURE UnPackChar; assembler;
ASM
  mov  al, c                 {al=13, ah=10}
       cmp al,   1; jne @p1; mov ax, 2573;jmp @Beginn;
  @p1: cmp al,   0; jne @p2; mov al, 225; jmp @Anfang;
  @p2: cmp al,  27; jne @p3; mov al, 129; jmp @Anfang; 
  @p3: cmp al,  28; jne @p4; mov al, 132; jmp @Anfang;
  @p4: cmp al,  29; jne @pa; mov al, 142; jmp @Anfang;
  @pa: cmp al,  30; jne @p5; mov al, 148; jmp @Anfang; 

  @p5: cmp al,  26; ja  @p6; add al,  96; mov ah,  32; jmp @Beginn;
  @p6: cmp al, 128; jb  @Anfang
       cmp al, 152; ja  @p7; sub al,  30; mov ah, 115; jmp @Beginn;
  @p7: cmp al, 155; jb  @Anfang
       cmp al, 179; ja  @p8; sub al,  57; mov ah, 101; jmp @Beginn;
  @p8: cmp al, 204; ja  @p9; sub al,  82; mov ah, 104; jmp @Beginn;
  @p9: cmp al, 230; ja  @p0; sub al, 107; mov ah,  97; jmp @Beginn;
  @p0:                       sub al, 133; mov ah, 105; jmp @Beginn;

@Anfang:
  xor ah, ah
@Beginn:
  mov z,  al
  mov z1, ah
END;


PROCEDURE ClearTextWin;
BEGIN
  Window (1, 2, 80, 24); TextAttr:= BCol shl 4; ClrScr;
  Window (1, 1, 80, 25); GotoXY (1, 2);
END;

PROCEDURE OutSign (c : Char);
BEGIN
  If (wx<=WinRe) and (Counter>=Start) Then
  BEGIN
    If (AllSigns) and (c=#32) Then c:= #250 Else
    BEGIN
      If WinKonvert Then c:= WinToDos   (c) Else
      If MacKonvert Then c:= MacToASCII (c);
    END;
    If not BlindOut Then CharXY (wx, wy, c, TCol, BCol) Else
    BEGIN GotoXY (wx, wy); If c=#7 Then c:= ' '; OutChar (c); END;
    inc (wx);
  END;
  inc (Counter);
END;



PROCEDURE OutSpaceLine;
VAR
  Marker : Boolean;
BEGIN
  WriteXY (ObjLi, wy, FillString(WinLi-ObjLi), TCol, BCol);
  c:= #0; wx:= WinLi; Counter:= 0; Marker:= FALSE;
  While (not EofInFile) and (c<>#1)
  and ((not TxForm) or (((wx<=Break) or ((z1<>#32) and (c<>#32))) and (wx<=WinRe))) Do
  BEGIN
    c:= PopChar; 
    If c<>#1 Then
    BEGIN
      If not Marker Then
      BEGIN
        If c=#31 Then Marker:= TRUE Else
        BEGIN
          UnPackChar;
          OutSign (z);
          If z1<>#0 Then OutSign (z1);
        END;
      END Else
      BEGIN If (c=TAB) and (not AllSigns) Then c:= #32; OutSign (c); Marker:= FALSE; END;
    END Else
    If AllSigns Then BEGIN OutSign (#13); OutSign (#10); END;
  END;
  WriteXY (wx, wy, FillString (WinRe+1-wx), TCol, BCol);
  inc (wy);
END;


PROCEDURE OutBinaryLine;
BEGIN
  WriteXY (ObjLi, wy, FillString(WinLi-ObjLi), TCol, BCol);
  For wx:= WinLi To ObjRe Do
  BEGIN
    If (not EofInFile) and (wx<=WinRe) Then
    BEGIN
      c:= PopChar;
      If (c=' ') and (AllSigns) Then
      CharXY (wx, wy, #250, TCol, BCol) Else
      CharXY (wx, wy,    c, TCol, BCol);
    END Else CharXY (wx, wy, ' ', TCol, BCol);
  END;
END;


PROCEDURE OutHexLine;
VAR
  ein : LongInt;
  ww  : Array[1..2] Of Word absolute ein;
  tx  : Byte;
BEGIN
  ein:= FPos+((wy-WinOb) shl 4);
  WriteXY (ObjLi, wy, WordHex(ww[2])+WordHex(ww[1]), 0, cyan);
  WriteXY (ObjLi+8, wy, '  ', TCol, BCol);
  wx:= 12; tx:= 64;
  While wx < 63 Do
  BEGIN
    If not EofInFile Then
    BEGIN
      c:= PopChar;
      WriteXY (wx, wy, ByteHex(ord(c))+' ', TCol, BCol);
      If (c=' ') and (AllSigns) Then
      CharXY (tx, wy, #250, 0, cyan) Else
      CharXY (tx, wy, c, 0, cyan);
    END Else
    BEGIN
      WriteXY (wx, wy, '   ', TCol, BCol);
      CharXY  (tx, wy, ' ',  0, cyan);
    END;
    If tx MOD 4 = 3 Then
    BEGIN inc (wx, 4); CharXY (wx-1, wy, ' ',  TCol, BCol); END Else inc (wx, 3);
    inc (tx);
  END;
END;



PROCEDURE OutTextLine;
BEGIN
  WriteXY (ObjLi, wy, FillString(WinLi-ObjLi), TCol, BCol);
  c:= #0; wx:= WinLi; Counter:= 0;
  While (not EofInFile)
  and   ((c<>#13) or ((AllSigns) and (NextChar=#10))) and (c<>#10)
  and ((not TxForm) or (((wx<=Break) or (c<>#32)) and (wx<=WinRe))) Do
  BEGIN
    c:= PopChar;
    If (wx<=WinRe) and (Counter>=Start) Then
    BEGIN
      If ((c<>#13) and (c<>#10)) or (AllSigns) Then
      BEGIN
        If (c=TAB) and (not AllSigns) Then z:= #32 Else z:= c;
        If (AllSigns) and (z=#32) Then z:= #250 Else
        BEGIN
          If WinKonvert Then z:= WinToDos   (z) Else
          If MacKonvert Then z:= MacToASCII (z);
        END;
        If not BlindOut Then CharXY (wx, wy, z, TCol, BCol) Else
        BEGIN GotoXY (wx, wy); If z=#7 Then z:= ' '; OutChar (z); END;
        inc (wx);
      END;
    END;
    inc (Counter);
  END;                               (* mac ! *)
  If (c=#13) and (not EofInFile) and (NextChar=#10) Then c:= PopChar;
  WriteXY (wx, wy, FillString (WinRe+1-wx), TCol, BCol);
  inc (wy);
END;



PROCEDURE ScrollDown;
VAR                          
  x : Byte;
BEGIN
  CASE ViewMode Of
    Tex : If not EofInFile Then
          BEGIN
            SeekInPos (FPos); c:= #0; x:= WinLi;
            While (not EofInFile) and (c<>#13) and (c<>#10)
            and ((not TxForm) or (((x<=Break) or (c<>#32)) and (x<=WinRe)))
            Do BEGIN c:= PopChar; inc (x); END;
            If (c=#13) and (not EofInFile) and (NextChar=#10) Then c:= PopChar;
            FPos:= InFilePos;
            If FPos>= InFileSize Then FPos:= InfileSize-1;
          END;
    Spc : BEGIN
            SeekInPos (FPos); c:= #0; x:= WinLi; z1:= #0;
            While (not EofInFile) and (c<>#1)
            and ((not TxForm) or (((x<=Break) or ((z1<>#32) and (c<>#32))) and (x<=WinRe))) Do
            BEGIN
              c:= PopChar;
              If TxForm Then
              BEGIN inc (x); UnPackChar; If z1<>#0 Then inc (x); END;
            END;
            FPos:= InFilePos;
            If FPos>= InFileSize Then FPos:= InfileSize-1;
          END;
    Bin : If FPos+WinRe-WinLi<InFileSize Then inc (FPos, WinRe-WinLi+1);
    Hex : If FPos+16<InFileSize Then inc (FPos, 16);
  END;
END;



PROCEDURE ScrollUp;
VAR
  x : Byte;
BEGIN
  CASE ViewMode Of
    Tex : If FPos>2 Then
          BEGIN
            If MacKonvert Then SeekInPos (FPos-2) Else SeekInPos (FPos-3);
            c:= PopChar; x:= WinLi;
            While (InFilePos>1) and (c<>#13) and (c<>#10)
            and ((not TxForm) or (((x<=Break) or (c<>#32)) and (x<=WinRe)))
            Do BEGIN SeekInPos (InFilePos-2); c:= PopChar; inc (x); END;
            FPos:= InFilePos;
            If FPos=1 Then FPos:= 0 Else
            If FPos>=InFileSize Then FPos:= InFileSize-1;
          END Else FPos:= 0;
    Spc : BEGIN
            SeekInPos (FPos); c:= #0; x:= WinLi; z1:= #0;
            While (InFilePos>1) and (c<>#1) 
            and ((not TxForm) or (((x<=Break) or ((z1<>#32) and (c<>#32))) and (x<=WinRe))) Do
            BEGIN
              SeekInPos (InFilePos-2); c:= PopChar;
              If TxForm Then
              BEGIN inc (x); UnPackChar; If z1<>#0 Then inc (x); END;
            END;
            FPos:= InFilePos;
            If FPos=1 Then FPos:= 0 Else
            If FPos>=InFileSize Then FPos:= InFileSize-1;
          END;
    Bin : If FPos>WinRe-WinLi Then dec (FPos, WinRe-WinLi+1) Else FPos:= 0;
    Hex : If FPos>16 Then dec (FPos, 16) Else FPos:= 0;
  END;
END;



PROCEDURE ChangeViewMode (vm : ViewerMode);
BEGIN
  If ViewMode<>vm Then
  BEGIN
    If BlindOut Then ClearTextWin;
    ViewMode:= vm;
    CASE vm Of
      Tex,
      Spc : ScrollUp;
      Bin : If FPos>WinRe-WinLi Then dec (FPos, (FPos MOD WinRe-WinLi)) Else FPos:= 0;
      Hex : FPos:= FPos shr 4 shl 4;
    END;
  END;
END;


PROCEDURE ClickField (x, y : Byte; Hk1, Hk2 : Char; Txt : String);
VAR
  i, col : Byte;
BEGIN
  If ee=1 Then
  BEGIN
    For i:= 1 To Length (Txt) Do
    BEGIN
      If (Txt[i]=HK1) or (Hk1=#0) Then col:= 11 Else col:= 7;
      CharXY (i+x-1, y, Txt[i], col, 1);
    END;
  END Else
  If MouseIn (x, y, x+Length(Txt)-1, y) Then BEGIN t1:= hk1; t2:= Hk2; END;
END;


PROCEDURE MenLine;
BEGIN
  If ee=1 Then WriteXY (1, 25, SpaceStr (' ', 80), 0, 1);
  ClickField ( 1, 25, #0 , Left,  #27' ');
  ClickField (76, 25, #0 , Right, ' '#26);
  ClickField (79, 25, #0 , Down,  ' '#25);
  ClickField (79,  1, #0 , Up,    ' '#24);

  ClickField ( 3, 25, 'T', #0,    'Text');
  ClickField ( 8, 25, 'B', #0,    'Bin');
  ClickField (12, 25, 'H', #0,    'Hex');
  ClickField (16, 25, 'P', #0,    'SPC');
  ClickField (20, 25, 'U', #0,    'Umbruch');
  ClickField (28, 25, 'A', #0,    'Alle');
  ClickField (33, 25, 'W', #0,    'Win');
  ClickField (37, 25, 'M', #0,    'Mac');
  ClickField (41, 25, 'S', #0,    'Suchen');
  ClickField (48, 25, 'I', #0,    'WeItersuchen');
  ClickField (61, 25, 'N', #0,    'Next');
  ClickField (66, 25, 'V', #0,    'PreV');
  ClickField (71, 25, 'E', #0,    'Ende');
END;


PROCEDURE FindDialog;
BEGIN
  WriteXY (1, 25, ' Suchwort: ', 0, cyan);
  CursorOn;
  LineEditor (12, 25, 69, Suchwort, 14, cyan);
  CursorOff;
  If t1=#27 Then BEGIN SuchW:= ''; t1:= #0; IsSeek:= 0; END Else
  BEGIN IsSeek:= 1; SuchW:= UpStr (SuchWort); END;
  ee:= 1; MenLine; ee:= 0;
END;


FUNCTION SuchWFound : Boolean;
VAR
  x, y  : Byte;
  Found : Boolean;
BEGIN
  SuchWFound:= FALSE; Found:= FALSE;
  For y:= 2 To 24 Do
  BEGIN
    x:= Pos (SuchW, UpStr (GetScreenLine (1, 80, y)));
    If x <> 0 Then
    BEGIN
      SetBackColor (x, y, Length (SuchW), yellow, cyan);
      SuchWFound:= TRUE;
      If (BlindOut) and (not Found) Then
      BEGIN GotoXY (x, y); Found:= TRUE; END;
    END;
  END;
END;


BEGIN
  StretchParam (Param);
  ClipMode:= 1;    { Daten an Clipboard anhngen }
  ViewMode:= Tex;
  If ParamCount=0 Then Hilfe;
  For x:= 1 To ParamCount Do
  BEGIN
    Param:= UpStr (ParamStr (x));
    If Param[1]='/' Then
    CASE Param[2] Of
      '?' : Hilfe;
      '#' : SuchWort:= copy (ParamStr(x), 3, 255);
      'B' : ViewMode:= Bin;
      'H' : ViewMode:= Hex;
      'W' : BEGIN Winkonvert:= TRUE; MacKonvert:= FALSE; END;
      'M' : BEGIN Mackonvert:= TRUE; WinKonvert:= FALSE; END;
      'V' : BlindOut:= TRUE;
      'C' : IsClip  := TRUE;
      'A' : AllSigns:= TRUE;
    END Else
    If FileName='' Then FileName:= Param Else
    FileName:= FileName+'+'+Param;
  END;

  If IsClip Then FileName:= VollPfad (TempPath, ClipFile);

  FileName:= FileExpand (FileName);
  If DOSError=0 Then PStat:= PathStatus (FileName, CheckQuelle) Else PStat:= DOSError;
  If PStat<>0 Then SimpleHalt (PathStatusStr (PStat));
  QuellPfad:= GetPathName  (FileName);
  FName    := GetFileNames (FileName);
  Fields   := CountFields (FName, '+');
  t1:= #0;

  CursorOff;
  TextAttr:= 31; GotoXY (1, 1); ClrEol; GotoXY (1, 25); ClrEol;
  ClearTextWin;
  MouseInit;
  WriteXY (39, 1, 'ObenLinks:', 7, 1);
  WriteXY (61, 1, 'Spalte:',    7, 1);
  If MouseExist Then WriteXY (17, 1, 'ASCII:', 7, 1);
  ErrAbort:= TRUE;

  FileNum:= 1;
  cf:= 0;
  While (cf<Fields) and (t1<>#27) Do
  BEGIN
    inc (cf);
    FindFirst (Vollpfad (QuellPfad, nthField (FName, '+', cf)), NormalFile and not Directory, sr);
    If DOSError<>0 Then
    BEGIN
      Window (1, 1, 80, 25); TextAttr:= 7; ClrScr;
      If DOSError>=150 Then SimpleHalt (CopyResultStr (DOSError)) Else
      SimpleHalt ('Keine Datei gefunden');
    END;

    REPEAT
      FileName:= Vollpfad (QuellPfad, sr.name);
      If GetFileExt (FileName)='SPC' Then ViewMode:=Spc Else
      If ViewMode=Spc Then ViewMode:= Tex;

      ResetFile (FileName);

      WriteXY ( 2, 1, SpaceStr (GetFileName (FileName), 12), 14, 1);

      ee:= 1; MenLine; ee:= 0;

      Start:= 0; FPos:= 0; 
      REPEAT
        Nochmal:
        SeekInPos (FPos);
        CASE ViewMode Of
          Tex : BEGIN wy:= WinOb; While wy<=WinUn Do OutTextLine; END;
          Spc : BEGIN wy:= WinOb; While wy<=WinUn Do OutSpaceLine; END;
          Bin : For wy:= WinOb To WinUn Do OutBinaryLine;
          Hex : For wy:= WinOb To WinUn Do OutHexLine;
        END;

        WriteXY (30, 1, StretchStr (StrVal (Prozent (FPos, InFileSize, 100)), 3)+'%', 7, 1);
        NumXY   (50, 1, 11, FPos,  7, 1);
        NumXY   (69, 1, 11, Start, 7, 1);

        If IsSeek<>0 Then
        BEGIN
          Found:= SuchWFound;
          If IsSeek=1 Then
          BEGIN
            If not Found Then
            BEGIN
              For x:= 1 To WinUn-WinOb Do
              BEGIN If not EofInFile Then ScrollDown Else IsSeek:= 2; END;
              If (Keypressed) and (ReadKey=#27) Then IsSeek:= 0 Else Goto Nochmal;
            END Else              { hier gengt ReadKey }
            IsSeek:= 2;
          END Else
          If IsSeek=3 Then
          BEGIN
            For x:= 1 To WinUn-WinOb+1 Do
            BEGIN If not EofInFile Then ScrollDown Else IsSeek:= 2; END;
            If IsSeek<>2 Then BEGIN IsSeek:= 1; Goto Nochmal; END;
          END;
        END;

        t1:= #0; t2:= #0; kn:= 0; MouseOn;
        REPEAT
          MouseGet;
          If (MouseExist) and (kn=0) Then
          If (MouseIn (WinLi, WinOb, WinRe, WinUn)) Then
          NumXY   (24, 1, 3, lo(GetChar(xm, ym)), 7, 1) Else
          WriteXY (24, 1, '   ', 7, 1);
        UNTIL (kn<>0) or (KeyPressed);
        MouseOff;

        If KeyPressed Then
        BEGIN UpScanBKeys; CursorOff; END Else
        BEGIN If kn=1 Then xDelay (70); MenLine; END;

        If t1=#0 Then
        CASE t2 Of
          Down       : ScrollDown;
          Up         : ScrollUp;
          Right      : If ViewMode>=Tex Then inc (Start);
          Left       : If (ViewMode>=Tex) and (Start>=1) Then dec (Start);
          CTRL_Rght  : If ViewMode>=Tex Then inc (Start, 40);
          CTRL_Left  : If ViewMode>=Tex Then
                       If Start>=40 Then dec (Start, 40) Else Start:= 0;
          CTRL_PgUp,
          Pos1       : BEGIN FPos:= 0; SeekInPos (0); END;
          CTRL_Pos1  : If ViewMode>=Tex Then Start:= 0;
          PgDn       : For x:= 1 To WinUn-WinOb+ord(BlindOut) Do If not EofInFile Then ScrollDown;
          PgUp       : For x:= 1 To WinUn-WinOb+ord(BlindOut) Do If FPos>0 Then ScrollUp;
          CTRL_PgDn,
          Endx       : CASE ViewMode Of
                         Tex,
                         Spc : BEGIN
                                 FPos:= InFileSize-1;
                                 SeekInPos (FPos);
                                 For x:= 1 To WinUn-WinOb Do If FPos>2 Then ScrollUp;
                               END;
                         Bin : While FPos+WinRe-WinLi<InFileSize Do inc (FPos, WinRe-WinLi+1);
                         Hex : While FPos+16<InFileSize Do inc (FPos, 16);
                       END;
          F4         : BEGIN
                         RewriteClip;
                         For x:= WinOb To WinUn Do
                         WriteClipLine (Trim(GetScreenLine (2, 79, x)));
                         CloseClip;
                       END;
        END Else
        BEGIN
          CASE t1 Of
            'T' : ChangeViewMode (Tex);
            'B' : ChangeViewMode (Bin);
            'H' : ChangeViewMode (Hex);
            'P' : ChangeViewMode (Spc);
            'U' : TxForm:= not TxForm;
            'A' : AllSigns  := not AllSigns;
            'W' : BEGIN WinKonvert:= not WinKonvert; If WinKonvert Then MacKonvert:= FALSE; END;
            'M' : BEGIN MacKonvert:= not MacKonvert; If MacKonvert Then WinKonvert:= FALSE; END;
            'S' : FindDialog;
            'I' : If IsSeek<>0 Then IsSeek:= 3;
            'E' : t1:= #27;
            'N' : BEGIN
                    Findnext (sr);
                    If DosError<>0 Then
                    BEGIN
                      If cf>=Fields Then t1:= #1 Else BEGIN t1:= #2; inc (FileNum); END;
                    END Else inc(FileNum);
                  END;
            'V' : If FileNum>1 Then
                  BEGIN
                    dec (FileNum); FNumTmp:= 1;
                    cf:= 0;
                    While (cf<Fields) and (FNumTmp<=FileNum) Do
                    BEGIN
                      inc (cf);
                      FindFirst (Vollpfad (QuellPfad, nthField (FName, '+', cf)), NormalFile and not Directory, sr);
                      inc (FNumTmp);
                      While (DOSError=0) and (FNumTmp<=FileNum) Do
                      BEGIN FindNext (sr); If DOSError=0 Then inc (FNumTmp); END;
                    END;
                  END Else t1:=#1; (*Tarnung*)
          END;
          MouseWait;
        END;
      UNTIL (t1=#27) or (t1='N') or (t1='V') or (t1=#2);
      CloseInFile; InOutRes:= 0;
    UNTIL (t1=#27) or (t1=#2);
  END;
  Window (1, 1, 80, 25); TextAttr:= 7; ClrScr; CursorOn;
END.



{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
