PROGRAM xVol;
USES
  BiosCrt, Volume, Strings, hexBin, Masken, Disk;

VAR
  LabelRec : TLabelRec;
  x        : Word;
  Param    : String;

CONST
  ExtendedInfos : Boolean = FALSE;
  Drive         : Char    = #0; { = Current Drive }
  jn            : Array[Boolean] Of String = ('nein','ja');


PROCEDURE Hilfe;
BEGIN
  Standardkopf ('XVOL', Copyright);

  DosLnLF (
  'Zeigt den Namen (Label) und die Seriennummer eines Datentrgers an.'#13#10#13#10+
  'XVOL [Laufwerk:] [/e]'#13#10#13#10+
  '/e  zeigt erweiterte Informationen');

  Blindstop; Halt;
END;

 
BEGIN
  ClrScr;    { spter wegnehmen }

  StretchParam (Param);
  Drive:= CurrentDrive;

  For x:= 1 To ParamCount Do
  BEGIN
    Param:= UpStr (ParamStr(x));
    If Param[1]='/' Then
    CASE Param[2] Of
      '?' : Hilfe;
      'E' : ExtendedInfos:= TRUE;
    END Else
    Drive:= Param[1];
  END;

  DosStr ('Datentrger in Laufwerk ');
  DosChar (Drive);

  GetVolumeLabel (Drive, LabelRec);

  With LabelRec Do
  If VolumeFlag and DriveNotReady<>0 Then
  BEGIN
    DosLnLF (' nicht bereit');
  END Else
  BEGIN
    If VolumeFlag and FileLabelFound=0 Then
    BEGIN
      If (VolumeFlag and BootLabelFound<>0) and (VolumeBootName<>'NO NAME') Then
      BEGIN DosStr (' ist '); DosLnLF (VolumeBootName); END Else
      DosLnLF (' hat keine Datentrgerbezeichnung');
    END Else
    BEGIN DosStr (' ist '); DosLnLF (VolumeFileName); END;

    If VolumeFlag and BootLabelFound<>0 Then
    BEGIN
      DosStr ('Datentrgernummer: ');
      For x:= 4 DownTo 1 Do
      BEGIN If x=2 Then DosChar ('-'); DosStr (ByteHex (VolumeNr[x])); END;
      DosLnLF ('');
    END;

    If ExtendedInfos Then
    BEGIN
      DosStr (#13#10'Laufwerk: ');
      If VolumeFlag and IsNetDrive<>0 Then
      DosLnLF ('Netz- oder CD-ROM-Laufwerk') Else
      DosLnLF ('lokal');

      DosStr  (#13#10'Lange Dateinamen (LFN) im Wurzel-Verzeichnis: ');
      DosLnLF (jn[VolumeFlag and LFNFound<>0]);

      If  (VolumeFlag and LFNFound<>0)
      and (VolumeFlag and FileLabelFound <> 0) Then
      BEGIN
        DosStr  ('Liegt Datentrgername im Verzeichnis vor LFN: ');
        DosLnLF (jn[VolumeFlag and IsLabelFirst<>0]);
      END;

      DosStr  (#13#10'Datentrgername im Verzeichnis: ');
      If VolumeFlag and FileLabelFound <> 0 Then
      DosLnLF (VolumeFileName) Else
      DosLnLF ('nicht vorhanden');

      DosStr  ('Datentrgername im Bootsektor : ');
      If VolumeFlag and BootLabelFound <> 0 Then
      BEGIN
        DosLnLF (VolumeBootName);
        DosStr  (#13#10'Dateisystem-Bezeichnung: ');
        DosLnLF (VolumeFileSys);
      END Else
      BEGIN
        DosLnLF ('nicht verfgbar');
        DosStr  (#13#10'Dateisystem-Bezeichnung: nicht verfgbar');
      END;

      If   (VolumeFlag and LFNFound<>0)

      or  ((VolumeFlag and FileLabelFound =0)
      and  (VolumeFlag and BootLabelFound<>0)
      and  (VolumeBootname<>'NO NAME'))

      or  ((VolumeFlag and FileLabelFound<>0)
      and  (VolumeFlag and BootLabelFound<>0)
      and  (VolumeBootName<>VolumeFileName))

      Then

      DosLnLF (#13#10+
'Die Datentrgerbezeichnung knnte Probleme bereiten. Lesen Sie mehr dazu in'#13#10+
'der Hilfe zu XVOL (Befehl HELP XVOL).');
    END;
  END;

  If ReadKey=#0 Then;
END.




{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
