jmp BEGIN

.include PackTime, Exec

Handle  DW ?

ExePath DB 13,10
> 'YEAR2094  (c) Copyright 2000 A.Olejko', 13,10
> 'Korrigiert den Jahr-2094- und Jahr-2096-Fehler beim Start des Computers',13,10,13,10
> 'Installation:',13,10
> '1. PC-Datum per Hand setzen, wenn es nicht korrekt sein sollte',13,10 
> '2. YEAR2094.COM in ein Verzeichnis Ihrer Wahl kopieren',13,10
> '3. Startbefehl fr YEAR2094 in AUTOEXEC.BAT eintragen',13,10
> '4. YEAR2094 einmalig von Hand mit dem Parameter /i starten',13,10,13,10
> 'Siehe auch Dokumentation',13,10,'$'
 
ErrMsg  DB 'YEAR2094: Ablauffehler',13,10,'$' 

OBJECT TimeRec:
  Time DW ?
  Date DW ?
OBJECT END

OBJECT DateTime:
  Year  DW ?
  Month DW ?
  Day   DW ?
  Hour  DW ?
  Min   DW ?
  Sec   DW ?
OBJECT END

PROC Close
  mov bx, Handle
  mov ah, 3Eh
  int 21h
  ret
ENDP


PROC BCDToByte:    ; bergabe in AL, Ergebnis in AL
  push cx          ; verwandelt die BIOS-BCD-Zahlen in Dezimalzahlen,
  mov  ch, al      ; da die Zeitsetzfunktion von DOS dieses Format
  mov  cl, 4       ; bentigt
  shr  al, cl
  add  al, al
  mov  cl, al      ; al:= al*10
  add  al, al
  add  al, al
  add  al, cl
  and  ch, 0Fh
  add  al, ch
  pop  cx
  RET
ENDP


PROC GetBIOSDate:
  push ax, bx
  mov  ah, 4
  int  1Ah
  mov  al, dh / #BCDToByte / mov dh, al   ; Monat       in dh
  mov  al, dl / #BCDToByte / mov dl, al   ; Tag         in dl 
  mov  al, ch / #BCDToByte / mov ch, al   ; Jahrhundert in ch
  mov  al, cl / #BCDToByte / mov cl, al   ; Jahrzehnt   in cl
  mov  al, ch   
  xor  ah, ah   ; Jahrhundert in AX 
  push dx       ; Tag und Monat sichern, da von MUL zerstrt
  mov  bx, 100  ; mal 100
  mul  bx  
  pop  dx       ; Tag und Monat restaurieren
  xor  ch, ch   ; nur Jahrzehnt in CX (da noch in CL)
  add  ax, cx   ; zum Jahrhundert addieren
  mov  cx, ax   ; Ergebnis (komplette dezimale Jahreszahl) in CX
  pop  bx, ax
  RET
ENDP
 

@Error:
  lea dx, ErrMsg
  mov ah, 9
  int 21h
jmp @ende

; -------------------- Hauptprogramm ---------------------------------------
 
BEGIN:
  cld
  mov  ax, 6200h     ; Adresse des PSP ermitteln
  int  21h                   
  mov  es, bx        ; Segment des PSP in ES
  mov  di, 81h       ; Anfang Kommandozeile in SI
  xor  cx, cx
  mov  cl, es:[80h]  ; Lade LngenByte der Kommandozeile in CL
  mov  al, ' '
  repe scasb         ; Leerzeichen berspringen
  je   @laden        ; nur Leerzeichen? dann weiter

  cmp  byte es:[di], '?'        ; Hilfe ?
  jne  @laden
    lea dx, ExePath
    mov ah, 9
    int 21h
    jmp @ende
  @laden:

  #ProgPath (ExePath^)
  lea  dx, ExePath
  mov  ax, 3D00h     ; YEAR2094.COM ffnen zum "Nur Lesen"
  int  21h
  jc   @error
  mov  Handle, ax

  mov  bx, ax        ; Datei-Handle in BX
  mov  ax, 5700h     ; DOS-Funktion: Datum+Uhrzeit der Datei ermitteln
  int  21h
  jnc  @noerr / #Close / jmp short @error / @noerr:
 
  and  byte es:[di], 11011111b  ; UpCase 
  cmp  byte es:[di], 'I'        ; i wie Init 
  jne  @los
    #PackActTime (TimeRec^)
  @SetFileTime:
    mov bx, Handle
    mov cx, TimeRec.Time
    mov dx, TimeRec.Date
    mov ax, 5701h
    int 21h          ; setze aktuelles Datum als Dateidatum von YEAR2094.COM
    pushf / #Close / popf / jc @error
    jmp @ende

@los:
  mov TimeRec.Time, cx
  mov TimeRec.Date, dx
  #UnpackTime (TimeRec^, DateTime^)
 
  #GetBIOSDate
  cmp  cx, 2094          ; Jahreszahl auf 2094 prfen
  jb   @okay             ; wenn < 2094, dann okay (also auch fr 2096-Fehler)

  cmp  dh, DateTime.Month; prfe, ob inzwischen ein Jahresberlauf
  ja   @setnewdate       ; stattgefunden hat
  jb   @rollover
  cmp  dl, DateTime.Day  ; vergleiche DOS-Tag mit Datei-Tag
  jae  @setnewdate
  @rollover:
  inc  Word DateTime.Year
 
@setnewdate:
  mov  cx, DateTime.Year ; Jahreszahl aus Dateidatum nach CX
  mov  DateTime.Month, dh
  mov  DateTime.Day, dl

  mov  ah, 2Bh           ; DOS-Funktion: Setze neues Datum
  int  21h
  cmp  al, $FF           ; FFhex = Fehler
  jne  @okay
  jmp  @error

  @okay:
  #PackTime (DateTime^, TimeRec^)
  jmp  short @SetFileTime

@ende:
 .HALT



; Copyright (C) 1994-2002 Andre Olejko - olejko.de
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; version 2, as published by the Free Software Foundation.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
