UNIT Bioscrt;             {Bildschirmausgabe via BIOS oder DOS}


INTERFACE

USES Strings, Dos;

FUNCTION  ActMode               : Byte;
PROCEDURE TextMode       (Modus : Word);
PROCEDURE TextBackGround (Color : Byte);
PROCEDURE TextColor      (Color : Byte);
PROCEDURE LowVideo; 
PROCEDURE HighVideo;

PROCEDURE GotoXY         (x, y  : Byte);
FUNCTION  WhereX                : Byte;
FUNCTION  WhereY                : Byte;

PROCEDURE CursorSize (o, u : Byte); 

PROCEDURE Window (a, b, c, d : Byte);
PROCEDURE ClrScr;
PROCEDURE ClrEOL;
PROCEDURE ScrollUp;
PROCEDURE ScrollDown;
PROCEDURE LineFeed;
PROCEDURE DosLineFeed; 

PROCEDURE WriteChar (xch  : Char);
PROCEDURE WriteStr  (s    : String);
PROCEDURE WriteNum  (Zahl : LongInt);

PROCEDURE WriteCol  (s    : String);

PROCEDURE OutChar   (xch  : Char);
PROCEDURE OutStr    (s    : String);
PROCEDURE OutLn     (s    : String);
PROCEDURE OutLnLF   (s    : String);
PROCEDURE OutNum    (Zahl : LongInt);
PROCEDURE OutNumLn  (Zahl : LongInt);

PROCEDURE DOSChar   (xch  : Char); 
PROCEDURE DOSStr    (s    : String);
PROCEDURE DOSLn     (s    : String);
PROCEDURE DOSLnLF   (s    : String);
PROCEDURE DOSNum    (Zahl : LongInt);
PROCEDURE DOSNumLn  (Zahl : LongInt);

PROCEDURE ChangeOutPut  (Handle : Word);
FUNCTION  NUL : Word;
PROCEDURE DosWrite      (s : String);
PROCEDURE DosWriteLn    (s : String);

FUNCTION  Keypressed    : Boolean;
FUNCTION  ReadKey       : Char;
FUNCTION  UpReadKey     : Char;
PROCEDURE ScanKeys;
PROCEDURE UpScanKeys;
PROCEDURE WaitKey; 

PROCEDURE ClearKeyBuffer;
PROCEDURE WriteIntoKeyBuffer (Scan, Key : Char);

PROCEDURE Sound (Frequenz : Word);
PROCEDURE NoSound;

 
CONST
  BW40     = 0;
  CO40     = 1;
  BW80     = 2;
  CO80     = 3;     
  Mono     = 7;
  Font8x8  = $1112;
  Font8x14 = $1111;
  Font8x16 = $1114;

  Black     = 0; DarkGray     =  8; 
  Blue      = 1; LightBlue    =  9; 
  Green     = 2; LightGreen   = 10; 
  Cyan      = 3; LightCyan    = 11;
  Red       = 4; LightRed     = 12;
  Magenta   = 5; LightMagenta = 13;
  Brown     = 6; Yellow       = 14;
  LightGray = 7; White        = 15;

  Blink     = 128;

  TextAttr : Byte = 7;
  WindMin  : Word = 0;
  WindMax  : Word = 6223;

  CopyRight     = '(c) 1996-2002 A.Olejko - www.dosware.de';
  OldCopyRight  = '(c) 1994-2002 A.Olejko - www.dosware.de';

CONST
  StdIn  = 0;     { Datei-Handle von Gert CON -> Tastatur }
  StdOut = 1;     { Datei-Handle von Gert CON -> Bildschirm }
  StdErr = 2;     { Datei-Handle von Gert CON -> BildSchirm }
  AUX    = 3;     { Datei-Handle von Gert AUX -> COM1 }
  PRN    = 4;     { Datei-Handle von Gert PRN -> LPT1 }

{ Alle Gerte auer StdErr sind mit > bzw. < umleitbar; StdErr nur,
  wenn in einer Batch-Datei vorher CTTY [Gert] eingegeben wurde.
  Anm: Die Daten an StdErr werden ber den DOS-Interrupt 29h
  (Fast Console Output) ausgegeben. Die Handle drfen nicht mit
  "Close" (Int 21h, Funktion 3Eh) geschlossen werden, da bei
  I/O-Aktionen sonst Fehler 6 (ungltiges Handle) zurckgegeben wird.
  Dies gilt auch bei Verwendung der DOS-Funktionen < 1Ch ! }

VAR
  t1, t2    : Char;
  FirstMode : Word;


IMPLEMENTATION


{$IFDEF SHARE}
USES
  sperre;
{$ENDIF}


FUNCTION ActMode : Byte; assembler;
ASM
  mov ah, 0Fh
  int 10h
END;

 
PROCEDURE TextMode (Modus : Word); assembler;
ASM
  mov ax, Modus
  xor bl, bl
  int 10h
END;



PROCEDURE TextBackGround (Color : Byte); assembler;
ASM
  mov ah, Color
  mov cl, 4
  shl ah, cl
  mov al, TextAttr
  and al, 10001111b   {BlinkBit bleibt stehen}
  add al, ah
  mov TextAttr, al 
END;



PROCEDURE TextColor (Color : Byte); assembler;
ASM
  mov al, TextAttr
  and al, 11110000b
  add al, Color
  mov TextAttr, al
END;



PROCEDURE LowVideo; assembler;
ASM
  and textattr, 11110111b
END;



PROCEDURE HighVideo; assembler;
ASM
  or textattr, 00001000b
END;


PROCEDURE GotoXY (x, y : Byte); assembler;
ASM
  mov dx, WindMin
  add dl, x
  add dh, y
  dec dl
  dec dh
  mov ah, 2
  xor bh, bh
  int 10h
END; 



FUNCTION WhereX : Byte; assembler;
ASM
  mov ah, 3
  xor bh, bh
  int 10h
  mov al, dl
  mov bx, WindMin
  sub al, bl
  inc al
END;



FUNCTION WhereY : Byte; assembler;
ASM
  mov ah, 3
  xor bh, bh
  int 10h
  mov al, dh
  mov bx, WindMin
  sub al, bh
  inc al
END;  



PROCEDURE CursorSize (o, u : Byte); assembler;
ASM
  mov ah, 1
  mov ch, o
  mov cl, u
  int 10h
END;
{ch= 1:Groer Block, ch=5:dick, ch=6:Normal, ch=7:dnn, ch=8:kleiner Block}
{cl= 1..10: Cursordicke  ... ch:=Startzeile, cl:=EndeZeile}



PROCEDURE Window (a, b, c, d : Byte); assembler;
ASM
  mov dl, a
  dec dl
  mov dh, b
  dec dh
  mov WindMin, dx

  mov ah, 2      {GotoXY (1, 1)}
  xor bh, bh
  int 10h

  mov al, c
  dec al
  mov ah, d
  dec ah
  mov WindMax, ax
END;



PROCEDURE ClrScr; assembler;
ASM
  mov ax, 0600h
  mov cx, WindMin
  mov dx, WindMax
  mov bh, TextAttr
  int 10h
  mov dx, cx    {GotoXY (1, 1)}
  mov ah, 2      
  xor bh, bh
  int 10h
END;



PROCEDURE ClrEOL; assembler;
ASM
  mov ah, 3
  xor bh, bh
  int 10h
  mov cx, dx
  mov dx, WindMax
  mov dh, ch
  mov ax, 0600h
  mov bh, TextAttr
  int 10h
END;



PROCEDURE ScrollUp; assembler;
ASM
  mov ax, 0601h
  mov cx, WindMin
  mov dx, WindMax
  mov bh, TextAttr
  int 10h
END;



PROCEDURE ScrollDown; assembler;
ASM
  mov ax, 0701h
  mov cx, WindMin
  mov dx, WindMax
  mov bh, TextAttr
  int 10h
END;



PROCEDURE LineFeed; 
VAR
  y : Byte;
BEGIN
  y:= WhereY;
  If y > Hi(WindMax)-Hi(WindMin) Then ScrollUp Else inc (y);
  GotoXY (1, y);
END;



PROCEDURE DosLineFeed; 
VAR
  y : Byte;
BEGIN
  y:= WhereY;
  DosStr (#13#10);
  If y > Hi(WindMax)-Hi(WindMin) Then ScrollUp Else inc (y);
  GotoXY (1, y);
END;


{--------------------- Schreibe in Farbe und in Fenster --------------------}



PROCEDURE WriteChar (xch : Char); assembler;
ASM
  mov ah, 3                               {CursorPosition ermitteln}
  xor bh, bh
  int 10h

  mov al, xch

  cmp al, 13; jne @weiter;   mov ax, WindMin; mov dl, al; jmp @ende;
  @weiter:
  cmp al, 10; jne @schreibe; inc dh; jmp @ende;     {Zeilenumbruch?}

  @schreibe:
  mov cx, 1
  mov ah, 09h
  mov bl, TextAttr
  int 10h

  inc dl

  mov bx, WindMax    {gucke, ob rechter Fensterrand erreicht}
  cmp dl, bl
  jbe @ende
  mov ax, WindMin;
  mov dl, al
  inc dh

  cmp dh, bh; jbe @ende; call Linefeed;  {unterer Rand erreicht? Scrollen}

  @ende:             {schiebe Cursor an neue Position}
  mov ah, 2
  xor bh, bh
  int 10h
END;



PROCEDURE WriteStr (s : String);
VAR
  x : Byte;
BEGIN
  For x:= 1 To Length (s) Do WriteChar (s[x]);
END;



PROCEDURE WriteNum (Zahl : LongInt);
BEGIN
  WriteStr (StrVal (Zahl));
END;


{------------- nur fr AT-Rechner, etwa so schnell wie OutStr -------------}

PROCEDURE WriteCol (s : String); assembler;
ASM
  mov ah, 3
  xor bh, bh
  int 10h                {WhereX...}
  mov ax, 1301h          {Schiebe Cursor ($1300=nicht schieben)}
  mov bl, TextAttr
  mov di, bp             {Schreibe Zeichenkette}
  les bp, s
  xor ch, ch
  mov cl, es:[bp]
  inc bp
  int 10h
  mov bp, di
END;


{--------------------- Schreibe ohne Farbe und Fenster ---------------------} 



PROCEDURE OutChar (xch : Char); assembler;
ASM
  mov al, xch
  mov ah, 0Eh
  int 10h
END;



PROCEDURE OutStr (s : String); assembler;
ASM
  push ds
  cld
  lds  si, s
  xor  ax, ax
  lodsb
  mov  cx, ax
  jcxz @raus
  @Start:
    lodsb
    mov  ah, 0Eh
    int  10h
  loop @Start
  @raus:
  pop ds
END;


PROCEDURE OutLn (s : String);
BEGIN
  OutStr (s);
  LineFeed;
END;


PROCEDURE OutLnLF (s : String);
BEGIN
  OutStr (s); OutStr (#13#10);
END;


PROCEDURE OutNum (Zahl : LongInt);
BEGIN
  OutStr (StrVal(Zahl));
END;


PROCEDURE OutNumLn (Zahl : LongInt);
BEGIN
  OutNum (Zahl);
  LineFeed;
END;


{ dreimal schneller als Standard-Write, aber nicht mit > umleitbar. }
{ Daher gut fr Fehlermeldungen geeignet, die nicht umgeleitet }
{ werden drfen. }


{----------------------- Schreibe via DOS ---------------------------------}


PROCEDURE DOSChar (xch : Char); assembler;
ASM
  mov dl, xch
  mov ah, 02h
  int 21h
END;



PROCEDURE DOSStr (s : String); assembler;
ASM
  push ds
  cld
  lds  si, s
  xor  ax, ax
  lodsb
  mov  cx, ax
  jcxz @raus
  @Start:
    lodsb
    mov dl, al
    mov ah, 02h
    int 21h
  loop @Start
  @raus:
  pop ds
END;



PROCEDURE DOSLn (s : String);
BEGIN
  DOSStr (s);
  DOSLineFeed;
END;


PROCEDURE DOSLnLF (s : String);
BEGIN
  DOSStr (s); DosStr (#13#10);
END;


PROCEDURE DOSNum (Zahl : LongInt);
BEGIN
  DOSStr (StrVal (Zahl));
END;


PROCEDURE DOSNumLn (Zahl : LongInt);
BEGIN
  DOSNum (Zahl);
  DOSLineFeed;
END;


FUNCTION NUL : Word;
VAR
  f : File;
BEGIN
  Assign  (f, 'NUL');
  Rewrite (f);
  NUL:= FileRec(f).Handle;
END;


PROCEDURE ChangeOutPut (Handle : Word);
BEGIN
  Flush  (OutPut);                 { Daten physikalisch zum momentanen Output schreiben }
  TextRec(OutPut).Handle:= Handle; { Handle austauschen }
END;


PROCEDURE DosWrite (s : String); assembler;
ASM
  push ds
  lds  si, s
  lodsb
  xor  ah, ah
  mov  cx, ax
  mov  dx, si
  mov  bx, StdOut  { Datei-Handle von DOS-Gert "StdOut" }
  mov  ah, 40h
  int  21h
  pop  ds
END;


PROCEDURE DOSWriteLn (s : String);
BEGIN
  DOSWrite (s); DosWrite (#13#10);
END;

{---------------------------- Tastatur ----------------------------------}


FUNCTION Keypressed : Boolean; assembler;
ASM
  mov ah, 1
  int 16h
  mov al, 1
  jnz @ende
    int 28h
    mov ax, 1680h
    int 2Fh
  xor al, al
  @ende:
END;



FUNCTION ReadKey : Char; assembler;
ASM
  call waitkey;
END;



FUNCTION UpReadKey : Char; assembler;
ASM
  call waitkey;
  cmp al, 'a'; jb @weiter;
  cmp al, 'z'; ja @weiter;
  sub al, 32
  @weiter:
END;



PROCEDURE ScanKeys; assembler;
ASM
  call waitkey;
  mov t1, al
  mov t2, ah
END;



PROCEDURE UpScanKeys; assembler;
ASM
  call waitkey;
  cmp al, 'a'; jb @weiter;
  cmp al, 'z'; ja @weiter;
  sub al, 32
  @weiter:
  mov t1, al
  mov t2, ah
END;



PROCEDURE WaitKey; assembler;
ASM
  @nochmal:
    int 28h
    mov ax, 1680h
    int 2Fh
    mov ah, 1
    int 16h
  jz  @nochmal
  xor ah, ah
  int 16h
  or  al, al
  jz  @raus
  xor ah, ah
  @raus:
END;


PROCEDURE ClearKeyBuffer; assembler;
ASM
  @nochmal:
    mov  ah, 1
    int  16h
    jz   @ende
    call waitkey
  jmp @nochmal
  @ende:
END;


PROCEDURE WriteIntoKeyBuffer (Scan, Key : Char); assembler;
ASM
  mov cl, Scan
  mov ch, Key
  mov al, 05h
  int 16h
  (* mov Result, al*)
END;
{schreibt in Tastaturpuffer}



PROCEDURE Sound (Frequenz : Word); assembler;
ASM
  mov  bx,  Frequenz
  mov  ax,  34DDh
  mov  dx,  0012h
  cmp  dx,  bx
  jnb  @raus
  div  bx
  mov  bx,  ax
  in   al,  61h
  test al,  3
  jnz  @weiter
    or   al,  3
    out  61h, AL
    mov  al,  0B6h
    out  43h, AL
  @weiter:
  mov  al,  bl
  out  42h, al
  mov  al,  bh
  out  42h, al
  @raus:
END;


PROCEDURE NoSound; assembler;
ASM
  in   al,  61h
  and  al,  0FCh
  out  61h, al
END;

{----------------------------- Initialisierung ----------------------------}

BEGIN

ASM
  mov ah, 0Fh
  int 10h
  xor ah, ah
  mov FirstMode, ax
END;

END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
