UNIT biosgraf;


INTERFACE
USES
  bioscrt, Monitor;


CONST
  GrBlack    = 0;   {Farbenattribute}
  GrCyan     = 1;   
  GrRed      = 2;
  GrWhite    = 3;

  CO320x200  = 4;
  BW320x200  = 5;
  CO640x200  = 6;       

VAR
  LastMode : Word;

PROCEDURE GraphMode   (Modus      : Integer);
PROCEDURE PutPixels   (x, y, x1   : Word);
PROCEDURE HorLine     (x, y, x1   : Word);
PROCEDURE VerLine     (x, y, y2   : Word);
PROCEDURE GraphRahmen (a, b, c, d : Word);
PROCEDURE ClearScreen (a, b, c, d : Word);
PROCEDURE ClearMonit;



IMPLEMENTATION




PROCEDURE GraphMode (Modus : Integer); assembler;
ASM
  mov ah, $0F
  int $10
  mov LastMode, ax
  mov ax, Modus
  xor ah, ah
  int $10
END;



PROCEDURE PutPixels (x, y, x1 : Word); assembler;
ASM
  mov  ax, y           {ZeilenNummer}
  mov  cx, x           {SpaltenNummer}
  mov  bx, x1          {Zahl der zu schreibenden Pixel in dx}

  mov  dx, cx
  {$IFOPT G+}
    shr  cx, 2
  {$ELSE}
    shr  cx, 1; shr cx, 1
  {$ENDIF}
  test ax, 1
  je @Los              {wenn ax gerade, dann los!}
    add cx, 8192
  @Los:
  shr ax, 1

  {$IFOPT G+}
    shl ax, 4
    mov di, ax
    shl ax, 2
  {$ELSE}
    shl ax, 1; shl ax, 1; shl ax, 1; shl ax, 1
    mov di, ax
    shl ax, 1; shl ax, 1
  {$ENDIF}  {y:= y shl 6 + y shl 4 + x}

  add di, ax
  add di, cx           {Pixeloffset in di}

  mov es, VideoAddr    {setze Segment-Adresse des Video-RAM}

  mov ax, dx           {x:= x - (x shr 2 shl 2)}

{ shr dx, 2             entspricht x:= x Mod 4
  shl dx, 2 }

  and dl, 11111100b

  sub ax, dx
  shl ax, 1
  mov cx, 6
  sub cx, ax           {Zahl der zu rollenden Bits in cx}

  mov al, 11111100b    {=252}
  mov ah, TextAttr
  rol al, cl        
  rol ah, cl
  shr cl, 1
  inc cl

  @nochmal:
    mov dl, es:[di]
    and dl, al         {alte Farb-Bits lschen}
    or  dl, ah         {FarbBits schreiben}
    mov es:[di], dl

    dec bx
    jz @ende

    dec cl
    jnz @weiter
      inc di
      mov cl, 4
    @weiter:
    {$IFOPT G+}
      ror al, 2
      ror ah, 2
    {$ELSE}
      ror al, 1; ror al, 1
      ror ah, 1; ror ah, 1
    {$ENDIF}
    jmp @nochmal;
  @ende:
END;



PROCEDURE VerLine (x, y, y2 : Word);
VAR
  yy : Word;
BEGIN
  For yy:= y To y2 Do PutPixels (x, yy, 1);
END;




PROCEDURE HorLine (x, y, x1 : Word);
BEGIN
  inc (x1);
  PutPixels (x, y, x1-x);
END;



PROCEDURE GraphRahmen (a, b, c, d : Word);
BEGIN
  HorLine (a, b, c);
  HorLine (a, d, c);
  VerLine (a, b, d);
  VerLine (c, b, d);
END;



PROCEDURE ClearScreen (a, b, c, d : Word);
VAR
  y : Word;
BEGIN
  inc (c); dec (c, a);
  For y:= b To d Do PutPixels (a, y, c);
END;



PROCEDURE ClearMonit; assembler;
ASM
  mov ax, VideoAddr
  mov es, ax
  xor di, di
  mov al, TextAttr
  mov bl, 85
  mul bl
  mov ah, al
  mov cx, 8096
  rep stosw
END;




{--------------------------- BIOS-Pixel-Routinen ----------------------------}
{

PROCEDURE PutPixel (x, y : Word); assembler;
ASM
  mov al, TextAttr
  mov ah, $0C
  mov cx, x
  mov dx, y
  int $10
END;
 

PROCEDURE HorLine (x1, y, x2 : Word); assembler;
ASM
  mov bl, TextAttr
  mov bh, $0C
  mov cx, x1
  dec cx
  mov dx, y
  @start:
  inc cx
  mov ax, bx
  int $10
  cmp cx, x2
  jne @start
END;



PROCEDURE VerLine (x, y1, y2 : Word); assembler;
ASM
  mov bl, TextAttr
  mov bh, $0C
  mov dx, y1
  dec dx
  mov cx, x
  @start:
  inc dx
  mov ax, bx
  int $10
  cmp dx, y2
  jne @start
END;


PROCEDURE ClearScreen (a, b, c, d : Word); assembler;
ASM
  mov bl, TextAttr
  mov bh, $0C
  mov dx, b
  @Start_1:
    mov cx, a
    @start_2:
      mov ax, bx
      int $10
      inc cx
      cmp cx, c
    jbe @Start_2
    inc dx
    cmp dx, d
  jbe @Start_1
END;



PROCEDURE FillScreen (Zeichen : Char);
VAR
  x : Word;
  s : String;
BEGIN
  If ActMode = CO640x200 Then s[0]:= #80 Else s[0]:= #40;
  Fillchar (s[1], 80, Zeichen);
  For x:= 1 To 25 Do
  BEGIN
    If (x=25) and (ActMode = CO640x200) Then s[0]:= pred (s[0]);
    GotoXY (1, x); WriteStr (s);
  END;
END;
} 

BEGIN
ASM
  mov ah, $0F
  int $10
  mov LastMode, ax
END;
END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
