UNIT CdRom;

INTERFACE

TYPE
  TSector     = Array[1..2048] Of Char;
  TDriveList  = Array[1..26] Of Byte;
  TDeviceList = Array[1..26] Of RECORD
                                  SubUnit : Byte;
                                  Address : Pointer;
                                END;

  TDirEntry =
  RECORD
    XARLength : Byte;    { length of XAR in Logical Block Numbers }
    FileStart : LongInt; { Logical Block Number of file start }
    DiskSize  : Word;    { size of disk in logical blocks }
    FileSize  : LongInt; { file length in bytes }
    FileTime  : RECORD
                  Year, Month, Day, Hour, Min, Sec, Unknown : Byte;
                END;
    BitFlags  : Byte;
    ILSize    : Byte;    { interleave size }
    ILSkip    : Byte;    { interleave skip factor }
    VolumeNum : Word;    { volume set sequence number }
    FileName  : String[38];
    FileVer   : Word;    { file version number }
    SysDataLen: Byte;    { number of bytes of system use data }
    SysData   : Array[1..220] Of Byte;
  END;

  VTOCDate= RECORD
              Jahr : Array[1..4] Of Char;
              Monat, Tag, Stunde, Min, sec, Unknown : Array[1..2] Of Char;
            END;
  VTOCRec = RECORD
              VolumeNr   : Byte;
              ISOKennung : Array[1..5] Of Char;
              ISOVersion : Byte; { oder Word zusammen mit XAKennung ? }
              XAKennung  : Byte; { ?? }
              SystemID   : Array[1..32] Of Char; { Betriebssystem }
              VolumeName : Array[1..32] Of Char;
              Unknown1   : Array[1..2]  Of LongInt;
              iSize      : LongInt;   { Zahl der Sektoren im Intelformat }
              mSize      : LongInt;   { Zahl der Sektoren im Motorolaformat }
              Unknown2   : Array[1..44] Of Byte;
              PathTabSize: LongInt;
              mTabSize   : LongInt;  { Motorola...}
              PathTabBeg : LongInt;
              Unknown3   : Array[1..46] Of Byte;
              VolSetName : Array[1..128] Of Char;
              Herausgeber: Array[1..128] Of Char;
              Hersteller : Array[1..128] Of Char;
              BrennerSoft: Array[1..128] Of Char;
              UnKnown4   : Array[1..111] Of Char;
              HerstDate  : VTOCDate;
              Null1      : Byte;
              ReviDate   : VTOCDate;
              Null2      : Byte;
              HerausDate : VTOCDate;
              Null3      : Byte;
              UnknownDate: VTOCDate;
              Null4      : Byte;
              Unknown5   : Byte; { Rest wahrscheinlich ohne Bedeutung }
            END;

CONST
  DevListSize = SizeOf (TDeviceList);
  DiskFormat  : Word = 255;

FUNCTION  CDNum         : Word; 
FUNCTION  FirstCDROM    : Word;
FUNCTION  MSCDEXversion : Word;
PROCEDURE GetDriveList  (VAR Drives  : TDriveList);
PROCEDURE GetDeviceList (VAR Devices : TDeviceList);
PROCEDURE ReadSector    (Drive : Word; SectorNum : LongInt; ToRead : Word; VAR Buffer);
FUNCTION  IsCDROM       (Drive       : Word) : Boolean;
PROCEDURE GetDirEntry   (Drive : Byte; FileName : String; VAR Dir : TDirEntry);
FUNCTION  DriverRequestHeaderAddress (Drive : Word) : Pointer;
PROCEDURE ReadVTOC   (Drive, VTOC_Num  : Word; VAR VTOC : TSector);
FUNCTION  DateString (Date : VTOCDate) : String;


IMPLEMENTATION


FUNCTION CDNum : Word; assembler;
ASM
  mov  ax, 1500h         
  xor  bx, bx            { Rckgabe der Funktion 1500h: }
  int  2Fh               { CX=Erstes CD-LW (0=A:, 1=B: usw.) }     
  mov  ax, bx            { BX=Zahl der CD-Laufwerke }
END;
{ If CDNum=0 Then "Keine CD-Laufwerke installiert" } 


FUNCTION FirstCDROM : Word; assembler;
ASM
  mov ax, 1500h
  xor bx, bx
  int 2Fh
  mov ax, cx             { Rckgabe: Nummer des ersten CD-Laufwerkes }
END;


FUNCTION MSCDEXversion : Word; assembler;
ASM
  mov ax, 150Ch
  int 2Fh          { Wie DOSversion, wenn BX=0, dann Version < 2.0 }
  mov ax, bx
END;


PROCEDURE GetDriveList (VAR Drives : TDriveList); assembler;
ASM
  les bx, Drives         { Drives enthlt am Ende die Laufwerksnummern }
  mov di, bx             { aller angeschlossenen CD-Laufwerke (0=A: usw.) }
  mov cx, 26             { Gre von Drives }
  xor al, al
  rep stosb              { Drives mit Nullen fllen }
  mov ax, 150Dh
  int 2Fh
END;


PROCEDURE GetDeviceList (VAR Devices : TDeviceList); assembler;
ASM
  les bx, Devices        { ES:BX = Adresse des Empfangspuffers }
  mov di, bx
  mov cx, DevListSize
  xor al, al
  rep stosb              { Puffer mit Nullen fllen }
  mov ax, 1501h          { Get Drive Device List }
  int 2Fh
END;
{ Die Anordnung der Laufwerksbuchstaben in "Drives" entspricht der
  Anordnung der Treiber-Daten in "Devices" }


PROCEDURE ReadSector (Drive : Word; SectorNum : LongInt; ToRead : Word; VAR Buffer); assembler;
ASM
  mov ax, 1508h                 { Absolute Disk Read }
  les bx, Buffer                { mu pro Sector 2048 Byte gro sein }
  mov cx, Drive                 { Laufwerksnummer }
  mov di, Word Ptr SectorNum    { Nummer des ersten zu lesenden Sektors }
  mov si, Word Ptr SectorNum[2] { in SI:DI }
  mov dx, ToRead                { Zahl der zu lesenden Sektoren }
  les bx, Buffer                { Adresse Empfangspuffer in ES:BX }
  int 2Fh
  jnc @ende                     { kein Fehler, dann raus }
    xor ah, ah                  { Fehler in AL, kann mit hinterher }
    mov InOutRes, ax            { mit "IOResult" abgefragt werden }
  @ende:                        { 15=invalid Drive, 21=not ready }
END;


FUNCTION IsCDROM (Drive : Word) : Boolean; assembler;
ASM
  mov ax, 1500h
  xor bx, bx            { Rckgabe der Funktion 1500h: }
  int 2Fh               { CX=Erstes CD-LW (0=A:, 1=B: usw.) }     
  xor ax, ax
  or  bx, bx
  jz  @nein
  mov cx, Drive
  mov ax, 150Bh
  int 2Fh
  or  ax, ax            { ist BX = ADADh, dann ist MSCDEX installiert }
  jz  @nein
  mov ax, TRUE
  @nein:
END;


PROCEDURE GetDirEntry (Drive : Byte; FileName : String; VAR Dir : TDirEntry); assembler;
ASM
  mov cl, Drive
  mov ch, 1          { "copy flag": 0=direct copy
                                    1=ISO 9660/HighSierra-Unterschiede lschen }
  les di, Dir        { Adresse von Dir in SI:DI }
  mov si, es

  les bx, FileName   { Pascal-String in ASCIIZ-String konvertieren }
  mov al, es:[bx]    { Lngenbyte in AL }
  xor ah, ah         { AH = 0 }
  add bx, ax         { Zeiger auf Stringende }
  inc bx
  mov es:[bx], ah    { Null hinter String-Ende schreiben }
  sub bx, ax         { Zeiger wieder auf erstes Zeichen des Strings }
  mov ax, 150Fh
  int 2Fh
  jc  @Error
  mov DiskFormat, ax { 0=High Sierra, 1=ISO 9660 }
  jmp @raus
  @Error:
  mov InOutRes, ax   { Fehlercode kann mit IOResult abgefragt werden }
  @raus:
END;
{ hnlich "Findfirst", FileName mu mit Backslash beginnen }


FUNCTION DriverRequestHeaderAddress (Drive : Word) : Pointer; assembler;
ASM
  mov ax, 1510h
  mov cx, Drive
  int 2Fh
  mov dx, es     { Segment }
  mov ax, bx     { Offset  }
END;


PROCEDURE ReadVTOC (Drive, VTOC_Num : Word; VAR VTOC : TSector); assembler;
ASM
  mov ax, 1505h
  mov cx, Drive
  mov dx, VTOC_Num  { meist 0, ist sone Art Volume-Nr }
  les bx, VTOC
  int 2Fh
  jnc @ende
  mov InOutRes, ax
  @ende:
END;


FUNCTION DateString (Date : VTOCDate) : String;
BEGIN
  With Date Do
  If Tag = #0#0 Then DateString:= '??' Else
  DateString:=Tag+'.'+Monat+'.'+Jahr+' - '+Stunde+':'+min+':'+sec+' Uhr';
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
