UNIT Clipbord;

INTERFACE
USES
  Dos, strings, filecopy;

PROCEDURE ResetClip;
PROCEDURE RewriteClip;
PROCEDURE WriteClipLine (s : String);
FUNCTION  EofClip          : Boolean;
FUNCTION  GetClipLine      : String;
PROCEDURE CloseClip;

PROCEDURE ReadBinClip  (VAR Buf; VAR Size : Word);
PROCEDURE WriteBinClip (VAR Buf;     Size : Word);
PROCEDURE GetTempPath;

CONST
  ClipMode : Byte = 0;
  Clipfile = 'CLIPBRD.DAT';

VAR
  TempPath : PathStr;

IMPLEMENTATION

VAR
  t  : Text;
  f  : File;
  cf : PathStr;

CONST
  ClipStatus : Word = 1;

{ -------------------------------- Text-Clipboard ------------------------}

PROCEDURE ResetClip;
BEGIN
  Assign (t, cf); FileMode:= 0;
  Reset (t);
  ClipStatus:= IOResult;
END;


PROCEDURE RewClip;
BEGIN
  If ClipMode<=1 Then
  BEGIN Rewrite (t); If ClipMode=1 Then ClipMode:= 2; END Else Append (t);
END;

PROCEDURE RewriteClip;
BEGIN
  Assign (t, cf); FileMode:= 2; RewClip;
  ClipStatus:= IOResult;
  If ClipStatus<>0 Then
  BEGIN SetFAttr (t, 32); RewClip; ClipStatus:= IOResult; END;
END;


PROCEDURE WriteClipLine (s : String);
BEGIN
  If ClipStatus=0 Then
  BEGIN
    WriteLn (t, s);
    ClipStatus:= IOResult;
  END;
END;


FUNCTION EofClip : Boolean;
BEGIN
  EofClip:= (ClipStatus<>0) or (Eof(t));
END;


FUNCTION GetClipLine : String;
VAR
  s : String;
BEGIN
  If ClipStatus=0 Then
  BEGIN ReadLn (t, s); ClipStatus:= IOResult; GetClipLine:= s; END;
END;


PROCEDURE CloseClip;
BEGIN Close (t); If IOResult<>0 Then; ClipStatus:= 1; END;


{--------------------------- Binr-Clipboard -----------------------------}

PROCEDURE ReadBinClip (VAR Buf; VAR Size : Word);
BEGIN
  Assign (f, cf); FileMode:= 0; Reset (f, 1);
  If IOResult=0 Then
  BEGIN
    BlockRead (f, Buf, Size, Size); If IOResult<>0 Then Size:= 0;
    Close (f); InOutRes:= 0;
  END Else Size:= 0;
END;


PROCEDURE WriteBinClip (VAR buf; Size : Word);
BEGIN
  Assign (f, cf); FileMode:= 2; Rewrite (f, 1);
  If IOResult<>0 Then
  BEGIN SetFAttr (f, 32); Rewrite (f, 1); If IOResult<>0 Then Exit; END;
  BlockWrite (f, Buf, Size, Size); InOutRes:= 0;
  Close (f); InOutRes:= 0;
END;


PROCEDURE GetTempPath;
BEGIN
  TempPath:= Trim (GetEnv ('TEMP'));
  If  TempPath='' Then TempPath:= Trim (GetEnv ('TMP'));
  If (TempPath='') or (ObjektExist (TempPath) <> Ver) Then
  BEGIN
    TempPath:= ParamStr (0);
    While (Length(TempPath)<>0) and (TempPath[Length(TempPath)]<>'\') do dec (TempPath[0]);
  END;
END;


BEGIN
  GetTempPath;
  cf:= BuildPath (TempPath, ClipFile);
END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
