UNIT Compare;           {Vergleichsoperationen von Arrays und Dateien}

INTERFACE

FUNCTION CompareBuffers  (VAR Buf_1, Buf_2; BufSize : Word) : Word;
FUNCTION CheckSum        (VAR Buffer;       BufSize : Word) : Word;
FUNCTION BufPos          (SeekChar : Char; VAR Buffer; BufSize : Word) : Word;
FUNCTION BufBackPos      (SeekChar : Char; VAR Buffer; BufSize : Word) : Word; 
FUNCTION NotEqualPos     (SeekChar : Char; VAR Buffer; BufSize : Word) : Word;
FUNCTION NotEqualBackPos (SeekChar : Char; VAR Buffer; BufSize : Word) : Word;


IMPLEMENTATION


FUNCTION CompareBuffers (VAR Buf_1, Buf_2; BufSize : Word) : Word; assembler;
ASM
  mov  cx, BufSize
  mov  dx, cx
  mov  ax, cx
  jcxz @ende                 {wenn Lnge=0, dann raus (ax=0=Puffer identisch)}

  push ds                    {Datensegment sichern}
  lds  si, Buf_1             {Adressen der beiden Variablen laden}
  les  di, Buf_2
  cld                        

  add  cx, 2
  add  ax, 2
  shr  cx, 1
  repe cmpsw                 {gleich zwei Bytes vergleichen}
  shl  cx, 1
  sub  si, 2                 {Rcksprung um 2 Bytes}
  sub  di, 2
  add  cx, 2

  test dl, 1                 {ist Size eine gerade Zahl ?}
  je @gerade
    inc cx                   {wenn nicht, cx um eins hochzhlen}
  @gerade:
  repe cmpsb                 {letztes Einzelbyte prfen}
  pop  ds                    {Datensegment wieder herstellen}

  sub  ax, cx                {errechnen der Stelle, an der Bytes nicht gleich}
  cmp  ax, dx
  jbe  @ende
    xor  ax, ax              {Variablen identisch: ax (Funktionsrckgabe) = 0}
  @ende:
END;
{ Vergleicht zwei gleichgroe Datenpuffer miteinander. Sind beide Puffer }
{ identisch, wird 0 - ansonsten die Position zurckgegeben, ab der sich  }
{ die beiden Puffer unterscheiden. }


FUNCTION CheckSum (VAR Buffer; BufSize : Word) : Word; assembler;
ASM
  xor bx, bx
  xor ax, ax
  mov cx, BufSize
  mov dx, cx
  shr cx, 1
  jcxz @raus
  mov di, ds
  lds si, buffer

  @start:
    lodsW
    add bx, ax
    rol bx, 1
  loop @start

  test dx, 1
  je @weiter
  lodsb
  add bx, ax
  rol bx, 1

  @weiter:
  mov ds, di
  @raus:
  mov ax, bx
END;
{bildet die 16-Bit-Prfsumme eines Daten-Puffers. Diese ist recht genau, da}
{sie auch unterscheidet, wenn nur zwei Zeichen miteinander vertauscht wurden.}



FUNCTION BufPos (SeekChar : Char; VAR Buffer; BufSize : Word) : Word; assembler;
ASM
  cld
  mov   cx, BufSize
  mov   bx, cx
  jcxz  @weiter
  mov   al, SeekChar
  les   di, Buffer
  repne scasB
  je    @weiter
  xor   bx, bx
  @weiter:
  sub   bx, cx
  mov   ax, bx
END;
{stellt wie POS die Postion des ersten Zeichens im Puffer fest, das mit dem}
{Zeichen SeekChar bereinstimmt. Ist BufPos=0, dann wurde kein berein-}
{stimmendes Zeichen gefunden}



FUNCTION BufBackPos (SeekChar : Char; VAR Buffer; BufSize : Word) : Word; assembler;
ASM
  std
  mov   cx, BufSize
  mov   al, SeekChar
  les   di, Buffer
  add   di, cx
  dec   di
  inc   cx
  repne scasB
  mov   ax, cx
  cld             {<- mu!}
END;
{Wie BufPos - der Puffer wird jedoch von hinten nach vorn durchsucht.}
{Festgestellt wird als die Position des LETZTEN Feldes, das mit SeekChar}
{bereinstimmt.}


FUNCTION NotEqualPos (SeekChar : Char; VAR Buffer; BufSize : Word) : Word; assembler;
ASM
  cld
  mov  cx, BufSize
  mov  bx, cx
  jcxz @weiter
  mov  al, SeekChar
  les  di, Buffer
  repe scasB
  jne  @weiter
  xor  bx, bx
  @weiter:
  sub  bx, cx
  mov  ax, bx
END;
{Stellt fest, ab welcher Position die Zeichen im Puffer nicht mehr mit dem}
{Zeichen SeekChar bereinstimmen. Ist NotEqualPos=0, dann enthlt der}
{gesamte Puffer das Zeichen SeekChar.}


FUNCTION NotEqualBackPos (SeekChar : Char; VAR Buffer; BufSize : Word) : Word; assembler;
ASM
  std
  mov  cx, BufSize
  mov  al, SeekChar
  les  di, Buffer
  add  di, cx
  dec  di
  inc  cx
  repe scasB
  mov  ax, cx
  cld  {<- mu}
END;
{genau wie NotEqualPos - der Puffer wird jedoch von hinten nach vorn}
{geprft.}


END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
