UNIT DblFile;           { Operationen mit zwei Dateien }

(* ACHTUNG: das aufrufende Programm mu mittels $M mindestens 1024 Byte
   Heap belegen, optimal sind ca. 140000: {$M xxxxx, 2048, 140000} *)

INTERFACE

USES
  Compare, DOS, FileCopy, Strings;

TYPE
  TFileBuffer   = Array[1..65535] Of Char;
  DoubleFileRec = RECORD
                    Buffer1, Buffer2 : ^TFileBuffer; { Lese-/Vergleichs-Puffer }
                    BufEnd1, BufEnd2 : Word;         { Anzahl Zeichen in Puffern }
                    BufPtr1, BufPtr2 : Word;         { Bearbeitungs-Position innerhalb des Puffers }
                    BufSize          : Word;         { Puffergre (je Puffer) }
                    UserProc         : Pointer;      { Zeiger auf benutzerdefinierte Prozedur }
                    VerifyFunc       : Pointer;      { Zeiger auf Verify-Prozedur }
                    Parameter        : Word;         { Steuerungs-Parameter }
                    f1, f2           : File;         { die beiden Dateien }
                  END;
  TDFUserProc   = PROCEDURE (VAR Files : DoubleFileRec);

CONST                    { mgliche Parameter fr SetDFParameter }
  CompareComplete  =  1; { nur fr CompareFiles, bewirkt, da auch
                           unterschiedlich groe Dateien verglichen werden }

                         { nur fr CopyFile }
  DelArchiveAttr   =  2; { lscht das Archiv-Flag der Quelldatei }
(*OverwriteRO      =  4; { berschreibt auch schreibgeschtzte Dateien } *)
  SetOrigAttr      =  8; { setzt die Attribute der Quelldatei fr die Zieldatei }

                         { fr copyfile und movefile }
  DestFileChecked  = 16; { internes Prf-Bit, nicht als Parameter erlaubt! }
  DestFileNotExist = DestFilechecked or 0;  { teilt filecopy mit, da die Zieldatei nicht existiert. }
  DestFileExist    = DestFileChecked or 32; { teilt filecopy mit, da die Zieldatei bereits existiert }

  EraseSourceFile  = 64; { nur fr movefile: gibt an, ob nach einem
                           laufwerksbergreifende Verschieben die Quelldatei
                           gelscht werden soll. }

PROCEDURE AssignFiles     (VAR Files : DoubleFileRec; File1, File2 : String);
PROCEDURE SetDFUserProc   (VAR Files : DoubleFileRec; UserProc  : TDFUserProc);
PROCEDURE SetDFVerifyFlag (VAR Files : DoubleFileRec);
PROCEDURE SetDFParameter  (VAR Files : DoubleFileRec; Parameter : Word);

PROCEDURE CopyFile        (VAR Files : DoubleFileRec);
PROCEDURE MoveFile        (VAR Files : DoubleFileRec);
FUNCTION  CompareFiles    (VAR Files : DoubleFileRec) : LongInt;


IMPLEMENTATION


PROCEDURE AssignFiles (VAR Files : DoubleFileRec; File1, File2 : String);
BEGIN
  FillChar (Files, SizeOf(DoubleFileRec), 0);
  With Files Do
  BEGIN
    Assign (f1, File1);
    Assign (f2, File2);
  END;
END;
{ Gleiche Funktion wie "Assign", mu als erste Prozedur aufgerufen werden }


PROCEDURE SetDFUserProc (VAR Files : DoubleFileRec; UserProc : TDFUserProc);
BEGIN
  Files.UserProc:= @UserProc;
END;
{ Weist eine benutzerdefinierte Prozedur (UserProc) zu, die nach jedem
  Lese- bzw. Vergleichs-Vorgang ausgefhrt wird. Diese Prozedur mu genau
  dem Typ "TDFUserProc" entsprechen (siehe oben im INTERFACE-Teil) und als
  FAR-Prozedur deklariert werden.

  UserProc kann z.B. einen Fortschrittsbalken "antreiben", die Puffer-
  Inhalte auswerten oder manipulieren (konvertieren), Daten in externe
  Variablen umkopieren o..

  Achtung: SetDFUserProc mu nach jedem "AssignFiles"-Befehl
  aufgerufen werden, da AssignFiles die Prozedur-Zuweisung lscht. Explizit
  kann die User-Prozedur mit folgendem Befehl "abgeschaltet" werden:

  Files.UserProc:= NIL;
}


PROCEDURE SetDFParameter (VAR Files : DoubleFileRec; Parameter : Word);
BEGIN
  Files.Parameter:= Parameter;
END;
{ Setzt benutzerdefinierte Parameter. Mehrere Parameter mssen mit "or"
  verknpft werden. Mgliche Werte siehe Interface-Teil.

  Achtung: SetDFParameter mu nach jedem "AssignFiles"-Befehl
  aufgerufen werden, da AssignFiles die Parameter lscht. }


FUNCTION Verify (VAR Files : DoubleFileRec) : Integer; far; { intern fr copyfile }
VAR
  OldUserProc : Pointer;
  CompResult  : LongInt;
BEGIN
  With Files Do
  BEGIN
    OldUserProc:= UserProc;
    UserProc   := NIL;
    CompResult := CompareFiles (Files); { Time nur als Temp-Variable }
    UserProc   := OldUserProc;
    If InOutRes<>0 Then
    Verify     := IOResult Else
    Verify     := ord(CompResult<>0) * 1000; { eigener Standardwert }
  END;
END;


PROCEDURE SetDFVerifyFlag (VAR Files : DoubleFileRec);
BEGIN
  Files.VerifyFunc:= @Verify;
END;


PROCEDURE EraseFile (VAR f : File); { Intern fr CopyFile/MoveFile }
BEGIN
  SetFAttr (f, Archive); { <- da Erase bei schreibgeschtztem Laufwerk }
  InOutRes:= DOSError;   {    einen nicht abzufangenden Fehler auslst }
  If DOSError = 0 Then Erase (f);
END;


PROCEDURE CopyFile (VAR Files : DoubleFileRec);
TYPE
  TDFVerifyFunc = FUNCTION (VAR Files : DoubleFileRec) : Integer;

VAR
  Time      : Longint;
  Attr      : Word;
  Result    : Integer;
  f         : File;
  DestExist : Boolean;
  DestName  : PathStr;

LABEL
  Ende;

BEGIN
  With Files Do
  BEGIN
    FileMode:= 0;

    BufSize:= SizeOf(TFileBuffer);
    If MaxAvail < BufSize Then BufSize:= MaxAvail;
    BufSize:= BufSize and $FE00; { durch Sektorgre teilbarer Wert }
    If BufSize <> 0 Then GetMem (Buffer1, BufSize) Else
    BEGIN InOutRes:= 8; { DOS-Standard } Exit; END;
    Buffer2:= Buffer1; { mu !!! }

    GetFAttr (f1, Attr);
    Reset    (f1, 1);
    GetFTime (f1, Time);
    Result:= IOResult; If Result<>0 Then Goto Ende;

    DestName:= ASCIIZToPascal(FileRec(f2).Name);
    Assign (f, DestName);                      { mu hier drauen bleiben ! }
    If Parameter and DestFileChecked = 0 Then
    BEGIN Reset (f); Close (f); DestExist:= IOResult= 0; END Else
    DestExist:= (Parameter and DestFileExist=DestFileExist); { nicht <> 0 nehmen !! }

    If DestExist Then
    BEGIN
      Rename (f, BuildPath (GetPathName(DestName), '__copy__.tmp'));
      DestExist:= IOResult=0; { ist IOResult<>0, wird die Zieldatei direkt berschrieben }
    END;

    Rewrite (f2, 1);
    Result:= IOResult;
    If Result<>0 Then
    BEGIN
      If Result = 3 Then  { Path not found }
      BEGIN
        MakeTree (GetPathName(DestName));
        Result:= 0-IOresult;
        If Result<= -150 Then Goto Ende;
      END
      Else                { Datei schreibgeschtzt }
      SetFAttr (f2, Archive);
      Rewrite  (f2, 1);
      Result:= 0-IOResult; If Result<>0 Then Goto Ende;
    END;

    While not Eof (f1) Do
    BEGIN
      BlockRead  (f1, Buffer1^, BufSize, BufPtr1);
      Result:=   IOResult; If Result<>0 Then Goto Ende;

      If UserProc<>NIL Then TDFUserProc(UserProc) (Files);

      BlockWrite (f2, Buffer2^, BufPtr1, BufPtr2);
      Result:= 0-IOResult;

      If BufPtr1<>BufPtr2 Then { Zieldatentrger ist voll }
      BEGIN
        If not DestExist Then Result:= -101 Else
        BEGIN
          EraseFile (f);
          DestExist:= FALSE;
          BlockWrite (f2, Buffer2^[BufPtr2+1], BufPtr1-BufPtr2, BufPtr2);
          Result:= 0-IOResult;
          If BufPtr1<>BufPtr2 Then Result:= -101; { Zieldatentrger ist voll }
        END;
      END;
      If Result<>0 Then Goto Ende;
    END;

    SetFTime (f2, Time); InOutRes:= 0;

  Ende:
    FreeMem (Buffer1, BufSize);

    Close (f1); InOutRes:= 0;
    Close (f2); InOutRes:= 0;

    If Result=0 Then
    BEGIN
      If (Parameter and DelArchiveAttr<>0) and (Attr and archive<>0) Then
      SetFAttr (f1, Attr and (not archive)) Else
      SetFAttr (f2, Attr or archive);

      If VerifyFunc<>NIL Then Result:= TDFVerifyFunc(VerifyFunc) (Files);
    END;

    If DestExist Then
    BEGIN
      If Result<>0 Then
      BEGIN EraseFile (f2); Rename (f, DestName); END Else EraseFile (f);
    END Else
    If Result=-101 Then EraseFile(f2);

    InOutRes:= Result;
  END;
END;


PROCEDURE MoveFile (VAR Files : DoubleFileRec);
VAR
  Result   : Integer;
  DestName : PathStr;

BEGIN
  With Files Do
  BEGIN
    DestName:= ASCIIZToPascal(FileRec(f2).Name);
    Rename (f1, DestName);
    Result:= IOResult;
    If Result<>0 Then
    BEGIN
      CASE Result Of
        3  : BEGIN
               MakeTree (GetPathName (DestName));
               If InOutRes<>0 Then
               BEGIN InOutRes:= 0-InOutRes; Exit; END;
             END;
        5  : EraseFile (f2);  { ??? InOutRes=1003 ??}
        17 : BEGIN                 { Laufwerksbergreifendes Verschieben }
               CopyFile (Files);
               If (InOutRes=0) and (Parameter and EraseSourceFile<>0) Then
               BEGIN
                 EraseFile (f1);
                 Result:= IOResult;
                 If Result=150 Then InOutRes:= 1003 Else InOutRes:= Result;
                 { ??? oder 150 lassen? Quelllaufwerk schreibgeschtzt }
               END;
               Exit;
             END;
      END;
      Rename (f1, DestName);
      Result:= 0-IOResult;
    END;
    InOutRes:= Result;
  END;
END;
{ Verschiebt eine Datei oder benennt sie um (auch laufwerksbergreifend) }


FUNCTION CompareFiles (VAR Files : DoubleFileRec) : LongInt;
VAR
  Result : Integer;
  tmp    : LongInt;
LABEL
  Ende;
BEGIN
  With Files Do
  BEGIN
    BufSize:= SizeOf(TFileBuffer);
    If MaxAvail shr 1 < BufSize Then BufSize:= MaxAvail shr 1;
    BufSize:= BufSize and $FE00; { durch Sektorgre teilbarer Wert }
    If BufSize <> 0 Then
    BEGIN GetMem (Buffer1, BufSize); GetMem (Buffer2, BufSize); END Else
    BEGIN InOutRes:= 8; Exit; END;

    FileMode:= 0;

    Reset (f1, 1);
    Result:=   IOResult; If Result<>0 Then Goto Ende;
    Reset (f2, 1);
    Result:= 0-IOResult; If Result<>0 Then Goto Ende;

    If (Parameter and CompareComplete=0) and (FileSize(f1) - FileSize(f2)<>0) Then
    BEGIN CompareFiles:= -1; Goto Ende; END;

    REPEAT
      BlockRead (f1, Buffer1^, BufSize, BufEnd1);
      Result:=   IOResult; If Result<>0 Then Goto Ende;

      BlockRead (f2, Buffer2^, BufSize, BufEnd2);
      Result:= 0-IOResult; If Result<>0 Then Goto Ende;

      If BufEnd1=BufEnd2 Then
      BufPtr1:= CompareBuffers (Buffer1^, Buffer2^, BufEnd1) Else
      If BufEnd1<BufEnd2 Then
      BEGIN
        BufPtr1:= CompareBuffers (Buffer1^, Buffer2^, BufEnd1);
        If BufPtr1=0 Then BufPtr1:= BufEnd1+1;
      END Else
    { If BufEnd1>BufEnd2 Then }
      BEGIN
        BufPtr1:= CompareBuffers (Buffer1^, Buffer2^, BufEnd2);
        If BufPtr1=0 Then BufPtr1:= BufEnd2+1;
      END;

      If UserProc<>NIL Then TDFUserProc(UserProc) (Files);

      If BufPtr1<>0 Then
      BEGIN
        tmp:= FilePos(f1)-BufEnd1+BufPtr1;
        If BufEnd1<>BufEnd2 Then CompareFiles:= 0-tmp Else CompareFiles:= tmp;
        Goto Ende;
      END;

    UNTIL Eof(f1) or Eof(f2);

    CompareFiles:= 0;

  Ende:
    FreeMem (Buffer2, BufSize);
    FreeMem (Buffer1, BufSize);
    Close (f1); InOutRes:= 0;
    Close (f2);
    InOutRes:= Result;
  END;
END;

{ Vergleicht den Inhalt zweier Dateien binr. Ist das Funktionsergebnis 0,
  sind beide Dateien identisch, ist es <> 0, beinhaltet das
  Funktionsergebnis die Datei-Position (in Byte), ab der sich die beiden
  Dateien unterscheiden.

  Liefert die Funktion einen negativen Wert zurck, sind die beiden Dateien
  unterschiedlich gro. Abhngig davon, wie der Parameter "CompleteComp"
  gesetzt ist, sind zwei Ergebnisse mglich:

  CompleteComp = FALSE: -1
  CompleteComp = TRUE : 0-Dateipostion des ersten Unterschiedes

  Im ersten Fall werden die Dateien berhaupt nicht gelesen und -1 lediglich
  als eine Art Flag zurckgegeben. Im zweiten Fall werden die Dateien trotz
  ihres Grenunterschiedes solange gelesen, bis das Ende der kleinsten
  Datei erreicht wurde. Tritt vor dem Dateiende ein Unterschied auf, wird
  dessen Position als negativer Wert zurckgegeben, ansonsten die Position
  des nchsten Bytes der greren Datei (was im Grunde der Position des
  ersten Unterschiedes entspricht).

  Nach dem Aufruf von "CompareFiles" mu ZUERST IOResult geprft werden.
  Positive Werte bedeuten, da der Fehler beim Zugriff auf die 1. Datei
  aufgetreten ist, negative Werte, da der Fehler bei der 2. Datei
  aufgetreten ist - in diesem Falle kann durch "Spiegelung" des Wertes
  (mit abs(IOResult)) der korrekte (positive) Fehlercode ermittelt werden.

  Beim Auftreten eines Unterschiedes findet eine mit InstallDFUserProc
  installierte Prozedur im Record Files folgende relevante
  Informationen vor:

  BufPtr1: Position des ersten unterschiedlichen Zeichens im Puffer
  BufPtr2: undefiniert, sollte nicht ausgewerten werden
  BufEnd1: Zahl der zuletzt aus der 1. Datei gelesenen Zeichen (in Buffer1^)
  BufEnd2: Zahl der zuletzt aus der 2. Datei gelesenen Zeichen (in Buffer2^)

  Normalerweise bricht Comparefiles den Vergleich nach dem Auftreten des
  ersten Unterschiedes ab. Wird jedoch BufPtr1 von UserProc auf Null
  gesetzt, fhrt Comparefiles mit dem Vergleichen der Dateien fort.
}

END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
