UNIT Dev_IO;
{ Zugriffe auf Sektoren und Spuren logischer Laufwerke (ab DOS 3.1) }

INTERFACE
USES
  Disk;

CONST
  WriteTrack  = $41;
  FormatTrack = $42;
  ReadTrack   = $61;
  VerifyTrack = $62;

TYPE
  TRWBlock = RECORD
               SpecFunc  : Byte;    { immer 0 }
               Head      : Word;    { Kopfnummer/Seite }
               Cylinder  : Word;    { Zylindernummer }
                                    { nchstes wird von Read/Write gebraucht }
               FirstSec  : Word;    { erster zu bearbeitender Sektor }
               SecToRead : Word;    { Anzahl der zu bearbeitenden Sektoren }
               Buffer    : Pointer; { Adresse Lese-/Schreib-Puffer }
                                    { es folgt der inoffizielle Teil }
               Drive     : Char;    { Laufwerksbuchstabe oder Nummer }
               Mode      : Byte;    { was IOCTL machen soll }
             END;

  DeviceParam = RECORD
                  SpecFunc       : Byte;   { immer Null }
                  DeviceType     : Byte;
                  DeviceAttr     : Word;
                  Cylinder       : Word;
                  MediaType      : Byte;
                  BytesProSec    : Word;
                  SecProClust    : Byte;
                  ReservSec      : Word;
                  Fat_Kopien     : Byte;
                  Max_HauptEinTr : Word;
                  GesamtSec1     : Word;    { wenn <=32 MB, ansonsten =0 }
                  MedienBeschr   : Byte;
                  SecProFAT      : Word;
                  SecProSpur     : Word;
                  DiskSeiten     : Word;
                  VerstecktSec   : LongInt;
                  GesamtSec2     : LongInt; {wenn > 32 MB}
                END;

PROCEDURE GetDeviceParams (DriveLetter : Char; VAR DevPar : DeviceParam);
PROCEDURE IOCTL       (RWBlock         : TRWBlock);
PROCEDURE InitIOCTL   (VAR RWBlock     : TRWBlock;
                           DriveLetter : Char;
                           Modus       : Byte;
                           BufAddr     : Pointer);



IMPLEMENTATION


PROCEDURE GetDeviceParams (DriveLetter : Char; VAR DevPar : DeviceParam); assembler;
ASM
  push ds
  mov  ax, 440Dh
  mov  bl, DriveLetter
  and  bx, 31
  mov  cx, 0860h
  lds  dx, DevPar
  int  21h
  jc   @ende
  xor  ax, ax
  @ende:
  pop  ds
  mov  InOutRes, ax
END;


{ Initialisiert RWBlock, mu VOR IOCTL aufgerufen werden }

PROCEDURE InitIOCTL (VAR RWBlock     : TRWBlock;
                         DriveLetter : Char;
                         Modus       : Byte;
                         BufAddr     : Pointer); assembler;
ASM
  mov  ax, 4409h        { Is Drive Remote ? }
  mov  bl, Driveletter
  and  bl, 31
  int  21h
  jc   @error
  mov  ax, 2
  test dx, 1000h        { Netzlaufwerk ? }
  jnz  @error           { dann kein Zugriff via IOCTL erlaubt }
  inc  ax
  test dl, 01000000b    { untersttzt der Laufwerkstreiber IOCTL ? }
  jz   @error           { wenn Bit 6=0, dann nicht }

  les  di, RWBlock
  xor  ax, ax
  stosb                 { SpecFunc:= 0 }
  stosw                 { Head:= 0 }
  stosw                 { Zylinder:= 0 }
  stosw                 { erster zu bearbeitender Sektor:= 0 (!!!) }
  inc ax
  stosw                 { Zahl der zu lesenden/schreibenden Sektoren:= 1 }
  mov ax, Word Ptr BufAddr
  stosw
  mov ax, Word Ptr BufAddr[2]
  stosw                 { Adresse des Puffers, bei Verify und Format:= NIL }
  mov al, DriveLetter
  stosb
  mov al, Modus
  stosb
  xor ax, ax

  @error:
  mov InOutRes, ax
END;
{ Resultat anschlieend mit IOResult abfragen :
   0 = alles okay
   1 = Subfunktion nicht untersttzt
   2 = Zugriff auf Netzlaufwerk nicht mglich
   3 = Laufwerkstreiber untersttzt IOCTL-Zugriffe nicht
  15 = Laufwerk existiert nicht

Beispiele: InitIOCTL (RWBlock, 'A', VerifyTrack, NIL);
           InitIOCTL (RWBlock, 'c', ReadTrack,   BufAddr);
           InitIOCTL (RWBlock, #0,  FormatTrack, NIL); #0=aktuelles Laufwerk
}


PROCEDURE IOCTL (RWBlock : TRWBlock); assembler;
ASM
  push ds
  lds  dx, RWBlock
  mov  bx, dx
  mov  cl, [bx+14]         { cl := Mode }
  mov  bl, [bx+13]         { bl := Drive }
  and  bx, 31              { Umwandeln in Nummer (A=1, B=2, 0=Current) }
  mov  ch, 08h             { Gertekategorie (hier: Block) }
  mov  ax, 440Dh           { generische IOCTL-Funktion }
  int  21h
  jc   @error              { Carry gesetzt=Fehler }
  xor  ax, ax
  @error:
  pop  ds
  mov  InOutRes, ax        { Fehler mit IOResult abfragen }
END;



END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
