UNIT Dialogs;

INTERFACE

USES
  bioscrt, Monitor, mouse, menue, keyCode, editors;


CONST
  MaxHistLines = 8;


TYPE
  HistoryList = RECORD
                  HistPtr : Byte;
                  Line    : Array[1..MaxHistLines] Of MenStr;
                END;



PROCEDURE AssignHistoryList (VAR HistList : HistoryList);
PROCEDURE NotHistoryList;
PROCEDURE InsertInHistList  (VAR ss : String);
PROCEDURE LineEditBox (a, b, c : Byte; VAR StrToEdit : String; MaxStrLen : Byte; Title : MenStr; Typ : Byte);

CONST
  Normal      = 0;
  WithHelp    = 1;
  WithList    = 2;
  HelpAndList = 3;


IMPLEMENTATION


CONST
  HList  : ^HistoryList = NIL;




PROCEDURE AssignHistoryList (VAR HistList : HistoryList);
BEGIN
  HList:= addr (HistList);
END;


PROCEDURE NotHistoryList;
BEGIN
  HList:= NIL;
END;



FUNCTION FoundInList (VAR s : String) : Boolean;
VAR
  x : Byte;
BEGIN
  FoundInList:= FALSE;
  If HList = NIL Then Exit;
  For x:= 1 To HList^.HistPtr Do
  If HList^.Line[x] = s Then FoundInList:= TRUE;
END;



PROCEDURE InsertInHistList (VAR ss : String);
BEGIN
  If (HList = NIL) or (FoundInList(ss)) Then Exit;
  Move (HList^.Line[1], HList^.Line[2], SizeOf (HList^.Line) - SizeOf (HList^.Line[1]));
  If HList^.HistPtr < MaxHistLines Then inc (HList^.HistPtr);
  Move (ss, HList^.Line[1], SizeOf (HList^.Line[1]));
END;



PROCEDURE ViewList (a, b, c : Byte; Title : MenStr);

PROCEDURE Win;
VAR
  x : Byte;
BEGIN
  MenWin (a, b, c, b+10, Title);
  For x:= 1 To HList^.HistPtr Do
  MenLine (copy (HList^.Line[x], 1, c-a-5), '', chr (x), #1);
  MenuBalken;
END;

BEGIN
  If HList=NIL Then Exit;
  ViewMode:= ShowMen;
  Win;
  REPEAT
    MouseKey;
    Win;
  UNTIL EventOK;
  RestoreScreen;
END;



PROCEDURE ListKlickField (x, y : Byte);
BEGIN
  ClickField (x, y, #25#32#32, #0, Down);
  If ViewMode=ShowMen Then
  BEGIN WriteXY (x, y, #221#25#222, 8, 0); CharXY (x+1, y, #25, 14, 0); END;
END;



PROCEDURE LineEditBox (a, b, c : Byte; VAR StrToEdit : String; MaxStrLen : Byte; Title : MenStr; Typ : Byte);
VAR
  EditLen  : Byte;

PROCEDURE Win;
BEGIN
  MenWin (a, b, c, b+10, Title);
  Button (a+2, b+6,  '  ~Enter~  Okay  ', #13, #0);
  Button (a+2, b+8,  '  ~Esc~ Beenden  ', #27, #0);
  If Typ and WithHelp = WithHelp Then
  Button (a+20, b+6,  '  ~F1~    Hilfe  ', #0,  F1);
  If Typ and WithList = WithList Then
  Button (a+20, b+8,  '  ~F2~   Suchen  ', #0,  F2);
  If HList<>NIL Then ListKlickField (c-4, b+3);
END;

BEGIN
  RestoreScreen;
  REPEAT
    ViewMode:= ShowMen;
    Win;
    EditLen:= c-a-5; If HList<>NIL Then dec (EditLen, 2);

    REPEAT
      LineEditor (3, 4, StrToEdit, EditLen, MaxStrLen, 0, 7, Typ);
      Win;
    UNTIL EventOK;

    If (t1=#13) and (IfLineEdit) and (Length(StrToEdit)<>0) Then
    InsertInHistList (StrToEdit);

    If (t2=Down) or (t2=Up) Then
    BEGIN
      If (HList<>NIL) and (HList^.HistPtr>0) Then
      BEGIN
        RestoreScreen;
        ViewList (a, b, c, Title);
        If ord (t1) <= HList^.HistPtr Then
        Move (HList^.Line[ord(t1)], StrToEdit, SizeOf (HList^.Line[1]));
      END;
      EventOK:= FALSE;
    END;
    RestoreScreen;
  UNTIL EventOK;
  CursorOn;
  HList:= NIL;
END;



END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
