UNIT DirOp;

INTERFACE

PROCEDURE MDir (Path : String);
PROCEDURE CDir (Path : String);
PROCEDURE RDir (Path : String);
PROCEDURE GDir (LW   : Byte; VAR Path);
var llw : Word;
IMPLEMENTATION




PROCEDURE MDir (Path : String); Assembler;
ASM
  push ds
  lds si, Path
  xor ax, ax
  lodsb
  or ax, ax
  jz @ende
  mov dx, si
  add si, ax
  mov ds:[si], ah
  mov ah, $39
  int $21
  jc @ende
  xor ax, ax
  @ende:
  pop ds
  mov InOutRes, ax
END;



PROCEDURE RDir (Path : String); Assembler;
ASM
  push ds
  lds  si, Path
  xor  ax, ax
  lodsb
  or   ax, ax
  jz   @ende
  mov  dx, si
  add  si, ax
  mov [si], ah
  mov  ah, $3A
  int  $21
  jc   @ende
  xor  ax, ax
  @ende:
  pop  ds
  mov  InOutRes, ax
END;




PROCEDURE CDir (Path : String); Assembler;
ASM
  push ds
  lds  si, Path
  xor  ax, ax
  lodsb
  or   ax, ax
  jz   @ende

  mov  bx, ax            {evtl. Laufwerkswechsel}
  LodsW
  cmp  ah, ':'
  jne  @weiter
  and  al, 00011111b     {Laufwerksnummer, 0=A usw.}
  dec  al

  mov  dl, al
  mov  ah, $0E
  int  $21
  mov  ah, $19
  int  $21
  mov  dh, al
  cmp  dl, dh
  mov  ax, 1
  jne  @ende

  @weiter:
  mov  ax, bx
  lds  si, Path
  inc  si
  mov  dx, si
  add  si, ax
  mov [si], ah
  mov  ah, $3B
  int  $21
  jc @ende
  xor  ax, ax

  @ende:
  pop  ds
  mov  InOutRes, ax
END;




PROCEDURE GDir (LW : Byte; VAR Path); assembler;
ASM
  mov  al, LW          {ermittle Laufwerksbuchstaben}
  mov  dl, al
  or   al, al
  jnz  @weiter
  mov  ah, $19
  int  $21
  inc  al
  @weiter:
  mov  bh, al
  add  bh, 64

  push ds             {ermittle aktuellen Pfad}
  lds  si, Path
  add  si, 4
  mov  ah, $47
  int  $21
  jc  @ende

  cld                 {Suche Null-Byte}
  les  di, Path
  add  di, 4
  mov  cx, 255
  mov  dx, cx
  repne scasb
  sub  dx, cx
  add  dx, 2
  
  les  di, Path        {schreibe Lngenbyte und Laufwerksbuchstabe}
  mov  ax, bx
  mov  al, dl
  StosW
  mov ax, '\:'         {mu umgekehrt sein}
  StosW

  @ende:
  pop  ds
END;



END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
