UNIT Disk;

INTERFACE
USES
  CDROM;

TYPE
  DiskInfoRec = RECORD
                  SectorsPerCluster  : Word;
                  FreeClusters       : Word;
                  BytesPerSector     : Word;
                  Clusters           : Word;
                  UsedClusters       : Word;
                  Used               : LongInt;
                  Free               : LongInt;
                  Size               : LongInt;
                END;

  DiskSizeRec = RECORD
                  Used               : LongInt;
                  Free               : LongInt;
                  Size               : LongInt;
                END;

  TDriveList  = Array[1..26] Of Byte;


CONST
  RemoveSupport  = $0800;  { es kann abgefragt werden, ob Medium wechselbar } 
  NetWorkDrv     = $1000;  { Netzlaufwerk, dann nur SUBST-Bit gltig }
  InterLnkDrv    = $2000;  { Laufwerk mit Interlnk erzeugt }
  SubstDrv       = $8000;  { Laufwerk mit SUBST erzeugt }

  DiskDrive      =   1;
  PhantomDrive   =   2;
  HardDisk       =   4;
  NetDrive       =   8;
  CDDrive        =  16;
  SubstDrive     =  32;
  InterLnkDrive  =  64;
  NoDrive        = 128; { mehrere Abfragen zugleich mit OR mglich }



FUNCTION  DosDriveNr  (DriveChar     : Char) : Byte;
PROCEDURE GetDiskInfo (Drive : Byte;   VAR InfoRec : DiskInfoRec);
PROCEDURE GetDiskSize (Drive : Byte;   VAR InfoRec : DiskSizeRec);
FUNCTION  DskSize     (Drive : Byte) : LongInt;
FUNCTION  DskFree     (Drive : Byte) : LongInt;
FUNCTION  DriveStatus (Drive : Byte) : Integer;
FUNCTION  CurrentDrive       : Char;
FUNCTION  BootDrive          : Byte;

FUNCTION  GetLogicalDriveMap (Drive       : Byte) : Byte;
PROCEDURE SetLogicalDriveMap (NewDriveNum : Byte);
FUNCTION  IsDriveRemote      (Drive       : Byte) : Word;
FUNCTION  IsRemovableMedia   (Drive       : Byte) : Boolean;
FUNCTION  DoorLockSignal     (Drive       : Word) : Boolean;

PROCEDURE GetLWList     (VAR DriveList : TDriveList);
FUNCTION  TrueName      (InPath        : String) : String; 
FUNCTION  Drive         (DriveChar     : Char)   : Byte;


IMPLEMENTATION
VAR
  DriveList    : TDriveList;      { fr Funktion "Drive" }

CONST
  DrivesListet : Boolean = FALSE; { fr Funktion "Drive" }


FUNCTION DosDriveNr (DriveChar : Char) : Byte; Assembler;
ASM
  mov al, DriveChar
  and al, 00011111b
END;

{ermittelt DOS-Laufwerksnummer aus Gro- oder Kleinbuchstaben (@=Current)}
{Drive 0 = Current, Drive 1 = A, Drive 2 = B}


PROCEDURE GetDiskInfo (Drive : Byte; VAR InfoRec : DiskInfoRec); assembler;
ASM
  mov  ah, 36h
  mov  dl, Drive
  int  21h

  cmp  ax, $FFFF       {Fehler?}
  jne  @los
    mov ax, 161        {'Fehler beim Lesen von Peripheriegert' }
    mov InOutRes, ax
    jmp @ende

  @los:
  les  di, InfoRec     {lade Adresse von InfoRec}
  mov  si, ax          {Register sichern}
  push dx              
  push bx

  stosW                {mov SectorsPerCluster, ax}
  mov  ax, bx; stosW   {mov FreeClusters, bx}
  mov  ax, cx; stosW   {mov BytesPerSec, cx}
  mov  ax, dx; stosW   {mov Clusters, dx}
  sub  ax, bx; stosW   {mov UsedCluster, ax-bx}

  mov  bx, ax          {Used}
  mov  ax, si
  mul  cx
  mul  bx
  stosW; mov ax, dx; stosW
              
  mov  ax, si          {Free}
  mul  cx
  pop  bx 
  mul  bx
  stosW; mov ax, dx; stosW

  mov  ax, si          {Size}
  mul  cx
  pop  bx              {Alter Inhalt von DX}
  mul  bx
  stosW; mov ax, dx; stosW

  @Ende:
END;


PROCEDURE GetDiskSize (Drive : Byte; VAR InfoRec : DiskSizeRec); assembler;
ASM
  mov  ah, 36h
  mov  dl, Drive
  int  21h

  cmp  ax, $FFFF       {Fehler?}
  jne  @los
    mov ax, 161        {'Fehler beim Lesen von Peripheriegert' }
    mov InOutRes, ax
    jmp @ende

  @los:
  les  di, InfoRec     {lade Adresse von InfoRec}
  push dx              {Register zwischenspeichern}
  push bx
  mov  si, ax          

  mov  ax, dx          {Used}
  sub  ax, bx          {Size Minus Free}
  mov  bx, ax          
  mov  ax, si
  mul  cx
  mul  bx
  stosW; mov ax, dx; stosW
              
  mov  ax, si          {Free}
  mul  cx
  pop  bx 
  mul  bx
  stosW; mov ax, dx; stosW

  mov  ax, si          {Size}
  mul  cx
  pop  bx              {Inhalt von DX}
  mul  bx
  stosW; mov ax, dx; stosW

  @Ende:
END;



FUNCTION DskSize (Drive : Byte): LongInt; assembler;
ASM
  mov ah, 36h
  mov dl, Drive
  int 21h
  mov bx, dx
  mov dx, ax       {Damit DskFree= -1, wenn Fehler}
  cmp ax, $FFFF
  je  @ende
  mul cx
  mul bx
  @ende:
END;



FUNCTION DskFree (Drive : Byte): LongInt; assembler;
ASM
  mov ah, 36h
  mov dl, Drive
  int 21h
  mov dx, ax             {Damit DskFree= -1, wenn Fehler}
  cmp ax, $FFFF
  je  @raus
  mul cx
  mul bx
  @raus:
END;



FUNCTION DriveStatus (Drive : Byte) : Integer; assembler;
ASM
  mov ah, 36h
  mov dl, Drive
  int 21h
END;
{prft, ob Diskette eingelegt ist, gibt -1 zurck, wenn nicht}



FUNCTION CurrentDrive : Char; assembler;
ASM
  mov ah, 19h
  int 21h
  add al, 65
END;



FUNCTION BootDrive : Byte; assembler;
ASM
  mov ax, 3305h
  int 21h
  mov al, dl
END;
{stellt fest, von welchem Laufwerk gebootet wurde (1=A, 2=B usw.)}


FUNCTION GetLogicalDriveMap (Drive : Byte) : Byte; assembler;
ASM
  mov ax, 440Eh
  mov bl, Drive    { A:=1, B:=2, aktuelles:= 0 }
  int 21h
  jnc @ende
  mov al, 255      { = Error }
  @ende:
END;
{ Ergebnis in AL:
  0 : Dem Laufwerk ist nur EIN logischer Bezeichner zugeordnet
  1 : Dem Laufwerk sind A: und B: zugeordnet, momentan ist A: gltig
  2 : Dem Laufwerk sind A: und B: zugeordnet, momentan ist B: gltig }


PROCEDURE SetLogicalDriveMap (NewDriveNum : Byte); assembler;
ASM
  mov ax, 440Fh
  mov bl, NewDriveNum
  int 21h
END;
{ NewDriveNum: Neue logische Nummer des Diskettenlaufwerkes:
  1: Das Laufwerk wird zu A:
  2: Das Laufwerk wird zu B: }

{ Beide Funktionen nur auf A: und B: anwenden, C: geht zwar, ist aber
  sinnlos. CD-ROM funktioniert nicht }


FUNCTION IsDriveRemote (Drive : Byte) : Word; assembler;
ASM
  mov ax, 4409h
  mov bl, Drive
  int 21h
  jnc @ende
  mov dx, $FFFF
  @ende:
  mov ax, dx
END;


FUNCTION IsRemovableMedia (Drive : Byte) : Boolean; assembler;
ASM
  mov ax, 4408h
  mov bl, Drive
  int 21h
  not al
  and al, 1
END;



FUNCTION DoorLockSignal (Drive : Word) : Boolean; assembler;
ASM
  jmp  @los
  @Buf: DD 0, 0, 0, 0, 0, 0, 0, 0  { 32 Byte gro }
  @los:
  push ds
  mov  ax, 440Dh
  mov  cx, 0860h
  mov  bx, Drive
  mov  dx, offset @buf; push cs; pop ds
  int  21h
  mov  si, dx
  add  si, 2
  lodsw
  shr  al, 1
  and  al, 1
  pop  ds
END;



PROCEDURE GetLWList (VAR DriveList : TDriveList);
VAR
  x, d, m : Word;
BEGIN
  For x:= 1 To 26 Do
  BEGIN
    d:= IsDriveremote(x);
    If d=$FFFF Then DriveList[x]:= NoDrive Else
    BEGIN
      If d and NetWorkDrv<>0 Then
      BEGIN
        If IsCDRom (x-1) Then
        DriveList[x]:= CDDrive Else DriveList[x]:= NetDrive;
      END Else
      BEGIN
        If x<=2 Then
        BEGIN
          m:= GetLogicalDriveMap (x);
          If m=255 Then DriveList[x]:= NoDrive Else
          If (x<>m) and (m<>0) Then
          DriveList[x]:= PhantomDrive Else DriveList[x]:= DiskDrive;
        END Else
        If d and InterLnkDrv<>0 Then DriveList[x]:= InterLnkDrive Else
        If d and SubstDrv   <>0 Then DriveList[x]:= SubstDrive    Else
        DriveList[x]:= HardDisk;
      END;
      If d and SubstDrv<>0 Then DriveList[x]:= DriveList[x] or SubstDrive;
    END;
  END;
END;
{ Erstellt eine Liste aller Laufwerke }


FUNCTION TrueName (InPath : String) : String; assembler;
ASM
  push  ds
  cld
  lds   si, InPath
  lodsb
  mov   bx, ax                   { InPath in ASCII-Z-String konvertieren }
  xor   bh, bh
  mov  [si+bx], bh               { NullByte ans Ende setzen }
  les   di, @result              { Funktionsergebnis anpeilen }
  inc   di                       { Lngenbyte berspringen }
  mov   ah, 60h                  { DOS-Func 60h "Get Truename" }
  int   21h
  jnc   @okay                    { Fehler ? }
    xor  cl, cl                  { Bei Fehler: Ergebnisstring:= ''; }
    jmp  @raus
  @okay:
  push  di
  xor   al, al                   { ASCII-Z- in Pascal-String konvertieren }
  cld
  mov   cx, 65535
  repne scasb                    { 0-Byte suchen }
  not   cx
  dec   cx                       { Lnge in CX }
  pop   di
  @raus:
  mov   es:[di-1], cl            { Lngenbyte setzen }
  pop   ds
END;

{ Ermittelt den tatschlichen Pfadnamen von Netz- und SUBST-Laufwerken }
{ Das Backslash mu immer mit angegeben (z.B. 'C:\') werden. Erlaubt
{ sind auch Unterverzeichnisse im SUBST-Laufwerk, die }
{ dann entsprechend expandiert werden. CD_ROM werden als Netz-Pfad gezeigt,
  Disketten mssen im Laufwerk liegen und Phantomlaufwerke mssen vorher
  mit SetLogicalDrivemap zu echten Laufwerken gemacht werden }


FUNCTION Drive (DriveChar : Char) : Byte;
BEGIN
  If not DrivesListet Then
  BEGIN GetLWList (DriveList); DrivesListet:= TRUE; END;
  Drive:= DriveList[DosDriveNr(DriveChar)];
END;


END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
