UNIT Disk_IO;

INTERFACE


CONST
  DiskRead    = 2;  { Mode fr AssignDisk }
  DiskWrite   = 3;
  DiskVerify  = 4;
  DiskFormat  = 5;

  Drive360    = 1;
  Drive1200   = 2;
  Drive720    = 3;
  Drive1440   = 4;
  Drive2880   = 6; { auch 5 }

  Transferred : Byte = 0;
  Versuche    : Byte = 0;
  MaxBufSize  = 512 * 64;

TYPE
  TIOBuf      = Array [1..MaxBufSize] Of Char;

  TrackLayOut = Array [1..64] Of
                RECORD
                  Spur, Seite, Sektor, Laenge : Byte;
                END;

  DiskIORec   = RECORD
                  Drive      : Char;    { Laufwerksbuchstabe oder Nummer }
                  Seite      : Byte;    { Kopfnummer/Seite }
                  Spur       : Word;    { Spur/Zylindernummer }
                  FirstSec   : Byte;    { erster zu bearbeitender Sektor }
                  BufAddr    : Pointer; { Lese-/Schreib-Puffer oder TrackLayOut }
                  SecToRead  : Byte;    { Anzahl der zu bearbeitenden Sektoren }
                  Mode       : Byte;    { was DiskIO machen soll }
                  SecPerTrack: Byte;    { mu ermittelt werden }
                  TracksPSide: Word;    { "" }
                  SideNum    : Word;    { "" }
                  SectorNum  : LongInt; { ""  Gesamtzahl Sektoren }
                END;

  BootSector  = RECORD
                  Jump           : Array[1..3] Of Byte;
                  OEMName        : Array[1..8] Of Char;
                  BytesProSec    : Word;
                  SecProClust    : Byte;
                  ReservSec      : Word;
                  Fat_Kopien     : Byte;
                  Max_HauptEinTr : Word;
                  GesamtSec1     : Word;    {wenn <=32 MB, ansonsten =0}
                  MedienBeschr   : Byte;
                  SecProFAT      : Word;
                  SecProSpur     : Word;
                  DiskSeiten     : Word;
                  VerstecktSec   : LongInt;
                  GesamtSec2     : LongInt; {wenn > 32 MB}
                  DriveNumber    : Byte;    {80h=erstes LW, sonst 0}
                  Reserved       : Byte;
                  BootSignatur   : Byte;    {=29h, wenn erw. BIOS-Param-Block}
                  DiskNummer     : Array[1..4]  Of Byte;
                  DiskLabel      : Array[1..11] Of Char;
                  FAT_Type       : Array[1..8]  Of Char;
                END;

  DiskParamRec= RECORD
                  FirstSpec      : Byte; { Bit 7-4=Steprate, Bit 3-0=HeadUnload }
                  SecondSpec     : Byte; { Bit 7-1=HeadLoadTime, Bit 0=Non-DMA-Mode (immer 0) }
                  MotorTurnOff   : Byte; { Motornachlaufzeit in Clock-Ticks }
                  BytesPerSec    : Byte; { 00h = 128, 01h = 256, 02h = 512, 03h = 1024 }
                  SecPerTrack    : Byte;
                  GAPLen         : Byte; { 2Ah for 5.25", 1Bh for 3.5", Gap, wenn Lesen/Schreiben }
                  DataLen        : Byte; { nur, wenn BytesPerSec = 0 }
                  FormatGapLen   : Byte; { 50h for 5.25", 6Ch for 3.5" , GAP, wenn formatiert}
                  FillerByte     : Byte; { Fllbyte beim Formatieren, normalerweise F6h }
                  HeadSettleTime : Byte; { in Millisekunden, HeadSettleTime }
                  MotorStartTime : Byte; { in ClockTicks, Motorhochlaufzeit }
                END;
                { DiskDriveParameterTable, Adresse an Int 1Eh }


PROCEDURE AssignDisk (IORec:DiskIORec; Drive:Char; Mode:Byte; BufAddr:Pointer);
PROCEDURE DiskIO     (IORec:DiskIORec);

PROCEDURE FillTrackLayOut    (IORec : DiskIORec);

PROCEDURE GetDDPT        (VAR DDPT  : DiskParamRec);
PROCEDURE SetDDPT        (    DDPT  : DiskParamRec);
PROCEDURE Make3DDPT      (VAR DDPT  : DiskParamRec; SecPerTrack : Byte);
PROCEDURE Make5DDPT      (VAR DDPT  : DiskParamRec; SecPerTrack : Byte);

PROCEDURE GetDiskMetrics (VAR IORec : DiskIORec);
PROCEDURE InitDrive      (VAR IORec : DiskIORec);
FUNCTION  GetDriveType   (VAR IORec : DiskIORec) : Byte; 

FUNCTION  ChangeLineSupport (VAR IORec : DiskIORec) : Byte;
FUNCTION  DiskChanged    (VAR IORec : DiskIORec) : Boolean;

FUNCTION  DiskIOErrStr   (ErrCode   : Word) : String;

CONST
  DDPTSize = SizeOf (DiskParamRec);


IMPLEMENTATION


PROCEDURE AssignDisk (IORec:DiskIORec; Drive:Char; Mode:Byte; BufAddr:Pointer); assembler;
ASM
  cld
  les di, IORec
  xor ah, ah            { Seite:= 0 }
  mov al, Drive
  and al, 00011111b     {'a' und 'A' und #1 = 1 usw.}
  dec al                { A=0 usw}
  cmp al, 1
  jbe @a                { <=B: ?}
  add al, 126           { Bit 7 fr Festplatten setzen }
  @a:
  stosw                 { Seite:= 0 + Laufwerkskennung }
  xor ax, ax
  stosw                 { Spur/Zylinder:= 0 }
  inc ax
  stosb                 { FirstSec:= 1, erster zu lesender Sektor}
  mov ax, Word Ptr BufAddr
  stosw
  mov ax, Word Ptr BufAddr[2]
  stosw                 { Adresse des Puffers (beim Lesen/Schreiben DiskIORec, }
  mov ah, Mode          { beim Formatieren Tracklayout }
  mov al, 1             { SecToRead:= 1 }
  stosw
END;
{ Verknpft das IORec mit dem angegebenen Laufwerk und Puffer und }
{ initialisiert Seite=0, Spur=0, Sektor=1, SecToRead=1 und ist damit }
{ bereit zum Lesen des Bootsektors einer Diskette }


PROCEDURE FillTrackLayOut (IORec : DiskIORec); assembler;
ASM
  cld
  push ds
  lds  si, IORec
  inc  si
  lodsb
  mov  bh, al     { KopfNummer/Seite }
  lodsw
  mov  bl, al     { SpurNummer }
  inc  si
  lodsw
  mov  di, ax     { es:di:= Addresse TrackLayOut }
  lodsw
  mov  es, ax
  add  si, 2
  lodsb
  xor  ah, ah
  mov  cx, ax     { SecPerTrack - Counter: Zahl der Sektoren je Spur }
  mov  dx, 0201h  { dl=2=Sektorgre 512 Byte }
  pop  ds
  @Nochmal:
    mov ax, bx
    stosw
    mov ax, dx
    stosw
    inc  dl
  loop @Nochmal
END;
{ Fllt den TrackLayOut-Puffer mit den Daten der aktuellen Seite und Spur }
{ Zuvor mu SecPerTrack ermittelt werden ! }
 

PROCEDURE DiskIO (IORec : DiskIORec); assembler;
ASM
  mov Byte Ptr Versuche, 0
  @NeuerVersuch:
  cld
  push ds
  lds  si, IORec
  lodsw
  mov  dx, ax     { dh:= Kopfnummer, dl:= Drive }
  lodsw
  mov  bx, ax     { bx:= Spur/Zylinder }
  mov  cl, 6
  shl  bh, cl
  mov  ch, bl     { Spur   0 -  x, bei C Zylindernummer}
  lodsb
  mov  cl, al     { Sektor 1 - 63, bei Platte bit 7-8 = Highbits CylinderNr}
  add  cl, bh     { or cl, bh mte auch gehen }
  lodsw
  mov  bx, ax     { es:bx:= Pufferaddresse }
  lodsw
  mov  es, ax
  lodsw           { ah:= Mode (Lesen, Schreiben usw.), al:= SecToRead }
  pop  ds
  int  13h                     { Ausfhrung }
  mov  Transferred, al
  jnc  @raus                   { Carry nicht gesetzt, also fehlerfrei }
    inc  Byte Ptr Versuche
    cmp  Byte Ptr Versuche, 3  { jeder Zugriff wird bei Fehler dreimal wiederholt }
    jbe  @neuerversuch
    mov  al, ah
    xor  ah, ah
    mov  InOutRes, ax          { Fehlercode spter mit IOResult abfragen }
  @raus:
END;
{ Fhrt je nach Inhalt von IORec einen Disk-Zugriff aus }



PROCEDURE GetDDPT (VAR DDPT : DiskParamRec); assembler;
ASM
  mov  ax, 351Eh     { Adresse der DDPT ermitteln }
  int  21h                                 
  mov  si, bx
  mov  ax, es
  push ds
  mov  ds, ax
  les  di, DDPT
  mov  cx, DDPTSize
  cld
  rep  movsb         { umkopieren }
  pop  ds
END;
{ kopiert die DDPT (DiskDriveParameterTable) in das Record }


PROCEDURE SetDDPT (DDPT : DiskParamRec); assembler;
ASM
  mov  ax, 351Eh
  int  21h                                 
  mov  di, bx
  push ds
  lds  si, DDPT
  mov  cx, DDPTSize
  cld
  rep  movsb
  pop  ds
END;
{ kopiert das Record in die DDPT zurck }



PROCEDURE Make3DDPT (VAR DDPT : DiskParamRec; SecPerTrack : Byte); assembler;
ASM
  push ds
  lds  bx, DDPT
  mov  al, 2                 { Bytes per Sektor = 512 }
  mov  ah, SecPerTrack       { Sektoren je Spur }
  mov  [bx+3], ax
  mov  byte ptr [bx+5], 27   { neue Gap-Len, 42 fr 5 1/4" }
  mov  byte ptr [bx+7], 108  { neue Format Gap-Len, Orig= 84(!), 5 1/4" = 80 }
  pop  ds
END;
{ Erzeugt die Werte fr 3 1/2" Laufwerk zum Formatieren.
  Vergehensweise:
  1. Original-DDPT mit GetDDPT einlesen
  2. Sicherheitskopie davon anlegen
  3. Gelesene DDPT mit Make3DDPT fr 3 1/2-Zller ndern
  4. Manipulierte DDPT mit SetDDPT zurckschreiben
  5. Diskette formatieren
  6. Sicherheitskopie der DDPT mit SetDDPT zurckschreiben
}



PROCEDURE Make5DDPT (VAR DDPT : DiskParamRec; SecPerTrack : Byte); assembler;
ASM
  push ds
  lds  bx, DDPT
  mov  al, 2                 { Bytes per Sektor = 512 }
  mov  ah, SecPerTrack       { Sektoren je Spur }
  mov  [bx+3], ax
  mov  byte ptr [bx+5], 42   { neue Gap-Len }
  mov  byte ptr [bx+7], 80   { neue Format Gap-Len, Orig= 84(!) }
  pop  ds
END;
{ Werte fr 5 1/4" Laufwerk zum Formatieren, Vorgehensweise wie oben }


PROCEDURE GetDiskMetrics (VAR IORec : DiskIORec);
VAR
  OldMode :  Byte;
  OldSide :  Byte;
  BootRec : ^Bootsector;
BEGIN
  With IORec Do
  BEGIN
    OldMode:= Mode;
    OldSide:= Seite;
    BootRec:= BufAddr;
    Mode   := DiskRead;
    Seite  := ord (Drive > #1);   { Festplatte: BootSector auf Seite 1 }
    DiskIO (IORec);
    Mode   := OldMode;
    Seite  := OldSide;
    If InOutRes<>0 Then Exit;
    With BootRec^ Do
    BEGIN
      SecPerTrack  := SecProSpur;
      SideNum      := DiskSeiten;
      If GesamtSec1=0 Then
      BEGIN
        TracksPSide:= GesamtSec2 DIV SecProSpur DIV DiskSeiten + 1;
        SectorNum  := GesamtSec2 +VerstecktSec;
      END Else
      BEGIN
        TracksPSide:= (GesamtSec1+VerstecktSec) DIV SecProSpur DIV DiskSeiten;
        SectorNum  := (GesamtSec1+VerstecktSec);
      END;
    END;
  END;
END;
{ Sofort nach AssignDrive aufrufen, weil dann die Spur- und Seitennummer
 noch auf 0, 0 zeigen }


PROCEDURE InitDrive (VAR IORec : DiskIORec); assembler;
ASM
  xor  ah, ah                     { Laufwerksreset }
  les  di, IORec
  mov  dl, es:[di]                { Laufwerksnummer in DL }
  int  13h
  jnc  @raus
    mov al, ah
    xor ah, ah
    mov InOutRes, ax
  @raus:
END;


FUNCTION GetDriveType (VAR IORec : DiskIORec) : Byte; assembler;
ASM
  mov ah, 8
  les di, IORec
  mov dl, es:[di]      { Laufwerksnummer in DL }
  int 13h
  jnc @okay
    mov al, ah
    xor ah, ah
    mov InOutRes, ax
  @okay:
  mov al, bl     { DriveType, Konstanten siehe Interface-Teil }

{ weitere Werte, die der Int 13h hier zurckliefert:
  mov maxSpur,    ch
  mov maxSektor,  cl   Bit 7-6 HighBits der Spurnummer bei Festplatten
  mov MaxSeite,   dh
  mov NumOfDrive, dl }
END;
{ ermittelt die Daten des Diskettenlaufwerkes, unabhngig vom
  einliegenden Medium

  DriveType:
  Drive360    = 1; 5 1/4"
  Drive1200   = 2;   "
  Drive720    = 3; 3 1/2"
  Drive1440   = 4;   "
  Drive2880   = 6;  auch 5 }


FUNCTION ChangeLineSupport (VAR IORec : DiskIORec) : Byte; assembler;
ASM
  mov ah, 15h
  les di, IORec       { Laufwerksnummer in DL }
  mov dl, es:[di]
  int 13h
  jnc @okay
    mov al, ah
    xor ah, ah
    mov InOutRes, ax
  @okay:
  mov al, ah  { 0= NoDrive, 1= kein ChangeLineSupport, 2= ChangeLinesupport
                3= HardDisk, dann CX:DX= Zahl der 512-Byte-Sektoren }
END;


FUNCTION DiskChanged (VAR IORec : DiskIORec) : Boolean; assembler;
ASM
  mov ah, 16h
  les di, IORec
  mov dl, es:[di]    { Laufwerksnummer in DL }
  int 13h
  jnc @okay
    mov al, ah
    xor ah, ah
    mov InOutRes, ax
  @okay:
  or  ah, ah
  jz  @raus
  mov ah, 1
  @raus:
  mov al, ah
END;
{ erkennt Diskettenwechsel, zuvor mu mit "ChangeLineSupport" ermittelt
  werden, ob Laufwerk diese Funktion untersttzt. Nach dem Aufruf setzt
  das BIOS die Flags zurck, das Ergebnis mu also zwischengespeichert
  werden (hnlich IOResult)

  Funktioniert aber irgendwie nicht
  (IOResult meldet Fehler 6=Changeline belegt oder nicht untersttzt) }


FUNCTION DiskIOErrStr (ErrCode : Word) : String;
BEGIN
  CASE ErrCode Of
    $00 : DiskIOErrStr:='';
    $02 : DiskIOErrStr:='Adressmarkierung nicht gefunden';
    $03 : DiskIOErrStr:='Diskette ist schreibgeschtzt';
    $04 : DiskIOErrStr:='Sektor nicht gefunden';
    $06 : DiskIOErrStr:='Diskette wurde gewechselt';
    $08 : DiskIOErrStr:='DMA-berlauf';
    $0C : DiskIOErrStr:='Spur wird nicht untersttzt oder falsches Medium';
    $10 : DiskIOErrStr:='Nicht korrigierbarer Prfsummenfehler';
    $20 : DiskIOErrStr:='Controller-Fehler';
    $32 : DiskIOErrStr:='Angabe des Laufwerkstyps im CMOS nicht korrekt';
    $40 : DiskIOErrStr:='Kopfpositionierungsfehler';
    $80 : DiskIOErrStr:='Timeout (Laufwerk reagiert oder existiert nicht)';
    Else  DiskIOErrStr:='Nicht definierter Fehler';
  END;
END;
{ Fehlercodes nur fr Diskettenlaufwerke }

END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
