UNIT DOScrt;             {Bildschirmausgabe via DOS}


INTERFACE
USES
  Rechnen;


PROCEDURE DOSChar   (xch  : Char); 
PROCEDURE DOSStr    (s    : String);
PROCEDURE DOSLn     (s    : String);
PROCEDURE DOSNum    (Zahl : LongInt);
PROCEDURE DOSNumLn  (Zahl : LongInt);

PROCEDURE LineFeed;

PROCEDURE GotoXY    (x, y : Byte); 
FUNCTION  WhereX          : Byte; 
FUNCTION  WhereY          : Byte;
PROCEDURE ClrScr;
PROCEDURE ClrEoL;

FUNCTION  Keypressed : Boolean;
PROCEDURE ScanKeys;
PROCEDURE WaitKey; 

VAR
  t1, t2 : Char; 


IMPLEMENTATION



PROCEDURE GotoXY (x, y : Byte); assembler;
ASM
  mov dl, x
  mov dh, y
  dec dl
  dec dh
  mov ah, 2
  xor bh, bh
  int $10
END; 



FUNCTION WhereX : Byte; assembler;
ASM
  mov ah, 3
  xor bh, bh
  int $10
  mov al, dl
  inc al
END;



FUNCTION WhereY : Byte; assembler;
ASM
  mov ah, 3
  xor bh, bh
  int $10
  mov al, dh
  inc al
END;  



PROCEDURE ClrScr; assembler;
ASM
  mov ah, 6
  xor al, al
  xor cx, cx
  mov dx, 6223
  mov bh, 7
  int $10
  mov dx, cx    
  mov ah, 2      
  xor bh, bh
  int $10
END;



PROCEDURE ClrEOL; assembler;
ASM
  mov ah, 3
  xor bh, bh
  int $10
  mov cx, dx
  mov dx, 6223
  mov dh, ch
  mov ah, 6
  xor al, al
  mov bh, 7
  int $10
END;



PROCEDURE DOSChar (xch : Char); assembler;
ASM
  mov dl, xch
  mov ah, $02
  int $21
END;



PROCEDURE DOSStr (s : String); assembler;
ASM
  push ds
  cld
  lds si, s
  xor ax, ax
  lodsb
  mov cx, ax
  jcxz @raus
@Start:
  lodsb
  mov dl, al
  mov ah, $02
  int $21                                 
  loop @Start
@raus:
  pop ds
END;



PROCEDURE LineFeed;
BEGIN
  DOSStr (#13#10);
END;



PROCEDURE DOSLn (s : String);
BEGIN
  DOSStr (s);
  LineFeed;
END;



PROCEDURE DOSNum (Zahl : LongInt);
BEGIN
  DOSStr (LongStr (Zahl));
END;



PROCEDURE DOSNumLn (Zahl : LongInt);
BEGIN
  DOSNum (Zahl);
  LineFeed;
END;



{---------------------------- Tastatur ----------------------------------}



FUNCTION Keypressed : Boolean; assembler;
ASM
  mov ah, $0B
  int 21h          { Kein Zeichen: AL=0 }
  and al, 1        { Zeichen verfgbar: AL=FFh, deswegen and al, 1 }
END;



PROCEDURE ScanKeys; assembler;
ASM
  mov ah, 7
  int $21
  mov t1, al
  or  al, al
  jnz @ende
  mov ah, 7
  int $21
  mov t2, al
  @ende:
END;



PROCEDURE WaitKey; assembler;
ASM
  mov ah, 7
  int $21
  or  al, al
  jnz @ende
  mov ah, 7
  int $21
  @ende: 
END;



PROCEDURE DOSStr1 (S : String); assembler;
ASM
  push ds
  lds  si, s
  lodsb
  mov  dx, si    { Lngenbyte bersprungen }
  mov  cl, al
  xor  ch, ch
  mov  ah, 40h   { Write to File or Device }
  mov  bx, 1     { Handle des Bildschirmes }
  int  21h
  pop  ds
END;



END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
