UNIT Drucker;

INTERFACE

CONST
  PrinterStatus : Byte = 0;       {Statusbyte des Druckers}

  TimeOut       =   1;            {1 wenn Zeitberschreitung}
  NotInstalled  =   2;            {manchmal 1 wenn LPTx gar nicht installiert}
  UnUsed        =   4;            {unbenutztes Bit, kann als Schalter dienen}
  LineError     =   8;            {1 bei bertragungsfehler}
  Online        =  16;            {0 wenn Drucker NICHT eingeschaltet}
  PaperOut      =  32;            {1 wenn Papier fehlt}
  DataNotReady  =  64;            {1 wenn Daten nicht empfangen werden konnten}
  NotBusy       = 128;            {1 wenn Drucker im OK-Zustand leer wartet}

  {Zum Testen einzelner Status-Bits:                             }
  {If PrinterStatus and TimeOut <> 0 Then TimeOut-Bit-ist-gesetzt}


  {Oft wird nur das erste Fehlerbit gesetzt und alle weiteren gar nicht}
  {erst geprft. Ist der Drucker z.B. nicht eingeschaltet, wird trotzdem}
  {kein fehlendes Papier gemeldet.}

  {Im Normalfall darf nur das Online-Bit auf 1 stehen}



PROCEDURE OpenPrinter  (LPT     : Word);
FUNCTION  PrinterOk             : Boolean;
PROCEDURE PrintChar    (Zeichen : Char);
PROCEDURE DOSPrint     (Zeichen : Char);


IMPLEMENTATION

CONST
  PrinterPort : Word = 0;      {Nummer des Druckers (LPT1=0, LPT2=1 usw.)}  



PROCEDURE OpenPrinter (LPT : Word); assembler;
ASM
  xor  bx, bx
  xor  cx, cx
  mov  ah, 255
  mov  dx, LPT
  cmp  dx, 4
  ja   @ende
  mov  cx, dx
  mov  ah, 1
  int  17h
  @ende:
  mov  PrinterStatus, ah
  mov  PrinterPort,   cx
END;
{ ffnet und Initialisiert den Drucker } 



FUNCTION PrinterOK : BOOLEAN; assembler;
ASM
  mov  ah, 2
  mov  dx, PrinterPort
  int  17h
  mov  PrinterStatus, ah
  xor  al, al
  test ah, 00101001b           {Paper Out, IOError, TimeOut}
  jnz  @ende
  inc  al                      {TRUE}
  @ende:
END;
{Fragt den Druckerstatus ab. Sollte vor dem Drucken jeden Zeichens verwendet}
{werden, damit bei einem Fehler keine Zeichen verloren gehen.}




PROCEDURE PrintChar (Zeichen : Char); assembler;
ASM
  xor ah, ah
  mov al, Zeichen
  mov dx, PrinterPort
  int 17h
  mov PrinterStatus, ah
END;
{schickt ein Zeichen zum Drucker}




PROCEDURE DOSPrint (Zeichen : Char); assembler;
ASM
  mov ah, 5
  mov dl, Zeichen
  int 21h
END;
{Druckt ein Zeichen via DOS nach LPT1. Bei einem Fehler wird DOSPrint}
{nach kurzer Zeit beendet, eine Fehlermeldung ist jedoch nicht erfabar.}



END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
