UNIT Editors;



INTERFACE

USES
  bioscrt, Monitor, mouse, menue, keyCode, strings;


PROCEDURE LineEditor  (x, y : Byte; VAR s : String; ViewLen, MaxStrLen : Byte; vc, hc, Typ : Byte);
PROCEDURE WriteClrStr (x, y : Byte; s : String; len, vc, hc : Byte);


CONST
  IfLineEdit : Boolean = FALSE;
  EditMouse  : Boolean = TRUE;

IMPLEMENTATION



PROCEDURE WriteClrStr (x, y : Byte; s : String; len, vc, hc : Byte);
VAR
  i : Byte;
BEGIN
  WriteXY (x, y, s, vc, hc);
  For i:= x+Length (s) To x+Len-1 Do CharXY (i, y, #32, vc, hc);
END;



PROCEDURE LineEditor (x, y : Byte; VAR s : String; ViewLen, MaxStrLen : Byte; vc, hc, Typ : Byte);
VAR
  tmp, s1 : String;
  Start   : Byte;
  ins     : Boolean;
BEGIN
  CursorOn;
  StrCopy (s, Tmp);

  Start:=0;
  ins:= TRUE;
  IfLineEdit:= FALSE;
  If ViewLen  > 80 Then ViewLen  :=  80;
  If MaxStrLen>253 Then MaxStrLen:= 253;
  If Length(s) < ViewLen Then
  GotoXY (Length(s)+1+x, y) Else GotoXY (x+1, y);

  REPEAT
    StrCopy (copy (s, Start+1, ViewLen), s1);
    If EditMouse Then MouseOff;

    WriteClrStr (lo(WindMin)+x+1, y+Hi(WindMin), s1, ViewLen, vc, hc);
    If EditMouse Then MouseOn;

    If EditMouse Then MouseKey Else ScanKeys;

    If (EditMouse) and (kn<>0) Then
    BEGIN
      If (ym=y+Hi(WindMin)) Then
      If (xm>x+lo(WindMin)) and (xm<=Length(s1)+x+1+Lo(WindMin)) Then
      GotoXY (xm-Lo (WindMin), y) Else
      If (xm>Length(s1)+x+1+Lo(WindMin)) and (xm<=ViewLen+x+Lo(WindMin)) Then
      GotoXY (x+Length (s1)+1, y) Else Exit Else Exit;
    END;

    If (t1<>#0) and (t1<>#27) and (t1<>#13) and (t1<>TAB) Then
    BEGIN
      If t1=Back Then
      BEGIN
        delete (s, WhereX+Start-1-x, 1);
        If WhereX>1+x Then GotoXY (WhereX-1, y) Else If Start>0 Then dec (Start);
      END
      Else
      BEGIN
        If not ins Then delete (s, WhereX+Start-x, 1);
        If Length (s) < MaxStrLen Then
        BEGIN
          insert (t1, s, WhereX+Start-x);
          If WhereX < ViewLen+x Then
          GotoXY (WhereX+1, y) Else If Start < 253 Then inc (Start) ;
        END;
      END;
      IfLineEdit:= TRUE;
    END Else
    CASE t2 Of
      F9, F10 : BEGIN Start:= 0; If t2=F9 Then s:='' Else StrCopy (Tmp, s); GotoXY (1+x, y); IfLineEdit:= TRUE; END;
      Left    : If WhereX>1+x Then GotoXY (WhereX-1, y) Else If Start>0 Then dec (Start);
      Right   : If WhereX <= Length(s)-Start+x Then
                If WhereX < ViewLen+x Then
                GotoXY (WhereX+1, y) Else If Start < 253 Then inc (Start) ;
      Entf    : BEGIN
                  delete (s, WhereX+Start-x, 1);
                  If (Length (s1)<2) and (Start>0) Then dec (Start);
                  IfLineEdit:= TRUE;
                END;
      Pos1    : BEGIN Start:= 0; GotoXY (1+x, y); END;
      Endx    : BEGIN
                  Start:= Length(s)-Length(s1);
                  If Length (s1)=ViewLen Then
                  BEGIN inc (Start); GotoXY (ViewLen+x, y); END Else
                  GotoXY (1+Length(s1)+x, y);
                END;
      Einfg   : Ins:= not Ins;
    END;
  UNTIL (t1=#13) or (t1=#27) or (t2=Up) or (t2=Down) or (t1=TAB)
  or ((t2=F1) and (Typ and 1=1)) or ((t2=F2) and (Typ and 2=2));
  If t1=#27 Then StrCopy (tmp, s);
  CursorOff;
END;




END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
