UNIT EdWin;

INTERFACE
USES
  BiosCrt, Monitor, Dos, Strings, KeyCode, Masken, Mouse, time;

TYPE
  TBuffer = Array[1..65535] Of Char;
  ClipRec = RECORD
              ClipBuf    : ^TBuffer;
              ClipSize   : Word;
              ClipEnd    : Word;
            END;
  EdRec   = RECORD
              Buf        : ^TBuffer;
              BufSize    : Word;
              BufEnd     : Word;
              CurPos     : Word;
              a, b, c, d : Byte;
              FirstChar  : Word;
              LastChar   : Word;
              Start      : Word;
              IfEdit     : Boolean;
              m1, m2     : Word;
              ClipBord   : ^ClipRec;
              EdNr       : Word;
            END;
CONST
  ActEditor  : Word = 0;
  LastEditor : Word = 0;

PROCEDURE InitClipBoard (VAR Clip : ClipRec; BufAddr : Pointer; ClipSiz : Word);
PROCEDURE InitEditor (a1, b1, c1, d1 : Byte; VAR Ed : EdRec; Buffer : Pointer; Size, Chars : Word; Clip : Pointer);
PROCEDURE EditWin    (VAR Ed : EdRec);
PROCEDURE SendKey    (VAR Ed : EdRec; tt1, tt2 : Char);
PROCEDURE DrawEditor (VAR Ed : EdRec);
PROCEDURE CheckMouse (VAR Ed : EdRec);

IMPLEMENTATION

CONST
  TCol    = 0;
  BCol    = 7;
  Ins     : Boolean = TRUE;
  SndKey  : Boolean = FALSE;

VAR
  Draw    : Boolean;


PROCEDURE InitClipBoard (VAR Clip : ClipRec; BufAddr : Pointer; ClipSiz : Word);
BEGIN
  With Clip Do
  BEGIN
    ClipBuf := BufAddr;
    ClipSize:= ClipSiz;
    ClipEnd := 0;
  END;
END;



PROCEDURE EditWin (VAR Ed : EdRec);
VAR
  tmp        : Word;
  CurX, CurY : Word;

CONST
  Modus  : Byte = 0;

LABEL
  GetKey;

PROCEDURE CurXY (x, y : Byte); assembler;
ASM
  mov dl, x
  mov dh, y
  dec dl
  dec dh
  mov ah, 2
  xor bh, bh
  int 10h
END; 


PROCEDURE GetCurPos;
VAR
  x, y, i : Word;
BEGIN
  With Ed Do
  BEGIN
    x:= a; y:= b; i:= FirstChar; CurX:= 0; CurY:= 0;
    While (i<=BufEnd+1) and (y<=d) Do
    BEGIN
      If i=CurPos Then BEGIN CurX:= x; CurY:= y; Exit; END;
      If Buf^[i]=#13 Then BEGIN inc (y); x:= a; inc (i); END Else inc (x);
      inc (i);
    END;
  END;
END;
{ Wenn CurX und CurY = 0, dann befindet sich Cursor ber oder unter dem }
{ sichtbaren Editorfenster }


PROCEDURE IncVar (VAR Variab : Word);
VAR                          
  ch : Char;
BEGIN
  With Ed Do If Variab<=BufEnd Then
  BEGIN
    REPEAT inc (Variab); UNTIL (Variab>=BufEnd) or (Buf^[Variab]=#10);
    If Variab<=BufEnd Then inc (Variab);
  END;
END;


PROCEDURE ShowBuf;
VAR
  ch        : Char;
  Counter   : Word;
  OldCurPos : Word;
  wy, wx    : Byte;
  jmp       : Byte;
LABEL
  Nochmal;
BEGIN
  With Ed Do
  BEGIN
  Nochmal:
    LastChar:= FirstChar;
    If Modus=1 Then BEGIN OldCurPos:= CurPos; CurPos:= 0; END;
    For wy:= b To d Do
    BEGIN
      wx:= a; Counter:= 0;
      If LastChar<=BufEnd Then
      REPEAT
        ch:= Buf^[LastChar];
        If  (wy=ym) and (Modus=1) Then
        BEGIN
          If ((ch<>#10) and (wx=xm))
          or ((ch =#10) and (CurPos=0)) Then CurPos:= LastChar;
        END;
        If (wx<=c) and (Counter>=Start) and (ch<>#13) and (ch<>#10) Then
        BEGIN
          If (ch=TAB) or (ch=#7) Then ch:= ' ';
          If (LastChar>=m1) and (LastChar<=m2) and (m1<>0) and (m2<>0) Then
          CharXY (wx, wy, ch, TCol, cyan) Else
          CharXY (wx, wy, ch, TCol, BCol);
          inc (wx);
        END;
        inc (Counter);
        inc (LastChar);
        If  (wy=ym) and (Modus=1) Then
        BEGIN
          If  ((ch<>#10) and (wx=xm))
          or (((ch= #10) or (LastChar>BufEnd)) and (CurPos=0)) Then CurPos:= LastChar;
        END;
      UNTIL (LastChar>BufEnd) or (ch=#10);
      WriteXY (wx, wy, FillString (c+1-wx), TCol, BCol);
    END;
    If (Modus=1) and (Curpos=0) Then
    If LastChar>BufEnd Then CurPos:= BufEnd+1 Else CurPos:= OldCurPos;
    If LastChar>BufEnd Then LastChar:= BufEnd;
    If (CurPos<=BufEnd) and (Buf^[CurPos]=#10) and (CurPos>0) Then dec (CurPos);
    GetCurPos;
    If ((CurX=0) or (CurY=0)) and (FirstChar<BufEnd) and (Modus<>1) Then
    BEGIN
      IncVar (FirstChar); Goto Nochmal;
    END Else
    BEGIN
      jmp:= c-a; If jmp<2 Then jmp:= 2;
      If (CurX<=Start+1) and (Start<>0) Then
      BEGIN
        If Start>=jmp Then
        While (Start>=jmp) and (CurX<=Start+1) do dec (Start, jmp shr 1) Else Start:= 0;
        Goto Nochmal;
      END;
      If CurX-Start>c Then
      BEGIN
        While (CurX-Start>c) and (Start<BufSize-jmp shr 1) do inc (Start, jmp shr 1);
        Goto Nochmal;
      END;
      CurXY (CurX-Start, CurY);
    END;
  END;
END;



PROCEDURE ScrollDown;
VAR
  ch  : Char;
  wy  : Byte;
BEGIN
  With Ed Do If CurPos<=BufEnd Then
  BEGIN
    REPEAT inc (CurPos); UNTIL (CurPos>BufEnd) or (Buf^[CurPos]=#10);
    If CurPos<=BufEnd Then inc (CurPos);
    If (CurPos>=LastChar) and (LastChar<BufEnd) Then
    BEGIN
      LastChar:= FirstChar;
      For wy:= b To d Do If LastChar<BufEnd Then
      REPEAT
        ch:= Buf^[LastChar]; inc (LastChar);
      UNTIL (LastChar>=BufEnd) or (ch=#10);
      IncVar (FirstChar);
    END;
  END;
END;


PROCEDURE DecVar (VAR Variab : Word);
VAR
  ch : Char;
BEGIN
  With Ed Do If Variab>2 Then
  BEGIN
    dec (Variab, 2); ch:= Buf^[Variab-1];
    While (Variab>1) and (ch<>#13) and (ch<>#10) Do
    BEGIN dec (Variab); ch:= Buf^[Variab-1]; END;
  END Else Variab:= 1;
END;


PROCEDURE ScrollUp;
BEGIN
  With Ed Do
  BEGIN
    DecVar (CurPos);
    If CurPos<FirstChar Then DecVar (FirstChar);
  END;
END;


PROCEDURE GoRight;
BEGIN
  With Ed Do If CurPos<=BufEnd Then
  BEGIN
    inc (CurPos);
    If (Buf^[CurPos]=#10) and (CurPos<=BufEnd) Then inc (CurPos);
  END;
END;


PROCEDURE GoLeft;
BEGIN
  With Ed Do If CurPos>1 Then
  BEGIN
    dec (CurPos);
    If (Buf^[CurPos]=#10) and (CurPos>1) Then dec (CurPos);
  END;
END;


PROCEDURE InsChar (ch : Char);
BEGIN
  With Ed Do If (not Ins) or (BufEnd<BufSize) Then
  BEGIN
    If ((Ins) or (ch=#13) or (ch=#10)) and (CurPos<=BufEnd+1) and (BufEnd<BufSize) Then
    BEGIN
      inc (BufEnd);
      If CurPos<BufEnd Then
      Move (Buf^[CurPos], Buf^[CurPos+1], BufEnd-CurPos);
    END;
    Buf^[CurPos]:= ch;
    inc (CurPos);
    IfEdit:= TRUE;
  END;
END;


PROCEDURE DelBackChar;
BEGIN
  With Ed Do If CurPos>1 Then
  BEGIN
    Move (Buf^[CurPos], Buf^[CurPos-1], BufEnd+1-CurPos);
    dec (CurPos);
    dec (BufEnd);
    IfEdit:= TRUE;
  END;
END;


PROCEDURE DelEntfChar;
BEGIN
  With Ed Do If CurPos<=BufEnd Then
  BEGIN
    Move (Buf^[CurPos+1], Buf^[CurPos], BufEnd-CurPos);
    dec (BufEnd);
    IfEdit:= TRUE;
  END;
END;


PROCEDURE MoveToClipBoard;
BEGIN
  With Ed        Do If (ClipBord<>NIL) and (m1<>0) and (m2<>0) Then
  With ClipBord^ Do If  ClipBuf <>NIL  Then
  BEGIN
    ClipEnd:= m2+1-m1;
    If ClipEnd>ClipSize Then ClipEnd:= ClipSize;
    Move (Buf^[m1], ClipBuf^, ClipEnd);
  END;
END;


PROCEDURE DelBlock;
BEGIN
  With Ed Do If (m1<>0) and (m2<>0) Then
  BEGIN
    If (Buf^[m2+1]=#13) and (m2+2<BufEnd) Then inc (m2, 2);
    If t2<>AltY Then MoveToClipBoard;
    CurPos:= m1;
    If (FirstChar>CurPos) or (LastChar<Curpos) Then
    BEGIN
      FirstChar:= CurPos;
      If (FirstChar=1) or (Buf^[Firstchar-1]<>#10) Then ScrollUp;
      CurPos:= m1;
    END;
    Move (Buf^[m2+1], Buf^[m1], BufEnd-m2);
    dec  (BufEnd, m2+1-m1);
    m1:= 0; m2:= 0;
    Start:= 0; ShowBuf;
    IfEdit:= TRUE;
  END;
END;


PROCEDURE InsBlock;
VAR
  Versatz : Word;
BEGIN
  With Ed        Do If  ClipBord<>NIL  Then
  With ClipBord^ Do If (ClipBuf <>NIL) and (ClipEnd<>0) Then
  BEGIN
    If b<>d Then Versatz:= ClipEnd Else
    BEGIN
      Versatz:= 1;
      While (Versatz<ClipEnd) and (ClipBuf^[Versatz+1]<>#13) Do inc (Versatz);
    END;
    If Versatz > BufSize-BufEnd Then Versatz:= BufSize-BufEnd;
    If BufEnd  > CurPos Then
    Move (Buf^[CurPos], Buf^[CurPos+Versatz],  BufEnd+1-Curpos);
    Move (ClipBuf^,     Buf^[Curpos],          Versatz);
    m1:= CurPos; m2:= CurPos+Versatz-1;
    inc (BufEnd, Versatz);
    IfEdit:= TRUE;
  END;
END;


BEGIN
  If SndKey Then Goto GetKey;
  With Ed Do
  REPEAT
    ShowBuf; If Draw Then Exit;
    kn:= 0; t1:= #0; t2:= #0; MouseOn;
    REPEAT
      MouseGet; 
      If (kn<>0) and (MouseIn (a, b, c, d)) Then
      BEGIN
        If kn=1 Then BEGIN m1:= 0; m2:= 0; END;
        MouseOff;
        REPEAT
          If (d<>b) and (ym>d) and (LastChar<BufEnd) Then
          BEGIN xDelay (70); m2:= LastChar; IncVar (FirstChar); ym:= d; END;
          Modus:= 1; ShowBuf; Modus:= 0;
          If m1=0 Then m1:= CurPos Else If CurPos>m1 Then m2:= CurPos-1;
          MouseGet;
        UNTIL kn=0;
        t1:=#0; t2:= #0; MouseOn;
      END;
    UNTIL (kn<>0) or (keypressed);
    MouseOff;
    If kn=0 Then ScanBKeys Else
    If MouseIn (a, b, c+1, d) Then
    BEGIN
      t1:= #0;
      If (d=b) and (xm>c) Then Exit;
      If ym=b Then t2:=Up Else If ym=d Then t2:=Down else t2:=#0;
      If kn=1 Then xDelay (70);
    END Else Exit;
  GetKey:
    If t1<>#0 Then
    CASE t1 Of
      #13, #10 : If b=d Then Exit Else
                 BEGIN
                   DelBlock; InsChar (#13); InsChar (#10);
                   If WhereY>=d Then
                   BEGIN
                     tmp:= (d-b) shr 2; If tmp=0 Then tmp:= 1;
                     For tmp:= 1 To Tmp Do IncVar (FirstChar);
                   END;
                   Start:= 0;
                 END;
      TAB      : BEGIN
                   If ActEditor<LastEditor Then
                   inc(ActEditor) Else ActEditor:= 1;
                   Exit;
                 END;
      Back     : If (m1<>0) and (m2<>0) Then DelBlock Else
                 BEGIN
                   If Buf^[CurPos-1]=#10 Then DelBackChar;
                   DelBackChar;
                 END;
      Else       If t1<>#27 Then BEGIN DelBlock; InsChar (t1); END;
    END Else
    CASE t2 Of
      Pos1     : BEGIN Start:= 0; ScrollDown; ScrollUp; END;
      Up       : If b<>d Then ScrollUp;
      PgUp     : If b<>d Then For tmp:= 1 To d-b Do ScrollUp;
      CTRL_Pos1,
      CTRL_PgUp: BEGIN FirstChar:= 1; CurPos:= 1; END;
      Down     : If b<>d Then If CurPos<=BufEnd Then ScrollDown;
      PgDn     : If b<>d Then
                 For tmp:= 1 To d-b Do If LastChar<=BufEnd Then ScrollDown;
      CTRL_Ende,
      CTRL_PgDn: If b<>d Then
                 BEGIN
                   FirstChar:= BufEnd; CurPos:= BufEnd+1;
                   For tmp:= b to d Do DecVar (FirstChar);
                 END;
      Right    : GoRight;
      Left     : GoLeft;
      Einfg    : Ins:= not Ins;
      CTRL_Left: REPEAT GoLeft;  UNTIL (CurPos<=1)     or (Buf^[CurPos]=' ');
      CTRL_Rght: REPEAT GoRight; UNTIL (CurPos>BufEnd) or (Buf^[CurPos]=' ');
      Endx     : While (CurPos<=BufEnd) and (Buf^[CurPos]<>#13) Do GoRight;
      Entf     : If (m1<>0) and (m2<>0) Then DelBlock Else
                 BEGIN DelEntfChar; If Buf^[CurPos]=#10 Then DelEntfChar; END;
      AltA     : BEGIN m1:= 1; m2:= BufEnd; END;
      AltX, F3 : DelBlock;
      AltY     : DelBlock;
      AltV, F4 : InsBlock;
      AltC, F5 : BEGIN MoveToClipBoard; m1:= 0; m2:= 0; END;
      AltD, F6 : BEGIN m1:= 0; m2:= 0; END;
      F7       : BEGIN m1:= CurPos; If (m1> m2) and (m2<>0) Then BEGIN tmp:= m1; m1:= m2; m2:= tmp; END; END;
      F8       : BEGIN m2:= CurPos; If (m2<>m1) and (m2 >0) Then dec (m2);
                                    If (m2< m1) and (m1<>0) Then BEGIN tmp:= m1; m1:= m2; m2:= tmp; END; END;
      Shift_TAB: BEGIN If ActEditor>1 Then dec(ActEditor) Else ActEditor:= LastEditor; Exit; END;
      #0       : ; { Mausklick }
      Else       Exit;
    END;
  UNTIL (t1=#27) or (SndKey);
END;


PROCEDURE InitEditor (a1, b1, c1, d1 : Byte; VAR Ed : EdRec; Buffer : Pointer; Size, Chars : Word; Clip : Pointer);
BEGIN
  With Ed Do
  BEGIN
    Buf      := Buffer;
    BufSize  := Size;
    BufEnd   := Chars;
    CurPos   := 1;
    FirstChar:= 1;
    Start    := 0;
    IfEdit   := FALSE;
    ClipBord := Clip;
    a:= a1; b:= b1; c:= c1; d:= d1; m1:= 0; m2:= 0;
    If c<=a Then c:= a+1;
    If d<b Then d:= b;
    ActEditor:= 1;
    inc (LastEditor);
    EdNr:= LastEditor;
    If d>b Then
    BEGIN
      CharXY (c, b, #24, yellow, 0);
      CharXY (c, d, #25, yellow, 0);
      For b1:= b+1 To d-1 Do CharXY (c, b1, #178, 8, 0);
      dec (c);
    END;
  END;
  DrawEditor (Ed);
END;


PROCEDURE SendKey (VAR Ed : EdRec; tt1, tt2 : Char);
VAR
  s1, s2 : Char;
BEGIN
  SndKey:= TRUE; s1:= t1; s2:= t2;
  t1:= tt1; t2:= tt2;
  EditWin (Ed); 
  SndKey:= FALSE;t1:= s1; t2:= s2;
END;


PROCEDURE DrawEditor (VAR Ed : EdRec);
BEGIN
  Draw:= TRUE; EditWin (Ed); Draw:= FALSE;
END;


PROCEDURE CheckMouse (VAR Ed : EdRec);
BEGIN
  With Ed Do
  If MouseIn (a, b, c+1-ord(d=b), d) Then ActEditor:= EdNr;
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
