UNIT eMime;

INTERFACE

TYPE
  MimeStr = String[4];


FUNCTION MimeToCode (InStr : MimeStr) : MimeStr;
FUNCTION CodeToMIME (InStr : MimeStr) : MimeStr;


IMPLEMENTATION


FUNCTION CodeToMIME (InStr : MimeStr) : MimeStr; assembler;
ASM
  push ds
  cld
  les di, @Result
  xor al, al; stosb; mov dx, di; mov ax, 65535; Stosw; Stosw; mov di, dx;

  lds si, InStr
  lodsb
  xor cx, cx
  mov cl, al

  jcxz @ende
    lodsb
    mov bl, al
    {$IFOPT G+}
      shr al, 2
    {$ELSE}
      shr al, 1; shr al, 1
    {$ENDIF}
    stosb

    lodsb
  cmp cx, 1; ja @weiter
    xor al, al
    @weiter:
    mov bh, al
    {$IFOPT G+}
      shl bl, 6
      and al, 240
      shr al, 2
      or  al, bl
      shr al, 2
    {$ELSE}
      shl bl, 1; shl bl, 1; shl bl, 1; shl bl, 1; shl bl, 1; shl bl, 1
      and al, 240
      shr al, 1; shr al, 1
      or  al, bl
      shr al, 1; shr al, 1
    {$ENDIF}
    Stosb    
  cmp cx, 1; je @vorende

    lodsb
  cmp cx, 2; jne @weiter2
    xor al, al
    @weiter2:
    mov bl, al
    {$IFOPT G+}
      shl bh, 4
      shr al, 6
      shl al, 2
      or  al, bh
      shr al, 2
    {$ELSE}
      shl bh, 1; shl bh, 1; shl bh, 1; shl bh, 1
      shr al, 1; shr al, 1; shr al, 1; shr al, 1; shr al, 1; shr al, 1;
      shl al, 1; shl al, 1;
      or  al, bh
      shr al, 1; shr al, 1;
   {$ENDIF}
    Stosb

  cmp cx, 2; je @vorende
    mov al, bl
    and al, 63
    Stosb  

  @vorende:
    mov al, 4
  @ende:
  pop ds

  mov cx, 4
  les di, @Result; stosb;
  @start:
    mov al, es:[di]
        cmp al,  26; jae @1; add al,  65; jmp @6
    @1: cmp al,  52; jae @2; add al,  71; jmp @6
    @2: cmp al,  62; jae @3; sub al,   4; jmp @6
    @3: cmp al,  62; jne @4; mov al, '+'; jmp @6
    @4: cmp al,  63; jne @5; mov al, '/'; jmp @6
    @5: cmp al, 255; jne @6; mov al, '='; 
    @6:
    stosb
  loop @start
END;




FUNCTION MimeToCode (InStr : MimeStr) : MimeStr; assembler;
ASM
  les di, InStr; inc di; mov cx, 4
  @start:
    mov al, es:[di]
        cmp al, '='; jne @0; mov al, 255; jmp @5
    @0: cmp al, '+'; jne @1; mov al,  62; jmp @5
    @1: cmp al, '/'; jne @2; mov al,  63; jmp @5

    @2: cmp al,  58; jae @3; add al,   4; jmp @5
    @3: cmp al,  91; jae @4; sub al,  65; jmp @5
    @4: cmp al, 123; jae @5; sub al,  71;
    @5: 
    stosb
  loop @start

  push ds
  les di, @Result; inc di
  lds si, InStr  ; inc si

  xor cx, cx

  lodsW
  {$IFOPT G+}
    shl  ah, 2
    mov  bl, ah
    rol  ax, 2
  {$ELSE}
    shl  ah, 1; shl ah, 1
    mov  bl, ah
    rol  ax, 1; rol ax, 1
  {$ENDIF}
  stosb          ; inc cx 

  LodsB
  cmp  al, 255   ; je @ende
  mov  ah, bl
  mov  bl, al
  {$IFOPT G+}
    shr  ah, 2
    shl  al, 2
    rol  ax, 4
  {$ELSE}
    shr  ah, 1; shr ah, 1
    shl  al, 1; shl al, 1
    rol  ax, 1; rol  ax, 1; rol  ax, 1; rol  ax, 1
  {$ENDIF}
  xchg al, ah
  stosb          ; inc cx

  LodsB
  cmp  al, 255   ; je @Ende
  mov ah, bl
  {$IFOPT G+}
    shl al, 2
    ror ax, 2
  {$ELSE}
    shl al, 1; shl al, 1
    ror ax, 1; ror ax, 1
  {$ENDIF}
  stosb          ; inc cx

  @ende:
  les di, @Result; mov ax, cx; stosb
  pop ds
END;





END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
