UNIT Env; { emuliert Umgebungsspeicher in einer Datei }

INTERFACE
USES
  Strings, DOS;

VAR
  VarFile : PathStr;

FUNCTION  GetVar (VarName : String) : String;
PROCEDURE SetVar (VarStr  : String);

IMPLEMENTATION


FUNCTION GetVar (VarName : String) : String;
VAR
  f : Text;
  s : String;
BEGIN
  VarName:= UpStr (VarName);
  GetVar := '';

  Assign (f, VarFile);
  FileMode:= 0;
  Reset (f);
  If IOResult<>0 Then Exit;

  While not Eof(f) Do
  BEGIN
    ReadLn(f, s);
    If IOResult<>0 Then BEGIN Close(f); Exit; END;
    If nthField (s, '=', 1) = VarName Then
    BEGIN
      GetVar:= FromNthField (s, '=', 2);
      Close (f);
      Exit;
    END;
  END;
  Close (f);
END;


PROCEDURE SetVar (VarStr : String);
VAR
  f1, f2  : Text;
  VarName : String;
  VarCont : String;
  s       : String;
  Found   : Boolean;
  IsEmpty : Boolean;

BEGIN
  VarName:= UpStr(Trim(nthField (VarStr, '=', 1)));
  VarCont:= FromNthField (VarStr, '=', 2);
  VarStr := VarName+'='+VarCont;

  Assign (f1, VarFile);
  Rename (f1, ChangeFileExt (VarFile, 'tmp'));
  If IOResult=2 Then
  BEGIN
    If Length(VarCont)=0 Then Exit;
    Rewrite (f1);
    WriteLn (f1, VarStr);
    Close   (f1);
    Exit;
  END;

  FileMode:= 0;
  Reset (f1);
  If InOutRes<>0 Then Exit;

  Assign  (f2, VarFile);
  Rewrite (f2);
  If IOResult<>0 Then BEGIN Close (f1); InOutRes:= 1; Exit; END;

  Found  := FALSE;
  IsEmpty:= TRUE;
  While (not Eof (f1)) and (IOResult=0) Do
  BEGIN
    ReadLn (f1, s);
    If nthField (s, '=', 1) = VarName Then
    BEGIN
      Found:=TRUE;
      If Length(VarCont)<>0 Then
      BEGIN IsEmpty:= FALSE; WriteLn (f2, VarStr); END;
    END
    Else
    BEGIN IsEmpty:= FALSE; WriteLn (f2, s); END;
  END;
  If (not Found) and (Length(VarCont)<>0) Then
  BEGIN IsEmpty:= FALSE; WriteLn (f2, VarStr); END;

  Close (f1);
  Erase (f1);
  Close (f2);
  If IsEmpty Then Erase (f2);
END;


BEGIN
  VarFile:= GetEnv('TMP');
  If VarFile ='' Then
  BEGIN
    VarFile := GetEnv('TEMP');
    If VarFile='' Then VarFile:= 'C:\';
  END;
  VarFile:= BuildPath (VarFile, 'var.txt');
END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
