UNIT ErrorStr;

INTERFACE

USES
  Strings;


FUNCTION PathStatusStr  (Status : Byte) : String;
FUNCTION IOResultStr    (Result : Word) : String;
FUNCTION ExtIOResultStr (Result : Word) : String;

CONST
  Okay           = 0;
  NotExist       = 1;
  FormatError    = 2;
  PhantomFound   = 3;
  CDFound        = 4;
  WildCardsFound = 5;

IMPLEMENTATION


FUNCTION PathStatusStr (Status : Byte) : String;
BEGIN
  CASE Status Of
    NotExist       : PathStatusStr:= 'Laufwerk existiert nicht';
    FormatError    : PathStatusStr:= 'Ungltiges Format der Pfadangabe';
    PhantomFound   : PathStatusStr:= 'Phantomlaufwerk wird nicht untersttzt';
    CDFound        : PathStatusStr:= 'Schreiben auf CD-ROM nicht mglich';
    WildCardsFound : PathStatusStr:= 'Wildcards (* bzw. ?) in Zielangabe nicht erlaubt';
    Else             PathStatusStr:= '';
  END;
END;


FUNCTION IOResultStr (Result : Word) : String;
BEGIN
  CASE Result Of
    0   : IOResultStr:= '';
    2   : IOResultStr:= 'Datei nicht gefunden';
    3   : IOResultStr:= 'Verzeichnispfad nicht gefunden';
    4   : IOResultStr:= 'Zuviele offene Dateien';
    5   : IOResultStr:= 'Datei- oder Pfadzugriff verweigert';
    8   : IOResultStr:= 'Zu wenig Speicher'; { entspricht DOS-Standard }
    101 : IOResultStr:= 'Datentrger ist voll';
    150 : IOResultStr:= 'Laufwerk ist schreibgeschtzt';
    151 : IOResultStr:= 'Peripheriegert nicht bereit';
    152 : IOResultStr:= 'Laufwerk nicht betriebsbereit';
    153 : IOResultStr:= 'Ungltige DOS-Funktion';
    154 : IOResultStr:= 'Prfsummenfehler beim Lesen der Datei';
    155 : IOResultStr:= 'Ungltiger Disketten-Parameterblock';
    156 : IOResultStr:= 'Kopf-Positionsfehler des Laufwerkes';
    157 : IOResultStr:= 'Unbekanntes Datentrgerformat';
    158 : IOResultStr:= 'Laufwerksektor nicht gefunden';
    159 : IOResultStr:= 'Drucker hat kein Papier';
    160 : IOResultStr:= 'Fehler beim Schreiben zu Peripheriegert';
    161 : IOResultStr:= 'Fehler beim Lesen von Peripheriegert';
    162 : IOResultStr:= 'Unbekannter Hardwarefehler';
    Else  IOResultStr:= 'Undefinierter Fehler Nr '+StrVal (Result);
  END;
END;


FUNCTION ExtIOResultStr (Result : Word) : String;
BEGIN
  If Result<1000 Then ExtIOResultStr:= IOResultStr (Result) Else
  CASE Result Of
    1000 : ExtIOResultStr:= 'Dateien sind nicht identisch';
    1001 : ExtIOResultStr:= 'Gleichnamiges Verzeichnis im Ziel';
    1002 : ExtIOResultStr:= 'Gleichnamige Datei im Ziel gefunden';
  { 1003 : ExtIOResultStr:= 'Quelldatei konnte nicht gelscht werden'; (movefile) }
    2000 : ExtIOResultStr:= 'Kopieren vom Benutzer abgebrochen';
    2001 : ExtIOResultStr:= 'Zyklische Kopie nicht mglich';
  END;
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
