UNIT ExeWrite;  {schreibt eine typisierte Konstante direkt in die Exe-Datei}
                {Dokumentation am Ende dieser Datei}


INTERFACE



PROCEDURE WriteIntoExeFile (VAR Rec; Size : Word);


IMPLEMENTATION
USES
  DOS;


PROCEDURE WriteIntoExeFile (VAR Rec; Size : Word);
VAR
  f        : File;
  ExeHead  : array[1..5] Of Word;
  Gel      : Word;
BEGIN
  FileMode:=2;
  Assign (f, ParamStr (0));
  SetFAttr (f, 32); 
  Reset (f, 1);
  BlockRead (f, ExeHead, SizeOf(ExeHead), gel);
  Seek (f, (seg(Rec) - PrefixSeg + ExeHead[5] - 16) * 16 + ofs(Rec));
  BlockWrite (f, Rec, Size, gel);
  DOSError:= IOResult;
  Close (f);
  If IOResult<>0 Then;
END;





END.


{ Dokumentation:
  --------------
  Die Prozedur WriteIntoExeFile schreibt eine beliebige typisierte Konstante
  in die Exe-Datei des laufenden Programmes. Dadurch knnen Konfigurations-
  nderungen direkt in den Programmcode eingebaut werden. Bei Programmen
  grer als 64 kB funktioniert dies jedoch meistens nicht!
  Ein Fehler wird in der globalen Variablen DOSerror zurckgegeben.

  Parameter: VAR Rec  = Name der zu schreibenden Variablen
             Size     = Gre dieser Variablen, immer SizeOf () benutzen!

  Beispiel:

  CONST
    Colors : RECORD Hintergrund : Byte; Vordergrund : Byte   ; END =
                   (Hintergrund : blue; Vordergrund : yellow);
  BEGIN
    Colors.Hintergrund:= Black;
    WriteIntoExeFile (Colors, SizeOf (Colors));
    If DOSError <> 0 Then Fehler;
  END;

  Die nderung der Hintergrundfarbe des Programmes wird fest in das
  Programm "eingebrannt". 