UNIT Filecopy;

INTERFACE
USES
  DOS, Strings, Disk, Rechnen, WildCard, ErrorStr;

TYPE
  TCheckObjekt = (CheckQuelle, CheckZiel);

FUNCTION  FileExpand       (Pfad : PathStr) : PathStr;
FUNCTION  PathStatus       (Pfad : PathStr; ChkObjekt : TCheckObjekt) : Byte;
FUNCTION  SamePath (Quelle, Ziel : String; Rekurs : Boolean)      : Boolean;
FUNCTION  SameFile (File1, File2 : PathStr; sr1, sr2 : SearchRec) : Boolean;

FUNCTION  ObjektExist (Path : PathStr) : Byte;
FUNCTION  FolderExist (Path : PathStr) : Boolean;

PROCEDURE MakeTree   (Pfad : PathStr);
PROCEDURE XClose    (VAR f : File);
PROCEDURE EraseFile  (Name : PathStr);
PROCEDURE RenameFile (OldName, NewName : PathStr; DelExistFile : Boolean);

VAR
  CheckObjekt: TCheckObjekt;

CONST
  NormalFile     = Anyfile    and not VolumeID;
  OnlyFiles      = NormalFile and not directory;
  VisibleFiles   = OnlyFiles  and not (hidden or sysfile); { nur sichtbare Dateien }
  VisibleObjects = NormalFile and not (hidden or sysfile); { nur sichtbare Dateien UND Verzeichnisse }

  NoObj      = 0;
  Dat        = 1;
  Ver        = 2;
  Root       = 4;


IMPLEMENTATION


FUNCTION FileExpand (Pfad : PathStr) : PathStr;
BEGIN
  DOSError:= 0;
  If  (Length(Pfad)>=2) and (Pfad[2]=':') and (UpChar(Pfad[1])<='B') 
  and (Drive (Pfad[1])  and PhantomDrive <> 0) Then
  BEGIN DOSError:= PhantomFound; FileExpand:= Pfad; Exit; END;
  FileExpand:= DelLastSlash (FExpand (Pfad));
END;


FUNCTION PathStatus (Pfad : PathStr; ChkObjekt : TCheckObjekt) : Byte;
BEGIN
  PathStatus:= Okay;
  If ((Length(Pfad) <  2)
  or ((Length(Pfad) >= 2) and (Pfad[2] <> ':'))) Then PathStatus:= FormatError  Else
  If Drive(Pfad[1]) and Phantomdrive <> 0        Then PathStatus:= PhantomFound Else
  If Drive(Pfad[1]) =   NoDrive                  Then PathStatus:= NotExist     Else
  If ChkObjekt=CheckZiel Then
  BEGIN
    If Drive(Pfad[1]) and CDDrive <> 0           Then PathStatus:= CDFound      Else
    If isWildCard (Pfad)                         Then PathStatus:= WildCardsFound;
  END;
END;
{ CDFound und WildcardsFound, falls Pfad ein Zielpfad beim Kopieren ist
  Immer NACH FExpand aufrufen ! }


FUNCTION SamePath (Quelle, Ziel : String; Rekurs : Boolean) : Boolean;
VAR
  sr       : Searchrec;
  tmp      : String;
  WildCard : Boolean;
BEGIN
  SamePath:= FALSE;
  WildCard:= isWildcard(Quelle);
  If Wildcard Then Quelle:= GetPathName (Quelle);
  If Drive (Quelle[1]) or SubstDrive <> 0 Then Quelle:= TrueName (Quelle);
  If Drive (Ziel  [1]) or SubstDrive <> 0 Then Ziel  := TrueName (Ziel);
  If Quelle[Length(Quelle)] <> '\' Then CharAdd (Quelle, '\');
  If Ziel  [Length(Ziel)  ] <> '\' Then CharAdd (Ziel,   '\');
  If Quelle=Ziel Then BEGIN SamePath:= True; Exit; END;
  If pos (Quelle, Ziel)=1 Then
  BEGIN
    If WildCard Then SamePath:= Rekurs Else SamePath:= TRUE;
    Exit;
  END;
  If  (Length (Quelle) > Length (Ziel)) and (pos (Ziel, Quelle)=1) Then
  BEGIN
    dec (Quelle[0]);   { Wegen GetPathName und Findfirst }
    If  GetPathName (Quelle) <> Ziel Then Exit; { Samepath:= FALSE, s.o. }
    FindFirst (Quelle, anyfile, sr);
    If (DOSError=0) and (sr.attr and directory=0) Then SamePath:= TRUE;
    { Hier bei "move" aufpassen ! }    
  END
END;



FUNCTION SameFile (File1, File2 : PathStr; sr1, sr2 : SearchRec) : Boolean;
BEGIN
  If  (sr1.attr=sr2.attr)
  and (sr1.size=sr2.size)
  and (sr1.time=sr2.time)
  and (sr1.name=sr2.name) Then
  BEGIN
    If File1=File2 Then SameFile:= TRUE Else
    BEGIN
      If Drive (File1[1]) or SubstDrive <> 0 Then File1:= TrueName (File1);
      If Drive (File1[1]) or SubstDrive <> 0 Then File2:= TrueName (File2);
      SameFile:= File1 = File2;
    END;
  END Else SameFile:= FALSE;
END;
{ Nochmal zur Sicherheit }


FUNCTION ObjektExist (Path : PathStr) : Byte;
VAR
  DriveNr  : Byte;
  FloppyNr : Byte;
  sr       : SearchRec;

BEGIN
  FloppyNr:= 0;
  If pos(':', Path) = 2 Then
  BEGIN
    DriveNr:= DOSDriveNr(Path[1]);
    If DriveNr <= 2 Then
    BEGIN
      FloppyNr:= GetLogicalDriveMap (DriveNr);
      If FloppyNr = DriveNr Then FloppyNr:= 0;
      If FloppyNr<> 0       Then SetLogicalDriveMap (DriveNr);
    END;
  END;

  Path:= DelLastSlash(Fexpand(Path));

  If Drive(Path[1]) = NoDrive Then ObjektExist:= 0 Else
  BEGIN
    FindFirst (Path, anyfile, sr);
    If Length(Path) = 3 Then { Root-Verzeichnis }
    BEGIN
      If DOSError<=150 Then ObjektExist:= Root Else ObjektExist:= 0;
    END
    Else
    BEGIN
      If DOSError<>0 Then ObjektExist:= 0 Else
      If sr.attr and directory<>0 Then ObjektExist:= Ver Else ObjektExist:= Dat;
    END;
  END;

  If FloppyNr<>0 Then SetLogicalDriveMap (FloppyNr);
END;


FUNCTION FolderExist (Path : PathStr) : Boolean;
BEGIN
  FolderExist:= (not IsWildCard (Path)) and (ObjektExist (Path)=Ver);
END;


PROCEDURE MakeTree (Pfad : PathStr);
VAR
  x   : Byte;
  Dir : PathStr;
  sr  : SearchRec;
BEGIN
  Pfad:= FExpand (Pfad);
  Dir:= nthField (Pfad, '\', 1)+'\';
  For x:= 2 To CountFields (Pfad, '\') Do
  BEGIN
    Dir:= BuildPath (Dir, nthField (Pfad, '\', x));
    FindFirst (Dir, anyfile, sr);
    If (DOSError>=150) Then BEGIN InOutRes:= DOSError; Exit; END;
    If (DOSError<>  0) or (sr.attr and directory=0) Then { Provoziert Fehler 5 }
    BEGIN MkDir (Dir); If InOutRes<>0 Then Exit; END;
  END;
END;


PROCEDURE XClose (VAR f : File);
BEGIN
  Close (f); InOutRes:= 0;
END;


PROCEDURE EraseFile (Name : PathStr);
VAR
  f : File;
BEGIN
  Assign   (f, Name);
  SetFAttr (f, 32); InOutRes:= DOSError;
  If DOSError = 0 Then Erase (f);
END;


PROCEDURE RenameFile (OldName, NewName : PathStr; DelExistFile : Boolean);
VAR
  f : File;
BEGIN
  Assign (f, OldName);
  Rename (f, NewName);
  If (DelExistFile) and (IOResult<>0) Then
  BEGIN
    EraseFile (NewName);
    If InOutRes=0 Then Rename (f, NewName);
  END;
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
