UNIT FileIO;

INTERFACE

USES
  DOS, Monitor, BiosCrt, Masken;


PROCEDURE ResetFile   (Name : PathStr);
PROCEDURE CloseInFile; 
FUNCTION  PopChar           : Char;
FUNCTION  NextChar          : Char; 
FUNCTION  InFilePos         : LongInt;
FUNCTION  InFileSize        : LongInt;
PROCEDURE SeekInPos    (Pos : LongInt);
FUNCTION  EofInFile         : Boolean;

PROCEDURE RewriteFile (Name : PathStr);
PROCEDURE CloseOutFile;
PROCEDURE PushChar (Zeichen : Char); 
FUNCTION  OutFilePos        : LongInt; 


CONST
  ErrAbort : Boolean = FALSE; { bewirkt Abbruch bei Fehler, wenn TRUE }


IMPLEMENTATION

VAR
  InFile, OutFile : File;

CONST
  BufSize  = 20480;
  HalfSize = BufSize shr 1;

VAR
  InFilePtr, OutFilePtr : LongInt;
  InSize,    OutSize    : LongInt;
  InBufPtr,  OutBufPtr  : Word;
  InBufEnd,  OutBufEnd  : Word;
  InBuffer,  OutBuffer  : Array[1..BufSize] Of Char;


PROCEDURE ErrStop (Msg : String);
BEGIN
  If FileRec(InFile).Mode<>fmClosed Then BEGIN CloseInFile; InOutRes:= 0; END;
  Window (1, 1, 80, 25); TextAttr:= 7; ClrScr;
  SimpleHalt (Msg);
END;


PROCEDURE ResetFile (Name : PathStr);
BEGIN
  FileMode:= 0;
  Assign (InFile, Name);
  Reset  (InFile, 1);
  If (ErrAbort) and (IOResult<>0) Then
  ErrStop ('Datei konnte nicht geffnet werden:'#13#10+Name);
  InSize   := FileSize (InFile);
  InBufPtr := 0;
  InBufEnd := 0;
  InFilePtr:= 0;
END;



PROCEDURE RewriteFile (Name : PathStr);
BEGIN
  FileMode:= 2;
  Assign  (OutFile, Name);
  Rewrite (OutFile, 1);
  IF IOResult<>0 Then
  BEGIN
    SetFAttr (OutFile, 32);
    Rewrite  (OutFile,  1);
    If (ErrAbort) and (IOResult<>0) Then
    ErrStop ('Datei konnte nicht erzeugt werden:'#13#10+Name);
  END;
  OutBufPtr := 0;
  OutFilePtr:= 0;
END;



PROCEDURE ReadNewBuff;
BEGIN
  InFilePtr:= FilePos (InFile);
  BlockRead (InFile, InBuffer, BufSize, InBufEnd);
  If (ErrAbort) and (IOResult<>0) Then
  ErrStop ('Fehler beim Lesen der Datei');
END;


PROCEDURE WriteNewBuff;
BEGIN
  BlockWrite (OutFile, OutBuffer, OutBufPtr, OutBufEnd);
  If (ErrAbort) and (IOResult<>0) Then
  ErrStop ('Fehler beim Schreiben in Datei');
  inc (OutFilePtr, OutBufEnd);
END;



PROCEDURE ReadChr (VAR ch : Char);
BEGIN
  If InBufPtr >= InBufEnd Then BEGIN ReadNewBuff; InBufPtr:= 0; END;
  inc (InBufPtr);
  ch:= InBuffer[InBufPtr];
END;



FUNCTION PopChar : Char; Assembler;
ASM
  mov bx, InBufPtr
  cmp bx, InBufEnd
  jb @weiter
    call ReadNewBuff
    xor bx, bx
  @weiter:
  mov al, Byte Ptr InBuffer[bx]
  inc bx
  mov InBufPtr, bx
END;



FUNCTION NextChar : Char; Assembler;
ASM
  mov bx, InBufPtr
  cmp bx, InBufEnd
  jb @weiter
    call ReadNewBuff
    xor bx, bx
    mov InBufPtr, bx
  @weiter:
  mov al, Byte Ptr InBuffer[bx]
END;



PROCEDURE PushChar (Zeichen : Char); assembler;
ASM
  mov bx, OutBufPtr
  cmp bx, BufSize
  jb @weiter
    call WriteNewBuff
    xor bx, bx
  @weiter:
  mov al, Zeichen
  mov Byte Ptr OutBuffer[bx], al
  inc bx
  mov OutBufPtr, bx
END;



FUNCTION InFilePos : LongInt; assembler;
ASM
  mov dx, Word Ptr InFilePtr[2]
  mov ax, Word Ptr InFilePtr[0]
  add ax, InBufPtr
  adc dx, 0
END;
{ InFilePos:= InFilePtr + InBufPtr }



FUNCTION InFileSize : LongInt;
BEGIN
  InFileSize:= InSize;
END;



FUNCTION OutFilePos : LongInt; assembler;
ASM
  mov dx, Word Ptr OutFilePtr[2]
  mov ax, Word Ptr OutFilePtr[0]
  add ax, OutBufPtr
  adc dx, 0
END;
{ OutFilePos:= OutFilePtr + OutBufPtr }



PROCEDURE SeekInPos (Pos : LongInt);
BEGIN
  If (Pos >= 0) and (Pos <= InSize) Then
  BEGIN
    If (Pos >= InFilePtr+InBufEnd) Then
    BEGIN
      Seek (InFile, Pos);
      InBufPtr := 0;
      InBufEnd := 0;
      InFilePtr:= Pos;
    END Else
    If Pos < InFilePtr Then
    BEGIN
      If Pos > HalfSize Then
      Seek (InFile, Pos-HalfSize) Else Seek (InFile, 0);
      ReadNewBuff;
      InBufPtr := HalfSize;
    END Else
    InBufPtr:= Pos-InFilePtr;
  END;
END;



FUNCTION EofInFile : Boolean; assembler;
ASM
  xor cx, cx
  mov dx, Word Ptr InFilePtr[2]
  mov ax, Word Ptr InFilePtr[0]
  add ax, InBufPtr
  adc dx, cx
  cmp dx, Word Ptr InSize[2]
  jb @ende
  ja @weiter
  cmp ax, Word Ptr InSize[0]
  jb @ende
  @weiter:
  mov cx, TRUE
  @ende:
  mov ax, cx
END;
{ EofInFile:= InFilePtr + InBufPtr >= InSize }


PROCEDURE CloseInFile;
BEGIN
  Close (InFile);
END;


PROCEDURE CloseOutFile;
BEGIN
  WriteNewBuff;
  Close (OutFile);
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
