UNIT File_IO;

INTERFACE

USES
  DOS;


PROCEDURE ResetFile   (Name : PathStr);
PROCEDURE CloseInFile; 
FUNCTION  PopChar           : Char;
FUNCTION  NextChar          : Char; 
FUNCTION  InFilePos         : LongInt;
PROCEDURE SeekInPos    (Pos : LongInt);
FUNCTION  EofInFile         : Boolean;

PROCEDURE RewriteFile (Name : PathStr);
PROCEDURE CloseOutFile;
PROCEDURE PushChar (Zeichen : Char); 
FUNCTION  OutFilePos        : LongInt; 



VAR
  InFile, OutFile : File;


IMPLEMENTATION

CONST
  BufSize = 2048;

VAR
  InLen                : LongInt;
  InPtr,    OutPtr     : LongInt;
  InBufPtr, OutBufPtr  : Word;
  InBufEnd, OutBufEnd  : Word;
  InBuffer, OutBuffer  : Array[1..BufSize] Of Char;





PROCEDURE ResetFile (Name : PathStr);
BEGIN
  FileMode:= 0;
  Assign (InFile, Name);
  Reset  (InFile, 1);
  InBufPtr := 0;
  InBufEnd := 0;
  InPtr    := 0;
  InLen    := FileSize (InFile);
END;



PROCEDURE RewriteFile (Name : PathStr);
BEGIN
  FileMode:= 2;
  Assign  (OutFile, Name);
  Rewrite (OutFile, 1);
  IF IOResult<>0 Then
  BEGIN SetFAttr (OutFile, 32); Rewrite (OutFile, 1); END;
  OutBufPtr := 0;
  OutPtr    := 0;
END;



PROCEDURE ReadNewBuff;
BEGIN
  InPtr:= FilePos (InFile);
  BlockRead (InFile, InBuffer, BufSize, InBufEnd);
END;


PROCEDURE WriteNewBuff;
BEGIN
  BlockWrite (OutFile, OutBuffer, OutBufPtr, OutBufEnd);
  inc (OutPtr, OutBufEnd); 
END;



PROCEDURE ReadChr (VAR ch : Char);
BEGIN
  If InBufPtr >= InBufEnd Then BEGIN ReadNewBuff; InBufPtr:= 0; END;
  inc (InBufPtr);
  ch:= InBuffer[InBufPtr];
END;



FUNCTION PopChar : Char; Assembler;
ASM
  mov bx, InBufPtr
  cmp bx, InBufEnd
  jb @weiter
    call ReadNewBuff
    xor bx, bx
  @weiter:
  mov al, Byte Ptr InBuffer[bx]
  inc bx
  mov InBufPtr, bx
END;



FUNCTION NextChar : Char; Assembler;
ASM
  mov bx, InBufPtr
  cmp bx, InBufEnd
  jb @weiter
    call ReadNewBuff
    xor bx, bx
    mov InBufPtr, bx
  @weiter:
  mov al, Byte Ptr InBuffer[bx]
END;


PROCEDURE PushChar (Zeichen : Char); assembler;
ASM
  mov bx, OutBufPtr
  cmp bx, BufSize
  jb @weiter
    call WriteNewBuff
    xor bx, bx
  @weiter:
  mov al, Zeichen
  mov Byte Ptr OutBuffer[bx], al
  inc bx
  mov OutBufPtr, bx
END;



FUNCTION InFilePos : LongInt; assembler;
ASM
  mov dx, Word Ptr InPtr[2]
  mov ax, Word Ptr InPtr[0]
  add ax, InBufPtr
  adc dx, 0
END;
{ InFilePos:= InPtr + InBufPtr }



FUNCTION OutFilePos : LongInt; assembler;
ASM
  mov dx, Word Ptr OutPtr[2]
  mov ax, Word Ptr OutPtr[0]
  add ax, OutBufPtr
  adc dx, 0
END;
{ OutFilePos:= OutPtr + OutBufPtr }



PROCEDURE SeekInPos (Pos : LongInt);
BEGIN
  Seek (InFile, Pos);
  InPtr    := Pos;
  InBufPtr := 0;
  InBufEnd := 0;
END;



FUNCTION EofInFile : Boolean; assembler;
ASM
  xor cx, cx
  mov dx, Word Ptr InPtr[2]
  mov ax, Word Ptr InPtr[0]
  add ax, InBufPtr
  adc dx, cx
  cmp dx, Word Ptr InLen[2]
  jb @ende
  ja @weiter
  cmp ax, Word Ptr InLen[0]
  jb @ende
  @weiter:
  mov cx, TRUE
  @ende:
  mov ax, cx
END;
{ EofInFile:= InPtr + InBufPtr >= InLen }


PROCEDURE CloseInFile;
BEGIN
  Close (InFile);
END;


PROCEDURE CloseOutFile;
BEGIN
  WriteNewBuff;
  Close (OutFile);
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
