UNIT Find_FCB;

INTERFACE

USES
  DOS, Strings;

TYPE
{ Die folgenden Datentypen werden entweder nur Unit-intern bentigt oder
  dienen lediglich zur Information bzw. fr eigene Erweiterungen }

  TNameArray = Array[1..11] Of Char;
               { Format des Dateinamens in einem FCB oder DirEntry. Die
                 ersten 8 Bytes enthalten den Teil vor dem Punkt, die
                 letzten 3 Bytes die Dateiendung. Der evtl. Rest der beiden
                 Bereiche ist mit Leerzeichen aufgefllt }

  TExtHeader = RECORD
                 Signature  : Byte;                { immer auf $FF setzen! }
                 Reserved   : Array[1..5] Of Byte; { auf 0 setzen }
                 SearchAttr : Byte;                { gesuchtes Dateiattribut }
               END;
               { Struktur ExtHeader, die einem FCB vorangestellt wird, um
                 so einen ExtendedFCB zu bilden }

  TSearchFCB = RECORD
                 DriveID       : Byte;       { Laufwerksnummer, 1=A 2=B usw (0=current drive) }
                 FileName      : TNameArray; { Suchmaske }
                           { die folgenden Felder setzt DOS ab Version 3.3 }
                 Unknown1      : Byte;       { unbekannt, i.d.R. '?' }
                 DirEntryNr    : Word;       { Nummer d. Verzeichniseintrages
                                               der gefundenen Datei }
                 CurDirCluster : Word;       { Nummer des Start-Clusters
                                               des aktuellen Verzeichnisses }
                 Unknown2      : LongInt;    { unbekannt } 
                 DriveNumber   : Byte;       { = DriveID }
               END;
               { Struktur eines File Control Blocks (FCB) zum Suchen }

  TExtFCB    = RECORD
                 ExtHeader : TExtHeader;
                 FCB       : TSearchFCB;
               END;
               { Struktur Extended File Control Block (ExtendedFCB) }

  TDirEntry  = RECORD
                 FileName     : TNameArray;           { Dateiname }
                 Attr         : Byte;                 { Dateiattribut }
                 Intern       : Array[1..10] Of Byte; { "reserviert", bis
                                                        MS-DOS 6.x leer,
                                                        DR-DOS: Dateipawort }
                 Time         : LongInt;              { Uhrzeit, Datum }
                 StartCluster : Word;                 { Erster Cluster Datei
                                                        bzw. Unterverzeichnis }
                 Size         : LongInt;              { Dateigre }
               END;
               { Struktur eines normalen DOS-Verzeichniseintrages }

  TLFNEntry  = RECORD
                 Sequence     : Byte;                { s.u. }
                 Name1        : Array[1..5] Of Word; { Unicode der ersten 5 Zeichen }
                 Attr         : Byte;                { immer $0F = RHSI }
                 Indicator    : Byte;                { Zeichen-Indikator, i.d.R. 0, manchmal 32 }
                 CheckSum     : Byte;                { Addition bestimmter Felder des 8.3-Namens MOD 256 }
                 Name2        : Array[1..6] Of Word; { Unicode der nchsten 6 Zeichen }
                 StartCluster : Word;                { bei langen Namen immer 0 }
                 Name3        : Array[1..2] Of Word; { Unicode der nchsten 2 Zeichen }
               END;
               { Struktur eines Verzeichniseintrages, der ein Teilstck
                 eines langen Windows-9x-Dateinamens enthlt:
                 Sequence-Byte:
                 Bits 0-4     : Nummer des Verzeichniseintrages
                 Bit  5       : derzeit ungenutzt, immer 0
                 Bit  6       : kennzeichnet das Ende einer Sequenz
                 Bit  7       : derzeit ungenutzt (immer 0 ?)
                 Der Dateiname endet mit einem 0-Byte, der evtl. Rest ist
                 mit ASCII 255 aufgefllt. }

  TDTA       = RECORD
                 ExtHeader : TExtHeader;
                 DriveID   : Byte;
                 DirEntry  : TDirEntry;
               END;
               { Struktur der DTA (Disk Transfer Area), in der FindFirstDE
                 und FindNextDE die gefundenen Daten ablegen }

  LFNDirRec  = RECORD
                 ExtFCB       : TExtFCB;    { FCB darf nicht manipuliert werden }
                 ExtHeader    : TExtHeader;
                 DriveID      : Byte;
                                            { Beginn Struktur TLFNEntry }
                 Sequence     : Byte;                  { s.u. }
                 Name1        : Array[1..5] Of Word;   { Unicode der ersten 5 Zeichen }
                 Attr         : Byte;                  { immer $0F = RHSI }
                 Indicator    : Byte;                  { Zeichen-Indikator, i.d.R. 0, manchmal 32 }
                 CheckSum     : Byte;                  { Addition bestimmter Felder des 8.3-Namens MOD 256 }
                 Name2        : Array[1..6] Of Word;   { Unicode der nchsten 6 Zeichen }
                 StartCluster : Word;                  { bei langen Namen immer 0 }
                 Name3        : Array[1..2] Of Word;   { Unicode der nchsten 2 Zeichen }
                                            { Ende Struktur TLFNEntry }
                 Name         : String[12]; { normalisierter Dateiname }
                 LongName     : String;     { langer Dateiname, wenn vorhanden }
                 SeekAttr     : Word;       { darf nicht verndert werden ! }
                 SeekMask     : String[11]; { darf nicht verndert werden ! }
               END;

{ Die folgenden Daten-Strukturen werden von den vier "Find-xxx"-Prozeduren
  bentigt }

  TSearchRec = RECORD
                 ExtFCB       : TExtFCB;    { FCB darf nicht manipuliert werden }
                 ExtHeader    : TExtHeader;
                 DriveID      : Byte;
                                            { Beginn Struktur TDirEntry }
                 TrueName     : TNameArray;            { Dateiname }
                 Attr         : Byte;                  { Dateiattribut }
                 Intern       : Array[1..10] Of Byte;  { "reserviert", bis DOS 6.x leer }
                 Time         : LongInt;               { Uhrzeit, Datum }
                 StartCluster : Word;                  { Erster Cluster der Datei/des Unterverzeichnisses }
                 Size         : LongInt;               { Dateigre }
                                            { Ende Struktur TDirEntry  }
                 Name         : String[12]; { normalisierter Dateiname }
               END;
               { SearchRec mit einem ExtFCB, den DOS fr die Suche bentigt } 

  LSearchRec = RECORD
                 ExtFCB       : TExtFCB;    { FCB darf nicht manipuliert werden }
                 ExtHeader    : TExtHeader;
                 DriveID      : Byte;
                                            { Beginn Struktur TDirEntry }
                 TrueName     : TNameArray;            { Dateiame }
                 Attr         : Byte;                  { Dateiattribut }
                 Intern       : Array[1..10] Of Byte;  { "reserviert", bis DOS 6.x leer }
                 Time         : LongInt;               { Uhrzeit, Datum }
                 StartCluster : Word;                  { Erster Cluster der Datei/des Unterverzeichnisses }
                 Size         : LongInt;               { Dateigre }
                                            { Ende Struktur TDirEntry }
                 Name         : String[12]; { normalisierter Dateiname }

                 LongName     : String;     { langer Dateiname, wenn vorhanden }
                 SearchAttr   : Word;       { darf nicht verndert werden ! }
                 SearchMask   : String[11]; { darf nicht verndert werden ! }
               END;
               { Um zustzliche Felder erweitertes TSearchRec zum Suchen
                 nach langen Dateinamen }
                

PROCEDURE FindFirstFCB (Path  : String; Attr : Word; VAR S : TSearchRec);
PROCEDURE FindNextFCB  (VAR S : TSearchRec);

PROCEDURE FindFirstLFN (Path  : String; Attr : Word; VAR S : LSearchRec);
PROCEDURE FindNextLFN  (VAR S : LSearchRec);


CONST
  NormalFile = Anyfile and not VolumeID;

IMPLEMENTATION

VAR
  FName  : String[12]; { Globale temporre Strings fr FindFirstXXX, damit }
  OldDir : PathStr;    { diese z.B. bei Rekursionen nicht den Stack belasten }

CONST
  FCBSize = SizeOf (TExtFCB);


PROCEDURE SetCurDir (CurDir : PathStr); assembler;
ASM
  push ds
  lds  si, CurDir
  mov  bl, [si]
  xor  bh, bh
  cmp  bx, 78                { Lnge wird auf 78 Zeichen begrenzt. Dies }
  jbe  @los                  { ist normalerweise ohnehin keine gltige }
  mov  bx, 78                { Pfadlnge }
  @los:
  inc  si
  mov  byte ptr [si+bx], 0   { Nullbyte ans String-Ende setzen }

  mov  dx, si                { Change Current Directory }
  mov  ah, 3Bh
  int  21h
  jc   @ende
  xor  ax, ax
  @ende:
  pop  ds
  mov  InOutRes, ax
END;
{ Setzt das in CurDir angegebene Verzeichnis als das aktuelle Verzeichnis
  auf dem in Curdir angegebenen Laufwerk. Es wird (da hier nicht erlaubt)
  im Unterschied zu Pascal-ChDir KEIN Laufwerkswechsel vollzogen !
  Der Erfolg der Aktion kann/mu anschlieend mit IOResult ermittelt werden. }


PROCEDURE FindFirstDE (Drive : Char; SearchAttr : Byte; SearchMask : String; VAR TSR); assembler;
ASM
  push ds
  cld

  les  di, TSR                  { FCB fr Suche initialisieren }
  mov  al, $FF
  stosb                         { Kennung FF fr ExtendedFCB schreiben }
  xor  al, al 
  mov  cx, 5
  rep  stosb                    { Res1 mit Nullbytes fllen }
  mov  al, SearchAttr
  stosb                         { Gesuchtes Dateiattribut speichern }
  mov  al, Drive
  and  al, 31                   { DriveLetter zu Zahl }
  stosb                         { zu durchsuchendes Laufwerk speichern }
  mov  cx, 11 
  lds  si, SearchMask
  inc  si                       { Lngenbyte bergehen, da Lnge immer 11 }
  rep  movsb                    { Suchmaske in FCB einsetzen }

  mov  ah, 2Fh
  int  21h
  push es
  push bx                       { Adresse der alten DTA speichern }
 
  lds  dx, TSR                  { Den Beginn der Struktur "Direntry" des }
  add  dx, FCBSize              { XSearchRecs als neue DTA einsetzen }
  mov  ah, 1Ah
  int  21h

  mov  bx, dx 
  add  bx, 8

  sub  dx, FCBSize
  mov  ah, 11h
  int  21h                      { FindFirst with FCB }

  cmp  byte ptr [bx], ''       { Nimmt eine nderung zurck: DOS erkennt }
  jne  @weiter                  { ein LFN-Sequence-Byte 5 "flschlich" als }
  mov  byte ptr [bx], 5         { Lschmarkierung und wandelt es in  um }
  @weiter:

  pop  dx
  pop  ds
  mov  ah, 1Ah
  int  21h                      { Adresse der alten DTA restaurieren }

  pop  ds
  xor  ah, ah
  mov  DOSError, ax
END;
{ Kernfunktion zum Einlesen des ersten Verzeichniseintrages }


PROCEDURE FindNextDE (VAR TSR); assembler;
ASM
  push ds

  mov  ah, 2Fh
  int  21h
  push es
  push bx                       { Adresse der alten DTA speichern }
 
  lds  dx, TSR                  { Den Beginn der Struktur "Direntry" des }
  add  dx, FCBSize              { XSearchRecs als neue DTA einsetzen }
  mov  ah, 1Ah
  int  21h

  mov  bx, dx 
  add  bx, 8

  sub  dx, FCBSize
  mov  ah, 12h
  int  21h                      { FindNext with FCB }

  cmp  byte ptr [bx], ''       { Nimmt eine nderung zurck: DOS erkennt }
  jne  @weiter                  { ein LFN-Sequence-Byte 5 "flschlich" als }
  mov  byte ptr [bx], 5         { Lschmarkierung und wandelt es in  um }
  @weiter:

  pop  dx
  pop  ds
  mov  ah, 1Ah
  int  21h                      { Adresse der alten DTA restaurieren }

  pop  ds
  xor  ah, ah
  mov  DOSError, ax
END;
{ Kernfunktion zum Einlesen aller weiteren Verzeichniseintrge }



FUNCTION FCBMask (ein : String) : String; assembler;
ASM
  push ds
  cld
  les di, @Result
  mov ax, 11
  stosb            { Lngenbyte des Rckgabestrings setzen }
  push di
  mov cx, ax
  mov al, ' '
  rep stosb        { Rckgabestring mit 11 Leerzeichen fllen }

  pop di
  mov bx, di
  add bx, 8        { spteren Beginn der Datei-Endung anpeilen und merken }

  lds si, ein
  lodsb; mov cl, al; xor ch, ch; jcxz @ende     { Lngenbyte checken }
  cmp cx, 12; jbe @los; mov cx, 12; @los:       { evtl. berlnge kappen }

  @loop:           { bis zum Punkt kopieren }
    lodsb
    cmp al, '.'
    je  @weiter
    stosb
  loop @loop

  @weiter:
  jcxz @ende
  dec cx
  mov di, bx        { Dateiendung kopieren }
  rep movsb

  @ende:
  pop  ds
END;
{ wandelt einen Dateinamen in das von FCB-Funktionen bentigte
  Format um. Dabei wird ein evtl. vorhanderen Punkt zwischen
  Dateinamen und Dateiendung entfernt und der Dateiname wird mit
  Leerzeichen auf 8 Zeichen Lnge gestreckt, die Dateiendung
  auf 3 Zeichen.

  Die folgende Funktion kehrt diesen Vorgang um }


FUNCTION FCBToFileName (FCBName : TNameArray) : String; assembler;
ASM
  push ds
  std
  les  di, FCBName
  mov  cx, 8
  add  di, 7
  push di
  mov  al, ' '
  repe scasb
  je   @w1
  inc  cx
  @w1:
  mov  bx, cx        { Lnge Prfix in BX }

  mov  cx, 3
  pop  di
  add  di, cx
  repe scasb
  je   @w2
  inc  cx
  @w2:
  mov  ax, cx        { Lnge Ext in AX und CX}
  add  ax, bx        { Gesamtlnge in AX }
  jcxz @los          { wenn keine Endung vorhanden, dann weiter }
  inc  ax            { ansonsten Lnge um eins hoch (fr den Punkt) }
  @los:
  cld
  lds  si, FCBName
  mov  dx, si        { SI in DX merken }
  les  di, @Result
  stosb              { Lngenbyte schreiben }
  xchg cx, bx
  rep  movsb         { Prfix kopieren }
  mov  cx, bx
  jcxz @fertig       { wenn keine Endung, dann fertig und raus }
    mov al, '.'
    stosb            { Punkt schreiben }
    mov si, dx
    add si, 8        { Dateiendung anpeilen }
    rep movsb        { Endung kopieren }
  @fertig:
  pop  ds
END;
{ Konvertiert den Dateinamen, wie er im Verzeichniseintrag gespeichert ist,
  in einen normalen Dateinamen (mit Punkt zwischen Name und Extension u.a.).
  Der Funktion darf kein String bergeben werden, sondern nur ein Array,
  welches im ersten Feld bereits das erste Zeichen des Namens enthlt (dort
  steht bei einem String das Lngenbyte). Das Array mu 11 gltige Zeichen
  enthalten }


{ Die folgenden Prozeduren und Funktionen werden nur von Find___LFN bentigt }

FUNCTION BuildSeekMask (FCBMask : String) : String; assembler;
ASM
  push ds
  lds  si, FCBMask
  inc  si
  mov  cx, 11
  les  di, @Result
  mov  ax, cx
  stosb
  xor  bl, bl
  @nextchar:
    cmp cx, 3
    jne @noext
      xor bl, bl
    @noext:
    lodsb
    cmp al, '*'
    jne @weiter
      inc bl
    @weiter:
    or bl, bl
    jz @store
      mov al, '?'
    @store:
    stosb
  loop @nextchar
  pop  ds
END;
{ Erzeugt aus einem FCB-Namen eine Suchmaske. Aus "*       TXT" wird
  "????????.TXT" u.a. }


FUNCTION SameName (Seekname : String; Name : TNameArray) : Boolean; assembler;
ASM
  push ds
  lds  si, SeekName
  inc  si  { Lngenbyte bergehen, es wird immer Lnge 11 erwartet }
  les  di, Name
  mov  cx, 11
  xor  bl, bl
  mov  bh, ' '
  @next:
    lodsb
    cmp al, '?'
    je  @okay
    mov ah, es:[di]
    cmp al, bh
    jne @cmp
      cmp ah, bh
      jne @notfound
      jmp @okay
    @cmp:
    cmp al, ah
    jne @notfound
    @okay:
    inc di
  loop @next
  inc  bl
  @notfound:
  mov  al, bl
  pop  ds
END;
{ vergleicht den Dateinamen im gerade gefundenen DirEntry mit der Suchmaske
  und liefert TRUE zurck, wenn die Maske auf den Namen pat. Normalerweise
  fhrt DOS diesen Vergleich selbst durch, da wegen der langen Dateinamen
  jedoch IMMER *.* als Suchmaske an DOS bergeben wird, mu die Filterung
  selbst vorgenommen werden, da ja auch alle kurzen Dateinamen gefunden
  werden. }


FUNCTION SameAttr (SearchAttr, Attr : Byte) : Boolean; assembler;
ASM
  xor al, al          { al = FALSE }
  mov bl, Attr
  and bl, 00011110b   { = Directory or VolumeID or SysFile or Hidden }
  mov bh, SearchAttr
  and bh, 00111111b   { evtl. flschlich gesetzte Bits 6 und 7 lschen }

  mov ah, bl
  and ah, bh

  or  bl, bl
  je  @and
  cmp bl, ah
  jne @false

  @and:
  or  ah, ah
  jnz @true
  cmp bh, VolumeID
  je  @false

  @true:
  inc al              { al = TRUE }
  @false:
END;
{ Prft, ob das gesuchte Attribut mit dem gefundenen bereinstimmt.
  Diese Prfung ist aus demselben Grund notwendig, wie oben zu
  "Samename" beschrieben. }


FUNCTION GetLFNChar (Index : Word; sr : LSearchRec) : Char; assembler;
ASM
  les di, sr
  add di, FCBSize+9        { FCB, ExtHeader und Sequence berspringen }
  mov ax, Index
  add ax, ax               { in Byte-Position umrechnen ... }
  cmp ax, 8
  jbe @los
  add ax, 3
  cmp ax, 23
  jbe @los
  add ax, 2
  @los:
  add di, ax
  mov al, es:[di]
END;
{ Gibt eines der 13 Zeichen eines langen Dateinamens aus einem LFNEntry
  zurck. Die Indizierung via "Index" erfolgt linear zwischen 0 und 12 }


PROCEDURE ScanLongName (VAR sr : LSearchRec);
VAR
  i, w     : Word;
  c        : Char;

LABEL
  Nochmal;

BEGIN                 
  Nochmal:
  With sr Do
  BEGIN
    LongName[0]:= #0;
    w:= $FFFF;

    While (DOSError = 0) and (Attr=15) and (w>1) Do
    BEGIN
      If ord (TrueName[1]) and $40<>0 Then  { = Sequence-Byte and 40h ... }
      BEGIN
        w:= ord (TrueName[1]) and 31;  { nur Bit 0-4 briglassen }
        w:= w * 13;           { kann max. den Wert 260 annehmen }
        c:= GetLFNChar(12, sr);
        If (c<>#0) and (c<>#255) Then
        If w>250 Then LongName[0]:= #250 Else LongName[0]:= chr(lo(w)); { mu sein,
            da ein langer Name, dessen Lnge sich ohne Rest durch 13 teilen
            lt, mangels Platz kein Null-Byte als Endemarke bekommt }
      END;
      For i:= 12 DownTo 0 Do
      BEGIN
        c:= GetLFNChar (i, sr);
        If w <= 255 Then LongName[w]:= c;
        dec (w);
        If c=#0 Then LongName[0]:= chr(lo(w));
      END;
      FindNextDE (sr);
    END;

    If DOSError = 0 Then
    BEGIN
      If  (* (SameAttr (SearchAttr, Attr))
      and *) (SameName (SearchMask, TrueName)) Then
      Name:= FCBToFileName (TrueName) Else
      BEGIN FindNextDE (sr); Goto Nochmal; END;
    END;
  END;
END;
{ Scannt das Verzeichnis solange, bis der kurze Dateiname erreicht (bzw.
  der lange zu Ende) ist, sammelt dabei die Teilstcke des langen
  Dateinamens auf und fgt sie im Feld sr.LFN zusammen.

  Die Filterung der gefundenen Dateien nach Attribut und Namen wird hier
  selbst vorgenommen, da DOS als Suchmaske IMMER *.* und als Such-Attribut
  immer "anyfile" bergeben bekommt, damit auch die langen Dateinamen
  gefunden werden, auf die eine andere Suchmaske praktisch nie passen wrde. }


{ --------------------------- Haupt-Prozeduren ----------------------------}
{       entsprechen in Funktion und Handhabung Pascal-FindFirst/Next       }

PROCEDURE FindFirstFCB (Path : String; Attr : Word; VAR S : TSearchRec);
BEGIN
  Path := FExpand      (Path);
  FName:= GetFileName  (Path);
  Path := GetPathName  (Path);
  Path := DelLastSlash (Path);

  GetDir (ord(Path[1]) and 31, OldDir);
  SetCurDir (Path);
  If InOutRes<>0 Then BEGIN DOSError:= IOResult; Exit; END;

  FindFirstDE (Path[1], Attr, FCBMask(UpStr(FName)), S);
  S.Name:= FCBToFileName (S.TrueName);

  SetCurDir (OldDir);
  If InOutRes<>0 Then DOSError:= IOResult;
END;


PROCEDURE FindNextFCB (VAR S : TSearchRec);
BEGIN
  FindNextDE (S);
  S.Name:= FCBToFileName (S.TrueName);
END;


PROCEDURE FindFirstLFN (Path : String; Attr : Word; VAR S : LSearchRec);
BEGIN
  Path := FExpand      (Path);
  FName:= GetFileName  (Path);
  Path := DelLastSlash (GetPathName (Path));

  GetDir (ord(Path[1]) and 31, OldDir);
  SetCurDir (Path);
  If InOutRes<>0 Then BEGIN DOSError:= IOResult; Exit; END;

  S.SearchAttr:= Attr;
  S.SearchMask:= BuildSeekMask(FCBMask(UpStr(FName)));
  If Attr <> VolumeID Then Attr:= Anyfile;
  FindFirstDE (Path[1], Attr, '???????????', S);

  SetCurDir (OldDir);
  If InOutRes<>0 Then BEGIN DOSError:= IOResult; Exit; END;

  ScanLongName (S);
END;


PROCEDURE FindNextLFN (VAR S : LSearchRec);
BEGIN
  FindNextDE   (S);
  ScanLongName (S);
END;


END.




{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
