UNIT grafik;


INTERFACE
USES
  bioscrt;


CONST
  VGA320x200 = 19;
VAR
  LastMode : Word;

PROCEDURE GraphMode   (Modus      : Integer);
PROCEDURE PutPixel    (x, y       : Word);
PROCEDURE HorLine     (x, y, Len  : Word);
PROCEDURE VerLine     (x, y, Len  : Word);
PROCEDURE GraphRahmen (a, b, c, d : Word);
PROCEDURE ClearMonit;
PROCEDURE ClearScreen (a, b, c, d : Word; Color : Byte);


IMPLEMENTATION



PROCEDURE GraphMode (Modus : Integer); assembler;
ASM
  mov ah, $0F
  int $10
  mov LastMode, ax
  mov ax, Modus
  xor ah, ah
  int $10
END;



PROCEDURE PutPixel (x, y : Word); assembler;
ASM
  mov ax, y        {y shl 8 + y shl 6 entspricht y * 320}
  shl ax, 1
  shl ax, 1        {statt 125 Takten werden nur 20 bentigt}
  shl ax, 1
  shl ax, 1
  shl ax, 1
  shl ax, 1
  mov bx, ax       {y shl 6 zwischenspeichern}
  shl ax, 1
  shl ax, 1        {y shl 8}
  add bx, ax       {entspricht y shl 8 + y shl 6}
  add bx, x        {Spalten-Nr. dazu}

  mov ax, $A000
  mov es, ax
  mov di, bx
  mov al, TextAttr
  mov es:[di], al
END;



PROCEDURE HorLine (x, y, Len : Word); assembler;
ASM
  mov ax, y
  mov bx, 320
  mul bx
  mov bx, ax
  mov dx, x
  add bx, dx
  mov cx, Len
  cmp cx, dx
  jbe @ende
  sub cx, dx
  mov ax, $A000
  mov es, ax
  mov di, bx
  xor ax, ax
  mov al, TextAttr
  mov ah, al

  test di, 1           {ist DI (=Offset) eine gerade Zahl?}
  je @los              {wenn ja, dann los!}
  StosB                {wenn nicht, schreibe einen einzelnen Pixel}
  dec cx               {Schleifenzhler um 1 runter}
  jcxz @ende           {wenn Null, dann raus}

  @los:
  mov dx, cx           {Schleifenzhler in DX zwischenspeichern}
  shr cx, 1            {Inhalt von CX durch Zwei teilen}
  rep StosW            {schreibe sovile Pixel, bis CX = Null}

  Test dl, 1           {War CX vor Kopierbeginn gerade?}
  je @ende             {wenn ja, fertig und raus}

  stosB

  @ende:
END;



PROCEDURE VerLine (x, y, Len : Word); assembler;
ASM
  mov ax, y
  mov di, ax
  mov bx, 320
  mul bx
  mov bx, ax
  mov dx, x
  add bx, dx

  mov cx, Len
  cmp cx, di
  jbe @ende
  sub cx, di

  mov ax, $A000
  mov es, ax
  mov di, bx
  xor ax, ax
  mov al, TextAttr
  @Start:
    stosb
    add di, 319
  loop @Start
  @ende:
END;



PROCEDURE GraphRahmen (a, b, c, d : Word);
BEGIN
  HorLine (a, b, c);
  HorLine (a, d, c);
  VerLine (a, b, d);
  VerLine (c, b, d+1);
END;



PROCEDURE ClearMonit; Assembler;
ASM
  mov ax, $A000
  mov es, ax
  xor di, di
  mov al, TextAttr
  mov ah, al
  mov cx, 32000
  rep stosw
END;

PROCEDURE ClearScreen (a, b, c, d : Word; Color : Byte);
VAR
  y : Word;
BEGIN
  TextAttr:= Color;
  For y:= b to d Do HorLine (a, y, c);
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
