UNIT HexBin;

INTERFACE

FUNCTION  ShiftRight   (    Wert : LongInt; Schiebe:Word) : LongInt;
FUNCTION  ShiftLeft    (    Wert : LongInt; Schiebe:Word) : LongInt;
FUNCTION  GetNum       (    WStr : String)                : Word;
FUNCTION  WordBits     (    Zahl : Word)                  : String;
FUNCTION  ByteBits     (    Zahl : Byte)                  : String;
FUNCTION  LongBits     (    Zahl : LongInt)               : String;
PROCEDURE SetByteBit   (VAR Zahl : Byte; BitNum : Byte);
PROCEDURE SetWordBit   (VAR Zahl : Word; BitNum : Byte);
PROCEDURE DelByteBit   (VAR Zahl : Byte; BitNum : Byte);
PROCEDURE DelWordBit   (VAR Zahl : Word; BitNum : Byte);
FUNCTION  BitOf        (    Zahl : Word; BitNum : Byte)   : Byte;
FUNCTION  WordHex      (    Zahl : Word)                  : String;
FUNCTION  Bytehex      (    Zahl : Byte)                  : String;
FUNCTION  LongHex      (    Zahl : LongInt)               : String;
PROCEDURE RolByteBits  (VAR Zahl : Byte; Roll   : Byte);
PROCEDURE RorByteBits  (VAR Zahl : Byte; Roll   : Byte);
PROCEDURE RolWordBits  (VAR Zahl : Word; Roll   : Byte);
PROCEDURE RorWordBits  (VAR Zahl : Word; Roll   : Byte);
FUNCTION  GetNot       (    Zahl : Word)                  : Word;


IMPLEMENTATION



FUNCTION ShiftRight (Wert : LongInt; Schiebe : Word) : LongInt; assembler;
ASM
  mov cx, Schiebe
  mov ax, Word Ptr Wert
  mov dx, Word Ptr Wert[2]
  and cx, 1Fh
  jz @ende
  @nochmal:
    shr dx, 1
    rcr ax, 1
  loop @nochmal
  @ende:
END;



FUNCTION ShiftLeft (Wert : LongInt; Schiebe : Word) : LongInt; assembler;
ASM
  mov cx, Schiebe
  mov ax, Word Ptr Wert
  mov dx, Word Ptr Wert[2]
  and cx, 1Fh
  jz @ende
  @nochmal:
    shl ax, 1
    rcl dx, 1
  loop @nochmal
  @ende:
END;



FUNCTION GetNum (WStr : String) : Word; Assembler;
ASM
  cld; mov bx, ds; lds si, WStr; xor ax, ax; xor dx, dx; lodsb; mov cx, ax;
  jcxz @raus
  cmp cx, 16; jbe @weiter; mov cx, 16; @weiter:
  @start: shl dx, 1; lodsb; sub al, 48; or dx, ax; loop @start
  @raus:  mov ds, bx; mov ax, dx
END;
{Gibt die in WStr bergebene Zeichenfolge ('1' oder '0') als Zahl zurck}
{Nicht belegte Stellen werden als 0 interpretiert, z.B. GetNum ('101')}
{entspricht 0000000000000101 (also 5). Strings lnger als 16 Zeichen werden}
{auf 16 Zeichen Lnge gekrzt.}



FUNCTION WordBits (Zahl : Word) : String; assembler;
ASM
  mov bx, Zahl
  cld; les di, @result; mov cx, 16; mov ax, cx; stosb; 
  mov ah, 49
  @start:
    rol  bx, 1
    mov  al, ah
    test bx, 1
    jnz  @weiter; dec al; @weiter:
    stosb
  loop @start
END;
{gibt die 16 Bits von ZAHL als String zurck.}


FUNCTION ByteBits (Zahl : Byte) : String; assembler;
ASM
  mov bl, Zahl
  cld; les di, @result; mov cx, 8; mov ax, cx; stosb
  mov ah, 49
  @start:
    rol  bl, 1
    mov  al, ah
    test bl, 1
    jnz  @weiter; dec al; @weiter:
    stosb
  loop @start
END;
{gibt die 8 Bits von ZAHL als String zurck.}


FUNCTION LongBits (Zahl : LongInt) : String;
BEGIN
  LongBits:= WordBits (Zahl shr 16) + WordBits (Zahl and $FFFF);
END;


PROCEDURE SetByteBit (VAR Zahl : Byte; BitNum : Byte); Assembler;
ASM
  les di, Zahl
  mov al, es:[di]
  mov bl, 1
  mov cl, BitNum
  shl bl, cl
  or  al, bl
  stosB
END;
{Setzt ein Bit an Position BitNum (0 bis 7) in Zahl auf 1}



PROCEDURE SetWordBit (VAR Zahl : Word; BitNum : Byte); Assembler;
ASM
  les di, Zahl
  mov ax, Word Ptr es:[di]
  mov bx, 1
  mov cl, BitNum
  shl bx, cl
  or  ax, bx
  stosW
END;
{Setzt ein Bit an Position BitNum (0 bis 15) in Zahl auf 1}



PROCEDURE DelByteBit (VAR Zahl : Byte; BitNum : Byte); Assembler;
ASM
  les di, Zahl
  mov al, es:[di]
  mov bl, 1
  mov cl, BitNum
  shl bl, cl
  not bl
  and al, bl
  stosB
END;
{Setzt ein Bit an Position BitNum (0 bis 7) in Zahl auf 0}



PROCEDURE DelWordBit (VAR Zahl : Word; BitNum : Byte); Assembler;
ASM
  les di, Zahl
  mov ax, es:[di]
  mov bx, 1
  mov cl, BitNum
  shl bx, cl
  not bx
  and ax, bx
  stosW
END;
{Setzt ein Bit an Position BitNum (0 bis 15) in Zahl auf 0}



FUNCTION BitOf (Zahl : Word; BitNum : Byte) : Byte; Assembler;
ASM
  mov ax, Zahl
  mov bx, 1
  mov cl, BitNum
  shr ax, cl
  and ax, bx
END;
{Gibt den Wert des Bits in Zahl an Position BitNum zurck (0 oder 1)}
{und kann mit Boolean (BitsOf (x,y)) in TRUE und FALSE konvertiert werden.}



FUNCTION WordHex (Zahl : Word) : String; assembler;
ASM
  cld
  les di, @Result
  mov ax, 4
  mov cx, ax
  stosb
  mov bx, Zahl
  @start:
  mov al, $F
  {$IFOPT G+}
    rol bx, 4
  {$ELSE}
    rol bx, 1; rol bx, 1; rol bx, 1; rol bx, 1
  {$ENDIF}
  and al, bl
  cmp al, 9; jbe @falsch1; add al, 7; @falsch1: add al, 48
  Stosb
  loop @start
END;
{verwandelt ein WORD in einen vierstelligen HEX-String}


FUNCTION Bytehex (Zahl : Byte) : String; assembler;
ASM
  les di, @Result
  mov al, 2
  stosb
  mov al, Zahl
  mov ah, al
  {$IFOPT G+}
    shr al, 4
  {$ELSE}
    shr al, 1; shr al, 1; shr al, 1; shr al, 1
  {$ENDIF}
  mov bx, $0F0F
  and ax, bx
  cmp al, 9; jbe @falsch1; add al, 7; @falsch1: add al, 48
  cmp ah, 9; jbe @falsch2; add ah, 7; @falsch2: add ah, 48
  StosW
END;
{verwandelt ein BYTE in einen zweistelligen HEX-String}


FUNCTION LongHex (Zahl : LongInt) : String;
BEGIN
  LongHex:= WordHex (Zahl shr 16) + WordHex (Zahl and $FFFF);
END;


PROCEDURE RolByteBits (VAR Zahl : Byte; Roll : Byte); assembler;
ASM
  les di, Zahl
  mov al, es:[di]
  mov cl, Roll
  rol al, cl
  stosb
END;
{entspricht Assembler-ROL}



PROCEDURE RorByteBits (VAR Zahl : Byte; Roll : Byte); assembler;
ASM
  les di, Zahl
  mov al, es:[di]
  mov cl, Roll
  ror al, cl
  stosb
END;
{entspricht Assembler-ROR}


PROCEDURE RolWordBits (VAR Zahl : Word; Roll : Byte); assembler;
ASM
  les di, Zahl
  mov ax, es:[di]
  mov cl, Roll
  rol ax, cl
  stosW
END;
{entspricht Assembler-ROL}


PROCEDURE RorWordBits (VAR Zahl : Word; Roll : Byte); assembler;
ASM
  les di, Zahl
  mov ax, es:[di]
  mov cl, Roll
  ror ax, cl
  stosW
END;
{entspricht Assembler-ROR}



FUNCTION GetNot (Zahl : Word) : Word; Assembler;
ASM
  mov ax, zahl
  not ax
END;
{entspricht Assembler-NOT}


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
