UNIT InstChk;

INTERFACE

USES
  Dos, Strings;

TYPE
  LineRec = RECORD
              BufLen : Byte;
              Line   : String
            END;


FUNCTION  CDROMInstalled : Word;
PROCEDURE CDCopyRight     (DriveNum : Word; VAR Buffer); 
FUNCTION  MSCDexVersion  : Word;
PROCEDURE GetCDROMList    (VAR Buffer);
FUNCTION  AnsiSysInstalled           : Boolean;
FUNCTION  WindowsInstalled           : Boolean;
FUNCTION  DosKeyInstalled            : Boolean; 
PROCEDURE ReadLine          (VAR Ein : LineRec);
PROCEDURE ReadDosKeyLine    (VAR Ein : LineRec);
FUNCTION  PrintInstalled             : Boolean; 
FUNCTION  AssignInstalled            : Boolean; 
FUNCTION  DriverSysInstalled         : Boolean;
FUNCTION  ShareInstalled             : Boolean; 
FUNCTION  NetworkRedirectorInstalled : Boolean;
FUNCTION  NlsFuncInstalled           : Boolean; 
FUNCTION  WindowsVersion             : Word;
PROCEDURE ReleaseCurrentVMTimeSlice; 
PROCEDURE BeginCriticalSection; 
PROCEDURE EndCriticalSection;
FUNCTION  CPUinRealMode              : Boolean;
FUNCTION  FreeHMA                    : Word;
FUNCTION  XMSinstalled               : Boolean;
FUNCTION  NovellNetWareInstalled     : Boolean; 
FUNCTION  GraphicsComInstalled       : Boolean; 
FUNCTION  DisplaySysInstalled        : Boolean;
FUNCTION  keybComInstalled           : Boolean;
FUNCTION  keybComVersion             : Word;
FUNCTION  ForeignKeyboard            : Boolean; 
PROCEDURE SetKeybCom           (Mode : Byte);


IMPLEMENTATION


FUNCTION CDROMInstalled : Word; assembler;
ASM
  mov ax, $1500
  xor bx, bx
  int $2F
  mov al, bl
  mov ah, cl
END;
{lo (CDRomInstalled) : Zahl der installierten CD-Laufwerke}
{hi (CDRomInstalled) : Nummer des ersten CD_Drives (A=0 usw.)}
{BX : Zahl CD-Drives}
{CX : Nummer des ersten CD-Laufwerkes (A=0, B=1 usw)}



PROCEDURE CDCopyRight (DriveNum : Word; VAR Buffer); assembler;
ASM
  mov ax, $1502
  mov cx, DriveNum
  les bx, Buffer
  int $2F
END;
{Buffer mu 38 Byte gro sein - Inhalt noch unbekannt}
{AX = 15 : Invalid Drive}
{CF = 1  : kein CDRom}

{al = 01 : GetDeviceList-je Laufwerk 5 Byte Puffer anbieten:
           Byte 1 = SubUnit-Nr im Treiber
           Word:Word = Adresse DeviceDriverHeader}
{al = 03 : 38 Byte Puffer (GetAbstractFileName)}
{al = 04 : 38 Byte Puffer (GetBibliograficDocFileName)}



FUNCTION MSCDexVersion : Word; assembler;
ASM
  mov ax, $150C
  int $2F
  mov ax, bx
END;
{bh = Hauptversionsnummer}
{bl = Unterversionsnummer}
{Versionen unter 1.02 geben immer Null zurck}


PROCEDURE GetCDROMList (VAR Buffer); assembler;
ASM
  mov ax, $150D
  les bx, Buffer
  int $2F
END;

{trgt die Nummern aller angeschlossenen CD-Laufwerke in Buffer ein (0=A)}
{Buffer sollte daher vorsichtshalber etwa 36 Byte gro sein}



FUNCTION AnsiSysInstalled : Boolean; assembler;
ASM
  mov ax, $1A00
  int $2F
END;


FUNCTION WindowsInstalled : Boolean;
BEGIN
  WindowsInstalled:= GetEnv ('windir') <> '';
END;


FUNCTION DosKeyInstalled : Boolean; assembler;
ASM
  mov ax, $4800
  int $2F
END;


PROCEDURE ReadLine (VAR Ein : LineRec); assembler;
ASM
  push ds
  lds si, Ein
  mov Word ptr [si], $00FF
  mov dx, si
  mov ah, $0A
  int $21
  pop ds
END;


PROCEDURE ReadDosKeyLine (VAR Ein : LineRec); assembler;
ASM
  push ds
  lds si, Ein
  mov Word ptr ds:[si], $0080
  mov dx, si
  mov ax, $4810
  int $2F
  pop ds
END;
{Ruft Doskey-Kommandozeileneditor auf, auch alte Eingaben lassen sich aufrufen}


FUNCTION PrintInstalled : Boolean; assembler;
ASM
  mov ax, $0100;
  int $2F
  cmp al, 1
  jne @ende
  dec al
  @ende:
END;
{al = 0   : Print.com nicht installiert, aber installierbar}
{al = 1   : Print.com nicht installiert, aber auch NICHT installierbar}
{al = $FF : Print.com resident installiert}



FUNCTION AssignInstalled : Boolean; assembler;
ASM
  mov ax, $0600;
  int $2F
  cmp al, 1
  jne @ende
  dec al
  @ende:
END;
{Belegung des al-Registers analog zu PrintInstalled}



FUNCTION DriverSysInstalled : Boolean; assembler;
ASM
  mov ax, $0800;
  int $2F
  cmp al, 1
  jne @ende
  dec al
  @ende:
END;
{Belegung des al-Registers analog zu PrintInstalled}


FUNCTION ShareInstalled : Boolean; assembler;
ASM
  mov ax, $1000;
  int $2F
  cmp al, 1
  jne @ende
  dec al
  @ende:
END;
{Belegung des al-Registers analog zu PrintInstalled}


FUNCTION NetworkRedirectorInstalled : Boolean; assembler;
ASM
  mov ax, $1100;
  int $2F
  cmp al, 1
  jne @ende
  dec al
  @ende:
END;
{Belegung des al-Registers analog zu PrintInstalled}
{prft, ob Netzwerkumleitung mglich/aktiv (CD-ROM?)}


FUNCTION NlsFuncInstalled : Boolean; assembler;
ASM
  mov ax, $1400;
  int $2F
  cmp al, 1
  jne @ende
  dec al
  @ende:
END;
{Belegung des al-Registers analog zu PrintInstalled}



FUNCTION WindowsVersion : Word; Assembler;
ASM
  mov ax, $1600
  int $2F
END;
{al = $00 oder $80: Win 3.x EnhancedMode oder win/386 luft nicht}
{al = $01 oder $FF: Win 2.x/386 luft}
{sonst: al= Hauptversionsnummer/ ah=Unterversionsnummer (nur Win 3.x)}



PROCEDURE ReleaseCurrentVMTimeSlice; assembler;
ASM
  mov ax, $1680
  int $2F
END;
{meldet Windows 3.x, OS/2, DOS 5.0 da ein Proze keine Rechenzeit mehr}
{bentigt MicroSoft empfiehlt dies statt int $28.}



PROCEDURE BeginCriticalSection; assembler;
ASM
  mov ax, $1681
  int $2F
END;
{meldet Windows 3.x, da ein Proze nicht unterbrochen werden darf}



PROCEDURE EndCriticalSection; assembler;
ASM
  mov ax, $1682
  int $2F
END;
{meldet Windows 3.x, da ein Proze wieder unterbrochen werden darf}



FUNCTION CPUinRealMode : Boolean; assembler;
ASM
  mov ax, $1686
  int $2F
END;


FUNCTION FreeHMA : Word; assembler; {Wert zweifelhaft ?}
ASM
  mov ax, $4A01
  int $2F
  mov ax, bx
END;


FUNCTION XMSinstalled : Boolean; assembler;
ASM
  mov ax, $4300
  int $2F
  cmp al, $80
  je @ende
  xor ax, ax
  @ende:
END;


FUNCTION NovellNetWareInstalled : Boolean; assembler;
ASM
  mov ax, $7A00
  int $2F
END;


FUNCTION GraphicsComInstalled : Boolean; assembler;
ASM
  mov ax, $C000
  int $2F
  cmp ax, $FFFF
  je @ende
  xor ax, ax
  @ende:
END;


FUNCTION DisplaySysInstalled : Boolean; assembler; 
ASM
  mov ax, $AD00
  int $2F
END;


FUNCTION keybComInstalled : Boolean; assembler;
ASM
  mov ax, $AD80
  int $2F
END;


FUNCTION keybComVersion : Word; assembler;
ASM
  mov ax, $AD80
  int $2F
  mov ax, bx
END;
{liefert immer Version 1.0 zurck (bis DOS 6.22)}



FUNCTION ForeignKeyboard : Boolean; assembler;
ASM
  mov ax, $AD83
  int $2F
  mov al, bl
END;
{bl = 00 : US-Tastatur, bl = $FF : Foreign}



PROCEDURE SetKeybCom (Mode : Byte); assembler;
ASM
  mov ax, $AD82
  mov bl, Mode
  int $2F
END;
{setzt den Tastaturmodus in Keyb.Com: Mode=0: US, Mode=$FF: Deutsche}
{CF = 1 Fehler, CF = 0, Okay}


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
