UNIT KeyCode;


INTERFACE


FUNCTION  KeyStatus                : Byte;
PROCEDURE SetKeyStatus    (KeyCode : Byte);
PROCEDURE DelKeyStatus    (KeyCode : Byte);
FUNCTION  GetAltCode      (ein     : Char) : Char;
FUNCTION  GetAltChar      (ein     : Char) : Char;


CONST
  RShift = 1;
  LShift = 2;
  Strg   = 4;
  Alt    = 8;
  Scroll = 16;
  Num    = 32;
  Caps   = 64;
  Einf   = 128;


CONST
  F1=  {#0}#59; AF1=  {#0}#104; CF1=  {#0}#94;  SHIFT_F1=  {#0}#84;
  F2=  {#0}#60; AF2=  {#0}#105; CF2=  {#0}#95;  SHIFT_F2=  {#0}#85;
  F3=  {#0}#61; AF3=  {#0}#106; CF3=  {#0}#96;  SHIFT_F3=  {#0}#86;
  F4=  {#0}#62; AF4=  {#0}#107; CF4=  {#0}#97;  SHIFT_F4=  {#0}#87;
  F5=  {#0}#63; AF5=  {#0}#108; CF5=  {#0}#98;  SHIFT_F5=  {#0}#88;
  F6=  {#0}#64; AF6=  {#0}#109; CF6=  {#0}#99;  SHIFT_F6=  {#0}#89;
  F7=  {#0}#65; AF7=  {#0}#110; CF7=  {#0}#100; SHIFT_F7=  {#0}#90;
  F8=  {#0}#66; AF8=  {#0}#111; CF8=  {#0}#101; SHIFT_F8=  {#0}#91;
  F9=  {#0}#67; AF9=  {#0}#112; CF9=  {#0}#102; SHIFT_F9=  {#0}#92;
  F10= {#0}#68; AF10= {#0}#113; CF10= {#0}#103; SHIFT_F10= {#0}#93;

  PgUp        = {#0}#73;  CTRL_PgUp   = {#0}#132;  Up     = {#0}#72;
  PgDn        = {#0}#81;  CTRL_PgDn   = {#0}#118;  Down   = {#0}#80;
  Pos1        = {#0}#71;  CTRL_Pos1   = {#0}#119;  Left   = {#0}#75;
  CTRL_Left   = {#0}#115;
  Endx        = {#0}#79;  CTRL_Ende   = {#0}#117;  Right  = {#0}#77;
  CTRL_Rght   = {#0}#116;
  Einfg       = {#0}#82;  CTRL_EINFG  = {#0}#4;    Entf   = {#0}#83;
  CTRL_ENTF   = {#0}#6;

  Back =  #8;   CTRL_back =  #127;    CTRL_Druck=  {#0}#114;
  ENTER=  #13;  CTRL_ENTER=  #10;     TAB       =      #9;
  ESC  =  #27;  LEER      =  #32;     SHIFT_TAB =  {#0}#15;

  ALTA=  {#0}#30;   CTRA= #1;    ALTN=  {#0}#49;    CTRN= #14;
  ALTB=  {#0}#48;   CTRB= #2;    ALTO=  {#0}#24;    CTRO= #15;
  ALTC=  {#0}#46;   CTRC= #3;    ALTP=  {#0}#25;    CTRP= #16;
  ALTD=  {#0}#32;   CTRD= #4;    ALTQ=  {#0}#16;    CTRQ= #17;
  ALTE=  {#0}#18;   CTRE= #5;    ALTR=  {#0}#19;    CTRR= #18;
  ALTF=  {#0}#33;   CTRF= #6;    ALTS=  {#0}#31;    CTRS= #19;
  ALTG=  {#0}#34;   CTRG= #7;    ALTT=  {#0}#20;    CTRT= #20;
  ALTH=  {#0}#35;   CTRH= #8;    ALTU=  {#0}#22;    CTRU= #21;
  ALTI=  {#0}#23;   CTRI= #9;    ALTV=  {#0}#47;    CTRV= #22;
  ALTJ=  {#0}#36;   CTRJ= #10;   ALTW=  {#0}#17;    CTRW= #23;
  ALTK=  {#0}#37;   CTRK= #11;   ALTX=  {#0}#45;    CTRX= #24;
  ALTL=  {#0}#38;   CTRL= #12;   ALTY=  {#0}#21;    CTRY= #25;
  ALTM=  {#0}#50;   CTRM= #13;   ALTZ=  {#0}#44;    CTRZ= #26;

  ALT1=#$78;   ALT2=#$79;   ALT3=#$7A;  ALT4=#$7B;  ALT5=#$7C;
  ALT6=#$7D;   ALT7=#$7E;   ALT8=#$7F;  ALT9=#$80;  ALT0=#$81;


IMPLEMENTATION

CONST
  KeyTabStr =       { Index = Zeichencode - 64 }
  #30#48#46#32#18#33#34#35#23#36#37#38#50#49#24#25#16#19#31#20#22#47#17#45#21#44;
  KeyTable : String = KeyTabStr;

  AltTabStr =       { Index = ALT-Code - 15 }
  'QWERTYUIOP'#0#0#0#0'ASDFGHJKL'#0#0#0#0#0'ZXCVBNM';  { QWERTY-Tastatur ! }
  AltTable : String = AltTabStr;


FUNCTION GetAltCode (ein : Char) : Char; assembler;
ASM
  xor al, al
  mov ah, ein
  cmp ah, '0'; jb @nix; jne @weiter; mov ah, 58; @weiter:
  cmp ah,  58; ja @los
  add ah, 71
  mov al, ah
  jmp @nix
  @los:
  and ah, 11011111b       { UpCase }
  cmp ah, 'A'; jb @nix
  cmp ah, 'Z'; ja @los
  sub ah, 64              { auf Tabellen-Index umrechnen ('A' = 1 usw.) }
  lea bx, KeyTable
  mov al, ah
  xlat
  @nix:
END;
{ Ermittelt aus den (normalen) Tastencodes '0'..'9', 'A'..'Z' den Code }
{ der Tastenkombis ALT0..ALT9, ALTA..ALTZ. Es knnen auch Kleinbuchstaben }
{ bergeben werden } 
{ ungltige Tasten: Ergebnis=0 }

FUNCTION GetAltChar (ein : Char) : Char; assembler;
ASM
  xor al, al
  mov ah, ein
  cmp ah, $81; ja @nix; jne @weiter; mov ah, $77; @weiter:
  cmp ah, $77; jb @los
  sub ah, 71
  mov al, ah
  jmp @nix
  @los:
  cmp ah, 16;  jb @nix
  cmp ah, 50;  ja @nix
  sub ah, 15              { auf Tabellen-Index umrechnen (ALTQ = 1 usw.) }
  mov al, ah
  lea bx, AltTable
  xlat
  @nix:
END;
{ Ermittelt aus dem Code der Tastenkombis ALT0..ALT9, ALTA..ALTZ }
{ die (normalen) Tastencodes '0'..'9', 'A'..'Z'}
{ ungltige Tasten: Ergebnis=0 }
 

FUNCTION KeyStatus : Byte; assembler;
ASM
  xor ax, ax
  mov es, ax
  mov al, es:[$417]
END;
{holt das Statusbyte fr ALT/STRG/usw. - Tasten}



PROCEDURE SetKeyStatus (KeyCode : Byte); assembler;
ASM
  xor ax, ax
  mov es, ax
  mov al, KeyCode
  or  es:[$417], al
END;
{setzt das Statusbyte fr ALT/STRG/usw. - Tasten}



PROCEDURE DelKeyStatus (KeyCode : Byte); assembler;
ASM
  xor ax, ax
  mov es, ax
  mov al, KeyCode
  not al
  and es:[$417], al
END;
{lscht das Statusbyte fr ALT/STRG/usw. - Tasten (Taste in KeyCode)}


END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
