UNIT konvert;

INTERFACE

USES
  Strings;

{$ifndef filefind}
FUNCTION DosToWin   (ein : Char) : Char;
{$endif}
FUNCTION WinToDos   (ein : Char) : Char;
{$ifndef filefind}
FUNCTION MacToAscii (ein : Char) : Char;
FUNCTION AsciiToMac (ein : Char) : Char;
{$ifndef browser}
FUNCTION WinToMac   (ein : Char) : Char;
FUNCTION MacToWin   (ein : Char) : Char;
{$endif}
{$endif}
FUNCTION HTML2Text  (Code: String) : String;
FUNCTION Text2HTML  (Code: Char)   : String;
FUNCTION HTMLStr    (s   : String) : String;

FUNCTION URLDecode  (s   : String) : String;

IMPLEMENTATION

CONST
  WinDos : String =
  'ܚĎ֙''ɐ'#21''+
  'ŗĶǀ'#255'ŏƒѥ'+
  '`''"""`|';

{$ifndef filefind}

{$ifndef browser}

  WinMac : String =
  'ĀŁǂɃфօ܆'+
  'ߧƮد𶪻«ǻ͖З/ڤۑԒ'+
  ''#255'؆ąɠ'+
  'Μϟًܛ݇Ҕ';

{$endif}

  MacDos : String =
  'Հ'#21''#39'ā'+
  '""ǮŽ/ȯ",ğª`'+
  ''#39'ĳ"ؘ';

{$endif}


FUNCTION WinToDos (ein : Char) : Char; assembler;
ASM
  mov al, ein
  cmp al, 128
  jb @nix
  mov dl, al
  mov bx, ds
  lea si, WinDos; lodsb; mov cl, al; xor ch, ch; shr cx, 1
  @nochmal:
    lodsW
    cmp al, dl
  loopne @nochmal
  jne @ende
  mov dl, ah
  @ende:
  mov ds, bx
  mov al, dl
  @nix:
END;

{$ifndef filefind}


FUNCTION DosToWin (ein : Char) : Char; assembler;
ASM
  mov al, ein
  cmp al, 39;  je @los
  cmp al, 20;  je @los
  cmp al, 21;  je @los
  cmp al, 128; jb @nix
  @los:
  mov dl, al
  mov bx, ds
  lea si, WinDos; lodsb; mov cl, al; xor ch, ch; shr cx, 1
  @nochmal:
    lodsW
    cmp ah, dl
  loopne @nochmal
  jne @ende
  mov dl, al
  @ende:
  mov ds, bx
  mov al, dl
  @nix:
END;


 
FUNCTION MacToASCII (ein : Char) : Char; assembler;
ASM
  mov al, ein
  cmp al, 31;  je @los
  cmp al, 128
  jb  @nix
  @los:
  mov dl, al
  mov bx, ds
  lea si, MacDos; lodsb; mov cl, al; xor ch, ch; shr cx, 1
  @nochmal:
    lodsW
    cmp al, dl
  loopne @nochmal
  jne @ende
  mov dl, ah
  @ende:
  mov ds, bx
  mov al, dl
  @nix:
END;


FUNCTION ASCIIToMac (ein : Char) : Char; assembler;
ASM
  mov al, ein
  cmp al, 45;  je @los
  cmp al, 21;  je @los
  cmp al, 39;  je @los
  cmp al, 128; jbe @nix
  @los:
  mov dl, al
  mov bx, ds
  lea si, MacDos; lodsb; mov cl, al; xor ch, ch; shr cx, 1
  @nochmal:
    lodsW
    cmp ah, dl
  loopne @nochmal
  jne @ende
  mov dl, al
  @ende:
  mov ds, bx
  mov al, dl
  @nix:
END;

{$ifndef browser}

FUNCTION WinToMac (ein : Char) : Char; assembler;
ASM
  mov al, ein
  cmp al, 128
  jb  @nix
  @los:
  mov dl, al
  mov bx, ds
  lea si, WinMac; lodsb; mov cl, al; xor ch, ch; shr cx, 1
  @nochmal:
    lodsW
    cmp al, dl
  loopne @nochmal
  jne @ende
  mov dl, ah
  @ende:
  mov ds, bx
  mov al, dl
  @nix:
END;


FUNCTION MacToWin (ein : Char) : Char; assembler;
ASM
  mov al, ein
  cmp al, 128; jb @nix
  @los:
  mov dl, al
  mov bx, ds
  lea si, WinMac; lodsb; mov cl, al; xor ch, ch; shr cx, 1
  @nochmal:
    lodsW
    cmp ah, dl
  loopne @nochmal
  jne @ende
  mov dl, al
  @ende:
  mov ds, bx
  mov al, dl
  @nix:
END;
{$endif}
{$endif}

FUNCTION HTML2Text (Code : String) : String;
BEGIN
  If (pos ('0', Code) = 3) and (Length(Code)= 7) Then delete (Code, 3, 1);
   (* bei fhrenden Nullen, z.B. &#0228; *)
  If (Code= '&Auml;'  ) or (Code='&#196;') Then HTML2Text:= '' Else
  If (Code= '&Ouml;'  ) or (Code='&#214;') Then HTML2Text:= '' Else
  If (Code= '&Uuml;'  ) or (Code='&#220;') Then HTML2Text:= '' Else
  If (Code= '&auml;'  ) or (Code='&#228;') Then HTML2Text:= '' Else
  If (Code= '&ouml;'  ) or (Code='&#246;') Then HTML2Text:= '' Else
  If (Code= '&uuml;'  ) or (Code='&#252;') Then HTML2Text:= '' Else
  If (Code= '&Aring;' ) or (Code='&#197;') Then HTML2Text:= '' Else
  If (Code= '&aring;' ) or (Code='&#229;') Then HTML2Text:= '' Else
  If (Code= '&Aelig;' ) or (Code='&#198;') Then HTML2Text:= '' Else
  If (Code= '&aelig;' ) or (Code='&#230;') Then HTML2Text:= '' Else
  If (Code= '&Ccedil;') or (Code='&#199;') Then HTML2Text:= '' Else
  If (Code= '&ccedil;') or (Code='&#231;') Then HTML2Text:= '' Else
  If (Code= '&Eacute;') or (Code='&#201;') Then HTML2Text:= '' Else
  If (Code= '&eacute;') or (Code='&#233;') Then HTML2Text:= '' Else
  If (Code= '&ntilde;') or (Code='&#241;') Then HTML2Text:= '' Else
  If (Code= '&Ntilde;') or (Code='&#209;') Then HTML2Text:= '' Else
  BEGIN
  Code:= LowStr (Code);
  If (Code= '&szlig;' ) or (Code='&#223;') Then HTML2Text:= '' Else
  If (Code= '&nbsp;'  ) or (Code='&#160;') Then HTML2Text:= #32 Else
  If (Code= '&euro;'  )                    Then HTML2Text:= '' Else
  If (Code= '&pound;' ) or (Code='&#163;') Then HTML2Text:= '' Else
  If (Code= '&sub1;'  ) or (Code='&#185;') Then HTML2Text:= '' Else
  If (Code= '&iquest;') or (Code='&#191;') Then HTML2Text:= '' Else
  If (Code= '&frac12;') or (Code='&#189;') Then HTML2Text:= '' Else
  If (Code= '&frac14;') or (Code='&#188;') Then HTML2Text:= '' Else
  If (Code= '&yen;'   ) or (Code='&#165;') Then HTML2Text:= '' Else
  If (Code= '&laquo;' ) or (Code='&#132;') or (Code='&#171;') or (code='&#147;')  Then HTML2Text:= '' Else
  If (Code= '&raquo;' ) or (Code='&#148;') or (Code='&#187;')   Then HTML2Text:= '' Else
  If (Code= '&deg;'   ) or (Code='&#176;') or (Code='&#186;')   Then HTML2Text:= '' Else
  If (Code= '&cedil;' ) or (Code='&#126;') Then HTML2Text:= '~' Else
  If (Code= '&agrave;') or (Code='&#224;') Then HTML2Text:= '' Else
  If (Code= '&aacute;') or (Code='&#225;') Then HTML2Text:= '' Else
  If (Code= '&acirc;' ) or (Code='&#226;') Then HTML2Text:= '' Else
  If (Code= '&egrave;') or (Code='&#232;') Then HTML2Text:= '' Else
  If (Code= '&euml;'  ) or (Code='&#235;') Then HTML2Text:= '' Else
  If (Code= '&ecirc;' ) or (Code='&#234;') Then HTML2Text:= '' Else
  If (Code= '&igrave;') or (Code='&#236;') Then HTML2Text:= '' Else
  If (Code= '&iacute;') or (Code='&#237;') Then HTML2Text:= '' Else
  If (Code= '&icirc;' ) or (Code='&#238;') Then HTML2Text:= '' Else
  If (Code= '&iuml;'  ) or (Code='&#239;') Then HTML2Text:= '' Else
  If (Code= '&ograve;') or (Code='&#242;') Then HTML2Text:= '' Else
  If (Code= '&oacute;') or (Code='&#243;') Then HTML2Text:= '' Else
  If (Code= '&ocirc;' ) or (Code='&#244;') Then HTML2Text:= '' Else
  If (Code= '&ugrave;') or (Code='&#249;') Then HTML2Text:= '' Else
  If (Code= '&uacute;') or (Code='&#250;') Then HTML2Text:= '' Else
  If (Code= '&ucirc;' ) or (Code='&#251;') Then HTML2Text:= '' Else
  If (Code= '&iexcl;' ) or (Code='&#161;') Then HTML2Text:= '' Else
  If (Code= '&oslash;') or (Code='&#162;') Then HTML2Text:= '' Else
  If (Code= '&yuml;'  ) or (Code='&#255;') Then HTML2Text:= '' Else
  If (Code= '&divide;') or (Code='&#247;') Then HTML2Text:= '' Else
  If (Code= '&ordf;'  ) or (Code='&#170;') Then HTML2Text:= '' Else
  If (Code= '&ordm;'  ) or (Code='&#186;') Then HTML2Text:= '' Else
  If (Code= '&not;'   ) or (Code='&#172;') Then HTML2Text:= '' Else
  If (Code= '&middot;') or (Code='&#183;') Then HTML2Text:= '' Else
  If (Code= '&sect;'  ) or (Code='&#167;') Then HTML2Text:= #21 Else
  If (Code= '&acute;' ) or (Code='&#180;')
  or (Code='&#145;')    or (Code='&#146;') Then HTML2Text:= #39 Else
  If (Code= '&amp;'   )                    Then HTML2Text:= '&' Else
  If (Code= '&quot;'  )                    Then HTML2Text:= '"' Else
  If (Code= '&gt;'    ) or (Code='&#155;') Then HTML2Text:= '>' Else
  If (Code= '&lt;'    ) or (Code='&#139;') Then HTML2Text:= '<' Else
  If (Code= '&copy;'  ) or (Code='&#169;') Then HTML2Text:= '(c)'  Else
  If (Code= '&reg;'   ) or (Code='&#174;') Then HTML2Text:= '(R)'  Else
  If (Code= '&trade;' ) or (Code='&#153;') Then HTML2Text:= '(TM)' Else
  If (Code= '&#131;'  )                    Then HTML2Text:= ''    Else
  If (Code= '&#133;'  )                    Then HTML2Text:= '...'  Else
  If (Code= '&#134;'  )                    Then HTML2Text:= '' Else
  If (Code= '&#135;'  )                    Then HTML2Text:= '' Else
  If (Code= '&#136;'  )                    Then HTML2Text:= '^' Else
  If (Code= '&#137;'  )                    Then HTML2Text:= '%o'Else
  If (Code= '&#149;'  )                    Then HTML2Text:= '' Else
  If (Code= '&#150;'  ) or (Code='&#173;') Then HTML2Text:= '-' Else
  If (Code= '&shy;'   ) or (Code='&#151;') or (Code='&#175;')   Then HTML2Text:= '' Else
  If (Code= '&shy;'   ) or (Code='&#152;') or (Code='&#126;')   Then HTML2Text:= '~' Else
  If (Code= '&brvbar;') or (Code='&#166;') Then HTML2Text:= '|' Else
  If                       (Code='&#124;') Then HTML2Text:= '' Else
  If (Code= '&plusmn;') or (Code='&#177;') Then HTML2Text:= '' Else
  If (Code= '&sup2;'  ) or (Code='&#178;') Then HTML2Text:= '' Else
  If (Code= '&micro;' ) or (Code='&#181;') Then HTML2Text:= '' Else
  If (Code= '&para;'  ) or (Code='&#182;') Then HTML2Text:= #20 Else
  If (Code= '&#248;'  )                    Then HTML2Text:= '' Else
  If (Code= '&times;' ) or (Code='&#215;') Then HTML2Text:= 'x' Else
  If (Code= '&eth;'   ) or (Code='&#240;') Then HTML2Text:= '' Else
  If (Code= '&frac34;') or (Code='&#190;') Then HTML2Text:= '3/4' Else
  If (Code= '&#9;')                        Then HTML2Text:= ' '   Else (*Tabulator*)

  HTML2Text:= Code;
  END;
END;


FUNCTION Text2HTML (Code : Char) : String;
BEGIN
  If (Code>='A') and (Code<='Z') or (Code>='a') and (Code<='z') Then
  Text2Html:= Code Else
  CASE Code Of
    '' : Text2Html:= '&Auml;';
    '' : Text2Html:= '&Ouml;';
    '' : Text2Html:= '&Uuml;';
    '' : Text2Html:= '&auml;';
    '' : Text2Html:= '&ouml;';
    '' : Text2Html:= '&uuml;';
    '' : Text2Html:= '&szlig;';
    '' : Text2Html:= '&euro;';
    '' : Text2Html:= '&pound;';
    '' : Text2Html:= '&sub1;';
    '' : Text2Html:= '&iquest;';
    '' : Text2Html:= '&Aring;';
    '' : Text2Html:= '&aring;';
    '' : Text2Html:= '&frac12;';
    '' : Text2Html:= '&frac14;';
    '' : Text2Html:= '&Aelig;';
    '' : Text2Html:= '&aelig;';
    '' : Text2Html:= '&Ccedil;';
    '' : Text2Html:= '&ccedil;';
    '' : Text2Html:= '&Eacute;';
    '' : Text2Html:= '&eacute;';
    '' : Text2Html:= '&ntilde;';
    '' : Text2Html:= '&Ntilde;';
    '' : Text2Html:= '&yen;';
    '' : Text2Html:= '&laquo;';
    '' : Text2Html:= '&raquo;';
    '' : Text2Html:= '&deg;';
    '~' : Text2Html:= '&cedil;';
    '' : Text2Html:= '&agrave;';
    '' : Text2Html:= '&aacute;';
    '' : Text2Html:= '&acirc;';
    '' : Text2Html:= '&egrave;';
    '' : Text2Html:= '&euml;';
    '' : Text2Html:= '&ecirc;';
    '' : Text2Html:= '&igrave;';
    '' : Text2Html:= '&iacute;';
    '' : Text2Html:= '&icirc;';
    '' : Text2Html:= '&iuml;';
    '' : Text2Html:= '&ograve;';
    '' : Text2Html:= '&oacute;';
    '' : Text2Html:= '&ocirc;';
    '' : Text2Html:= '&ugrave;';
    '' : Text2Html:= '&uacute;';
    '' : Text2Html:= '&ucirc;';
    '' : Text2Html:= '&iexcl;';
    '' : Text2Html:= '&oslash;';
    '' : Text2Html:= '&yuml;';
    '' : Text2Html:= '&divide;';
    '' : Text2Html:= '&ordf;';
    '' : Text2Html:= '&ordm;';
    '' : Text2Html:= '&not;';
    '' : Text2Html:= '&middot;';
    #21 : Text2Html:= '&sect;';
    #39 : Text2Html:= '&acute;';
    '&' : Text2Html:= '&amp;';
    '"' : Text2Html:= '&quot;';
    '>' : Text2Html:= '&gt;';
    '<' : Text2Html:= '&lt;';
    '' : Text2Html:= '&#131;';
    '' : Text2Html:= '&#134;';
    '' : Text2Html:= '&#135;';
    '^' : Text2Html:= '&#136;';
    '' : Text2Html:= '&shy;';
    '~' : Text2Html:= '&#152;';
    '|' : Text2Html:= '&brvbar;';
    '' : Text2Html:= '&plusmn;';
    '' : Text2Html:= '&sup2;';
    '' : Text2Html:= '&micro;';
    #20 : Text2Html:= '&para;';
    '' : Text2Html:= '&#248;';
    '' : Text2Html:= '&eth;';
     #9 : Text2Html:= '&#9;';
    Else  Text2Html:= Code;
  END;
END;


FUNCTION HTMLStr (s : String) : String;
VAR
  t : String;
  x : Byte;
BEGIN
  t:= '';
  For x:= 1 To Length(s) Do StrAdd (t, Text2HTML(s[x]));
  HTMLStr:= t;
END;


FUNCTION URLDecode (s : String) : String;
VAR
  x, l : Byte;
  s2   : String;
  c    : Char;
BEGIN
  l:= Length (s);
  x:= 0;
  s2:= '';
  While x < l Do
  BEGIN
    inc (x);
    If s[x]='%' Then
    BEGIN
      inc (x);
      c:= WinToDos (chr (Byte (IntVal ('$'+copy (s, x, 2)))));
      If pos (c, #13#10#9) = 0 Then CharAdd (s2, c);
      inc (x);
    END Else
    If s[x]='+' Then CharAdd (s2, ' ') Else CharAdd (s2, s[x]);
  END;
  URLDecode:= s2;
END;

END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
