UNIT LFN;

INTERFACE

USES
  Dos, Strings;

TYPE
  TExtFCB    = RECORD
                 Signatur : Byte;                 { immer $FF ! }
                 Res1     : Array[1..5] Of Byte;  { auf 0 setzen }
                 SeekAttr : Byte;                 { gesuchtes Dateiattribut }
                 DriveNr  : Byte;                 { Laufwerksnummer, 1=A 2=b }
                 FileName : Array[1..8] Of Char;  { Prfix Suchmaske }
                 FileExt  : Array[1..3] Of Char;  { Datei-Endung Suchmaske }
                 Res2     : LongInt;              { Die folgenden Felder }
                 FileSize : LongInt;              { werden nicht bentigt, }
                 FileDate : Word;                 { mssen aber als Platz- }
                 FileTime : Word;                 { halter vorhanden sein und }
                 Res3     : Array[1..13] Of Byte; { enthalten gltige Werte }
               END;
               { Struktur Extended File Control Block
                 Dateinamensfelder mit Leerzeichen auffllen }

  TSearchRec = RECORD
                 FCB     : TExtFCB;    { FCB darf nicht manipuliert werden }
                 Attr    : Byte;
                 Time    : Longint;
                 Cluster : Word;       { Erster Cluster der Datei, wer's braucht }
                 Size    : Longint;
                 Name    : String[12]; { kurzer Dateiname }
                 LFN     : String;     { langer Dateiname, wenn vorhanden }
                 SeekAttr: Word;       { darf nicht verndert werden ! }
                 SeekMask: String[11]; { darf nicht verndert werden ! }
               END;
               { SearchRec mit zustzlichen Feldern fr den langen Dateinamen
                 und einem ExtFCB, den DOS fr die Suche bentigt } 


  TDirEntry  = RECORD
                 Spacer       : Array[1..8] Of Byte;
                 FileName     : Array[1..8] Of Char;   { mit Leerzeichen aufgefllt }
                 FileExt      : Array[1..3] Of Char;   { "" }
                 FileAttr     : Byte;                  { Dateiattribut }
                 Intern       : Array[1..10] Of Byte;  { "reserviert", bis DOS 6.x leer }
                 FileTime     : LongInt;               { Uhrzeit, Datum }
                 StartCluster : Word;                  { Erster Cluster der Datei/des Unterverzeichnisses }
                 FSize        : LongInt;               { Dateigre }
               END;
               { Struktur eines verzeichniseintrages mit vorangestelltem
                 Spacer (Abstandhalter) zum Beginn der DTA }

  TLFNEntry  = RECORD         { Struktur eines DirEntry fr lange Dateinamen }
                 Spacer       : Array[1..8] Of Byte;   { s.o. }
                 Sequence     : Byte;                  { s.u. }
                 Name1        : Array[1..5] Of Word;   { Unicode der ersten 5 Zeichen }
                 FileAttr     : Byte;                  { immer $0F = RHSI }
                 Indicator    : Byte;                  { Zeichen-Indikator, i.d.R. 0, manchmal 32 }
                 CheckSum     : Byte;                  { Addition bestimmter Felder des 8.3-Namens MOD 256 }
                 Name2        : Array[1..6] Of Word;   { Unicode der nchsten 6 Zeichen }
                 StartCluster : Word;                  { bei langen Namen immer 0 }
                 Name3        : Array[1..2] Of Word;   { Unicode der nchsten 2 Zeichen }
               END;
               { Sequenz-Byte:
                 Bits 0-4    : Nummer des Verzeichniseintrages
                 Bit  5      : derzeit ungenutzt, immer 0
                 Bit  6      : kennzeichnet das Ende einer Sequenz
                 Bit  7      : derzeit ungenutzt (immer 0 ?)
                 Der Dateiname endet mit einem 0-Byte, der evtl. Rest ist
                 mit ASCII 255 aufgefllt. }

CONST
  GetLongNames : Boolean = TRUE;
                         { auf FALSE setzen, wenn lange Dateinamen nicht
                           interpretiert, sondern als "normale" Verzeichnis-
                           eintrge behandelt werden sollen. }
VAR
  DirEntry : TDirEntry;  { fungiert als DTA (Disk Transfer Adress) fr
                           den Suchvorgang und enthlt nach jedem Aufruf
                           von FindFirstDE und FindnextDE den Verzeichnis-
                           eintrag in Originalform }

  LFNEntry : TLFNEntry absolute DirEntry;
                         { liegt als Maske auf Direntry, um die
                           Interpretation der Daten zu erleichtern, wenn
                           Direntry ein Teilstck eines langen Dateinamens
                           enthlt. Belegt keinen zustzliche Speicher }

  DTA      : RECORD
               Spacer   : Array[1..8]  Of Char;
               DirEntry : Array[1..32] Of Char;
             END absolute DirEntry;
                         { liegt ebenfalls als Maske auf Direntry und
                           ermglicht Einzel-Zugriffe auf alle 32 Bytes
                           des Verzeichniseintrages. Steht die Konstante
                           GetLongNames auf FALSE, kann nach jedem Aufruf
                           von FindFirstLFN/NextLFN der Original-Inhalt des
                           gerade gefundenen Eintrages im Feld "DTA.DirEntry"
                           begutachtet werden. }


PROCEDURE FindFirstLFN (Path  : String; Attr : Word; VAR S : TSearchRec);
PROCEDURE FindNextLFN  (VAR S : TSearchRec);

FUNCTION  FCBMask (ein : String) : String;


IMPLEMENTATION

VAR
  FName  : String[12]; { Globale temporre Strings fr FindFirstLFN, damit }
  OldDir : PathStr;    { diese z.B. bei Rekursionen nicht den Stack belasten }

CONST
  AttMask = Directory or VolumeID or SysFile or Hidden;


PROCEDURE SetCurDir (CurDir : PathStr); assembler;
ASM
  push ds
  lds  si, CurDir
  mov  bl, [si]
  xor  bh, bh
  cmp  bx, 78                { Lnge wird auf 78 Zeichen begrenzt. Dies }
  jbe  @los                  { ist normalerweise ohnehin keine gltige }
  mov  bx, 78                { Pfadlnge }
  @los:
  inc  si
  mov  byte ptr [si+bx], 0   { Nullbyte ans String-Ende setzen }

  mov  dx, si                { Change Current Directory }
  mov  ah, 3Bh
  int  21h
  jc   @ende
  xor  ax, ax
  @ende:
  pop  ds
  mov  InOutRes, ax
END;
{ Setzt das in CurDir angegebene Verzeichnis als das aktuelle Verzeichnis
  auf dem in Curdir angegebenen Laufwerk. Es wird (da hier nicht erlaubt)
  im Unterschied zu Pascal-ChDir KEIN Laufwerkswechsel vollzogen !
  Der Erfolg der Aktion kann/mu anschlieend mit IOResult ermittelt werden. }


PROCEDURE FindFirstDE (Drive : Char; VAR FCB : TSearchRec); assembler;
ASM
  push ds
  cld
  les  di, FCB                  { FCB fr Suche initialisieren }
  mov  al, $FF
  stosb                         { Kennung FF fr ExtendedFCB schreiben }
  xor  al, al 
  mov  cx, 5
  rep  stosb                    { Res1 mit Nullbytes fllen }
  mov  al, anyfile              { wegen der langen Namen immer anyfile ! }
  stosb                         { Gesuchtes Dateiattribut speichern }
  mov  al, Drive
  and  al, 31                   { DriveLetter zu Zahl }
  stosb                         { zu durchsuchendes Laufwerk speichern }

  mov  cx, 11                   { *.* als Suchmaske vorgeben, Filterung }
  mov  al, '?'                  { erfolgt durch eigene Funktion }
  rep  stosb                    { Suchmaske in FCB einsetzen }

  mov  ah, 2Fh
  int  21h
  push es
  push bx                       { Adresse der alten DTA speichern }
 
  mov  ah, 1Ah                  { DirEntry als DTA einsetzen }
  mov  dx, Seg DirEntry
  mov  ds, dx
  mov  dx, Offset DirEntry
  int  21h

  lds  dx, FCB
  mov  ah, 11h
  int  21h                      { FindFirst with FCB }

  pop  dx
  pop  ds
  mov  ah, 1Ah
  int  21h                      { Adresse der alten DTA restaurieren }

  pop  ds
  xor  ah, ah
  mov  DOSError, ax
END;
{ Kernfunktion zum Einlesen des ersten Verzeichniseintrages }


PROCEDURE FindNextDE (VAR FCB : TSearchRec); assembler;
ASM
  push ds

  mov  ah, 2Fh
  int  21h
  push es
  push bx                       { Adresse der alten DTA speichern }
 
  mov  ah, 1Ah                  { DirEntry als DTA einsetzen }
  mov  dx, Seg DirEntry
  mov  ds, dx
  mov  dx, Offset DirEntry
  int  21h

  lds  dx, FCB
  mov  ah, 12h
  int  21h                      { FindNext with FCB }

  pop  dx
  pop  ds
  mov  ah, 1Ah
  int  21h                      { Adresse der alten DTA restaurieren }

  pop  ds
  xor  ah, ah
  mov  DOSError, ax
END;
{ Kernfunktion zum Einlesen aller weiteren Verzeichniseintrge }



FUNCTION FCBMask (ein : String) : String; assembler;
ASM
  push ds
  cld
  les di, @Result
  mov ax, 11
  stosb            { Lngenbyte des Rckgabestrings setzen }
  push di
  mov cx, ax
  mov al, ' '
  rep stosb        { Rckgabestring mit 11 Leerzeichen fllen }

  pop di
  mov bx, di
  add bx, 8        { spteren Beginn der Datei-Endung anpeilen und merken }

  lds si, ein
  lodsb; mov cl, al; xor ch, ch; jcxz @ende     { Lngenbyte checken }
  cmp cx, 12; jbe @los; mov cx, 12; @los:       { evtl. berlnge kappen }

  @loop:           { bis zum Punkt kopieren }
    lodsb
    cmp al, '.'
    je  @weiter
    stosb
  loop @loop

  @weiter:
  jcxz @ende
  dec cx
  mov di, bx        { Dateiendung kopieren }
  rep movsb

  @ende:
  pop  ds
END;
{ wandelt einen Dateinamen in das von FCB-Funktionen bentigte
  Format um. Dabei wird ein evtl. vorhanderen Punkt zwischen
  Dateinamen und Dateiendung entfernt und der Dateiname wird mit
  Leerzeichen auf 8 Zeichen Lnge gestreckt, die Dateiendung
  auf 3 Zeichen.

  Die folgende Funktion kehrt diesen Vorgang um }


FUNCTION FCBToFileName (VAR FCBName) : String; assembler;
ASM
  push ds
  std
  les  di, FCBName  { FCBName darf hier kein Lngenbyte enthalten! }
  mov  cx, 8
  add  di, 7
  push di
  mov  al, ' '
  repe scasb
  je   @w1
  inc  cx
  @w1:
  mov  bx, cx        { Lnge Prfix in BX }

  mov  cx, 3
  pop  di
  add  di, cx
  repe scasb
  je   @w2
  inc  cx
  @w2:
  mov  ax, cx        { Lnge Ext in AX und CX}
  add  ax, bx        { Gesamtlnge in AX }
  jcxz @los          { wenn keine Endung vorhanden, dann weiter }
  inc  ax            { ansonsten Lnge um eins hoch (fr den Punkt) }
  @los:
  cld
  lds  si, FCBName
  mov  dx, si        { SI in DX merken }
  les  di, @Result
  stosb              { Lngenbyte schreiben }
  xchg cx, bx
  rep  movsb         { Prfix kopieren }
  mov  cx, bx
  jcxz @fertig       { wenn keine Endung, dann fertig und raus }
    mov al, '.'
    stosb            { Punkt schreiben }
    mov si, dx
    add si, 8        { Dateiendung anpeilen }
    rep movsb        { Endung kopieren }
  @fertig:
  pop  ds
END;
{ Konvertiert den Dateinamen, wie er im Verzeichniseintrag gespeichert ist,
  in einen normalen Dateinamen (mit Punkt zwischen Name und Extension u.a.).
  Der Funktion darf kein String bergeben werden, sondern nur ein Array,
  welches im ersten Feld bereits das erste Zeichen des Namens enthlt (dort
  steht bei einem String das Lngenbyte). Das Array mu 11 gltige Zeichen
  enthalten }


FUNCTION BuildSeekMask (FCBMask : String) : String; assembler;
ASM
  push ds
  lds  si, FCBMask
  inc  si
  mov  cx, 11
  les  di, @Result
  mov  ax, cx
  stosb
  xor  bl, bl
  @nextchar:
    cmp cx, 3
    jne @noext
      xor bl, bl
    @noext:
    lodsb
    cmp al, '*'
    jne @weiter
      inc bl
    @weiter:
    or bl, bl
    jz @store
      mov al, '?'
    @store:
    stosb
  loop @nextchar
  pop  ds
END;
{ Erzeugt aus einem FCB-Namen eine Suchmaske. Aus "*       TXT" wird
  "????????.TXT" u.a. }


FUNCTION SameName (Seekname : String; VAR DirEntryName) : Boolean; assembler;
ASM
  push ds
  lds  si, SeekName
  inc  si  { Lngenbyte bergehen, es wird immer Lnge 11 erwartet }
  les  di, DirEntryName
  mov  cx, 11
  xor  bl, bl
  mov  bh, ' '
  @next:
    lodsb
    cmp al, '?'
    je  @okay
    mov ah, es:[di]
    cmp al, bh
    jne @cmp
      cmp ah, bh
      jne @notfound
      jmp @okay
    @cmp:
    cmp al, ah
    jne @notfound
    @okay:
    inc di
  loop @next
  inc  bl
  @notfound:
  mov  al, bl
  pop  ds
END;
{ vergleicht den Dateinamen im gerade gefundenen DirEntry mit der Suchmaske
  und liefert TRUE zurck, wenn die Maske auf den Namen pat. Normalerweise
  fhrt DOS diesen Vergleich selbst durch, da wegen der langen Dateinamen
  jedoch IMMER *.* als Suchmaske an DOS bergeben wird, mu die Filterung
  selbst vorgenommen werden, da ja auch alle kurzen Dateinamen gefunden
  werden. }


FUNCTION GetLFNChar (Index : Word) : Char; assembler;
ASM
  mov dx, Seg DirEntry
  mov es, dx
  mov di, Offset DirEntry
  add di, 9                { Spacer und Sequence berspringen }
  mov ax, Index
  add ax, ax               { in Byte-Position umrechnen ... }
  cmp ax, 8
  jbe @los
  add ax, 3
  cmp ax, 23
  jbe @los
  add ax, 2
  @los:
  add di, ax
  mov al, es:[di]
END;
{ Gibt eines der 13 Zeichen eines langen Dateinamens aus einem DirEntry
  bzw. LFNEntry zurck. Die Indizierung via "Index" erfolgt linear
  zwischen 0 und 12 }


PROCEDURE ScanLongName (VAR sr : TSearchRec);
VAR
  i, w  : Word;
  c     : Char;
LABEL
  Nochmal;
BEGIN                 
  Nochmal:
  sr.LFN[0]:= #0;
  w        := $FFFF;

  If GetLongNames Then
  With sr, LFNEntry Do
  While (DOSError = 0) and (FileAttr=15) and (w>1) Do
  BEGIN
    If Sequence and $40<>0 Then
    BEGIN
      w:= Sequence and 31;  { nur Bit 0-4 briglassen }
      w:= w * 13;           { kann max. den Wert 260 annehmen }
    END;
    For i:= 12 DownTo 0 Do
    BEGIN
      c:= GetLFNChar (i);
      If w <= 255 Then LFN[w]:= c;
      dec (w);
      If c=#0 Then LFN[0]:= chr(lo(w));
    END;
    FindNextDE (sr);
  END;

  If DOSError= 0 Then
  With sr, DirEntry Do
  BEGIN
    w:= DirEntry.FileAttr and AttMask;

    If  ((w        =  0)        or (w and SeekAttr =  w))
    and ((SeekAttr <> VolumeID) or (w and SeekAttr <> 0))
    and  (SameName (SeekMask, FileName))
    Then
    BEGIN
      Attr:= FileAttr;
      Move  (FileTime, Time, 10); { gleich samt FirstCluster und FileSize }
      Name:= FCBToFileName (FileName);
    END Else
    BEGIN FindNextDE (sr); Goto Nochmal; END;
  END;
END;
{ Scannt das Verzeichnis solange, bis der kurze Dateiname erreicht (bzw.
  der lange zu Ende) ist, sammelt dabei die Teilstcke des langen
  Dateinamens auf und fgt sie im Feld sr.LFN zusammen.

  Die Filterung der gefundenen Dateien nach Attribut und Namen wird hier
  selbst vorgenommen, da DOS als Suchmaske IMMER *.* und als Such-Attribut
  immer "anyfile" bergeben bekommt, damit auch die langen Dateinamen
  gefunden werden, auf die eine andere Suchmaske praktisch nie passen wrde.
  }


{ ------------------------- Haupt-Prozeduren -----------------------}

PROCEDURE FindFirstLFN (Path : String; Attr : Word; VAR S : TSearchRec);
BEGIN
  Path := FExpand     (Path);
  FName:= GetFileName (Path);
  Path := GetPathName (Path);
  DelLastSlash (Path);

  GetDir (ord(Path[1]) and 31, OldDir);
  SetCurDir (Path);
  If InOutRes<>0 Then BEGIN DOSError:= IOResult; Exit; END;

  S.SeekAttr:= Attr;
  S.SeekMask:= BuildSeekMask(FCBMask(UpCaseStr(FName)));
  FindFirstDE (Path[1], S);

  SetCurDir (OldDir);
  If InOutRes<>0 Then BEGIN DOSError:= IOResult; Exit; END;

  ScanLongName (S);
END;
{ entspricht in Funktion und Handhabung Pascal-FindFirst }


PROCEDURE FindNextLFN (VAR S : TSearchRec);
BEGIN
  FindNextDE   (S);
  ScanLongName (S);
END;
{ entspricht in Funktion und Handhabung Pascal-FindNext }


END.




{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
