UNIT LineEdit;

INTERFACE
USES
  BiosCrt, Monitor, Masken, keycode, Strings;

CONST
  ins : Boolean = TRUE;

PROCEDURE LineEditor (x, y, MaxLen : Byte; VAR s : String; vcol, hcol : Byte);


IMPLEMENTATION


PROCEDURE LineEditor (x, y, MaxLen : Byte; VAR s : String; vcol, hcol : Byte);
VAR
  StrTemp : String;
  ActSign : Byte;
  OldWMin,
  OldWMax : Word;
  OldX,
  OldY    : Byte;


PROCEDURE IncSign (Zahl : Byte);
BEGIN
  While (Zahl>0) and (ActSign<=Length(s)) Do BEGIN inc (ActSign); dec (Zahl); END;
  GotoXY (ActSign+x-1, y);
END;


PROCEDURE DecSign (Zahl : Byte);
BEGIN
  While (Zahl>0) and (ActSign>1) Do BEGIN dec (ActSign); dec (Zahl); END;
  GotoXY (ActSign+x-1, y);
END;


BEGIN
  ActSign:= succ (Length (s));
  StrTemp:= s;
  OldWMin:= WindMin; OldWMax:= WindMax; OldX:= WhereX; OldY:= WhereY;
  Window (1, 1, 80, 25);

  REPEAT
    WriteXY (x, y, SpaceStr (s, MaxLen), vcol, hcol);
    GotoXY (ActSign+x-1, y);

    ScanBKeys;

    If (t1<>#0) and (t1<>#13) and (t1<>#27) Then
    BEGIN
      If t1=Back Then
      BEGIN If ActSign > 1 Then BEGIN DecSign (1); delete (s, ActSign, 1); END; END
      Else
      BEGIN
        If not ins Then delete (s, ActSign, 1);
        If succ (Length (s)) < MaxLen Then
        insert  (t1, s, ActSign);
        IncSign (1);
      END
    END
    Else
    CASE t2 Of
      Left  : DecSign (1);
      Right : IncSign (1);
      Entf  : delete  (s, ActSign, 1);
      Pos1  : DecSign (MaxLen);
      Endx  : IncSign (MaxLen);
      Einfg : Ins:= not Ins;
      F9    : BEGIN s[0]:= #0;   DecSign (MaxLen); END;
      F10   : BEGIN s:= StrTemp; IncSign (MaxLen); END;
    END;
  UNTIL (t1=#13) or (t1=#27);
  WindMin:= OldWMin; WindMax:= OldWMax; GotoXY (OldX, OldY);
END;

END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
