UNIT ListWin;

INTERFACE

USES
  bioscrt, Monitor, mouse, menue, keyCode, editors;



PROCEDURE ListWinInit;
PROCEDURE AssignList      (VAR List; SizeOfLine : Byte; LenOfList : Word);
PROCEDURE InsertInList    (s : String; Index : Word);
FUNCTION  GetListLine     (Index : Word) : String;
PROCEDURE SetStartEndLine (Anfang, Ende : Word);
PROCEDURE SortList;
PROCEDURE ShowList;
FUNCTION  ListIndex             : Word;
FUNCTION  BalkenY               : Word;
PROCEDURE ScrollUp        (Zahl : Word);
PROCEDURE ScrollDown      (Zahl : Word);
PROCEDURE ScrollLeft      (Zahl : Word);
PROCEDURE ScrollRight     (Zahl : Word);



CONST
  MaxListMem   = 60000;


IMPLEMENTATION

TYPE
  L = array[0..MaxListMem] Of Char;

VAR
  LineSize     : Byte; 
  ListLen      : Word;
  Liste        : ^L;
  OldFirstLine : Word;
  FirstLine    : Word;
  Line         : Word;
  Start        : Byte;
  LastLine     : Word;
  StartLine    : Word;
  CurX         : Byte;



PROCEDURE ListWinInit;
BEGIN
  OldFirstLine := 0;
  FirstLine    := 0;
  Line         := 1;
  Start        := 1;
  CurX         := 1;
  StartLine    := 1;
END; {Initialisiert das Fenster neu}



PROCEDURE AssignList (VAR List; SizeOfLine : Byte; LenOfList : Word);
BEGIN
  If SizeOfLine * LenOfList > MaxListMem Then BEGIN Liste:= NIL; Exit; END;
  Liste        := addr (List);
  LineSize     := SizeOfLine;
  ListLen      := LenOfList;
  LastLine     := LenOfList;
  ListWinInit;
END;
{Verbindet einen Speicherbereich (List : Variable beliebigen Typs) mit dem}
{Listenfenster. Zur Formatierung mu die Lnge eines Strings (SizeOfLine) und}
{die Zahl der Zeilen angegeben werden}



PROCEDURE InsertInList (s : String; Index : Word);
BEGIN
  If (Index>0) and (Index<=ListLen) Then
  Move (s, Liste^[pred (Index) * LineSize], succ (ord (s[0])));
END;


VAR
  st : String;

FUNCTION GetListLine (Index : Word) : String;
BEGIN
  If (Index>ListLen) or (Index>LastLine) or (Index=0) Then GetListLine:='' Else
  BEGIN
    Move (Liste^[pred (Index) * LineSize], st, LineSize);
    GetListLine:= st;
  END;
END;



PROCEDURE SetStartEndLine (Anfang, Ende : Word);
BEGIN
  StartLine:= Anfang;
  LastLine := Ende;
  If LastLine>ListLen Then LastLine:= ListLen;
  If StartLine<1 Then StartLine:= 1;
  FirstLine:=StartLine-1;
END;



FUNCTION ListIndex : Word; assembler;
ASM
  mov ax, FirstLine
  add ax, Line
END;



FUNCTION BalkenY : Word; assembler;
ASM
  mov ax, Line
END;


VAR  {WEGEN Stackberlauf !}
  XX, YY  : String;
  ii, jj  : Integer;

PROCEDURE SortiereListe (StartLine, EndLine : Integer);
BEGIN
  ii:= StartLine; jj:= EndLine; XX:= GetListLine ((StartLine+EndLine) DIV 2);
  REPEAT
    WHILE GetListLine (ii) < XX Do inc (ii);
    WHILE XX < GetListLine (jj) Do dec (jj);
    If ii <= jj then
    BEGIN
      YY:= GetListLine (ii);
      InsertInList (GetListLine (jj), ii);
      InsertInList (YY, jj);
      inc (ii); dec (jj);
    END;
  UNTIL ii > jj;
  If StartLine < jj Then SortiereListe (StartLine, jj);
  If ii < EndLine   Then SortiereListe (ii, EndLine);
END;



PROCEDURE SortList;
BEGIN
  If (LastLine>StartLine) and (LastLine>1) Then
  SortiereListe (StartLine, LastLine);
END;



PROCEDURE ShowList;
VAR
  x, y : Byte;
BEGIN
  MouseOff;
  x:= 0;
  For y:= Hi (WindMin)+3 To Hi (WindMax) Do
  BEGIN
    inc (x);
    WriteClrStr
   (Lo(WindMin)+4, y, copy (GetListLine (x+FirstLine), Start, Lo(WindMax)-Lo(WindMin)-5),
    Lo(WindMax)-4-Lo(WindMin), MenCol.WinT, MenCol.WinB);
  END;
  MouseOn;
  LaufBalken (Line);
END;



PROCEDURE ScrollUp (Zahl : Word);
VAR
  OldFirstLine : Word;
  OldLine      : Word;
BEGIN
  OldFirstLine:= FirstLine;
  OldLine     := Line;
  While (Zahl>0) and (FirstLine+Line>StartLine) Do
  BEGIN dec (Zahl); If Line>1 Then dec (Line) Else dec (FirstLine); END;
  If OldFirstLine<>FirstLine Then ShowList Else
  If OldLine     <>Line      Then LaufBalken (Line);
END;



PROCEDURE ScrollDown (Zahl : Word);
VAR
  OldFirstLine : Word;
  OldLine      : Word;
BEGIN
  OldFirstLine:= FirstLine;
  OldLine     := Line;
  While (Zahl>0) and (FirstLine+Line<LastLine) Do
  BEGIN
    dec (Zahl);
    If Line < Hi (WindMax) - Hi (WindMin) - 2 Then
    inc (Line) Else inc (FirstLine);
  END;
  If OldFirstLine<>FirstLine Then ShowList Else
  If OldLine     <>Line      Then LaufBalken (Line);
END;



PROCEDURE ScrollLeft (Zahl : Word);
VAR
  OldStart : Byte;
BEGIN
  OldStart:= Start;
  While (Zahl>0) and (Start>1) Do
  BEGIN dec (Zahl); dec (Start); END;
  If OldStart<>Start Then ShowList;
END;



PROCEDURE ScrollRight (Zahl : Word);
VAR
  OldStart : Byte;
BEGIN
  OldStart:= Start;
  While (Zahl>0) and (Start < LineSize) Do
  BEGIN dec (Zahl);  inc (Start); END;
  If OldStart<>Start Then ShowList;
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
