UNIT LogFile;

INTERFACE
USES
  Strings, dos, Time;


CONST
  LogStatus : Word = 2;   { mu auf 0 gesetzt werden, um LogFile zu aktivieren }

PROCEDURE AppendErr  (Txt : String);

IMPLEMENTATION

CONST
  LogFileName             = 'DOSERROR.LOG';
  LogFilePath : PathStr   = '';
  AppName     : String[8] = '';   { Name des Programmes, welches den Fehler meldet }


PROCEDURE AppendErr (Txt : String);
VAR
  f : Text;
BEGIN
  If LogStatus=2 Then Exit;
  If LogStatus=0 Then
  BEGIN
    LogFilePath:= ParamStr (0);
    dec (LogFilePath[0], 4);   { '.EXE' abschneiden }
    AppName:= GetFileName (LogFilePath);
    LogFilePath:= BuildPath (LogFilePath[1]+':\', LogFileName);
    LogStatus:= 1;
  END;
  Assign (f, LogFilePath);
  SetFAttr (f, 32);
  Append (f);
  If IOResult<>0 Then
  BEGIN Rewrite (f); If IOResult<>0 Then BEGIN LogStatus:= 2; Exit; END; END;
  WriteLn (f, AppName,    ' - ', ActDateStr (10), ' - ', ActTimeStr (8), #13#10,
              Txt, #13#10);
  If IOResult<>0 Then LogStatus:= 2;
  Close (f);
  If IOResult<>0 Then LogStatus:= 2;
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
