UNIT LStr;

INTERFACE

TYPE
  CBuf    = Array[1..65535] Of Char;
  LString = RECORD
              MaxLen : Word;
              Len    : Word;
              Chars  : ^CBuf;
            END;

PROCEDURE CreateLStr  (VAR ls : LString; MaxLength : Word);
PROCEDURE DestroyLStr (VAR ls : LString);
PROCEDURE WriteLStr   (ls : LString);
PROCEDURE WriteLStrLn (ls : LString);
PROCEDURE StrToLStr   (Quelle : String;  VAR Ziel : LString);
PROCEDURE CloneLStr   (Quelle : LString; VAR Ziel : LString);
PROCEDURE AddLStr     (Quelle : LString; VAR Ziel : LString);
PROCEDURE AddStrLStr  (Quelle : String;  VAR Ziel : LString);
PROCEDURE AddChar     (VAR Ziel : LString; Zeichen : Char);
PROCEDURE UpLStr      (Quelle : LString; VAR Ziel : LString);
PROCEDURE LowLStr     (Quelle : LString; VAR Ziel : LString);
PROCEDURE TrimLStr    (VAR InOut : LString);
PROCEDURE RightLStr   (Quelle : LString; VAR Ziel : LString; Count : Word);
PROCEDURE CopyLStr    (Quelle : LString; VAR Ziel : LString; Index, Count : Word);
FUNCTION  CopyStrLStr (Quelle : LString; Index : Word; Count : Word) : String;
PROCEDURE DeleteLStr  (VAR InOut : LString; Index, Count : Word);
FUNCTION  InLStr      (Start : Word; QuellStr : LString; SuchStr : String) : Word;
PROCEDURE InsertLStr  (Quelle : String; VAR Ziel : LString; Index : Word);
PROCEDURE ReplaceAllLStr  (VAR InOut : LString; SeekStr, NewStr : String);
FUNCTION  CountFieldsLstr (OrigStr : LString; Separator : Char) : Byte;
FUNCTION  nthFieldLStr    (OrigStr : LString; Separator : Char; n : Word) : String;

PROCEDURE ReadBin         (VAR f : File; VAR Ziel : LString);
PROCEDURE WriteBin        (VAR f : File; Quelle   : LString);
PROCEDURE ReadLongLine    (VAR f : Text; VAR s : LString);
PROCEDURE WriteLongLine   (VAR f : Text;     s : LString);

PROCEDURE ReadLongLineChk (VAR f : Text; VAR s : LString; VAR LastLine : Boolean);
PROCEDURE WriteLongStr    (VAR f : Text;     s : LString);
 
IMPLEMENTATION


PROCEDURE CreateLStr (VAR ls : LString; MaxLength : Word);
BEGIN
  With ls Do
  BEGIN
    Len:= 0;
    If MaxLength > MaxAvail Then MaxLength:= MaxAvail;
    MaxLen:= MaxLength;
    If MaxLength <> 0 Then GetMem (Chars, MaxLength);
  END;
END;


PROCEDURE DestroyLStr (VAR ls : LString);
BEGIN
  With ls Do
  BEGIN
    If MaxLen<>0 Then FreeMem (Chars, MaxLen);
    Maxlen:= 0; Len:= 0;
  END;
END;


PROCEDURE WriteLStr (ls : LString);
VAR
  x : Word;
BEGIN
  With ls Do
  For x:= 1 To Len Do Write (Chars^[x]);
END;


PROCEDURE WriteLStrLn (ls : LString);
BEGIN
  WriteLStr (ls); WriteLn;
END;


PROCEDURE StrToLStr (Quelle : String; VAR Ziel : LString); assembler;
ASM
  les  di, Ziel; mov cx, es:[di]; jcxz @ende; add di, 2
  push ds
  cld
  lds  si, Quelle; lodsb; xor ah, ah
  xchg cx, ax     { ax=max.Lnge von Ziel, cx= Lnge von Quelle }
  cmp  cx, ax
  jbe  @weiter
    mov cx, ax
  @weiter:
  mov  ax, cx
  stosw
  les  di, dword ptr es:[di]
  mov  cx, ax
  rep  movsb
  pop  ds
  @ende:
END;
{ kopiert einen String in einen LString }


PROCEDURE CloneLStr (Quelle : LString; VAR Ziel : LString); assembler;
ASM
  les  di, Ziel; mov cx, es:[di]; jcxz @ende; add di, 2;
  push ds
  cld
  lds  si, Quelle; add si, 2; lodsw;
  xchg cx, ax     { ax=max.Lnge von Ziel, cx= Lnge von Quelle }
  cmp  cx, ax
  jbe  @weiter
    mov cx, ax
  @weiter:
  mov  ax, cx
  stosw
  les  di, dword ptr es:[di]
  lds  si, dword ptr    [si]
  push cx
  shr  cx, 1
  rep  movsw
  pop  cx
  and  cx, 1
  rep  movsb 
  pop  ds
  @ende:
END;
{ kopiert den LString "Quelle" in den LString "Ziel" }


PROCEDURE AddLStr (Quelle : LString; VAR Ziel : LString); assembler;
ASM
  les  di, Ziel; mov bx, es:[di]; or bx, bx; jz @ende; add di, 2
  push ds
  cld
  lds  si, Quelle; add si, 2; lodsw;
  mov  cx, ax       { ax, cx = Lnge des anzuhngenden Strings }
  jcxz @raus
  mov  dx, es:[di]  { dx = momentane Lnge von "Ziel" }
  add  ax, dx       { ax     = resultierende Lnge nach Anhngen von "Quelle"}
  jnc  @notOF       { jmp, wenn ax+dx <= 65535 }
    mov ax, 65535   { ansonsten Register-berlauf korrigieren }
    sub ax, dx
    mov cx, ax
  @notOF:
  cmp  ax, bx
  jbe  @weiter
    mov ax, bx
    mov cx, ax
    sub cx, dx
  @weiter:
  stosW
  les  di, dword ptr es:[di]
  lds  si, dword ptr    [si]
  add  di, dx
  mov  dx, cx
  rep  movsb
  @raus:
  pop  ds
  @ende:
END;
{ hngt den LString "Quelle" an den LString "Ziel" an.
  Quelle und Ziel drfen identisch sein. }


PROCEDURE AddStrLStr (Quelle : String; VAR Ziel : LString); assembler;
ASM
  les  di, Ziel; mov bx, es:[di]; or bx, bx; jz @ende; add di, 2
  push ds
  cld
  lds  si, Quelle; lodsb; xor ah, ah
  mov  cx, ax       { ax, cx = Lnge des anzuhngenden Strings }
  jcxz @raus
  mov  dx, es:[di]  { dx = momentane Lnge von "Ziel" }
  add  ax, dx       { ax     = resultierende Lnge nach Anhngen von "Quelle"}
  jnc  @notOF       { jmp, wenn ax+dx <= 65535 }
    mov ax, 65535   { ansonsten Register-berlauf korrigieren }
    sub ax, dx
    mov cx, ax
  @notOF:
  cmp  ax, bx
  jbe  @weiter
    mov ax, bx
    mov cx, ax
    sub cx, dx
  @weiter:
  stosW
  les  di, dword ptr es:[di]
  add  di, dx
  mov  dx, cx
  rep  movsb
  @raus:
  pop  ds
  @ende:
END;
{ hngt den String "Quelle" an den LString "Ziel" an.
  Quelle und Ziel drfen (und knnen) NICHT identisch sein. }

PROCEDURE AddChar (VAR Ziel : LString; Zeichen : Char); assembler;
ASM
  les di, Ziel; mov cx, es:[di]; jcxz @ende; add di, 2
  cld
  mov ax, es:[di]
  cmp ax, cx
  jae @ende
  inc ax
  stosW
  les di, dword ptr es:[di]
  dec ax
  add di, ax
  mov al, Zeichen
  Stosb
  @ende:
END;
{ hngt ein einzelnes Zeichen an das Ende des LStrings "Ziel"  an }


PROCEDURE UpLStr (Quelle : LString; VAR Ziel : LString); assembler;
ASM
  les  di, Ziel; mov cx, es:[di]; jcxz @ende; add di, 2
  push ds
  cld
  lds  si, Quelle; add si, 2; lodsw;
  xchg cx, ax     { ax=max.Lnge von Ziel, cx= Lnge von Quelle }
  cmp  cx, ax
  jbe  @weiter
    mov cx, ax
  @weiter:
  mov  ax, cx
  stosw
  jcxz @raus
  les  di, dword ptr es:[di]
  lds  si, dword ptr    [si]
  @start:
    lodsb
    cmp al, 'a'; jb  @1
    cmp al, 'z'; ja  @a
    sub al, 32; stosb; loop @Start; jmp @raus
    @a: cmp al, ''; jne @b; mov al, '';     stosb; loop @start; jmp @raus
    @b: cmp al, ''; jne @c; mov al, '';     stosb; loop @start; jmp @raus
    @c: cmp al, ''; jne @1; mov al, ''; @1: stosb; loop @start;
  @raus:
  pop  ds
  @ende:
END;
{ Verwandelt alle Zeichen eines Strings in Grobuchstaben
  Quelle und Ziel drfen identisch sein }


PROCEDURE LowLStr (Quelle : LString; VAR Ziel : LString); assembler;
ASM
  les  di, Ziel; mov cx, es:[di]; jcxz @ende; add di, 2
  push ds
  cld
  lds  si, Quelle; add si, 2; lodsw;
  xchg cx, ax     { ax=max.Lnge von Ziel, cx= Lnge von Quelle }
  cmp  cx, ax
  jbe  @weiter
    mov cx, ax
  @weiter:
  mov  ax, cx
  stosw
  jcxz @raus
  les  di, dword ptr es:[di]
  lds  si, dword ptr    [si]
  @start:
    lodsb
    cmp al, 'A'; jb  @1
    cmp al, 'Z'; ja  @a
    add al,  32; stosb; loop @start; jmp @raus
    @a: cmp al, ''; jne @b; mov al, '';     stosb; loop @start; jmp @raus
    @b: cmp al, ''; jne @c; mov al, '';     stosb; loop @start; jmp @raus
    @c: cmp al, ''; jne @1; mov al, ''; @1: stosb; loop @start
  @raus:
  pop  ds
  @ende:
END;
{ Verwandelt alle Zeichen eines LStrings in Kleinbuchstaben
  Quelle und Ziel drfen identisch sein }


PROCEDURE TrimLStr (VAR InOut : LString); assembler;
ASM
  les  di, InOut; mov cx, es:[di+2]; jcxz @ende
  push ds
  les  di, dword ptr es:[di+4]
  push di
  add  di, cx
  dec  di
  mov  al, 32
  std
  repe scasb
  cld
  pop  di
  je   @raus
  mov  si, di
  inc  cx
  repe scasb
  je   @raus
  push es; pop ds; dec di; xchg di, si
  inc  cx
  push cx
  rep  movsb
  pop  cx
  @raus:
  les  di, InOut
  mov  es:[di+2], cx
  pop  ds
  @ende:
END;
{ Lscht alle Leerzeichen am Anfang und Ende des LStrings }


PROCEDURE RightLStr (Quelle : LString; VAR Ziel : LString; Count : Word); assembler;
ASM
  les  di, Ziel; mov bx, es:[di]; or bx, bx; jz @ende; add di, 2
  push ds
  cld
  mov  cx, count
  cmp  cx, bx
  jbe  @weiter1
    mov cx, bx
  @weiter1:
  lds  si, Quelle; add si, 2; lodsw
  cmp  cx, ax
  jbe  @weiter2
    mov cx, ax
  @weiter2:
  sub  ax, cx
  mov  bx, ax
  mov  ax, cx
  stosw
  les  di, dword ptr es:[di]
  lds  si, dword ptr    [si]
  add  si, bx
  rep  movsb
  pop  ds
  @ende:
END;
{ kopiert "Count" Zeichen vom Ende der "Quelle" in den "Ziel"-LString
  Quelle und Ziel drfen identisch sein }


PROCEDURE CopyLStr (Quelle : LString; VAR Ziel : LString; Index, Count : Word); assembler;
ASM
  les  di, Ziel; mov dx, es:[di]; or dx, dx; jz @weg; add di, 2
  push ds
  cld
  lds  si, Quelle; add si, 2; lodsw; or ax, ax; jz @ende
  mov  bx, Index; or bx, bx; jnz @los; inc bx; @los:
  cmp  ax, bx
  jae  @weiter; @raus: xor ax, ax; jmp @ende; @weiter:
  mov  cx, Count; jcxz @raus
  dec  bx
  sub  ax, bx
  cmp  cx, ax; jbe @weiter1; mov cx, ax; @weiter1:
  cmp  cx, dx; jbe @weiter2; mov cx, dx; @weiter2:
  mov  ax, cx
  stosw

  les  di, dword ptr es:[di]
  lds  si, dword ptr    [si]
  add  si, bx
  rep  movsb

  jmp  @popds
  @ende:
  stosw
  @popds:
  pop  ds
  @weg:
END;
{ wie Pascal-"copy", der kopierte LString befindet sich in "Ziel".
  Quelle und Ziel drfen identisch sein }


FUNCTION CopyStrLStr (Quelle : LString; Index : Word; Count : Word) : String; assembler;
ASM
  push ds
  cld
  les  di, @Result
  mov  cx, Count; jcxz @raus
  or   ch, ch
  jz   @okay
    mov cx, 255  { da der Ausgabe-String nur 255 Zeichen aufnehmen kann }
  @okay:

  lds  si, Quelle; add si, 2; lodsw; or ax, ax; jz @ende
  mov  bx, Index; or bx, bx; jnz @los; inc bx; @los:
  cmp  ax, bx  { Quelle.Len >= Index ? }
  jae  @weiter; @raus: xor ax, ax; jmp @ende; @weiter:

  dec  bx
  sub  ax, bx
  cmp  cx, ax; jbe @weiter1; mov cx, ax; @weiter1:
  mov  al, cl
  stosb

  lds  si, dword ptr [si]
  add  si, bx
  rep  movsb

  jmp  @popds
  @ende:
  stosb
  @popds:
  pop  ds
END;
{ wie Pascal-"copy", nur da "Quelle" ein LString ist. }


PROCEDURE DeleteLStr (VAR InOut : LString; Index, Count : Word); assembler;
ASM
  les  di, InOut; mov cx, es:[di]; jcxz @weg; add di, 2
  push ds
  cld
  lds  si, InOut; add si, 2; LodsW; or ax, ax; jz @ende
  mov  bx, Index; or bx, bx; jnz @los; inc bx; @los:
  cmp  ax, bx
  jb   @ende
  mov  dx, Count; or dx, dx; jz @ende
  cmp  dx, ax; jbe @w1; mov dx, ax; @w1:

  mov  cx, bx   { Index in CX }
  dec  bx
  add  cx, dx   { Count dazu addieren }
  cmp  ax, cx   { Sollen Zeichen ber das LString-Ende hinaus gelscht werden? }
  jae  @weiter
    mov ax, bx
    stosw
    jmp @ende
  @weiter:
  sub  ax, dx   { resultierende Stringlnge in AX }
  stosw

  les  di, dword ptr es:[di]
  lds  si, dword ptr    [si]

  add  di, bx
  add  si, bx
  add  si, dx   { Leseposition okay }

  mov  cx, ax
  sub  cx, bx   { Zahl der nach vorn zu kopierenden Zeichen okay }
  rep  movsb

  @ende:
  pop  ds
  @weg:
END;
{ wie Pascal-"delete" }



FUNCTION InLStr (Start : Word; QuellStr : LString; SuchStr : String) : Word; assembler;
ASM
  push ds
  cld
  lds  si, SuchStr;  lodsw; or  al, al; jz   @raus
  les  di, QuellStr; mov cx, es:[di+2]; jcxz @raus { Lnge Quelle}

  mov  dx, Start; or dx, dx; jz @w1; dec dx; @w1:
  mov  bl, al; xor bh, bh
  add  dx, bx 
  jc   @raus       { wenn Start+Length(SuchStr) > 65535 }
  cmp  dx, cx      { Start+Length(SuchStr) > Stringlnge? }
  ja   @raus
  inc  dx
  sub  dx, bx
  sub  cx, dx
  inc  cx
  dec  al          { eins runter, da das erste Zeichen nicht von CMPSB
                     gesucht zu werden braucht (macht scasb) }
  xchg al, ah      { Lnge SuchStr in AH, erstes Zeichen in AL }

  les  di, dword ptr es:[di+4]
  add  di, dx
  dec  di          { Zeiger auf erstes Zeichen des zu durchsuchenden Strings }

  mov  bx, cx

  @nochmal:
  repne scasb
  jne   @raus      { nichts gefunden }
    push cx
    push si
    push di
    mov  cl, ah
    xor  ch, ch
    repe cmpsb
    pop  di
    pop  si
    pop  cx
    jne  @nochmal
    sub  bx, cx
    mov  ax, bx
    add  ax, dx
    dec  ax
    jmp  @gefunden
  @raus:
  xor  ax, ax
  @gefunden:
  pop  ds
END;
{ wie Pascal-"pos", gesucht wird jedoch ab Position "Start". Die ermittelte
  Position bezieht sich jedoch auf den gesamten LString }


PROCEDURE insertLStr (Quelle : String; VAR Ziel : LString; Index : Word); assembler;
ASM
  push ds                 
  les  di, Ziel; mov dx, es:[di]; or dx, dx; jz @raus  { dx = Ziel.MaxLen }
  add  di, 2
  mov  ax, index; or ax, ax; jnz @noinc; inc ax; @noinc:
  mov  bx, es:[di]        { bx = Ziel.Len }
  cmp  ax, bx             { ax = Index }
  jbe  @weiter
    mov ax, bx
    inc ax                { wenn Index = 65535 war, dann ist er jetzt 0 }
    or  ax, ax            { selbiges prfen }
    jz  @raus
    cmp ax, dx            { If Index > Ziel.MaxLen Then Goto @raus }
    ja  @raus
  @weiter:
  mov  cx, dx
  sub  cx, ax
  inc  cx

  push ax
  mov  ax, cx            { MaxIns:= Ziel.MaxLen-Index+1 }
  lds  si, Quelle; mov cl, [si]; xor ch, ch    { cx = Length(Quelle) = Count }
  cmp  cx, ax; jbe @1; mov cx, ax; @1:
  pop  ax
  jcxz @raus             { If Count=0 Then Goto Raus }

  push ax
  mov  ax, bx            { ax = Ziel.Len }
  add  ax, cx            { ax = ax+Count }
  jnc  @2; mov ax, 65535; @2:
  cmp  ax, dx            { resultierende Lnge (=ax) > Ziel.MaxLen (=dx) ? }
  jbe  @3; mov ax, dx; @3:
  mov  es:[di], ax
  pop  ax                { ax wieder Index }

  mov  si, ax
  add  si, cx            { si = LastIns = Index+Count }
  jc   @HangOn           { wenn Additionsberlauf }
  cmp  si, es:[di]       { cmp si, ResLen }
  ja   @HangOn
  cmp  ax, bx
  ja   @HangOn           { If Index > Ziel.Len Then Goto HangOn }

  push cx                { Count speichern }
  xchg cx, bx            { bis hier wird bx gebraucht, enthlt jetzt Count }
  sub  cx, ax
  inc  cx                { cx = Ziel.Len-Index+1 }

  sub  dx, si            { bis hier wird dx gebraucht }
  inc  dx                { di:= Ziel.MaxLen-LastIns+1 }
  cmp  cx, dx
  jbe  @4; mov cx, dx; @4:

  mov  si, es:[di]       { resultierende Lnge }
  les  di, dword ptr es:[di+2]; push es; pop ds
  add  di, si
  dec  di
  mov  si, di
  sub  si, bx            { di = ResLen; si = ResLen-Count }

  std
  rep  movsb
  pop  cx                { cx = Count }

  les  di, Ziel; add di, 2
  @HangOn:
    cld
    les di, dword ptr es:[di+2]
    add di, ax
    dec di                 { di = Index }
    lds si, Quelle; inc si
    rep movsb
  @raus:
  pop ds
END;


PROCEDURE ReplaceAllLStr (VAR InOut : LString; SeekStr, NewStr : String);
VAR
  x : Word;
BEGIN
  If (SeekStr<>'') and (SeekStr<>NewStr) Then
  BEGIN
    x:= InLStr (1, InOut, SeekStr);

    If Length (NewStr)=Length (SeekStr) Then  { Fast sofort fertig }
    While x<>0 Do
    BEGIN
      move (NewStr[1], InOut.Chars^[x], Length (NewStr));
      x:= InLStr (x+Length (NewStr), InOut, SeekStr);
    END
    Else

    If Length (NewStr)=0 Then
    BEGIN
      DeleteLStr (InOut, x, Length (SeekStr));
      x:= InLStr (x, InOut, SeekStr);
    END
    Else

    If Length (NewStr)<Length (SeekStr) Then
    While x<>0 Do
    BEGIN
      DeleteLStr (InOut, x+Length(NewStr)-1, Length (SeekStr)-Length (NewStr));
      move (NewStr[1], InOut.Chars^[x], Length (NewStr));
      x:= InLStr (x+Length (NewStr), InOut, SeekStr);
    END
    Else

    While x<>0 Do
    BEGIN
      InsertLStr (copy (NewStr, Length(SeekStr)+1, 255), InOut, x+Length(SeekStr));
      move (NewStr[1], InOut.Chars^[x], Length (SeekStr));
      x:= InLStr (x+Length (NewStr), InOut, SeekStr);
    END;

  END;
END;


FUNCTION CountFieldsLstr (OrigStr : LString; Separator : Char) : Byte; assembler;
ASM
  xor bx, bx
  cld
  les di, OrigStr
  mov cx, es:[di+2]; jcxz @raus
  les di, dword ptr es:[di+4]
  mov al, Separator
  @nochmal:
    repne scasb
    jne @raus
    inc bx
  jmp @nochmal
  @raus:
  mov ax, bx
  inc ax
END;
{ ermittelt die Anzahl der durch das "Separator"-Zeichen voneinander
  getrennten Teile des "OrigStr". Wird als "Separator" z.B. ein
  Leerzeichen angegeben, ermittelt "CountFields" die Zahl der Wrter in
  einem LString - wird ; oder #9 (Tabulator) angegeben, kann die Zahl der
  Datenfelder in einem CSV-String ermittelt werden. }


FUNCTION nthFieldLStr (OrigStr : LString; Separator : Char; n : Word) : String; assembler;
ASM
  push ds
  cld
  xor  dl, dl { Zhler fr die Stringlnge des Funktionsergebnisses }
  les  di, @Result; push di; inc di

  lds  si, OrigStr;
  mov  cx, [si+2]; jcxz @ende
  lds  si, dword ptr [si+4]

  mov  bx, 1  { Vergleichs-Wert zu "n" }
  mov  ah, Separator
  @next:
    lodsb
    cmp al, ah
    je  @incBX
    cmp bx, n
    je  @storeAL
  loop @next
  jmp @ende
  @storeAL:
    stosb
    inc dl
    cmp dl, 255
    jae @ende
  loop @next
  jmp @ende
  @incBX:
    cmp bx, n
    je  @ende
    inc bx
  loop @next
  @ende:
  pop  di
  mov  al, dl
  stosb
  pop  ds
END;
{ liefert das "n"-te durch den "Separator" abgetrennte Feld zurck. Wird
  z.B. als "Separator" ein Leerzeichen angegeben, kann ein Satz in seine
  einzelnen Wrter zerlegt werden, wird ein ; oder #9 (Tabulator) angegeben,
  kann ein CSV-String in seine einzelnen Felder zerlegt werden. Existiert
  das "n"-te Feld nicht, wird ein Leerstring zurckgegeben.

  Weiteres Anwendungsgebiet: Zerlegen eines Pfadnamens in die einzelnen
  Verzeichnisebenen ('\' als "Separator" angeben).
}


PROCEDURE ReadBin (VAR f : File; VAR Ziel : LString);
BEGIN
  With Ziel Do
  BlockRead (f, Chars^, MaxLen, Len);
END;


PROCEDURE WriteBin (VAR f : File; Quelle : LString);
VAR
  Dummy : Word;
BEGIN
  With Quelle Do
  BlockWrite (f, Chars^, Len, Dummy);
END;


PROCEDURE ReadLongLine (VAR f : Text; VAR s : LString);
VAR
  tmp : String;
BEGIN
  s.Len:= 0;
  While (not Eof(f)) and (not EoLn(f)) Do
  BEGIN
    Read (f, tmp);
    AddStrLStr (tmp, s);
    If InOutRes<>0 Then Exit;
    If s.Len >= s.MaxLen Then BEGIN InOutRes:= 255; Exit; END;
  END;
  If not Eof (f) Then ReadLn (f);
END;


PROCEDURE WriteLongLine (VAR f : Text; s : LString);
VAR
  tmp : String;
  p1  : Word;
BEGIN
  p1:= 1;
  REPEAT
    tmp:= copyStrLStr (s, p1, 255);
    If Length (tmp)<>0 Then
    BEGIN inc (p1, Length (tmp)); Write (f, tmp); END;
  UNTIL Length (tmp)=0;
  WriteLn (f);
END;


PROCEDURE ReadLongLineChk (VAR f : Text; VAR s : LString; VAR LastLine : Boolean);
VAR
  tmp : String;
BEGIN
  s.Len:= 0;
  While (not Eof(f)) and (not EoLn(f)) Do
  BEGIN
    Read (f, tmp);
    AddStrLStr (tmp, s);
    If InOutRes<>0 Then Exit;
    If s.Len >= s.MaxLen Then BEGIN InOutRes:= 255; Exit; END;
  END;
  LastLine:=Eof(f);
  If not LastLine Then ReadLn (f);
END;
(* Meldet in LastLine, ob letzte Zeile (ohne Vorschub) erreicht (fr ESI.PAS) *)


PROCEDURE WriteLongStr (VAR f : Text; s : LString);
VAR
  tmp : String;
  p1  : Word;
BEGIN
  p1:= 1;
  REPEAT
    tmp:= copyStrLStr (s, p1, 255);
    If Length (tmp)<>0 Then
    BEGIN inc (p1, Length (tmp)); Write (f, tmp); END;
  UNTIL Length (tmp)=0;
END;
(* entspricht "Write", also ohne CR am Ende *)


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
