UNIT LStream;

{ *** Beispielcode am Ende *** }

INTERFACE

CONST
  BufSize = 2048; { mindestens 256 !!! (=SizeOf(String), 1 mehr fr #13) }

TYPE
  TStreamBuf = RECORD
    Len  : Word;
    Data : Array[1..BufSize] Of Char;
  END;

  TLineStream = OBJECT
    PROCEDURE Init (Save : Boolean);
    PROCEDURE ReInit;
    PROCEDURE WriteLine (s : String);
    FUNCTION  ReadLine    : String;
    FUNCTION  EoF         : Boolean;

    PRIVATE

    Buffers     : Array[0..1] Of TStreamBuf;

    ReadPtr     : Word;    { Lesezeiger im Puffer }
    ReadBuf     : Byte;    { gibt an, welcher der beiden Puffer der Lesepuffer ist }
    WriteBuf    : Byte;    { gibt an, welcher der beiden Puffer der Schreibpuffer ist }

    ReadBlockNr : LongInt; { laufende Nummer des zuletzt gelesenen Blocks }
    WriteBlockNr: LongInt; { laufende Nummer des zuletzt geschriebenen Blocks }

    ReadFPos    : LongInt; { Leseposition in Datei }
    WriteFPos   : LongInt; { Schreibposition in Datei }

    FileExist   : Boolean;
    SaveAll     : Boolean; { auch gepufferte Blcke schreiben }
    f           : File;

    PROCEDURE WriteBlock;
    PROCEDURE ReadBlock;
    FUNCTION  NextEofLine : Word;
  END;


IMPLEMENTATION


PROCEDURE TLineStream.Init (Save : Boolean);
BEGIN
  Buffers[0].Len:= 0;
  Buffers[1].Len:= 0;

  ReadPtr := 0;

  ReadBuf := 0;
  WriteBuf:= 0;

  ReadBlockNr := 0;
  WriteBlockNr:= 0;

  ReadFPos := 0;
  WriteFPos:= 0;

  SaveAll  := Save;
  FileExist:= FALSE;
END;


PROCEDURE TLineStream.ReInit;
BEGIN
  If FileExist Then BEGIN Close(f); Erase(f); END;
  Init (SaveAll);
END;


PROCEDURE TLineStream.WriteBlock;
BEGIN
  If not FileExist Then
  BEGIN
    Assign  (f, 'test.tmp');
    Rewrite (f, 1);
    FileExist:= TRUE;
  END Else
  Seek (f, WriteFPos);

  BlockWrite (f, Buffers[WriteBuf], SizeOf(TStreamBuf));
  WriteFPos:= FilePos(f);
END;


PROCEDURE TLineStream.WriteLine (s : String);
BEGIN
  If Buffers[WriteBuf].Len+Length(s)+1>=BufSize Then
  BEGIN
    If WriteBuf=ReadBuf Then
    BEGIN
      If SaveAll Then BEGIN WriteBlock; ReadFPos:= WriteFPos; END;
      If WriteBuf=0 Then WriteBuf:= 1 Else WriteBuf:= 0;
    END
    Else WriteBlock;

    inc (WriteBlockNr);
    Buffers[WriteBuf].Len:= 0;
  END;
  { Nicht in folgenden "With"-Block setzen, falls Flush den Puffer tauscht }

  With Buffers[WriteBuf] Do
  BEGIN
    Move (s[1], Data[Len+1], Length(s));
    inc (Len, Length(s)+1); { +1 fr Anhngen von #13 }
    Data[Len]:=#13;
  END;
END;


PROCEDURE TLineStream.ReadBlock;
BEGIN
  inc (ReadBlockNr);
  Buffers[ReadBuf].Len:= 0;
  ReadPtr:= 0;

  If ReadBlockNr=WriteBlockNr Then
  BEGIN
    ReadBuf:= WriteBuf;
    If not SaveAll Then BEGIN WriteFPos:= 0; ReadFPos:= 0; END;
  END
  Else
  BEGIN
    Seek (f, ReadFPos);
    BlockRead (f, Buffers[ReadBuf], SizeOf(TStreamBuf));
    ReadFPos:= FilePos (f);
  END;
END;


FUNCTION TLineStream.NextEofLine : Word;
VAR
  x : Word;
BEGIN
  With Buffers[ReadBuf] Do
  BEGIN
    For x:= ReadPtr+1 To Len Do
    If Data[x]=#13 Then
    BEGIN
      NextEofLine:= x;
      Exit;
    END;
    NextEofLine:= 0;  { keine weiteren Zeilen }
  END;
END;


FUNCTION TLineStream.ReadLine : String;
VAR
  LineEnd : Word;
  LineLen : Byte;
  s       : String;

BEGIN
  LineEnd:= NextEofLine;
  If (LineEnd=0) and not EoF Then
  BEGIN
    ReadBlock;
    LineEnd:= NextEofLine;
  END;

  If LineEnd>0 Then
  BEGIN
    LineLen:= LineEnd-ReadPtr-1;
    Move (Buffers[ReadBuf].Data[ReadPtr+1], s[1], LineLen);
    s[0]:= chr(LineLen);
    ReadPtr := LineEnd;
    ReadLine:= s;
  END
  Else ReadLine:= '';  (* Eof *)
END;


FUNCTION TLineStream.EoF : Boolean;
BEGIN
  EoF:= (ReadBuf=WriteBuf) and (ReadPtr>=Buffers[ReadBuf].Len);
END;


{-------------------------------- Beispiel ------------------------------

PROGRAM Test;
USES
  Strings, LStream;
VAR
  vf : TLineStream;
  x  : Byte;
BEGIN
  vf.Init (false);
  For x:= 1 To 22 Do vf.WriteLine (StrVal(x));
  While not vf.EoF Do WriteLn (vf.ReadLine);
  vf.ReInit;
  ReadLn;
END.

}

END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
