UNIT Masken;

INTERFACE

USES
  BiosCRT, Dos, keycode, strings, monitor, LogFile;


VAR
  ee : Byte;


CONST
  EingabeHilfe = #24#25' = Eingabefeld whlen     Leer/TAB = Option setzen/entfernen     Esc = Beenden';
  UWin         = 21;
  ULine        = UWin+1;
  UText        = UWin+2;
  ErrCode      : Word = 0;


PROCEDURE ParamField   (y   : Byte; VAR Param : Boolean; Zeile : PathStr);
PROCEDURE EditStr      (y   : Byte; VAR s : String;        Txt : PathStr);

PROCEDURE Linie;
PROCEDURE StandardKopf (Titel, Txt : String);
PROCEDURE Fusszeile    (Txt        : String);

PROCEDURE ErrorHalt    (Txt : String);
PROCEDURE ErrorEnd     (Txt : String);
PROCEDURE ErrorMsg     (Txt : String);
PROCEDURE SimpleHalt   (Txt : String);
PROCEDURE UserAbort;

PROCEDURE ErrorHaltLog (Txt : String);
PROCEDURE ErrorEndLog  (Txt : String);
PROCEDURE ErrorMsgLog  (Txt : String);
PROCEDURE SimpleHaltLog(Txt : String);
PROCEDURE UserAbortLog;

PROCEDURE Tastenabfrage(Txt : String; k1, k2 : Char);
PROCEDURE GotoOldPos;

PROCEDURE BlindStop;
PROCEDURE ScanBKeys;
PROCEDURE UpScanBKeys;
PROCEDURE WaitBKey;
FUNCTION  ReadBKey   : Char;
FUNCTION  UpReadBKey : Char;


IMPLEMENTATION

CONST
  ins       : Boolean = TRUE;
  FirstLine : Byte    = 0;

VAR
  OldX, OldY : Byte;



FUNCTION EmptyLine (y : Byte) : Boolean;
VAR
  s : String[81];
BEGIN
  s:= Trim(GetScreenLine (1, 80, y));
  EmptyLine:= (s='') or (s[1]='') or (s[1]=#$B0) or (s[1]=#178) or
  (pos ('--------', s)<>0);
END;


PROCEDURE ScanBKeys;
VAR
  y, OldWindMin : Word;
  OldY, OldX    : Word;
LABEL
  Ende, GoUp, GoDn, Check;

BEGIN
  CursorOn;
  ScanKeys;
  If (t1=#0) and (Keystatus and (LShift or Caps)<>0) Then
  BEGIN
    OldY:= WhereY; OldX:= WhereX; 
    OldWindMin:= WindMin; WindMin:= 0; y:= WhereY;
    If t1=#0 Then Goto Check;
    While (Keystatus and (LShift or Caps)<>0) Do
    BEGIN
      GotoXY (1, y);
      ScanKeys;
      Check:
      If t1=#0 Then
      CASE t2 Of
        Up   : BEGIN
                 GoUp:
                 If y>1 Then
                 REPEAT dec (y); UNTIL (y<=1) or (not EmptyLine(y));
                 If (EmptyLine(y)) and (t2<>Down) Then Goto GoDn;
               END;
        Down : BEGIN
                 GoDn:
                 If y<25 Then
                 REPEAT inc (y); UNTIL (y>=25) or (not EmptyLine(y));
                 If (EmptyLine(y)) and (t2<>Up) Then Goto GoUp;
               END;
        Pos1 : BEGIN y:= 1;  If EmptyLine(y) Then Goto GoDn; END;
        Endx : BEGIN y:= 25; If EmptyLine(y) Then Goto GoUp; END;
        Else   Goto Ende;
      END Else Goto Ende;
    END;
    Ende:
    WindMin:= OldWindMin;
    GotoXY (OldX, OldY);
  END;
END;


PROCEDURE UpScanBKeys;
BEGIN
  ScanBKeys; t1:= UpChar (t1);
END;


PROCEDURE WaitBKey;
BEGIN
  ScanBKeys; t1:= #0; t2:= #0;
END;


FUNCTION ReadBKey : Char;
BEGIN
  ScanBKeys; ReadBKey:= t1; t2:= #0;
END;


FUNCTION UpReadBKey : Char;
BEGIN
  UpReadBKey:= UpChar (ReadBKey);
END;


PROCEDURE BlindStop;
BEGIN
  If (Keystatus and (LShift or Caps)<>0) Then ScanBKeys;
END;


PROCEDURE ParamLine (y : Byte; Param : Boolean; Zeile : PathStr);
BEGIN
  GotoXY (1, y);
  If Param Then OutStr ('[x]   ') Else OutStr ('[ ]   ');
  OutStr (Zeile); GotoXY (2, y);
END;


PROCEDURE ParamField (y : Byte; VAR Param : Boolean; Zeile : PathStr);
BEGIN
  ParamLine (y, Param, Zeile); If ee=1 Then Exit;
  REPEAT
    ScanBKeys;
    If (t1=TAB) or (t1=' ') Then BEGIN Param:= not Param; ParamLine (y, Param, Zeile); END Else
    If t1=#27 Then UserAbort;
  UNTIL (t1=#13) or (t2=Up) or (t2=Down);
END;



PROCEDURE EditStr (y : Byte; VAR s : String; Txt : PathStr);
VAR
  StrTemp : String;
  ActSign : Byte;

PROCEDURE IncSign (Zahl : Byte);
BEGIN
  While (Zahl>0) and (ActSign<=Length(s)) Do BEGIN inc (ActSign); dec (Zahl); END;
  GotoXY (ActSign, y);
END;


PROCEDURE DecSign (Zahl : Byte);
BEGIN
  While (Zahl>0) and (ActSign>1) Do BEGIN dec (ActSign); dec (Zahl); END;
  GotoXY (ActSign, y);
END;


BEGIN
  GotoXY (1, y); OutStr (Txt); inc (y, 2);
  ActSign:= succ (Length (s));
  StrTemp:= s;

  REPEAT
    CursorOff;
    GotoXY (1, y); OutStr (s); ClrEol; GotoXY (ActSign, y);
    CursorOn;
    If ee = 1 Then Exit;

    ScanBKeys; If t1=#27 Then UserAbort;

    If (t1<>#0) and (t1<>#13) Then
    BEGIN
      If t1=Back Then
      BEGIN If ActSign > 1 Then BEGIN DecSign (1); delete (s, ActSign, 1); END; END
      Else
      BEGIN
        If not ins Then delete (s, ActSign, 1);
        If succ (Length (s)) < 79 Then
        insert  (t1, s, ActSign);
        IncSign (1);
      END
    END
    Else
    CASE t2 Of
      Left  : DecSign (1);
      Right : IncSign (1);
      Entf  : delete  (s, ActSign, 1);
      Pos1  : DecSign (80);
      Endx  : IncSign (80);
      Einfg : Ins:= not Ins;
      F9    : BEGIN s[0]:= #0;   DecSign (80); END;
      F10   : BEGIN s:= StrTemp; IncSign (80); END;
    END;
  UNTIL (t1=#13) or (t2=Up) or (t2=Down);
END;



PROCEDURE Linie; assembler;
ASM
  mov  cx, 80
  @start:
  mov  ax, 0EC4h
  int  10h
  loop @Start
END;



PROCEDURE StandardKopf (Titel, Txt : String);
BEGIN
  TextAttr:= 7;
  Window (1, 1, 80, 25);
  ClrScr;
  OutStr (Titel);
  GotoXY (81 - Length (txt), 1);
  OutStr (Txt);
  Linie;
  Window (1, 3, 80, UWin); 
END;


PROCEDURE Fusszeile (Txt : String);
BEGIN
  OldX:= WhereX;
  OldY:= WhereY;
  GotoXY (1, ULine-Hi(WindMin)); Linie;
  OutStr (Txt); ClrEol; GotoXY (1, UText-Hi(WindMin));
END;

{ -------------- Programm-Fehler ohne LOG-Datei-Funktion ---------------- }

PROCEDURE ErrorHalt (Txt : String);
BEGIN
  Fusszeile (Txt); BlindStop;
  OutStr (#13#10); CursorOn; Halt (ErrCode);
END;


PROCEDURE ErrorEnd (Txt : String);
BEGIN
  Fusszeile (Txt); ScanBKeys;
  OutStr (#13#10); CursorOn; Halt (ErrCode);
END;


PROCEDURE ErrorMsg (Txt : String);
BEGIN
  Fusszeile (Txt); ScanBKeys;
  GotoOldPos;
END;


PROCEDURE SimpleHalt (Txt : String);
BEGIN
  DosStr (Txt); BlindStop; DosStr (#13#10); CursorOn; Halt (ErrCode);
END;


PROCEDURE UserAbort;
BEGIN
  ErrorHalt ('Abbruch durch Anwender');
END;


{ -------------- Programm-Fehler mit LOG-Datei-Funktion ---------------- }

PROCEDURE ErrorHaltLog (Txt : String);
BEGIN
  AppendErr (Txt);
  ErrorHalt (Txt);
END;


PROCEDURE ErrorEndLog (Txt : String);
BEGIN
  Fusszeile (Txt); AppendErr (Txt);
  If LogStatus=2 Then ScanBKeys;
  OutStr (#13#10); CursorOn; Halt (ErrCode);
END;


PROCEDURE ErrorMsgLog (Txt : String);
BEGIN
  Fusszeile (Txt); AppendErr (Txt);
  If LogStatus=2 Then ScanBKeys;
  GotoOldPos;
END;


PROCEDURE SimpleHaltLog (Txt : String);
BEGIN
  DosStr (Txt); AppendErr (Txt); BlindStop; DosStr (#13#10); CursorOn;
  Halt (ErrCode);
END;


PROCEDURE UserAbortLog;
BEGIN
  AppendErr ('Abbruch durch Anwender');
  UserAbort;
END;


PROCEDURE Tastenabfrage (txt : String; k1, k2 : Char);
BEGIN
  Fusszeile (Txt);
  REPEAT UpScanBKeys; UNTIL (t1=k1) or (t1=k2);
  GotoOldPos;
END;


PROCEDURE GotoOldPos;
BEGIN
  GotoXY (OldX, OldY);
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
