UNIT Menue;

INTERFACE

USES
  Bioscrt, Monitor, mouse, keyCode, strings, ram, rechnen;

CONST
  MaxMenLines = 23;
  Blinds      : Boolean = FALSE;

TYPE
  MenStr        = String[80];
  ShortHelpList = Array[1..MaxMenLines] Of MenStr;
  ScreenBuffer  = Array[1..4000] Of Byte;


PROCEDURE MouseKey;
FUNCTION  CenterTextX (s : String) : Byte;
PROCEDURE UniWin (a, b, c, d : Byte; Title : MenStr);
PROCEDURE MenWin (a, b, c, d : Byte; Title : MenStr);
PROCEDURE RestoreScreen;
PROCEDURE MenLine (LineText, HotkeyInfo : MenStr; Hk1, hk2 : Char);
PROCEDURE InitHeadLine (Line : Byte);
PROCEDURE HeadField (LineText : MenStr; Hk1, hk2 : Char);
PROCEDURE Button (x, y : Byte; LineText : MenStr; Hk1, hk2 : Char);
PROCEDURE ClickField (x, y : Byte; LineText : MenStr; Hk1, hk2 : Char);
PROCEDURE EmptyMenLine;
PROCEDURE AssignShortHelp    (VAR SHelp : ShortHelpList);
PROCEDURE AssignScreenBuffer (VAR SBuf  : ScreenBuffer);
PROCEDURE BottomLine         (s         : MenStr);
PROCEDURE LaufBalken         (LineNum   : Byte);
PROCEDURE DelBalken;
PROCEDURE MenuBalken;



TYPE
  MenPal = RECORD
             HeadB, HeadT,  WinB,  WinT, KeyT,
             InfoT, Balken, HelpB, HelpT, ButtB : Byte;
           END;


CONST
  MenCol : MenPal = (HeadB  : black;    HeadT : yellow;
                     WinB   : darkgray; WinT  : White;
                     KeyT   : cyan;     InfoT : Lightgray;
                     Balken : Black;
                     HelpB  : darkgray; HelpT : cyan;
                     ButtB  : Blue);


CONST
  ShowMen        = 1;
  GetEv          = 2;
  Refresh        = 3;
  MustRefresh    = 4;
  OpenNew        = 5;
  ViewMode       : Byte    = ShowMen;
  EventOK        : Boolean = FALSE;
  Kreuz          : Boolean = FALSE;
  Vergleichswert : Byte    = 0;
  F1Pressed      : Boolean = FALSE;
  IfHelpContext  : Boolean = FALSE;
  HelpTitle      : MenStr  = '';

IMPLEMENTATION


VAR
  WinRec        : RECORD WinMin, WinMax : Word; CurX, CurY, Attr : Byte; END;
  BalkInit      : Boolean;
  MenLines      : Byte;
  MenLineNum    : Byte;
  OldLineNum    : Byte;
  LineList      : Array[1..MaxMenLines] Of Byte;


CONST
  TextOnly      = 0;
  LenOfWin      = 1;
  ShortHelp     : ^ShortHelpList = NIL;
  ScreenBuf     : ^ScreenBuffer  = NIL;
  HeadX         :  Byte          = 1;
  HeadY         :  Byte          = 1;
  EmptyLines    :  Byte          = 0;



PROCEDURE MouseKey;
VAR
  ActX, ActY : Byte;
  CurInit    : Boolean;
BEGIN
  If Blinds Then BEGIN ActX:= WhereX; ActY:= WhereY; CurInit:= FALSE; END;
  ViewMode:= GetEv;
  t1:=#0; t2:=#0; EventOK:= FALSE; kn:= 0;
  MouseOn;
  REPEAT
    MouseGet;
    If Blinds Then
    BEGIN
      If  KeyStatus and (Alt  or LShift) = (Alt  or LShift) Then GotoXY (1, 1) Else
      If (KeyStatus and (Strg or Alt)    = (Strg or Alt))   Then
      BEGIN
        While (KeyStatus and (Strg or Alt)    = (Strg or Alt)) Do;
        If not CurInit Then GotoXY (1, 1) Else
        BEGIN
          If WhereY>=hi(WindMax)-hi(WindMin) Then GotoXY (1, 1) Else
          GotoXY (1, WhereY+1); 
        END;
        t1:=#0; t2:=#0; EventOK:= FALSE; CurInit:= TRUE;
      END Else
      If KeyStatus and (Strg or LShift) = (Strg or LShift) Then
      BEGIN asm mov ah, 2; xor bh, bh; mov dh, 24; mov dl, 0; int 10h; end; END
    END;
  UNTIL (kn<>0) or (Keypressed);
  MouseOff;
  If Blinds Then GotoXY (ActX, ActY);
  If KeyPressed Then Scankeys Else MouseWait;
  If t1<>#0 Then t2:=#0;
  EventOK:= t1=#27;
END;



PROCEDURE SaveOldWin;
BEGIN
  With WinRec Do
  BEGIN
    WinMin:= WindMin; WinMax:= WindMax;
    CurX  := WhereX;  CurY  := WhereY;
    Attr  := TextAttr;
  END;
  If Screenbuf<>NIL Then GetScreen25 (ScreenBuf^);
END;



PROCEDURE RestoreScreen;
BEGIN
  If Screenbuf<>NIL Then SetScreen25 (ScreenBuf^);
  ScreenBuf:= NIL;
  ShortHelp:= NIL;
  With WinRec Do
  BEGIN
    WindMin := WinMin; WindMax:= WinMax;
    TextAttr:= Attr;
    GotoXY (CurX, CurY);
  END;
END;



FUNCTION CenterTextX (s : String) : Byte; Assembler;
ASM
  les di, s
  mov ax, WindMin
  mov bx, WindMax
  add al, bl
  sub al, es:[di]
  shr al, 1
  inc al
  jnz @ende
  mov al, 1
  @ende:
END;
{Zentriert Text im gesetzten Window}
{bei CRT/BIOSCrt mu lo(WindMin) abgezogen werden}


PROCEDURE UniWin (a, b, c, d : Byte; Title : MenStr);
BEGIN
  SaveOldWin;
  Window (a, b, c, d);
  TextAttr:= MenCol.WinB *16; ClrScr;
  TextAttr:= MenCol.HeadB*16; ClrEol;
  WriteXY (CenterTextX (Title), b, Title, MenCol.HeadT, MenCol.HeadB);
  Schatten25 (a, b, c, d);
  BalkInit:= FALSE;
  EventOK := FALSE;
END;



PROCEDURE MenWin (a, b, c, d : Byte; Title : MenStr);
BEGIN
  Kreuz:= FALSE;
  EmptyLines := 0;
  If ViewMode = GetEv Then
  BEGIN
    If (kn<>0) and ((xm<a) or (xm>c) or (ym<b) or (ym>d)) Then
    BEGIN t1:= #27; EventOK:= TRUE; END;
    MenLines:= 0;
    Exit;
  END;
  If ViewMode = Refresh Then BEGIN MenLines:= 0; Exit; END;
  UniWin (a, b, c, d, Title);
  MenLines   := 0;
  MenLineNum := 1;
  ShortHelp  := NIL;
  FillChar (LineList, SizeOf (LineList), 0);
END;



PROCEDURE EmptyMenLine;
BEGIN
  If MenLines<MaxMenLines Then inc (MenLines);
  LineList[MenLines]:= 0;
  inc (EmptyLines);
END;



PROCEDURE MenText (x, y : Byte; LineText : MenStr; Hk1, hk2 : Char; LineMode : Byte);
VAR
  Tilde             : Boolean;
  i, e, z,
  KreuzLen, BCol    : Byte;
LABEL
  DoF1, Kreu, Ab;
BEGIN
  If Kreuz Then KreuzLen:= 6 Else KreuzLen:= 0;
  If ViewMode= Refresh Then If Kreuz Then Goto Ab Else Exit;
  If ViewMode= GetEv Then
  BEGIN
    If (EventOK) or (F1Pressed) Then Exit;
    F1Pressed:= FALSE;
    If LineMode=TextOnly Then e:= x+Length(LineText)+KreuzLen Else e:= lo (WindMax);
    If ((kn<>0) and (ym=y) and (xm>=x) and (xm < e))
    or ((Upcase (t1) = UpCase (HK1)) and (t2 = HK2))
    or ( UpCase (t1) = UpCase (LineText [pos ('~', LineText)+1]))
    or ((LineMode=LenOfWin) and (t1 = #13) and (y=MenLineNum+Hi(WindMin)+2)) Then
    BEGIN
      If (kn=2) and (IfHelpContext) Then Goto DoF1;
      If Kreuz Then Goto Kreu;
      t1:= HK1; t2:= HK2; EventOK:= TRUE;
    END Else
    If (t1=#0) and (t2=F1) and (IfHelpContext) and (y=MenLineNum+Hi(WindMin)+2) Then
    BEGIN
      DoF1:
      EventOK:= TRUE; F1Pressed:= TRUE;
      HelpTitle:= LineText;
      While (pos ('~', HelpTitle) <> 0) and (Length (HelpTitle)>1) Do
      delete (HelpTitle, pos ('~', HelpTitle), 1);
    END Else
    If (t1=' ') and (Kreuz) and (y=MenLineNum+Hi(WindMin)+2) Then
    BEGIN
      Kreu:
      MenLineNum:=y-(Hi(WindMin)+2);

      Ab:
      If y=MenLineNum+Hi(WindMin)+2 Then
      BCol:= MenCol.Balken Else BCol:= MenCol.WinB;

      If ViewMode=Refresh Then BEGIN
      If Vergleichswert=MenLines-EmptyLines Then
      CharXY (x+2, y, '+', lightMagenta, BCol) Else
      CharXY (x+2, y, ' ', lightMagenta, BCol);exit; End;

      If Vergleichswert=MenLines-EmptyLines Then
      CharXY (x+2, y, ' ', lightMagenta, BCol) Else
      CharXY (x+2, y, '+', lightMagenta, BCol);

      If t1=#13 Then BEGIN EventOk:= TRUE; t1:= #0; t2:= #0; Exit; END;
      t1:= HK1; t2:= HK2;
    END;
    Exit;
  END;

  If Kreuz Then
  BEGIN
    WriteXY (x+1, y, '( )', MenCol.InfoT, MenCol.WinB);
    If Vergleichswert= MenLines-EmptyLines Then CharXY (x+2, y, '+', lightMagenta, MenCol.WinB);
  END;

  Tilde:= False; i:= 0; z:=0;
  If LineText [Length (LineText)]='~' Then LineText[0]:= Pred (LineText[0]);
  While i < Length (LineText) Do
  BEGIN
    inc (i);
    If LineText[i]= '~' Then Tilde:= not Tilde Else
    BEGIN
      inc (z);
      If Blinds Then
      If Tilde Then LineText[i]:= UpChar  (LineText[i]) Else
                    LineText[i]:= LowChar (LineText[i]);
      If Tilde Then
      CharXY (z+x+KreuzLen, y, LineText[i], MenCol.KeyT, MenCol.WinB) Else
      CharXY (z+x+KreuzLen, y, LineText[i], MenCol.WinT, MenCol.WinB)
    END;
  END;
END;



PROCEDURE MenLine (LineText, HotkeyInfo : MenStr; Hk1, hk2 : Char);
VAR
  x, y : Byte;
BEGIN
  x:= Lo (WindMin)+3;
  If MenLines < MaxMenLines Then inc (MenLines);
  LineList[MenLines]:= 1;
  y:= MenLines+Hi(WindMin)+2;
  MenText (x, y, LineText, Hk1, hk2, LenOfWin);
  If ViewMode=ShowMen Then WriteXY (x+31, y, HotKeyInfo, MenCol.InfoT, MenCol.WinB);
END;



PROCEDURE InitHeadLine (Line : Byte);
VAR
  x : Byte;
BEGIN
  Kreuz  := FALSE;
  EventOK:= False;
  HeadY  := Line;
  If ViewMode=ShowMen Then
  For x:= 1 To 80 Do CharXY (x, HeadY, #32, MenCol.WinT, MenCol.WinB);
  HeadX:= 1;
END;



PROCEDURE ClickField (x, y : Byte; LineText : MenStr; Hk1, hk2 : Char);
BEGIN
  MenText (X, Y, LineText, Hk1, hk2, TextOnly);
END;



PROCEDURE HeadField (LineText : MenStr; Hk1, hk2 : Char);
BEGIN
  MenText (HeadX, HeadY, LineText, Hk1, hk2, TextOnly);
  inc (HeadX, Length (LineText)-1);
END;



PROCEDURE Button (x, y : Byte; LineText : MenStr; Hk1, hk2 : Char);
VAR
  z : Byte;
BEGIN
  Kreuz  := FALSE;
  z:= MenCol.WinB;
  MenCol.WinB:= MenCol.ButtB;
  MenText (X, Y, LineText, Hk1, hk2, TextOnly);
  MenCol.WinB:= z;
  If ViewMode=ShowMen Then
  BEGIN
    CharXY (x+Length(LineText)-1, y, #220, black, MenCol.WinB);
    For z:= x+2 To x+Length(LineText)-1 Do
    CharXY (z, y+1, #223, black, MenCol.WinB);
  END;
END;


PROCEDURE IncMenLine;
BEGIN
  While (LineList[MenLineNum+1]=0) and (MenLineNum < Hi(WindMax) - Hi(WindMin)-2) Do
  inc (MenLineNum);
  If MenLineNum < Hi(WindMax) - Hi(WindMin)-2 Then
  inc (MenLineNum) Else MenLineNum:= 1;
  If MenLineNum=1 Then
  While (LineList[MenLineNum]=0) and (MenLineNum < Hi(WindMax) - Hi(WindMin)-2) Do
  inc (MenLineNum);
END;



PROCEDURE DecMenLine;
BEGIN
  While (LineList[MenLineNum-1]=0) and (MenLineNum > 1) Do
  dec (MenLineNum);
  If MenLineNum > 1 Then
  dec (MenLineNum) Else MenLineNum:= Hi(WindMax) - Hi(WindMin)-2;
  If MenLineNum= Hi(WindMax) - Hi(WindMin)-2 Then
  While (LineList[MenLineNum]=0) and (MenLineNum > 1) Do
  dec (MenLineNum);
END;



PROCEDURE BottomLine (s : MenStr);
VAR
  x : Byte;
BEGIN
  CharXY  (1, 25, #32, MenCol.HelpT, MenCol.HelpB);
  WriteXY (2, 25,   s, MenCol.HelpT, MenCol.HelpB);
  For x:= Length (s)+2 To 80 Do
  CharXY  (x, 25, #32, MenCol.HelpT, MenCol.HelpB);
END;



PROCEDURE AssignShortHelp (VAR SHelp : ShortHelpList);
BEGIN
  ShortHelp:= addr (SHelp);
END;



PROCEDURE AssignScreenBuffer (VAR SBuf : ScreenBuffer);
BEGIN
  ScreenBuf:= addr (SBuf);
END;



PROCEDURE LaufBalken (LineNum : Byte);
VAR
  x : Byte;
LABEL
  Ende;
BEGIN
  If not BalkInit Then BalkInit:= TRUE Else
  If OldLineNum<>LineNum Then
  ChangeBackColor (Lo (WindMin)+2, OldLineNum+Hi(WindMin)+2, Lo(WindMax)-Lo(WindMin)-1, MenCol.WinB);
  ChangeBackColor (Lo (WindMin)+2,    LineNum+Hi(WindMin)+2, Lo(WindMax)-Lo(WindMin)-1, MenCol.Balken);
  OldLineNum:= LineNum;
  If Blinds Then
  BEGIN
    For x:= Lo (WindMin)+3 To Lo(WindMax)-3 Do
    If hi(GetChar (x, LineNum+Hi(WindMin)+2)) and $0F = MenCol.KeyT Then
    BEGIN GotoXY (x-Lo (WindMin), LineNum+2); Goto Ende; END;
    GotoXY (3, LineNum+2);
  END;
  Ende:
END;



PROCEDURE DelBalken;
BEGIN
  ChangeBackColor (Lo (WindMin)+2, OldLineNum+Hi(WindMin)+2, Lo(WindMax)-Lo(WindMin)-1, MenCol.WinB);
END;


PROCEDURE MenuBalken;
BEGIN
  If not BalkInit Then
  BEGIN
    MenLineNum:= 1;
    While (LineList[MenLineNum]=0) and (MenLineNum < Hi(WindMax) - Hi(WindMin)-2) Do
    inc (MenLineNum);
  END Else
  If (t1=#0) and ((t2=Down) or (t2=Up)) Then
  BEGIN
    If t2=Up Then DecMenLine Else If t2=Down Then IncMenLine;
    t1:=#0; t2:=#0;
  END;
  LaufBalken (MenLineNum);
  If ShortHelp<>NIL Then BottomLine (Shorthelp^[MenLineNum]);
END;


BEGIN
  SaveOldWin;
END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
