UNIT Monitor;

INTERFACE
USES
  Strings;

VAR
  ScrMode   :  Byte;
  VideoAddr :  Word;

CONST
  MonoMon   = 1;
  FarbMon   = 2;
  Cursor    : Boolean = TRUE;


PROCEDURE VGAColorOff;
PROCEDURE VGAColorOn;
PROCEDURE CursorOn;
PROCEDURE CursorOff;

PROCEDURE GetScreen25     (VAR adresse);
PROCEDURE SetScreen25     (VAR adresse);

PROCEDURE GetScreen50     (VAR adresse);
PROCEDURE SetScreen50     (VAR adresse);

PROCEDURE WriteXY         (x, y    : Word; s : String;  VColor, HColor : Byte);
PROCEDURE CharXY          (x, y    : Word; c : char;    VColor, HColor : Byte);
PROCEDURE NumXY           (x, y, z : Word; l : LongInt; VColor, HColor : Byte);

PROCEDURE ChangeBackColor (x, y, z        : Word; HColor : Byte);
PROCEDURE SetBackColor    (x, y, Count    : Word; z1, z2 : Byte);
FUNCTION  GetChar         (x, y : Word)   : Word;
FUNCTION  GetScreenLine   (xa, xe, y      : Word) : String;

PROCEDURE Schatten25      (a, b, c, d     : Byte);
PROCEDURE Schatten50      (a, b, c, d     : Byte);


IMPLEMENTATION

VAR
  CurSize   : Word;
  VideoMode : Byte; { abs... $0040:$0049; nicht mehr verwenden }


PROCEDURE VGAColorOn; assembler;
ASM
  cmp ScrMode, MonoMon
  je  @raus
  mov ah, $10
  mov al, $03
  mov bl, $00
  int $10
  @raus:
END;



PROCEDURE VGAColorOff; assembler;
ASM
  cmp ScrMode, MonoMon
  je  @raus
  mov ah, $10
  mov al, $03
  mov bl, $01
  int $10
  @raus:
END;



PROCEDURE CursorOff; Assembler;
ASM
  mov cursor, FALSE
  mov ah, 1
  mov cx, 10280
  int $10
END;



PROCEDURE CursorOn; Assembler;
ASM
  mov cursor, TRUE
  mov ah, 1
  mov cx, CurSize
  int $10
END;



PROCEDURE GetScreen25 (VAR Adresse); assembler;
ASM
  mov cx, 2000
  cld
  les di, Adresse 
  mov bx, ds
  mov ds, VideoAddr
  xor si, si
  rep movsw
  mov ds, bx
END;



PROCEDURE SetScreen25 (VAR Adresse); assembler;
ASM
  mov cx, 2000
  cld
  mov es, VideoAddr
  xor di, di
  mov bx, ds
  lds si, Adresse
  rep movsw
  mov ds, bx
END; 



PROCEDURE GetScreen50 (VAR Adresse); assembler;
ASM
  mov cx, 4000
  cld
  les di, Adresse 
  mov bx, ds
  mov ds, VideoAddr
  xor si, si
  rep movsw
  mov ds, bx
END;



PROCEDURE SetScreen50 (VAR Adresse); assembler;
ASM
  mov cx, 4000
  cld
  mov es, VideoAddr
  xor di, di
  mov bx, ds
  lds si, Adresse
  rep movsw
  mov ds, bx
END; 



PROCEDURE WriteXY (x, y : Word; S : String; VColor, HColor : Byte); assembler;
ASM
  mov di, x
  mov ax, y

  dec di
  dec ax
  mov bh, 80
  mul bh
  add di, ax
  add di, di                 {Offset  Bildspeicher in di}

  cmp di, 16384
  ja @raus
  mov es, VideoAddr          {Segment Bildspeicher in es}

  mov bx, ds
  cld
  lds si, s
  xor ax, ax
  lodsb
  mov cx, ax
  jcxz @Ende                                    {Stringlnge in cx}

  mov al, HColor
  {$IFOPT G+}
    shl al, 4
  {$ELSE}
    shl al, 1; shl al, 1; shl al, 1; shl al, 1;
  {$ENDIF}
  add al, VColor                                {Farbe in al}

  @beginn:
    movsb
    stosb
  loop @beginn

  @ende:
    mov ds, bx
  @raus:
END;



PROCEDURE CharXY (x, y : Word; c : char; VColor, HColor : Byte); assembler;
ASM
  mov di, x
  mov ax, y

  dec di
  dec ax
  mov bh, 80
  mul bh
  add di, ax
  add di, di

  cmp di, 16384
  ja @raus
  mov es, VideoAddr                             {Segment Bildspeicher in es}

  mov al, c                                     {Zeichen in al}
  mov ah, HColor
  {$IFOPT G+}
    shl ah, 4
  {$ELSE}
    shl ah, 1; shl ah, 1; shl ah, 1; shl ah, 1;
  {$ENDIF}
  add ah, VColor                                {Farbe in ah}
  stosw

  @raus:
END;



PROCEDURE NumXY (x, y, z : Word; l : LongInt; VColor, HColor : Byte);
VAR
  tmp : String[11];
BEGIN
  FillChar (tmp, SizeOf (tmp), #32);
  tmp:= StrVal (l);
  If z>11 Then z:= 11;
  If z>Length(tmp) Then tmp[0]:= Char (z);
  WriteXY (x, y, tmp, VColor, HColor);
END;



PROCEDURE ChangeBackColor (x, y, z : Word; HColor : Byte); assembler;
ASM
  mov di, x
  mov ax, y

  mov bh, 80
  mul bh
  add di, ax
  add di, di
  sub di, 161                    {Offset  Bildspeicher in di}

  cmp di, 16384
  ja @raus
  mov es, VideoAddr              {Segment Bildspeicher in es}

  mov cx, z                      {Zahl der zu ndernden Zeichen}
  jcxz @raus

  mov bl, HColor;
  {$IFOPT G+}
    shl bl, 4
  {$ELSE}
    shl bl, 1; shl bl, 1; shl bl, 1; shl bl, 1;
  {$ENDIF}     {neue Farbe in bl}
  mov bh, 00001111B
  cld

  @beginn:
    mov al, es:[di];
    and al, bh                                 {alte Farbe lschen}
    or  al, bl                                 {neue Farbe setzen}
    StosB                                      {Farbe schreiben}
    inc di                                     {Zeichen berspringen}
  loop @beginn

  @raus:
END;



PROCEDURE SetBackColor (x, y, Count : Word; z1, z2 : Byte); assembler;
ASM
  mov di, x
  mov ax, y

  mov bh, 80
  mul bh
  add di, ax
  add di, di
  sub di, 161                    {Offset  Bildspeicher in di}

  cmp di, 16384
  ja @raus
  mov es, VideoAddr                             {Segment Bildspeicher in es}

  mov al, z2
  {$IFOPT G+}
    shl al, 4
  {$ELSE}
    shl al, 1; shl al, 1; shl al, 1; shl al, 1;
  {$ENDIF}
  add al, z1                                    {Farbe in al}
  mov cx, Count
  jcxz @raus
  @start:
    stosb
    inc di
  loop @start
  @raus:
END;



FUNCTION GetChar (x, y : Word) : Word; assembler;
ASM
  mov di, x
  mov ax, y

  dec di
  dec ax
  mov bh, 80
  mul bh
  add di, ax
  add di, di              {Offset  Bildspeicher in di}

  mov es, VideoAddr       {Segment Bildspeicher in es}

  mov ax, es:[di]
END;




FUNCTION GetScreenLine (xa, xe, y : Word) : String; assembler;
ASM
  mov ax, y
  mov si, xa
  mov cx, xe
  sub cx, si

  dec si
  dec ax
  mov bh, 80
  mul bh
  add si, ax
  add si, si                {Offset  Bildspeicher in di}

  mov bx, ds
  mov ds, VideoAddr         {Segment Bildspeicher in es}

  cld
  les di, @result
  mov ax, cx
  stosb                     {Schreibe Stringlnge}
  or cx, cx
  jz @Ende                                      
  cmp cx, 255
  ja @Ende

  @beginn:
    movsb
    inc si
  loop @beginn

  @ende:
  mov ds, bx
END;



PROCEDURE Schatten25 (a, b, c, d : Byte);
VAR
  y : Byte;
BEGIN
  inc (a, 2); inc (b); inc (c); inc (d);
  For y:= b To d Do SetBackColor (c, y, 2, 8, 0); 
  SetBackColor (a, d, c-a, 8, 0);
END;



PROCEDURE Schatten50 (a, b, c, d : Byte);
VAR
  y : Byte;
BEGIN
  inc (a); inc (b); inc (c); inc (d);
  For y:= b To d Do SetBackColor (c, y, 1, 8, 0);
  SetBackColor (a, d, c-a,  8, 0);
END;

{---------------------------- Initialisierung ----------------------------}

BEGIN
  ASM
    mov ah, 0Fh
    int 10h
    mov VideoMode, al
  END;
  If VideoMode = 7 Then
  BEGIN VideoAddr:=$B000; ScrMode:=MonoMon; CurSize:= 3085; END Else
  BEGIN VideoAddr:=$B800; ScrMode:=FarbMon; CurSize:= 1543; END;
  If VideoMode = 2 Then   ScrMode:=MonoMon;
END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
