UNIT mouse;

INTERFACE


CONST
  MouseTime  : Word    = 400;         {Lnge Doppelklick}
  MouseExist : Boolean = FALSE;
  xm         : Word    = 1;
  ym         : Word    = 1;
  kn         : Word    = 0;


PROCEDURE MouseInit;
PROCEDURE MouseGet;
PROCEDURE MouseOn;
PROCEDURE MouseOff;
PROCEDURE MouseWindow   (x1, y1, x2, y2 : Word);
PROCEDURE MouseMoveXY   (x,  y          : Word);
PROCEDURE MouseWait;
PROCEDURE MouseSpeed    (sx, sy         : Word);
FUNCTION  DoubleClick                   : Boolean;
FUNCTION  MouseMoved                    : Boolean;

PROCEDURE CyanCursor;
PROCEDURE ColCursor     (Attr           : Byte);
PROCEDURE NormalCursor;
PROCEDURE MouseColor    (Color, Cha     : Word);
FUNCTION  MouseIn   (a, b, c, d : Word) : Boolean;


IMPLEMENTATION


PROCEDURE MouseInit; assembler;
ASM
  cli
  mov ax, $3533    {GetIntVec 33h}
  int $21
  sti
  mov ax, es
  or  ax, bx
  jz  @ende        {wenn NIL...}

  xor ax, ax
  xor bx, bx
  int $33
  or  ax, ax
  jz  @ende        {auch keine Maus}
  mov al, TRUE

  @ende:
  mov MouseExist, al
END;
{stellt fest, ob Maustreiber installiert und initialisiert ihn}



PROCEDURE MouseOn; assembler;
ASM
  cmp MouseExist, FALSE
  je @ende
  mov ax, 1
  int $33
  @ende:
END;
{Mauszeiger sichtbar}



PROCEDURE MouseOff; assembler;
ASM
  cmp MouseExist, FALSE
  je @ende
  mov ax, 2
  int $33
  @ende:
END;
{Mauszeiger unsichtbar}



PROCEDURE MouseGet; assembler;
ASM
  cmp MouseExist, FALSE
  je @ende
  mov ax, 3
  int $33
  mov kn, bx
  {$IFOPT G+}
    shr cx, 3; inc cx; mov xm, cx
    shr dx, 3; inc dx; mov ym, dx
  {$ELSE}
    shr cx, 1; shr cx, 1; shr cx, 1; inc cx; mov xm, cx
    shr dx, 1; shr dx, 1; shr dx, 1; inc dx; mov ym, dx
  {$ENDIF}
  @ende:
END;
{ermittelt die Mauskoordinaten und den Zustand der Maustasten}



PROCEDURE MouseMoveXY (x, y : Word); assembler;
ASM
  cmp MouseExist, FALSE
  je @ende
  {$IFOPT G+}
    mov cx, x; dec cx; shl cx, 3
    mov dx, y; dec dx; shl dx, 3
  {$ELSE}
    mov cx, x; dec cx; shl cx, 1; shl cx, 1; shl cx, 1
    mov dx, y; dec dx; shl dx, 1; shl dx, 1; shl dx, 1
  {$ENDIF}
  mov ax, 4
  int $33
  @ende:
END;
{GotoXY fr den Mauscursor}



PROCEDURE MouseWait; assembler;
ASM
  cmp MouseExist, FALSE
  je @ende
  @nochmal:
  mov ax, 3
  int $33
  or  bx, bx           {kn = 0 ?}
  jnz @nochmal
  @ende:
END;
{wartet nach einem Mausklick, bis der Anwender den Mausknopf loslt}



PROCEDURE MouseWindow (x1, y1, x2, y2 : Word); assembler;
ASM
  cmp MouseExist, FALSE
  je @ende
  {$IFOPT G+}
    mov cx, x1; dec cx; shl cx, 3
    mov dx, x2; dec dx; shl dx, 3
  {$ELSE}
    mov cx, x1; dec cx; shl cx, 1; shl cx, 1; shl cx, 1
    mov dx, x2; dec dx; shl dx, 1; shl dx, 1; shl dx, 1
  {$ENDIF}
  mov ax, 7
  int $33
  {$IFOPT G+}
    mov cx, y1; dec cx; shl cx, 3
    mov dx, y2; dec dx; shl dx, 3
  {$ELSE}
    mov cx, y1; dec cx; shl cx, 1; shl cx, 1; shl cx, 1
    mov dx, y2; dec dx; shl dx, 1; shl dx, 1; shl dx, 1
  {$ENDIF}
  mov ax, 8
  int $33
  @ende:
END;
{sperrt die Maus in ein Fenster}



PROCEDURE MouseSpeed (sx, sy : Word); Assembler;
ASM
  cmp MouseExist, FALSE
  je @ende
  mov ax, 15
  mov cx, sx
  mov dx, sy
  int $33
  @ende:
END;
{Geschwindigkeit der Zeigerbewegung einstellen}


FUNCTION DoubleClick : Boolean; assembler;
ASM
  xor ax, ax              {false}
  cmp MouseExist, FALSE
  je  @ende

  @wait:                  { warte, bis der erste Klick beendet ist }
    mov ax, 3
    int 33h
    or  bx, bx
  jnz @wait

  xor ax, ax
  int 1Ah
  mov bx, MouseTime
  mov cl, 6
  shr bx, cl              { nicht ganz identisch mit DIV 55}
  add bx, dx

  @nochmal:
    xor ax, ax
    int 1Ah
    or  dx, dx
    jz  @ende             { berlauf }
    cmp dx, bx
    jae @ende             { Zeit abgelaufen }

    push bx
    push dx

    mov ax, 3             { nachgucken, ob inzwischen ein }
    xor bx, bx            { zweiter Mausklick erfolgte }
    int 33h
    xor ax, ax
    or  bx, bx
    jnz @weiter
      pop dx
      pop bx
      jmp @nochmal
    @weiter:
    shr dx, 1; shr dx, 1; shr dx, 1
    inc dx
    cmp dx, ym

    pop dx
    pop bx
    je  @okay
  jmp @nochmal

  @okay:
    mov al, TRUE
  @ende:
END;
{Prft, ob ein Doppelklick erfolgte}


FUNCTION DoubleClick_alt : Boolean; assembler;
ASM
  xor ax, ax              {false}
  cmp MouseExist, FALSE
  je  @ende

  mov ax, 5               {"Klickzhler" initialisieren}
  xor bx, bx
  int 33h

  xor ax, ax
  int 1Ah
  mov bx, MouseTime
  mov cl, 6
  shr bx, cl              { nicht ganz identisch mit DIV 55}
  add bx, dx

  @nochmal:
    xor ax, ax
    int 1Ah
    or  dx, dx
    jz  @overflow
    cmp dx, bx
    jae @overflow
  jmp @nochmal

  @overflow:              {warten}

  mov ax, 5               {nachgucken, ob inzwischen ein}
  xor bx, bx              {zweiter Mausklick erfolgte}
  int 33h
  xor ax, ax
  or  bx, bx
  jz  @ende
  shr dx, 1; shr dx, 1; shr dx, 1
  inc dx
  cmp dx, ym
  jne @ende

  mov al, TRUE

  @ende:
END;
{Prft, ob ein Doppelklick erfolgte}


FUNCTION MouseMoved : Boolean; assembler;
ASM
  xor ax, ax              {false}
  cmp MouseExist, FALSE
  je  @ende
  mov ax, 11              {Funktion 11: relative Bewegung } 
  int 33h
  xor ax, ax
  or  cx, dx              {MouseMoved:= CX or DX <> 0}
  jz  @ende
  inc ax                  {reicht evtl. mov ax, cx ?}
  @ende:
END;
{Prft, ob Maus bewegt wurde}



PROCEDURE CyanCursor; assembler;
ASM
  cmp MouseExist, FALSE
  je @ende
  mov ax, 10
  xor bx, bx
  xor cx, cx
  mov dx, 3035
  int $33
  @ende:
END;
{frher fr DOS-Comander bis 3.0}



PROCEDURE ColCursor (Attr : Byte); assembler;
ASM
  cmp MouseExist, FALSE
  je @ende
  mov ax, 10
  xor bx, bx
  mov cx, 255       {wird cx kleiner, dann wird Zeichen erniedrigt}
  xor dl, dl        {erhht das Zeichen unter MausCursor um dl}
  mov dh, Attr      {Zeichenattribut in Mauscursor}
  int $33
  @ende:
END;
{"blinder" Cursor mit anderer Farbe}



PROCEDURE NormalCursor; assembler;
ASM
  cmp MouseExist, FALSE
  je @ende
  mov ax, 10
  xor bx, bx
  mov cx, 30719
  mov dx, 30464
  int $33
  @ende:
END;
{erzeugt wieder den Standardcursor}



PROCEDURE MouseColor (Color, Cha : Word); assembler;
ASM
  cmp MouseExist, FALSE
  je @ende
  mov ax, cha
  cmp ax, $FF
  je  @weiter
  {$IFOPT G+}
    shl ax, 8
  {$ELSE}
    mov ah, al
    xor al, al
  {$ENDIF}
  @weiter:
  mov bx, ax

  mov dx, color

  {$IFOPT G+}
    shl dx, 12
  {$ELSE}
    mov cl, 12
    shl dx, cl
  {$ENDIF}
  mov cx, dx

  and dx, $FF00
  {$IFOPT G+}
    shr ax, 8
  {$ELSE}
    mov al, ah
    xor ah, ah
  {$ENDIF}
  add dx, ax

  and cx, $FF
  {$IFOPT G+}
    shl cx, 8
  {$ELSE}
    mov ch, cl
    xor cl, cl
  {$ENDIF}
  and bx, $FF
  add cx, bx

  mov ax, 10
  xor bx, bx
  int $33

  @ende:
END;
{setzt Farbe und Zeichen des Mauszeigers}



FUNCTION MouseIn (a, b, c, d : Word) : Boolean; assembler;
ASM
  xor ax, ax
  mov cx, xm
  mov dx, ym
  cmp cx, a ; jb @ende
  cmp cx, c ; ja @ende
  cmp dx, b ; jb @ende
  cmp dx, d ; ja @ende
  inc ax
  @ende:
END;

END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
