UNIT Newcrt;             {Ersatz fr Crt}


INTERFACE
USES
  Rechnen;


PROCEDURE VGAColorOn;
PROCEDURE VGAColorOff;

PROCEDURE TextMode       (Modus : Integer);
PROCEDURE TextBackGround (Color : Byte);
PROCEDURE TextColor      (Color : Byte);
PROCEDURE LowVideo; 
PROCEDURE HighVideo;

PROCEDURE CursorSize      (o, u : Byte); 
PROCEDURE CursorOff;
PROCEDURE CursorOn;

PROCEDURE GotoXY          (x, y : Byte);
FUNCTION  WhereX                : Byte;
FUNCTION  WhereY                : Byte;

PROCEDURE Window    (a, b, c, d : Byte);
PROCEDURE SaveWindow;
PROCEDURE RestoreWindow;
PROCEDURE NormWindow;

PROCEDURE ClrScr;
PROCEDURE ClrEOL;
PROCEDURE ScrollUp;
PROCEDURE ScrollDown;
PROCEDURE LineFeed;

PROCEDURE WriteStr   (Zeichen : String);
PROCEDURE WriteStrLn (Zeichen : String);
PROCEDURE WriteNum   (Zahl    : LongInt);
PROCEDURE WriteNumLn (Zahl    : LongInt);

PROCEDURE GetScreen25 (VAR Adresse);
PROCEDURE SetScreen25 (VAR Adresse); 
PROCEDURE GetScreen50 (VAR Adresse);
PROCEDURE SetScreen50 (VAR Adresse);

FUNCTION  Keypressed    : Boolean;
FUNCTION  ReadKey       : Char;
FUNCTION  UpReadKey     : Char;
PROCEDURE ScanKeys;
PROCEDURE UpScanKeys;
PROCEDURE WaitKey; 
PROCEDURE ReadStr   (VAR ss);
PROCEDURE ReadNum   (VAR ss);
PROCEDURE ClearKeyBuffer;
PROCEDURE WriteIntoKeyBuffer (Scan, Key : Char);

PROCEDURE Delay (Time : Word);
 

CONST
  BW40     = 0;
  CO40     = 1;
  BW80     = 2;
  CO80     = 3;     
  Mono     = 7;
  Font8x8  = $1112;
  Font8x14 = $1111;
  Font8x16 = $1114;

  Black     = 0; DarkGray     =  8; 
  Blue      = 1; LightBlue    =  9; 
  Green     = 2; LightGreen   = 10; 
  Cyan      = 3; LightCyan    = 11;
  Red       = 4; LightRed     = 12;
  Magenta   = 5; LightMagenta = 13;
  Brown     = 6; Yellow       = 14;
  LightGray = 7; White        = 15;
  Blink     = 128;

  TextAttr  : Byte = 7;
  WindMin   : Word = 0;
  WindMax   : Word = 6223;

VAR
  t1, t2   : Char;
  LastMode : Word;
  ActMode  : Word;
  ScrMode  : Byte;

CONST
  MonoMon  = 1;
  FarbMon  = 2;
  Cursor   : Boolean = TRUE;


IMPLEMENTATION

VAR
  CurSize   : Word;
  VideoMode : Byte absolute $0040:$0049;
  BiosCursor: Word absolute $0040:$0050;
  VideoAddr : Word;
  CurPos    : Word;
  OldCurPos : Word;

CONST
  OldWMin   : Word = 0;
  OldWMax   : Word = 6223;



{------------------------------ Farbe, Modus ------------------------------}


PROCEDURE VGAColorOn; assembler;
ASM
  cmp ScrMode, MonoMon
  je @raus
  mov ah, $10
  mov al, $03
  mov bl, $00
  int $10
  @raus:
END;



PROCEDURE VGAColorOff; assembler;
ASM
  cmp ScrMode, MonoMon
  je @raus
  mov ah, $10
  mov al, $03
  mov bl, $01
  int $10
  @raus:
END;



PROCEDURE TextMode (Modus : Integer); assembler;
ASM
  mov ah, $0F
  int $10
  mov LastMode, ax
  mov ax, Modus
  mov ActMode, ax
  xor bl, bl
  int $10
END;



PROCEDURE TextBackGround (Color : Byte); assembler;
ASM
  mov ah, Color;
  {$IFOPT G+}
    shl ah, 4
  {$ELSE}
    mov cl, 4
    shl ah, cl
  {$ENDIF}
  mov al, TextAttr;
  and al, 00001111B
  add al, ah
  mov TextAttr, al
END;



PROCEDURE TextColor (Color : Byte); assembler;
ASM
  mov al, TextAttr
  and al, 11110000B
  add al, Color
  mov TextAttr, al
END;



PROCEDURE LowVideo; assembler;
ASM
  and textattr, 11110111b
END;



PROCEDURE HighVideo; assembler;
ASM
  or textattr, 00001000b
END;


{--------------------------------- Cursor --------------------------------}


PROCEDURE CursorSize (o, u : Byte); assembler;
ASM
  mov ah, 1
  mov ch, o
  mov cl, u
  int $10
END;
{ch= 1:Groer Block, ch=5:dick, ch=6:Normal, ch=7:dnn, ch=8:kleiner Block}
{cl= 1..10: Cursordicke  ... ch:=Startzeile, cl:=EndeZeile}



PROCEDURE CursorOff; Assembler;
ASM
  mov cursor, FALSE
  mov ah, 1
  mov cx, 10280
  int $10
END;



PROCEDURE CursorOn; Assembler;
ASM
  mov cursor, TRUE
  mov ah, 1
  mov cx, CurSize
  int $10
END;



PROCEDURE MoveCursor; Assembler;
ASM
  cmp cursor, 0
  je @ende
  mov ah, 2
  xor bh, bh
  int $10
  @ende:
END;



PROCEDURE GotoXY (x, y : Byte); assembler;
ASM
  mov  bx, WindMin
  mov  dx, bx
  add  dl, x
  add  dh, y
  dec  dl
  dec  dh
  cmp  dl, bl
  jb   @raus
  cmp  dh, bh
  jb   @raus
  mov  ax, WindMax
  cmp  dl, al
  ja   @raus
  cmp  dh, ah
  ja   @raus
  mov  CurPos, dx
  call MoveCursor
  @raus:
END; 



FUNCTION WhereX : Byte; assembler;
ASM
  mov ax, CurPos
  sub ax, WindMin
END;



FUNCTION WhereY : Byte; assembler;
ASM
  mov  ax, CurPos
  xchg al, ah
  sub  ax, WindMin
  mov  al, ah
END;  



{------------------------------ Fenster ------------------------------------}


PROCEDURE Window (a, b, c, d : Byte); assembler;
ASM
  mov  dl, a
  mov  dh, b
  dec  dl
  dec  dh
  mov  WindMin, dx
  mov  al, c
  mov  ah, d
  dec  al
  dec  ah
  mov  WindMax, ax
  mov  CurPos,  dx
  call MoveCursor
END;



PROCEDURE SaveWindow; assembler;
ASM
  mov ax, WindMin
  mov OldWMin, ax
  mov ax, WindMax
  mov OldWMax, ax
  mov ax, CurPos
  mov OldCurPos, ax
END;



PROCEDURE RestoreWindow; assembler;
ASM
  mov ax, OldWMin
  mov WindMin, ax
  mov ax, OldWMax
  mov WindMax, ax
  mov ax, OldCurPos
  mov CurPos, ax
END;



PROCEDURE NormWindow; assembler;
ASM
  mov WindMin, 0
  mov WindMax, 6223
END;


{--------------------------------- Clear, Scroll --------------------------}


PROCEDURE ClrScr; assembler;
ASM
  mov  cx, WindMin
  mov  CurPos, cx
  mov  dx, cx
  call MoveCursor
  mov  dx, WindMax
  mov  ah, 6
  xor  al, al
  mov  bh, TextAttr
  int  $10
END;



PROCEDURE ClrEOL; assembler;
ASM
  mov cx, CurPos
  mov dx, WindMax
  mov dh, ch
  mov ah, 6
  xor al, al
  mov bh, TextAttr
  int $10
END;



PROCEDURE ScrollUp; assembler;
ASM
  mov ah, 6
  mov al, 1
  mov cx, WindMin
  mov dx, WindMax
  mov bh, TextAttr
  int $10
END;



PROCEDURE ScrollDown; assembler;
ASM
  mov ah, 7
  mov al, 1
  mov cx, WindMin
  mov dx, WindMax
  mov bh, TextAttr
  int $10
END;


{-------------------------------- Ausgabe ---------------------------------}


PROCEDURE WriteStr (Zeichen : String); assembler;
ASM
  mov  dx, CurPos
  mov  es, VideoAddr

  push ds
  lds  si, Zeichen
  xor  cx, cx
  cld
  lodsb
  mov  cl, al
  jcxz @raus

  @start:
    mov bx, dx
    xor ax, ax
    mov al, bh
    xor bh, bh
    mov di, bx
    mov bh, 80
    mul bh
    add di, ax
    add di, di

    lodsb
    mov bx, ds
    pop ds

    cmp al, 13
    ja  @los2
    jne @los1
      mov dl, Byte Ptr WindMin
      jmp @1
    @los1:
    cmp al, 10
    jne @los2
      mov dl, Byte Ptr WindMax
      jmp @weiter

    @los2: 
    mov ah, TextAttr
    stosw

    @weiter:
    mov ax, WindMax
    inc dl
    cmp dl, al
    jbe @1
      mov dl, Byte Ptr WindMin
      cmp dh, ah
      inc dh
    jb @1
      dec dh
      mov di, dx; push cx; push bx 
      call Scrollup
      mov dx, di; pop  bx; pop  cx
    @1:

    push ds
    mov  ds, bx
  loop @start

  @raus:
  pop  ds
  mov  CurPos, dx
  call MoveCursor
END;



PROCEDURE LineFeed;
BEGIN
  WriteStr (#13#10);
END;



PROCEDURE WriteStrLn (Zeichen : String);
BEGIN
  WriteStr (Zeichen);
  LineFeed;
END;



PROCEDURE WriteNum (Zahl : LongInt);
BEGIN
  WriteStr (LongStr (Zahl));
END;



PROCEDURE WriteNumLn (Zahl : LongInt);
BEGIN
  WriteStr (LongStr (Zahl));
  LineFeed;
END;



PROCEDURE GetScreen25 (VAR Adresse); assembler;
ASM
  mov cx, 2000
  cld
  les di, Adresse 
  mov bx, ds
  mov ds, VideoAddr
  xor si, si
  rep movsw
  mov ds, bx
END;



PROCEDURE SetScreen25 (VAR Adresse); assembler;
ASM
  mov cx, 2000
  cld
  mov es, VideoAddr
  xor di, di
  mov bx, ds
  lds si, Adresse
  rep movsw
  mov ds, bx
END; 



PROCEDURE GetScreen50 (VAR Adresse); assembler;
ASM
  mov cx, 4000
  cld
  les di, Adresse 
  mov bx, ds
  mov ds, VideoAddr
  xor si, si
  rep movsw
  mov ds, bx
END;



PROCEDURE SetScreen50 (VAR Adresse); assembler;
ASM
  mov cx, 4000
  cld
  mov es, VideoAddr
  xor di, di
  mov bx, ds
  lds si, Adresse
  rep movsw
  mov ds, bx
END; 


{---------------------------- Tastatur ----------------------------------}



FUNCTION Keypressed : Boolean; assembler;
ASM
  mov ah, 1
  int $16
  mov al, 1
  jnz @ende
  int 28h
  dec al
  @ende:
END;



FUNCTION ReadKey : Char; assembler;
ASM
  call waitkey;
END;



FUNCTION UpReadKey : Char; assembler;
ASM
  call waitkey;
  cmp al, 'a'; jb @weiter;
  cmp al, 'z'; ja @weiter;
  sub al, 32
  @weiter:
END;



PROCEDURE ScanKeys; assembler;
ASM
  call waitkey;
  mov t1, al
  mov t2, ah
END;



PROCEDURE UpScanKeys; assembler;
ASM
  call waitkey;
  cmp al, 'a'; jb @weiter;
  cmp al, 'z'; ja @weiter;
  sub al, 32
  @weiter:
  mov t1, al
  mov t2, ah
END;



PROCEDURE WaitKey; assembler;
ASM
  @nochmal:
    int 28h
    mov ah, 1
    int $16
  jz  @nochmal
  xor ah, ah
  int $16
END;


PROCEDURE ReadStr (VAR ss);
VAR
  s    : String absolute ss;
  x, y : Byte;
BEGIN
  x:= WhereX; y:= WhereY;
  REPEAT
    GotoXY (x, y); WriteStr (s); ClrEol;
    ScanKeys;
    If (t1=#8) Then BEGIN If s[0]>#0 Then dec (s[0]); END Else
    If (t1<>#27) and (t1<>#13) and (t1<>#0) Then s:= s+ t1;
  UNTIL (t1=#27) or (t1=#13);
  If t1=#13 Then LineFeed;
END;



PROCEDURE ReadNum (VAR ss);
VAR
  s    : String absolute ss;
  x, y : Byte;
BEGIN
  x:= WhereX; y:= WhereY;
  REPEAT
    GotoXY (x, y); WriteStr (s); ClrEol;
    ScanKeys;
    If (t1=#8) Then BEGIN If s[0]>#0 Then dec (s[0]); END Else
    If (t1>='0') and (t1<='9') Then s:= s + t1;
  UNTIL (t1=#27) or (t1=#13);
  If t1=#13 Then LineFeed;
END;



PROCEDURE ClearKeyBuffer; assembler;
ASM
  @nochmal:
  mov ah, 1
  int $16
  jz  @ende
  xor ah, ah
  int $16
  jmp @nochmal
  @ende:
END;



PROCEDURE WriteIntoKeyBuffer (Scan, Key : Char); assembler;
ASM
  mov cl, Scan
  mov ch, Key
  mov al, $05
  int $16
  (* mov Result, al*)
END;
{schreibt in Tastaturpuffer}



PROCEDURE Delay (Time : Word); assembler;
ASM
  mov ax, $8600
  mov dx, Time
  {$IFOPT G+}
    shl dx, 2
  {$ELSE}
    shl dx, 1; shl dx, 1
  {$ENDIF}
  mov cl, dh; xor dh, dh; xor ch, ch
  int $15
END;


{----------------------------- Initialisierung ----------------------------}
BEGIN
  If VideoMode = 7 Then
  BEGIN VideoAddr:=$B000; ScrMode:=MonoMon; CurSize:= 3085; END Else
  BEGIN VideoAddr:=$B800; ScrMode:=FarbMon; CurSize:= 1543; END;
  If VideoMode = 2 Then   ScrMode:=MonoMon;
  CurPos:= BiosCursor;
  OldCurPos:= CurPos;
  ASM
    mov al, VideoMode
    xor ah, ah
    mov LastMode, ax
    mov ActMode, ax
  END;
END.

END.
