UNIT PageDev;

INTERFACE

USES
  DOS;

TYPE
  TAlign      = (Left, Right, Center, Justify);
  TPageMode   = (All, EvenOnly, OddOnly);

  TPageKonfig = RECORD
                  LineLen      : Byte;     { max. Zeilenlnge in Zeichen (ohne linken Rand) }
                  LeftMargin   : Byte;     { Breite linker Rand in Zeichen }
                  TopMargin    : Byte;     { Breite oberer Rand in Zeilen }
                  BottomMargin : Byte;     { unterer Rand in Zeilen }
                  LinesPerPage : Byte;     { Text-Zeilen pro Seite (ohne obere und untere Rnder)}
                  TabLen       : Byte;     { Lnge Tabulator-Einzug }
                  PageMode     : TPageMode;{ Alle, nur gerade oder nur ungerade Seiten drucken }
                  TextAlign    : TAlign;   { Ausrichtung des Textes }
                  FirstPage    : Longint;  { erste zu druckende Seite }
                  LastPage     : Longint;  { letzte zu druckende Seite, 0 = Alle }

                  FirstPageNr  : Longint;  { Nummer der ersten Seite }
                  PrintPageNr  : Boolean;  { TRUE, wenn Seiten-Numerierung gedruckt werden soll }
                  PageNrAlign  : TAlign;   { Ausrichtung der Fuzeile (Justify unwirksam !, = Left)}
                  PageNrPrefix : String;   { Text, der VOR der Seitennummer gedruckt werden soll }
                  PageNrSuffix : String;   { Text, der hinter der Seitennummer gedruckt werden soll }

                  PrintFormFeed: Boolean;  { TRUE, wenn Seitenvorschub-Zeichen #12 gedruckt werden soll }

                                           { Interne Felder }
                  LastSpace    : Byte;     { Zeilenumbruchposition }
                  Buffer       : String;   { Zeichenpuffer Formatierung }
                  ActPage      : Longint;  { aktuelle Seiten-Nummer, gerechnet vom Dateianfang }
                  ActLine      : Word;     { aktuelle Zeilennummer }
                END;
                { Alle Longints an durch 4 teilbaren Adressen ausgerichtet }


PROCEDURE WriteIntoPage  (VAR f : Text; c : Char; VAR PageKonfig : TPageKonfig);
FUNCTION  IsLastPage     (VAR f : Text; PageKonfig : TPageKonfig) : Boolean;
PROCEDURE FlushPageBuf   (VAR f : Text; PageKonfig : TPageKonfig);

PROCEDURE InitForPrinter (VAR Konfig : TPageKonfig);
PROCEDURE InitForScreen  (VAR Konfig : TPageKonfig);


IMPLEMENTATION


FUNCTION IsLastPage (VAR f : Text; PageKonfig : TPageKonfig) : Boolean;
BEGIN
  With PageKonfig Do
  IsLastPage:= (TextRec(f).UserData[1]=1) and (LastPage<>0) and (ActPage>LastPage);
END;


PROCEDURE FlushPageBuf (VAR f : Text; PageKonfig : TPageKonfig);
BEGIN
  WriteIntoPage (f, #26, PageKonfig);
END;


PROCEDURE WriteIntoPage (VAR f : Text; c : Char; VAR PageKonfig : TPageKonfig);
VAR
  x : Byte;


PROCEDURE WriteData (s : String);
BEGIN
  With PageKonfig Do
  BEGIN
    If  ((PageMode=All)
    or  ((odd (ActPage))     and (PageMode=OddOnly))
    or  ((not odd (ActPage)) and (PageMode=EvenOnly)))
    and  (ActPage>=FirstPage)
    and ((ActPage<=LastPage)  or (LastPage=0)) Then Write (f, s);
  END;
END;


PROCEDURE WriteSpaces (Count : Byte);
BEGIN
  For Count:= 1 To Count Do WriteData (' ');
END;


PROCEDURE WriteEmptyLines (Count : Byte);
BEGIN
  For Count:= 1 To Count Do WriteData (#13#10);
END;


FUNCTION FirstChar (s : String) : Byte; assembler;
ASM
  les  di, s
  mov  bl, es:[di]
  xor  bh, bh
  mov  cx, bx
  jcxz @ende
  inc  di
  mov  al, ' '
  repe scasb
  jne  @weiter
  mov  cx, bx    { Damit 0 rauskommt }
  @weiter:
  sub  bx, cx
  @ende:
  mov  ax, bx
END;
{ Position des ersten "richtigen" Zeichens nach fhrenden Leerzeichen,
  gibt 0 zurck, wenn der String nur Leerzeichen enthlt oder leer ist. }


PROCEDURE WriteTrimLine (s : String);
VAR
  CharFound : Boolean;
  x         : Byte;
BEGIN
  While (Length(s)>0) and (s[Length(s)]=' ') Do dec (s[0]);
  If Length (s)<>0 Then { mu }
  With PageKonfig Do
  BEGIN
    CASE TextAlign of
      Right   : WriteSpaces  (LineLen-Length(s));
      Center  : WriteSpaces ((LineLen-Length(s)) shr 1);
      Justify : If  (Length (s) >= LineLen-(LineLen shr 2))
                and (Length (s) <  LineLen)
                and (pos (' ', copy (s, FirstChar(s), 255)) <> 0) Then
                BEGIN
                  CharFound:= FALSE;
                  x:= 0;
                  While Length (s) < LineLen Do
                  BEGIN
                    If x >= Length(s) Then BEGIN x:= 0; CharFound:= FALSE; END;
                    inc (x);
                    If s[x] = ' ' Then
                    BEGIN
                      If (CharFound) and (s[x+1]<>' ') Then
                      BEGIN Insert (' ', s, x); inc (x); END;
                    END Else CharFound:= TRUE;
                  END;
                END;
    END;
    WriteSpaces (LeftMargin);
    WriteData (s);
  END;
END;


PROCEDURE WriteBottomMargin;
VAR
  fl   : Byte;
  Page : String[11];
BEGIN
  With PageKonfig Do
  BEGIN
    WriteEmptyLines (LinesPerPage-ActLine+BottomMargin+2);
    If PrintPageNr Then
    BEGIN
      WriteSpaces (LeftMargin);
      Str (ActPage+FirstPageNr-1, Page);
      fl:= Length(PageNrPrefix)+Length(Page)+Length(PageNrSuffix);
      CASE PageNrAlign Of
        Right  : WriteSpaces  (LineLen-fl);
        Center : WriteSpaces ((LineLen-fl) shr 1);
      END;
      WriteData (PageNrPrefix);
      WriteData (Page);
      WriteData (PageNrSuffix);
    END;
    If PrintFormFeed Then WriteData (#12#13); { Seitenvorschub UND Wagenrcklauf }
  END;
END;


PROCEDURE FlushBuffer;
BEGIN
  With PageKonfig Do
  BEGIN
    If ActLine=1 Then WriteEmptyLines (TopMargin);
    If InOutRes<>0 Then Exit;    { Damit sich keine Zhlvariablen "drehen" }
    inc (ActLine);

    If LastSpace=0 Then LastSpace:= LineLen;

    WriteTrimLine (copy (Buffer, 1, LastSpace));

    If InOutRes=0 Then
    BEGIN Delete (Buffer, 1, LastSpace); LastSpace:= 0; END;

    If (ActLine>LinesPerPage) or (c=#26) Then
    BEGIN
      WriteBottomMargin;
      If InOutRes<>0 Then Exit;    { Damit sich keine Zhlvariablen "drehen" }
      ActLine:= 1;
      inc (ActPage);
    END Else
    WriteData (#13#10);
  END;
END;


{ ----------------------------- HauptProzedur -------------------------- }

BEGIN
  With PageKonfig Do
  BEGIN
    If InOutRes<>0 Then Exit;

    If TextRec(f).UserData[1]=0 Then { Initialisierungs-Flag }
    BEGIN
      ActLine  := 1;
      ActPage  := 1;
      Buffer   := '';
      LastSpace:= 0;
      TextRec(f).UserData[1]:=1;
    END;

    If c=#26 Then             { Erklrung s.u. }
    BEGIN
      FlushBuffer;
      TextRec(f).UserData[1]:= 0;
    END
    Else
    BEGIN
      If (c<>#10) and (c<>#13) Then
      BEGIN
        If c=#9 Then
        For x:= 1 To TabLen Do
        Insert (' ', Buffer, 255) Else
        Insert (c,   Buffer, 255);
        If (c='-') or (c=' ') Then LastSpace:= Length (Buffer);
      END;
      If (Length(Buffer) >= LineLen) or (c=#10) Then { #13 geht auch, #10 ist besser bei UNIX-Dateien }
      BEGIN
        If c=#10 Then LastSpace:= LineLen;
        FlushBuffer;
      END;
    END;
  END;
END;
{ Bevor die Datei mit Close geschlossen wird, mu einmalig das Zeichen #26
  (Dateiende-Marke) gesendet werden, damit die noch gepufferten Daten
  physikalisch geschrieben (geflusht) werden:

  WriteIntoPage (f, #26, PageKonfig);
  Close (f);
}


{ ------------ Beispielkonfigurationen Drucker und Bildschirm ------------ }

PROCEDURE InitForPrinter (VAR Konfig : TPageKonfig);
BEGIN
  With Konfig Do
  BEGIN
    LineLen      := 70;
    TopMargin    := 2;
    LeftMargin   := 10;
    BottomMargin := 2;
    PageMode     := All;
    FirstPage    := 1;
    LastPage     := 0;
    LinesPerPage := 59;
    TextAlign    := Left;
    TabLen       := 2;

    PrintPageNr  := TRUE;
    FirstPageNr  := 1;
    PageNrPrefix := '';
    PageNrSuffix := '';
    PageNrAlign  := Center;

    PrintFormFeed:= TRUE;
  END;
END;


PROCEDURE InitForScreen (VAR Konfig : TPageKonfig);
BEGIN
  With Konfig Do
  BEGIN
    LineLen      := 79;
    TopMargin    := 0;
    LeftMargin   := 0;
    BottomMargin := 0;
    PageMode     := All;
    FirstPage    := 1;
    LastPage     := 0;
    LinesPerPage := 23;
    TextAlign    := Left;
    TabLen       := 2;

    PrintPageNr  := FALSE;
    FirstPageNr  := 1;
    PageNrPrefix := '';
    PageNrSuffix := '';
    PageNrAlign  := Center;

    PrintFormFeed:= FALSE;
  END;
END;


END.



{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
