UNIT Ram;

INTERFACE


PROCEDURE wFillChar (VAR Ziel; Count : Word; Zeichen : Char);
{$IFOPT G+}
PROCEDURE dFillChar (VAR Ziel; Count : Word; Zeichen : Char);
{$ENDIF}
PROCEDURE wMove     (VAR Quelle, Ziel; Count : Word);
{$IFOPT G+}
PROCEDURE dMove     (VAR Quelle, Ziel; Count : Word);
{$ENDIF}

IMPLEMENTATION



PROCEDURE wFillChar (VAR Ziel; Count : Word; Zeichen : Char); assembler;
ASM
  mov  cx, Count       { Zahl der aufzufllenden Speicherstellen in CX       }
  jcxz @raus           { Wenn CX=0, dann raus                                }
  cld                  { in Richtung aufsteigender Adressen abarbeiten       }
  mov  al, Zeichen     { Fllzeichen in AL                                   }
  mov  ah, al          { und AH                                              }
  les  di, Ziel        { Adresse des Ziels in Registerpaar ES:DI             }
  mov  bx, di          { Offsetadresse des Ziels (DI) auch in BX             }
  and  bx, 1           { Bit 1 bis 15 ausblenden, Ergebnis in BX ist 0 bzw 1 }
  sub  cx, bx          { Ergebnis von CX subtrahieren                        }
  xchg cx, bx          { Register BX und CX tauschen ihren Inhalt aus        }
  rep  stosb           { null oder ein Zeichen schreiben                     }
  mov  cx, bx          { in CX wieder Zahl der noch zu schreibenden Zeichen  }
  shr  cx, 1           { schnelle Division durch zwei                        }
  rep  stosw           { schreibe Doppelbyte, bis CX-Register auf Null steht }
  and  bx, 1           { Bit 1 bis 15 ausblenden, Ergebnis in BX ist 0 bzw 1 }
  mov  cx, bx          { Ergebnis nach CX                                    }
  rep  stosb           { null oder ein Zeichen schreiben                     }
  @raus:
END;


{$IFOPT G+}

PROCEDURE dFillChar (VAR Ziel; Count : Word; Zeichen : Char); assembler;
ASM
  cld                  { in Richtung aufsteigender Adressen abarbeiten       }
  les  di, Ziel        { Adresse des Ziels in Registerpaar ES:DI             }
  mov  al, Zeichen     { Fllzeichen in AL                                   }
  mov  cx, Count       { Zahl der aufzufllenden Speicherstellen in CX       }
  cmp  cx, 3           { vergleiche Zeichenzahl mit 3                        }
  jbe  @weiter         { If CX <= 3 Then Goto @weiter                        }

  mov  ah, al          { Fllzeichen auch in AH                              }
  mov  bx, ax          { AX in BX zwischenspeichern                          }
  db   66h             { Hinweis an Prozessor: Es folgt ein 32-Bit-Befehl    }
  shl  ax, 16          { SHL EAX, 16: Schiebe Zeichen in den "unsichtbaren"  }
  mov  ax, bx          { Teil des EAX-Registers; Zeichen nochmals nach AX    }

  mov  dx, di          { Offsetadresse des Ziels (DI) auch in DX             }
  and  dx, 3           { Bit 2 bis 15 ausblenden, Ergebnis in DX: 0 bis 3    }
  mov  bx, 4           { errechne, wieviele Bytes einzeln zu schreiben sind, }
  sub  bx, dx          { bis eine durch 4 teilbare Adresse erreicht ist      }
  sub  cx, bx          { Ergebnis von CX subtrahieren                        }
  xchg cx, bx          { Register BX und CX tauschen ihren Inhalt aus        }
  rep  stosb           { null bis 3 Zeichen einzeln schreiben                }

  mov  cx, bx          { in CX wieder Zahl der noch zu schreibenden Zeichen  }
  shr  cx, 2           { schnelle Division durch vier                        }
  rep                  { Wiederholungsanweisung                              }
  db   66h             { Es folgt ein 32-Bit-Befehl: STOSW wird zu STOSD     }
  stosw                { schreibe Longints, bis CX-Register auf Null steht   }

  mov  cx, bx          { Zeichenzahl wieder nach CX. Ermitteln der brig-    }
  and  cx, 3           { gebliebenen Zeichen durch Ausblenden der Bits 2-15  }
  @weiter:
  rep  stosb           { null bis drei Zeichen einzeln schreiben             }
END;

{$ENDIF}


PROCEDURE wMove  (VAR Quelle, Ziel; Count : Word); assembler;
ASM
  mov  cx, Count       { Zahl der zu kopierenden Speicherstellen in CX       }
  jcxz @raus           { Wenn CX=0, dann raus                                }
  mov  dx, ds          { DS-Register in DX zwischenspeichern. Wichtig!}
  les  di, Ziel        { Startadresse von Ziel   in Registerpaar ES:DI       }
  lds  si, Quelle      { Startadresse von Quelle in Registerpaar DS:SI       }
  cmp  di, si          { Vergleiche beide Offsets                            }
  ja   @Down           { If DI > SI Then Goto @Down                          }

  cld                  { in Richtung aufsteigender Adressen kopieren         }
  mov  bx, di          { Offsetadresse des Ziels (DI) auch in BX             }
  and  bx, 1           { Bit 1 bis 15 ausblenden, Ergebnis in BX ist 0 bzw 1 }
  sub  cx, bx          { Ergebnis von CX subtrahieren                        }
  xchg cx, bx          { Register BX und CX tauschen ihren Inhalt aus        }
  rep  movsb           { null oder ein Zeichen kopieren                      }
  mov  cx, bx          { in CX wieder Zahl der noch zu kopierenden Zeichen   }
  shr  cx, 1           { schnelle Division durch zwei                        }
  rep  movsw           { kopiere Doppelbytes, bis CX-Register auf Null steht }
  jmp  @ende           { Goto @ende                                          }

  @Down:

  std                  { in Richtung absteigender Adressen kopieren          }
  add  di, cx          { Addiere zu DI die Zahl der zu kopierenden Bytes     }
  add  si, cx          { dasselbe auch mit SI                                }
  mov  bx, di          { Offsetadresse des Ziels (DI) auch in BX             }
  and  bx, 1           { Bit 1 bis 15 ausblenden, Ergebnis in BX ist 0 bzw 1 }
  dec  di              { Beide Offsets nochmals um 1 reduzieren              }
  dec  si
  sub  cx, bx          { CX:= CX - BX                                        }
  xchg cx, bx          { Register BX und CX tauschen ihren Inhalt aus        }
  rep  movsb           { null oder ein Zeichen kopieren                      }
  dec  si              { Beide Offsets nochmals um 1 reduzieren              }
  dec  di
  mov  cx, bx          { in CX wieder Zahl der noch zu kopierenden Zeichen   }
  shr  cx, 1           { schnelle Division durch zwei                        }
  rep  movsw           { kopiere Doppelbytes, bis CX-Register auf Null steht }
  inc  si              { Offsets wieder um 1 erhhen                         }
  inc  di

  @ende:
  mov  cx, bx          { in CX wieder Zahl der noch zu kopierenden Zeichen   }
  and  cx, 1           { war CX gerade oder ungerade?                        }
  rep  movsb           { null oder ein Zeichen kopieren                      }

  mov ds, dx           { DS-Register wieder herstellen. Wichtig!             }
  @raus:
  cld                  { <- mu!}
END;



{$IFOPT G+}

PROCEDURE dMove  (VAR Quelle, Ziel; Count : Word); assembler;
ASM
  mov  dx, ds          { DS-Register in DX zwischenspeichern. Wichtig!       }
  mov  cx, Count       { Zahl der zu kopierenden Speicherstellen in CX       }
  les  di, Ziel        { Startadresse von Ziel   in Registerpaar ES:DI       }
  lds  si, Quelle      { Startadresse von Quelle in Registerpaar DS:SI       }
  cmp  di, si          { Vergleiche beide Offsets                            }
  ja   @Down           { If DI > SI Then Goto @Down                          }

  cld                  { in Richtung aufsteigender Adressen kopieren         }
  cmp  cx, 3           { vergleiche Zeichenzahl mit 3                        }
  jbe  @ende           { If CX <= 3 Then Goto @ende                          }
  mov  ax, di          { Offsetadresse des Ziels (DI) auch in AX             }
  and  ax, 3           { Bit 2 bis 15 ausblenden, Ergebnis in AX: 0 bis 3    }
  mov  bx, 4           { errechne, wieviele Bytes einzeln zu kopieren sind,  }
  sub  bx, ax          { bis eine durch 4 teilbare Adresse erreicht ist      }
  and  bx, 3           { falls BX = 4: Bit 3 ausblenden (aus 4 wird 0)       }
  sub  cx, bx          { Ergebnis von CX subtrahieren                        }
  xchg cx, bx          { Register BX und CX tauschen ihren Inhalt aus        }
  rep  movsb           { null bis drei Zeichen kopieren                      }
  mov  cx, bx          { in CX wieder Zahl der noch zu kopierenden Zeichen   }
  shr  cx, 2           { schnelle Division durch vier                        }
  rep
  db   66h             { Es folgt ein 32-Bit-Befehl: MOVSW wird zu MOVSD     }
  movsw                { kopiere DoppelWords, bis CX-Register auf Null steht }
  jmp  @weiter         { Goto @weiter                                        }

  @Down:

  std                  { in Richtung absteigender Adressen kopieren          }
  add  di, cx          { Addiere zu DI die Zahl der zu kopierenden Bytes     }
  add  si, cx          { dasselbe auch mit SI                                }
  mov  bx, di          { Offsetadresse des Ziels (DI) auch in BX             }
  and  bx, 3           { Bit 2 bis 15 ausblenden, Ergebnis in BX: 0 bis 3    }
  dec  di              { Beide Offsets nochmals um 1 reduzieren              }
  dec  si
  cmp  cx, 3           { vergleiche Zeichenzahl mit 3                        }
  jbe  @ende           { If CX <= 3 Then Goto @ende                          }
  sub  cx, bx          { CX:= CX - BX                                        }
  xchg cx, bx          { Register BX und CX tauschen ihren Inhalt aus        }
  rep  movsb           { null bis drei Zeichen kopieren                      }
  sub  si, 3           { Beide Offsets um 3 reduzieren                       }
  sub  di, 3
  mov  cx, bx          { in CX wieder Zahl der noch zu kopierenden Zeichen   }
  shr  cx, 2           { schnelle Division durch vier                        }
  rep
  db   66h             { Es folgt ein 32-Bit-Befehl: MOVSW wird zu MOVSD     }
  movsw                { kopiere DoppelWords, bis CX-Register auf Null steht }
  add  si, 3           { Offsets wieder um 3 erhhen                         }
  add  di, 3

  @weiter:
  mov  cx, bx          { in CX wieder Zahl der noch zu kopierenden Zeichen   }
  and  cx, 3           { Ermittle Zahl der noch zu kopierenden Zeichen       }

  @ende:  
  rep  movsb           { null bis drei Zeichen kopieren                      }
  mov  ds, dx          { DS-Register wieder herstellen. Wichtig!             }
  cld                  { <- mu!}
END;

{$ENDIF}


END.
