UNIT ReadText;

INTERFACE
USES
  ComPare;

PROCEDURE OpenText  (Name : String);
PROCEDURE CloseText;
FUNCTION  InChar : Char;
PROCEDURE ReadChr (VAR ch : Char);
FUNCTION  TextPos         : LongInt;
PROCEDURE SeekPos    (Pos : LongInt);
FUNCTION  EofText         : Boolean;

VAR
  TextFile : File;
  Reading  : Boolean;

CONST
  InChkSum : Word = 0;


IMPLEMENTATION
CONST
  BufSize = 8192;


VAR
  TextLen  : LongInt;
  TextPtr  : LongInt;
  BufPtr   : Word;
  BufEnd   : Word;
  Buffer   : Array[1..BufSize] Of Char;



PROCEDURE OpenText (Name : String);
BEGIN
  FileMode:= 0;
  Assign (TextFile, Name);
  Reset  (TextFile, 1);
  BufPtr  := 0;
  BufEnd  := 0;
  TextPtr := 0;
  TextLen := FileSize (TextFile);
END;



PROCEDURE CloseText;
BEGIN
  Close (TextFile);
END;



PROCEDURE ReadNewBuff;
BEGIN
  TextPtr:= FilePos (TextFile);
  BlockRead (TextFile, Buffer, BufSize, BufEnd);
END;



PROCEDURE ReadChr (VAR ch : Char);
BEGIN
  If BufPtr>=BufEnd Then BEGIN ReadNewBuff; BufPtr:= 0; END;
  inc (BufPtr);
  ch:= Buffer[BufPtr];
END;



PROCEDURE GetCheckSum;
BEGIN
  inc (InChkSum, CheckSum (Buffer, BufEnd));
END;



FUNCTION InChar : Char; Assembler;
ASM
  mov bx, BufPtr
  cmp bx, BufEnd
  jb @weiter
    call ReadNewBuff
    call GetCheckSum
    xor bx, bx
    mov Reading, TRUE
  @weiter:
  mov al, Byte Ptr Buffer[bx]
  inc bx
  mov BufPtr, bx
END;



FUNCTION TextPos : LongInt; assembler;
ASM
  mov dx, Word Ptr TextPtr[2]
  mov ax, Word Ptr TextPtr[0]
  add ax, BufPtr
  adc dx, 0
END;
(*TextPos:= TextPtr + BufPtr;*)



PROCEDURE SeekPos (Pos : LongInt);
BEGIN
  Seek (TextFile, Pos);
  TextPtr:= Pos;
  BufPtr := 0;
  BufEnd := 0;
END;



FUNCTION EofText : Boolean; assembler;
ASM
  xor cx, cx
  mov dx, Word Ptr TextPtr[2]
  mov ax, Word Ptr TextPtr[0]
  add ax, BufPtr
  adc dx, cx
  cmp dx, Word Ptr TextLen[2]
  jb @ende
  ja @weiter
  cmp ax, Word Ptr TextLen[0]
  jb @ende
  @weiter:
  mov cx, TRUE
  @ende:
  mov ax, cx
END;
(*EofText:= TextPtr + BufPtr >= TextLen*)



END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
