UNIT Sectors;



INTERFACE

CONST
  SecToRead          : Byte    = 1;
  SecError           : Byte    = 0;
  ClearBuf           : Boolean = TRUE;
  SectorsTransferred : Byte    = 0;

  ResetDiskSys       = 0;
  GetLastOpStatus    = 1;
  ReadSec            = 2;
  WriteSec           = 3;
  VerifySec          = 4;
  FormatSec          = 5;

  SectorSize         = 512;
  MaxBufSize         = SectorSize*64;


TYPE
  TrackBuffer  = Array[1..MaxBufSize] Of Char;
  SectorBuffer = Array[1..SectorSize] Of Char;


PROCEDURE AssignDrive  (Drive  : Char; VAR Buf; SizeOfBuf : Word);
FUNCTION  LastOperationStatus  : Byte;
PROCEDURE ReadSector   (Sektor : Byte; Spur : Word; Seite : Byte);
PROCEDURE WriteSector  (Sektor : Byte; Spur : Word; Seite : Byte);
PROCEDURE VerifySector (Sektor : Byte; Spur : Word; Seite : Byte);
FUNCTION  DiskChange   (Drive  : Byte) : Boolean;


IMPLEMENTATION

CONST
  OperationCode  :  Byte         = ReadSec;
  Buffer         :  Pointer      = NIL;
  BufSize        :  Word         = 0;
  DriveNum       :  Byte         = 255;




PROCEDURE AssignDrive (Drive : Char; VAR Buf; SizeOfBuf : Word);
BEGIN
  DriveNum  := ord (upcase(Drive))-65;
  If Drive>'B' Then inc (DriveNum, 126);
  BufSize   := SizeOfBuf;
  If SecToRead>SizeOfBuf DIV SectorSize Then
  Buffer:= NIL Else Buffer:= addr (Buf);
END;



PROCEDURE ClearBuffer; assembler;
ASM
  les di, Buffer
  xor ax, ax
  mov cx, BufSize
  shr cx, 1
  rep stosW           
END;
{Puffer mit Nullbytes fllen}




PROCEDURE SectorOp (Sektor : Byte; Spur : Word; Seite : Byte); Assembler;
ASM
  mov al, SecToRead       {Lese Sektor-Anzahl}
  mov ah, OperationCode   {Befehl: Sektor(en) lesen, schreiben usw.}
  mov dl, DriveNum        {Laufwerk: A=0, B=1 usw, C=$80, D=$81 (Bit 7 gesetzt)}
  mov dh, Seite           {Seite  0/1, bei C Kopfnummer 0..x}

  mov bx, Spur
  mov cl, 6
  shl bh, cl

  mov ch, bl          {Spur   0 -  x, bei C Zylindernummer}
  mov cl, Sektor      {Sektor 1 - 63, bei Platte bit 7-8 = Highbits CylinderNr}
  add cl, bh

  les bx, Buffer      {Pufferaddresse}
  int $13
  mov SecError, ah
  mov SectorsTransferred, al
END;




FUNCTION LastOperationStatus : Byte; assembler;
ASM
  xor ax, ax
  mov ah, GetLastOpStatus
  mov dl, DriveNum
  int $13
  mov SecError, al    {Falls Bios den Fehler in al zurckgibt}
  mov al, ah
END;




PROCEDURE ReadSector (Sektor : Byte; Spur : Word; Seite : Byte);
BEGIN
  If Buffer=NIL Then Exit;
  If ClearBuf Then ClearBuffer;
  OperationCode:= ReadSec;
  SectorOp (Sektor, Spur, Seite);
END;



PROCEDURE WriteSector (Sektor : Byte; Spur : Word; Seite : Byte);
BEGIN
  If Buffer=NIL Then Exit;
  OperationCode:= WriteSec;
  SectorOp (Sektor, Spur, Seite);
END;



PROCEDURE VerifySector (Sektor : Byte; Spur : Word; Seite : Byte);
BEGIN
  If Buffer=NIL Then Exit;
  OperationCode:= VerifySec;
  SectorOp (Sektor, Spur, Seite);
END;



FUNCTION DiskChange (Drive : Byte) : Boolean; assembler;
ASM
  mov ah, $16
  mov dl, Drive
  int $13
  or ah, ah
  jz @ende
  mov ah, 1
  @ende:
  mov al, ah
END;
{Drive 0 = A, Drive 1 = B}


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
